/******************************************************************************
 *
 * Copyright(c) 2019 - 2024 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#define _RTW_PHL_RATE_C_

#include <drv_types.h>

static const hrate rtw_drates_cck[] = {RTW_DATA_RATE_CCK1, RTW_DATA_RATE_CCK2, RTW_DATA_RATE_CCK5_5, RTW_DATA_RATE_CCK11};
static const hrate rtw_drates_ofdm[] = {RTW_DATA_RATE_OFDM6, RTW_DATA_RATE_OFDM9, RTW_DATA_RATE_OFDM12, RTW_DATA_RATE_OFDM18,
					RTW_DATA_RATE_OFDM24, RTW_DATA_RATE_OFDM36, RTW_DATA_RATE_OFDM48, RTW_DATA_RATE_OFDM54};
static const hrate rtw_drates_ht1ss[] = {RTW_DATA_RATE_MCS0, RTW_DATA_RATE_MCS1, RTW_DATA_RATE_MCS2, RTW_DATA_RATE_MCS3,
					RTW_DATA_RATE_MCS4, RTW_DATA_RATE_MCS5, RTW_DATA_RATE_MCS6, RTW_DATA_RATE_MCS7};
static const hrate rtw_drates_ht2ss[] = {RTW_DATA_RATE_MCS8, RTW_DATA_RATE_MCS9, RTW_DATA_RATE_MCS10, RTW_DATA_RATE_MCS11,
					RTW_DATA_RATE_MCS12, RTW_DATA_RATE_MCS13, RTW_DATA_RATE_MCS14, RTW_DATA_RATE_MCS15};
static const hrate rtw_drates_ht3ss[] = {RTW_DATA_RATE_MCS16, RTW_DATA_RATE_MCS17, RTW_DATA_RATE_MCS18, RTW_DATA_RATE_MCS19,
					RTW_DATA_RATE_MCS20, RTW_DATA_RATE_MCS21, RTW_DATA_RATE_MCS22, RTW_DATA_RATE_MCS23};
static const hrate rtw_drates_ht4ss[] = {RTW_DATA_RATE_MCS24, RTW_DATA_RATE_MCS25, RTW_DATA_RATE_MCS26, RTW_DATA_RATE_MCS27,
					RTW_DATA_RATE_MCS28, RTW_DATA_RATE_MCS29, RTW_DATA_RATE_MCS30, RTW_DATA_RATE_MCS31};
static const hrate rtw_drates_vht1ss[] = {RTW_DATA_RATE_VHT_NSS1_MCS0, RTW_DATA_RATE_VHT_NSS1_MCS1, RTW_DATA_RATE_VHT_NSS1_MCS2, RTW_DATA_RATE_VHT_NSS1_MCS3,
					RTW_DATA_RATE_VHT_NSS1_MCS4, RTW_DATA_RATE_VHT_NSS1_MCS5, RTW_DATA_RATE_VHT_NSS1_MCS6, RTW_DATA_RATE_VHT_NSS1_MCS7,
					RTW_DATA_RATE_VHT_NSS1_MCS8, RTW_DATA_RATE_VHT_NSS1_MCS9/*, RTW_DATA_RATE_VHT_NSS1_MCS10, RTW_DATA_RATE_VHT_NSS1_MCS11*/};
static const hrate rtw_drates_vht2ss[] = {RTW_DATA_RATE_VHT_NSS2_MCS0, RTW_DATA_RATE_VHT_NSS2_MCS1, RTW_DATA_RATE_VHT_NSS2_MCS2, RTW_DATA_RATE_VHT_NSS2_MCS3,
					RTW_DATA_RATE_VHT_NSS2_MCS4, RTW_DATA_RATE_VHT_NSS2_MCS5, RTW_DATA_RATE_VHT_NSS2_MCS6, RTW_DATA_RATE_VHT_NSS2_MCS7,
					RTW_DATA_RATE_VHT_NSS2_MCS8, RTW_DATA_RATE_VHT_NSS2_MCS9/*, RTW_DATA_RATE_VHT_NSS2_MCS10, RTW_DATA_RATE_VHT_NSS2_MCS11*/};
static const hrate rtw_drates_vht3ss[] = {RTW_DATA_RATE_VHT_NSS3_MCS0, RTW_DATA_RATE_VHT_NSS3_MCS1, RTW_DATA_RATE_VHT_NSS3_MCS2, RTW_DATA_RATE_VHT_NSS3_MCS3,
					RTW_DATA_RATE_VHT_NSS3_MCS4, RTW_DATA_RATE_VHT_NSS3_MCS5, RTW_DATA_RATE_VHT_NSS3_MCS6, RTW_DATA_RATE_VHT_NSS3_MCS7,
					RTW_DATA_RATE_VHT_NSS3_MCS8, RTW_DATA_RATE_VHT_NSS3_MCS9/*, RTW_DATA_RATE_VHT_NSS3_MCS10, RTW_DATA_RATE_VHT_NSS3_MCS11*/};
static const hrate rtw_drates_vht4ss[] = {RTW_DATA_RATE_VHT_NSS4_MCS0, RTW_DATA_RATE_VHT_NSS4_MCS1, RTW_DATA_RATE_VHT_NSS4_MCS2, RTW_DATA_RATE_VHT_NSS4_MCS3,
					RTW_DATA_RATE_VHT_NSS4_MCS4, RTW_DATA_RATE_VHT_NSS4_MCS5, RTW_DATA_RATE_VHT_NSS4_MCS6, RTW_DATA_RATE_VHT_NSS4_MCS7,
					RTW_DATA_RATE_VHT_NSS4_MCS8, RTW_DATA_RATE_VHT_NSS4_MCS9/*, RTW_DATA_RATE_VHT_NSS4_MCS10, RTW_DATA_RATE_VHT_NSS4_MCS11*/};
static const hrate rtw_drates_he1ss[] = {RTW_DATA_RATE_HE_NSS1_MCS0, RTW_DATA_RATE_HE_NSS1_MCS1, RTW_DATA_RATE_HE_NSS1_MCS2, RTW_DATA_RATE_HE_NSS1_MCS3,
					RTW_DATA_RATE_HE_NSS1_MCS4, RTW_DATA_RATE_HE_NSS1_MCS5, RTW_DATA_RATE_HE_NSS1_MCS6, RTW_DATA_RATE_HE_NSS1_MCS7,
					RTW_DATA_RATE_HE_NSS1_MCS8, RTW_DATA_RATE_HE_NSS1_MCS9, RTW_DATA_RATE_HE_NSS1_MCS10, RTW_DATA_RATE_HE_NSS1_MCS11};
static const hrate rtw_drates_he2ss[] = {RTW_DATA_RATE_HE_NSS2_MCS0, RTW_DATA_RATE_HE_NSS2_MCS1, RTW_DATA_RATE_HE_NSS2_MCS2, RTW_DATA_RATE_HE_NSS2_MCS3,
					RTW_DATA_RATE_HE_NSS2_MCS4, RTW_DATA_RATE_HE_NSS2_MCS5, RTW_DATA_RATE_HE_NSS2_MCS6, RTW_DATA_RATE_HE_NSS2_MCS7,
					RTW_DATA_RATE_HE_NSS2_MCS8, RTW_DATA_RATE_HE_NSS2_MCS9, RTW_DATA_RATE_HE_NSS2_MCS10, RTW_DATA_RATE_HE_NSS2_MCS11};
static const hrate rtw_drates_he3ss[] = {RTW_DATA_RATE_HE_NSS3_MCS0, RTW_DATA_RATE_HE_NSS3_MCS1, RTW_DATA_RATE_HE_NSS3_MCS2, RTW_DATA_RATE_HE_NSS3_MCS3,
					RTW_DATA_RATE_HE_NSS3_MCS4, RTW_DATA_RATE_HE_NSS3_MCS5, RTW_DATA_RATE_HE_NSS3_MCS6, RTW_DATA_RATE_HE_NSS3_MCS7,
					RTW_DATA_RATE_HE_NSS3_MCS8, RTW_DATA_RATE_HE_NSS3_MCS9, RTW_DATA_RATE_HE_NSS3_MCS10, RTW_DATA_RATE_HE_NSS3_MCS11};
static const hrate rtw_drates_he4ss[] = {RTW_DATA_RATE_HE_NSS4_MCS0, RTW_DATA_RATE_HE_NSS4_MCS1, RTW_DATA_RATE_HE_NSS4_MCS2, RTW_DATA_RATE_HE_NSS4_MCS3,
					RTW_DATA_RATE_HE_NSS4_MCS4, RTW_DATA_RATE_HE_NSS4_MCS5, RTW_DATA_RATE_HE_NSS4_MCS6, RTW_DATA_RATE_HE_NSS4_MCS7,
					RTW_DATA_RATE_HE_NSS4_MCS8, RTW_DATA_RATE_HE_NSS4_MCS9, RTW_DATA_RATE_HE_NSS4_MCS10, RTW_DATA_RATE_HE_NSS4_MCS11};
static const hrate rtw_drates_hedcm1ss[] = {RTW_DATA_RATE_HE_NSS1_MCS0, RTW_DATA_RATE_HE_NSS1_MCS1, RTW_DATA_RATE_HE_NSS1_MCS3, RTW_DATA_RATE_HE_NSS1_MCS4};
static const hrate rtw_drates_hedcm2ss[] = {RTW_DATA_RATE_HE_NSS2_MCS0, RTW_DATA_RATE_HE_NSS2_MCS1, RTW_DATA_RATE_HE_NSS2_MCS3, RTW_DATA_RATE_HE_NSS2_MCS4};

#if RTW_PHL_RATE_SUPPORT_EHT
static const hrate rtw_drates_eht1ss[] = {RTW_DATA_RATE_EHT_NSS1_MCS0, RTW_DATA_RATE_EHT_NSS1_MCS1, RTW_DATA_RATE_EHT_NSS1_MCS2, RTW_DATA_RATE_EHT_NSS1_MCS3,
					RTW_DATA_RATE_EHT_NSS1_MCS4, RTW_DATA_RATE_EHT_NSS1_MCS5, RTW_DATA_RATE_EHT_NSS1_MCS6, RTW_DATA_RATE_EHT_NSS1_MCS7,
					RTW_DATA_RATE_EHT_NSS1_MCS8, RTW_DATA_RATE_EHT_NSS1_MCS9, RTW_DATA_RATE_EHT_NSS1_MCS10, RTW_DATA_RATE_EHT_NSS1_MCS11,
					RTW_DATA_RATE_EHT_NSS1_MCS12, RTW_DATA_RATE_EHT_NSS1_MCS13, RTW_DATA_RATE_EHT_NSS1_MCS14, RTW_DATA_RATE_EHT_NSS1_MCS15};
static const hrate rtw_drates_eht2ss[] = {RTW_DATA_RATE_EHT_NSS2_MCS0, RTW_DATA_RATE_EHT_NSS2_MCS1, RTW_DATA_RATE_EHT_NSS2_MCS2, RTW_DATA_RATE_EHT_NSS2_MCS3,
					RTW_DATA_RATE_EHT_NSS2_MCS4, RTW_DATA_RATE_EHT_NSS2_MCS5, RTW_DATA_RATE_EHT_NSS2_MCS6, RTW_DATA_RATE_EHT_NSS2_MCS7,
					RTW_DATA_RATE_EHT_NSS2_MCS8, RTW_DATA_RATE_EHT_NSS2_MCS9, RTW_DATA_RATE_EHT_NSS2_MCS10, RTW_DATA_RATE_EHT_NSS2_MCS11,
					RTW_DATA_RATE_EHT_NSS2_MCS12, RTW_DATA_RATE_EHT_NSS2_MCS13};
static const hrate rtw_drates_eht3ss[] = {RTW_DATA_RATE_EHT_NSS3_MCS0, RTW_DATA_RATE_EHT_NSS3_MCS1, RTW_DATA_RATE_EHT_NSS3_MCS2, RTW_DATA_RATE_EHT_NSS3_MCS3,
					RTW_DATA_RATE_EHT_NSS3_MCS4, RTW_DATA_RATE_EHT_NSS3_MCS5, RTW_DATA_RATE_EHT_NSS3_MCS6, RTW_DATA_RATE_EHT_NSS3_MCS7,
					RTW_DATA_RATE_EHT_NSS3_MCS8, RTW_DATA_RATE_EHT_NSS3_MCS9, RTW_DATA_RATE_EHT_NSS3_MCS10, RTW_DATA_RATE_EHT_NSS3_MCS11,
					RTW_DATA_RATE_EHT_NSS3_MCS12, RTW_DATA_RATE_EHT_NSS3_MCS13};
static const hrate rtw_drates_eht4ss[] = {RTW_DATA_RATE_EHT_NSS4_MCS0, RTW_DATA_RATE_EHT_NSS4_MCS1, RTW_DATA_RATE_EHT_NSS4_MCS2, RTW_DATA_RATE_EHT_NSS4_MCS3,
					RTW_DATA_RATE_EHT_NSS4_MCS4, RTW_DATA_RATE_EHT_NSS4_MCS5, RTW_DATA_RATE_EHT_NSS4_MCS6, RTW_DATA_RATE_EHT_NSS4_MCS7,
					RTW_DATA_RATE_EHT_NSS4_MCS8, RTW_DATA_RATE_EHT_NSS4_MCS9, RTW_DATA_RATE_EHT_NSS4_MCS10, RTW_DATA_RATE_EHT_NSS4_MCS11,
					RTW_DATA_RATE_EHT_NSS4_MCS12, RTW_DATA_RATE_EHT_NSS4_MCS13};
#endif

const char *const _hal_rate_sec_str[] = {
	[HAL_RS_CCK]		= "CCK",
	[HAL_RS_OFDM]		= "OFDM",
	[HAL_RS_HT_1SS]		= "HT_1SS",
	[HAL_RS_HT_2SS]		= "HT_2SS",
	[HAL_RS_HT_3SS]		= "HT_3SS",
	[HAL_RS_HT_4SS]		= "HT_4SS",
	[HAL_RS_VHT_1SS]	= "VHT_1SS",
	[HAL_RS_VHT_2SS]	= "VHT_2SS",
	[HAL_RS_VHT_3SS]	= "VHT_3SS",
	[HAL_RS_VHT_4SS]	= "VHT_4SS",
	[HAL_RS_HE_1SS]		= "HE_1SS",
	[HAL_RS_HE_2SS]		= "HE_2SS",
	[HAL_RS_HE_3SS]		= "HE_3SS",
	[HAL_RS_HE_4SS]		= "HE_4SS",
	[HAL_RS_HEDCM_1SS]	= "HEDCM_1SS",
	[HAL_RS_HEDCM_2SS]	= "HEDCM_2SS",
#if RTW_PHL_RATE_SUPPORT_EHT
	[HAL_RS_EHT_1SS]	= "EHT_1SS",
	[HAL_RS_EHT_2SS]	= "EHT_2SS",
	[HAL_RS_EHT_3SS]	= "EHT_3SS",
	[HAL_RS_EHT_4SS]	= "EHT_4SS",
#endif
	[HAL_RS_NUM]		= "UNKNOWN",
};

#define HAL_RATES_BY_SEC_ENT(rs, ntx, mode, rate_array) [rs] = {ntx, mode, ARRAY_SIZE(rate_array), rate_array}

const struct hal_rate_sec_ent hal_rates_by_sec[HAL_RS_NUM] = {
	HAL_RATES_BY_SEC_ENT(HAL_RS_CCK,	RF_1TX, WLAN_MD_11B,			rtw_drates_cck),
	HAL_RATES_BY_SEC_ENT(HAL_RS_OFDM,	RF_1TX, WLAN_MD_11A | WLAN_MD_11G,	rtw_drates_ofdm),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HT_1SS,	RF_1TX, WLAN_MD_11N,			rtw_drates_ht1ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HT_2SS,	RF_2TX, WLAN_MD_11N,			rtw_drates_ht2ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HT_3SS,	RF_3TX, WLAN_MD_11N,			rtw_drates_ht3ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HT_4SS,	RF_4TX, WLAN_MD_11N,			rtw_drates_ht4ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_VHT_1SS,	RF_1TX, WLAN_MD_11AC,			rtw_drates_vht1ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_VHT_2SS,	RF_2TX, WLAN_MD_11AC,			rtw_drates_vht2ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_VHT_3SS,	RF_3TX, WLAN_MD_11AC,			rtw_drates_vht3ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_VHT_4SS,	RF_4TX, WLAN_MD_11AC,			rtw_drates_vht4ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HE_1SS,	RF_1TX, WLAN_MD_11AX,			rtw_drates_he1ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HE_2SS,	RF_2TX, WLAN_MD_11AX,			rtw_drates_he2ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HE_3SS,	RF_3TX, WLAN_MD_11AX,			rtw_drates_he3ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HE_4SS,	RF_4TX, WLAN_MD_11AX,			rtw_drates_he4ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HEDCM_1SS,	RF_1TX, WLAN_MD_11AX,			rtw_drates_hedcm1ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_HEDCM_2SS,	RF_2TX, WLAN_MD_11AX,			rtw_drates_hedcm2ss),
#if RTW_PHL_RATE_SUPPORT_EHT
	HAL_RATES_BY_SEC_ENT(HAL_RS_EHT_1SS,	RF_1TX, WLAN_MD_11BE,			rtw_drates_eht1ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_EHT_2SS,	RF_2TX, WLAN_MD_11BE,			rtw_drates_eht2ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_EHT_3SS,	RF_3TX, WLAN_MD_11BE,			rtw_drates_eht3ss),
	HAL_RATES_BY_SEC_ENT(HAL_RS_EHT_4SS,	RF_4TX, WLAN_MD_11BE,			rtw_drates_eht4ss),
#endif
};