#ifndef _MAC_FWCMD_INTF_H_
#define _MAC_FWCMD_INTF_H_

#define FWCMD_VER 0x0

// ID definition//

/*----------------------------------- H2CREG ---------------------------------------*/
#define FWCMD_H2CREG_FUNC_H2CREG_LB 0x0
#define FWCMD_H2CREG_FUNC_CNSL_CMD 0x1
#define FWCMD_H2CREG_FUNC_FWERR 0x2
#define FWCMD_H2CREG_FUNC_HIDDEN_GET 0x3
#define FWCMD_H2CREG_FUNC_GETPKT_INFORM 0x4
#define FWCMD_H2CREG_FUNC_SCH_TX_EN 0x5
#define FWCMD_H2CREG_FUNC_WOW_TRX_STOP 0x6
#define FWCMD_H2CREG_FUNC_AOAC_RPT_1 0x7
#define FWCMD_H2CREG_FUNC_AOAC_RPT_2 0x8
#define FWCMD_H2CREG_FUNC_AOAC_RPT_3_REQ 0x9
#define FWCMD_H2CREG_FUNC_WOW_CPUIO_RX_CTRL 0xA
#define FWCMD_H2CREG_FUNC_SET_GPIO 0xC
#define FWCMD_H2CREG_FUNC_FWDBG_ADDR_CFG 0xD

/*----------------------------------- C2HREG ---------------------------------------*/
#define FWCMD_C2HREG_FUNC_C2HREG_LB 0x0
#define FWCMD_C2HREG_FUNC_ERR_RPT 0x1
#define FWCMD_C2HREG_FUNC_ERR_MSG 0x2
#define FWCMD_C2HREG_FUNC_EFUSE_HIDDEN 0x3
#define FWCMD_C2HREG_FUNC_TX_PAUSE_RPT 0x4
#define FWCMD_C2HREG_FUNC_AOAC_RPT_1 0x5
#define FWCMD_C2HREG_FUNC_AOAC_RPT_2 0x6
#define FWCMD_C2HREG_FUNC_AOAC_RPT_3 0x7
#define FWCMD_C2HREG_FUNC_WOW_TRX_STOP 0x8
#define FWCMD_C2HREG_FUNC_IO_OFLD_RESULT 0x9
#define FWCMD_C2HREG_FUNC_WOW_CPUIO_RX_ACK 0xA
#define FWCMD_C2HREG_FUNC_FWDBG_ADDR_STS 0xB
#define FWCMD_C2HREG_FUNC_EFUSE_HIDDEN_PART1 0xC

/*----------------------------------- H2CPKT - CAT(TEST) ---------------------------*/
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2
#define FWCMD_H2C_CL_CMD_PATH 0x0
#define FWCMD_H2C_CL_SND_TEST 0x1
#define FWCMD_H2C_CL_PLAT_AUTO_TEST 0x2
#define FWCMD_H2C_CL_MAC_TEST 0x3
#define FWCMD_H2C_CL_FW_AUTO_TEST 0x4
#define FWCMD_H2C_CL_FW_STATUS_TEST 0x5
#define FWCMD_H2C_CL_WOW_TEST 0x6

// CLASS 0 - CMD_PATH
#define FWCMD_H2C_FUNC_H2C_LB 0x0
#define FWCMD_H2C_FUNC_LOG_TEST 0x1
#define FWCMD_H2C_FUNC_SEND_NULL_TEST 0x2
#define FWCMD_H2C_FUNC_L1_2_TEST 0x3

// CLASS 1 - SND_Test

// CLASS 2 - PLATFORM_AUTO_TEST
#define FWCMD_H2C_FUNC_PLAT_SPIC_TEST 0x0
#define FWCMD_H2C_FUNC_PLAT_CPU_PLATFORM 0x1
#define FWCMD_H2C_FUNC_PLAT_EFUSE_CTRL 0x2
#define FWCMD_H2C_FUNC_PLAT_IDDMA 0x3
#define FWCMD_H2C_FUNC_PLAT_AXIDMA 0x4
#define FWCMD_H2C_FUNC_PLAT_IPSEC 0x5
#define FWCMD_H2C_FUNC_PLAT_UART 0x6
#define FWCMD_H2C_FUNC_PLAT_HIOE 0x7
#define FWCMD_H2C_FUNC_PLAT_WATCHDOG 0x8
#define FWCMD_H2C_FUNC_PLAT_SECURITY 0x9
#define FWCMD_H2C_FUNC_PLAT_FL_WRITE 0xa
#define FWCMD_H2C_FUNC_PLAT_FL_ERASE 0xb
#define FWCMD_H2C_FUNC_PL_FLASH_READ 0xc
#define FWCMD_H2C_FUNC_PLAT_MODULE_MAX 0x10
#define FWCMD_H2C_FUNC_PLAT_INVALID 0x11

// CLASS 3 - MAC_TEST
#define FWCMD_H2C_FUNC_LONG_RUN 0x0
#define FWCMD_H2C_FUNC_CPUIO_TEST 0x1

// CLASS 4 - FW_AUTO_TEST
#define FWCMD_H2C_FUNC_LPS_TEST 0x0
#define FWCMD_H2C_FUNC_LPS_ONOFF_TEST 0x1
#define FWCMD_H2C_FUNC_CPUMGENQ_TEST 0x2
#define FWCMD_H2C_FUNC_MPIO_TEST 0x3
#define FWCMD_H2C_FUNC_SENDNULL_TEST 0x4
#define FWCMD_H2C_FUNC_MPIOV2_TEST 0x5
#define FWCMD_H2C_FUNC_MIO_TEST 0x6
#define FWCMD_H2C_FUNC_ANYTESTBUSYCALL_TEST 0x7
#define FWCMD_H2C_FUNC_ANYRW_TEST 0x8

// CLASS 5 - FW_STATUS_TEST
#define FWCMD_H2C_FUNC_FW_STATUS 0x0
#define FWCMD_H2C_FUNC_TRIGGER_CPU_EXCEPTION 0x1
#define FWCMD_H2C_FUNC_FW_PROFILING 0x2

// CLASS 6 - WOW_TEST
#define FWCMD_H2C_FUNC_WOW_AUTO_TEST 0x0

/*----------------------------------- H2CPKT - CAT(MAC) ----------------------------*/
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2
#define FWCMD_H2C_CL_FW_INFO 0x0
#define FWCMD_H2C_CL_WOW 0x1
#define FWCMD_H2C_CL_PS 0x2
#define FWCMD_H2C_CL_FWDL 0x3
#define FWCMD_H2C_CL_TWT 0x4
#define FWCMD_H2C_CL_FR_EXCHG 0x5
#define FWCMD_H2C_CL_ADDR_CAM_UPDATE 0x6
#define FWCMD_H2C_CL_BSSID_CAM_UPDATE 0x7
#define FWCMD_H2C_CL_MEDIA_RPT 0x8
#define FWCMD_H2C_CL_FW_OFLD 0x9
#define FWCMD_H2C_CL_SEC_CAM 0xA
#define FWCMD_H2C_CL_SOUND 0xB
#define FWCMD_H2C_CL_BA_CAM 0xC
#define FWCMD_H2C_CL_IE_CAM 0xD
#define FWCMD_H2C_CL_MCC 0xE
#define FWCMD_H2C_CL_SCSI 0xF
#define FWCMD_H2C_CL_FLASH 0x10
#define FWCMD_H2C_CL_FCS 0x11
#define FWCMD_H2C_CL_MISC 0x12
#define FWCMD_H2C_CL_MPORT 0x13
#define FWCMD_H2C_CL_MLO 0x14
#define FWCMD_H2C_CL_PROXY 0x15
#define FWCMD_H2C_CL_NAN 0x16
#define FWCMD_H2C_CL_FW_CMDREQ 0x17
#define FWCMD_H2C_CL_MRC 0x18
#define FWCMD_H2C_CL_BF_SENS 0x19
#define FWCMD_H2C_CL_OFFLOAD_AGG 0x1A
#define FWCMD_H2C_CL_ECO_PATCH 0x1B
#define FWCMD_H2C_CL_SER 0x1C
#define FWCMD_H2C_CL_NAT2P5 0x1D
#define FWCMD_H2C_CL_FTM 0x1E
#define FWCMD_H2C_CL_WOW_DIAG 0x1F
#define FWCMD_H2C_CL_WOW_TRI_EVT 0x20
#define FWCMD_H2C_CL_AP_SELF_DIAG 0x21
#define FWCMD_H2C_CL_STA_DIAG 0x22
#define FWCMD_H2C_CL_ADDBA_OFLD 0x23
#define FWCMD_H2C_CL_SOFTAP 0x24
#define FWCMD_H2C_CL_HOST_REL 0x25
#define FWCMD_H2C_CL_HCI 0x26

// CLASS 0 - FW_INFO
#define FWCMD_H2C_FUNC_LOG_CFG 0x0
#define FWCMD_H2C_FUNC_GENERAL_PKT 0x1
#define FWCMD_H2C_FUNC_C2H_RPT_CFG 0x2
#define FWCMD_H2C_FUNC_FW_DBGREG_CFG 0x3
#define FWCMD_H2C_FUNC_FW_REDL_CFG 0x4
#define FWCMD_H2C_FUNC_FW_SELF_DX 0x5
#define FWCMD_H2C_FUNC_FW_DBG_ADDR_CFG 0x6

// CLASS 1 - WOW
#define FWCMD_H2C_FUNC_KEEP_ALIVE 0x0
#define FWCMD_H2C_FUNC_DISCONNECT_DETECT 0x1
#define FWCMD_H2C_FUNC_WOW_GLOBAL 0x2
#define FWCMD_H2C_FUNC_GTK_OFLD 0x3
#define FWCMD_H2C_FUNC_ARP_OFLD 0x4
#define FWCMD_H2C_FUNC_NDP_OFLD 0x5
#define FWCMD_H2C_FUNC_REALWOW 0x6
#define FWCMD_H2C_FUNC_NLO 0x7
#define FWCMD_H2C_FUNC_WAKEUP_CTRL 0x8
#define FWCMD_H2C_FUNC_NEGATIVE_PATTERN 0x9
#define FWCMD_H2C_FUNC_DEV2HST_GPIO 0xA
#define FWCMD_H2C_FUNC_HST2DEV_CTRL 0xB
#define FWCMD_H2C_FUNC_WOW_CAM_UPD 0xC
#define FWCMD_H2C_FUNC_AOAC_REPORT_REQ 0xD
#define FWCMD_H2C_FUNC_WOW_STOP_FW_TRX 0xE
#define FWCMD_H2C_FUNC_WOW_CSA 0xF
#define FWCMD_H2C_FUNC_MAGIC_WAKER_FILTER 0x10
#define FWCMD_H2C_FUNC_TCP_KEEPALIVE 0x11
#define FWCMD_H2C_FUNC_WOW_PAYLOAD_CAM_UPD 0x12

// CLASS 2 - PS
#define FWCMD_H2C_FUNC_LPS_PARM 0x0
#define FWCMD_H2C_FUNC_P2P_ACT 0x1
#define FWCMD_H2C_FUNC_P2P_MACID_CTRL 0x2
#define FWCMD_H2C_FUNC_IPS_CFG 0x3
#define FWCMD_H2C_FUNC_PS_ADVANCE_PARM 0x4
#define FWCMD_H2C_FUNC_PERIODIC_WAKE 0x5
#define FWCMD_H2C_FUNC_BB_RF_PWR_ST 0x6
#define FWCMD_H2C_FUNC_PS_POWER_LEVEL 0x7
#define FWCMD_H2C_FUNC_LPS_OPTION_CFG 0x8
#define FWCMD_H2C_FUNC_DOZE_TIME_STATS 0x9
#define FWCMD_H2C_FUNC_TBTT_TUNING 0xA
#define FWCMD_H2C_FUNC_BKP_CAM_CFG 0xB
#define FWCMD_H2C_FUNC_SMPS_CFG 0xC
#define FWCMD_H2C_FUNC_RTD3_CFG 0xD
#define FWCMD_H2C_FUNC_LPS_DBG_CFG 0xE

// CLASS 3 - FWDL
#define FWCMD_H2C_FUNC_FWHDR_DL 0x0
#define FWCMD_H2C_FUNC_FWHDR_REDL 0x1

// CLASS 4 - TWT
#define FWCMD_H2C_FUNC_TWT_ANNOUNCE_UPD 0x00
#define FWCMD_H2C_FUNC_TWTINFO_UPD 0x1
#define FWCMD_H2C_FUNC_TWT_STANSP_UPD 0x2

// CLASS 5 - Frame Exchange
#define FWCMD_H2C_FUNC_TBLUD 0x0
#define FWCMD_H2C_FUNC_DCTLINFO_UD 0x1
#define FWCMD_H2C_FUNC_CCTLINFO_UD 0x2
#define FWCMD_H2C_FUNC_F2P_TEST 0x3
#define FWCMD_H2C_FUNC_SHCUT_UPDATE 0x4
#define FWCMD_H2C_FUNC_BCN_UPD 0x5
#define FWCMD_H2C_FUNC_SS_ULSTA_UPD 0x6
#define FWCMD_H2C_FUNC_F2PDBG_SET 0x7
#define FWCMD_H2C_FUNC_WLANINFO_GET 0x8
#define FWCMD_H2C_FUNC_DCTLINFO_UD_V1 0x9
#define FWCMD_H2C_FUNC_CCTLINFO_UD_V1 0xa
#define FWCMD_H2C_FUNC_FW_STS_PARA 0xb
#define FWCMD_H2C_FUNC_DCTLINFO_UD_V2 0xc
#define FWCMD_H2C_FUNC_BCN_UPD_BE 0xd
#define FWCMD_H2C_FUNC_BCN_IGNORE_EDCCA 0xe
#define FWCMD_H2C_FUNC_BCN_UPD_V1 0xf
#define FWCMD_H2C_FUNC_DCTLINFO_UD_V3 0x10
#define FWCMD_H2C_FUNC_CCTLINFO_UD_G7 0x11
#define FWCMD_H2C_FUNC_SWTX_STACFG 0x12
#define FWCMD_H2C_FUNC_TXMODE_SWITCH 0x13
#define FWCMD_H2C_FUNC_BCN_DYNAMIC_MECH 0x14

// CLASS 6 - Address CAM
#define FWCMD_H2C_FUNC_ADDRCAM_INFO 0x0
#define FWCMD_H2C_FUNC_ADDRCAM_INFO_V1 0x0

// CLASS 8 - Media Status Report
#define FWCMD_H2C_FUNC_JOININFO 0x0
#define FWCMD_H2C_FUNC_DL_GRP_UPD 0x1
#define FWCMD_H2C_FUNC_UL_GRP_UPD 0x2
#define FWCMD_H2C_FUNC_MU_STA_UPD 0x3
#define FWCMD_H2C_FUNC_FWROLE_MAINTAIN 0x4
#define FWCMD_H2C_FUNC_NOTIFY_DBCC 0x5
#define FWCMD_H2C_FUNC_DL_GRP_UPD_V2 0x1
#define FWCMD_H2C_FUNC_FW_FLOW_CTRL 0x6
#define FWCMD_H2C_FUNC_TXRPT_FORWARD 0x7
#define FWCMD_H2C_FUNC_MRU_GRP_UPD 0x8

// CLASS 9 - FW_OFLD
#define FWCMD_H2C_FUNC_DUMP_EFUSE 0x0
#define FWCMD_H2C_FUNC_PACKET_OFLD 0x1
#define FWCMD_H2C_FUNC_READ_OFLD 0x2
#define FWCMD_H2C_FUNC_WRITE_OFLD 0x3
#define FWCMD_H2C_FUNC_CONF_OFLD 0x4
#define FWCMD_H2C_FUNC_SYS_INIT 0x5
#define FWCMD_H2C_FUNC_TRX_INIT 0x6
#define FWCMD_H2C_FUNC_INTF_INIT 0x7
#define FWCMD_H2C_FUNC_MACID_PAUSE 0x8
#define FWCMD_H2C_FUNC_RX_FWD 0x9
#define FWCMD_H2C_FUNC_EN_MAC_HDR_CONV 0xB
#define FWCMD_H2C_FUNC_SET_HWSEQ_REG 0xA
#define FWCMD_H2C_FUNC_HWAMSDU_REG 0xC
#define FWCMD_H2C_FUNC_AMSDU_CUT_REG 0xD
#define FWCMD_H2C_FUNC_TCPIP_CHKSUM_OFFLOAD_REG 0xE
#define FWCMD_H2C_FUNC_USR_EDCA 0xF
#define FWCMD_H2C_FUNC_TSF32_TOGL 0x10
#define FWCMD_H2C_FUNC_CMD_OFLD_REG 0x11
#define FWCMD_H2C_FUNC_USR_TX_RPT 0x12
#define FWCMD_H2C_FUNC_CMD_OFLD_PKT 0x13
#define FWCMD_H2C_FUNC_OFLD_CFG 0x14
#define FWCMD_H2C_FUNC_H2C_AGG 0x15
#define FWCMD_H2C_FUNC_ADD_SCANOFLD_CH 0x16
#define FWCMD_H2C_FUNC_SCANOFLD 0x17
#define FWCMD_H2C_FUNC_TX_DUTY 0x18
#define FWCMD_H2C_FUNC_DISABLE_RF 0x19
#define FWCMD_H2C_FUNC_TX_ADDBA_PKT 0x1A
#define FWCMD_H2C_FUNC_PKT_DROP 0x1B
#define FWCMD_H2C_FUNC_CH_SWITCH 0x1C
#define FWCMD_H2C_FUNC_BCNERLYRPT 0x1D
#define FWCMD_H2C_FUNC_CFG_BCNFLTR 0x1E
#define FWCMD_H2C_FUNC_OFLD_RSSI 0x1F
#define FWCMD_H2C_FUNC_OFLD_TP 0x20
#define FWCMD_H2C_FUNC_HOST_EFUSE_REC 0x21
#define FWCMD_H2C_FUNC_SCANOFLD_DRV_CTRL 0x22
#define FWCMD_H2C_FUNC_WIFI_SENSING_CSI 0x23
#define FWCMD_H2C_FUNC_CMD_OFLD_V1_REG 0x24
#define FWCMD_H2C_FUNC_CMD_OFLD_V1_PKT 0x25
#define FWCMD_H2C_FUNC_DLE_QTA_CHANGE 0x26
#define FWCMD_H2C_FUNC_SCH_TX_EN_PKT 0x27
#define FWCMD_H2C_FUNC_MACID_PAUSE_SLEEP 0x28
#define FWCMD_H2C_FUNC_BCN_OFLD 0x29
#define FWCMD_H2C_FUNC_TBTT_SH_STAT_OFLD 0x2A
#define FWCMD_H2C_FUNC_STA_CSA 0x2B
#define FWCMD_H2C_FUNC_SCANOFLD_V2 0x2C
#define FWCMD_H2C_FUNC_FRAME_TO_ACT 0x2D
#define FWCMD_H2C_FUNC_DUMP_EFUSE_V2 0x2E
#define FWCMD_H2C_FUNC_TXRPT_STATS_EN 0x2F
#define FWCMD_H2C_FUNC_CPUMGPKT_TX 0x30
#define FWCMD_H2C_FUNC_BCN_CNT_GPIO 0x31
#define FWCMD_H2C_FUNC_RX_FWD_BE 0x32
#define FWCMD_H2C_FUNC_TRX_TIME_STATS_EN 0x33
#define FWCMD_H2C_FUNC_TRX_PROTECT_OFLD 0x34
#define FWCMD_H2C_FUNC_TB_PPDU_CTRL 0x35
#define FWCMD_H2C_FUNC_APF_OFLD_CTRL 0x36

// CLASS 10 - SECCAM
#define FWCMD_H2C_FUNC_SEC_CAM_INIT 0x0
#define FWCMD_H2C_FUNC_SECCAM_INFO 0x1
#define FWCMD_H2C_FUNC_SECCAM_INFO_V1 0x2

// CLASS 11 - Sound
#define FWCMD_H2C_FUNC_SET_SND_PARA 0x0
#define FWCMD_H2C_FUNC_GET_CSI_BUF 0x1
#define FWCMD_H2C_FUNC_SET_CSI_BUF 0x2
#define FWCMD_H2C_FUNC_GET_SND_STS 0x3
#define FWCMD_H2C_FUNC_SET_SND_STS 0x4
#define FWCMD_H2C_FUNC_INIT_SND_MER 0x5
#define FWCMD_H2C_FUNC_INIT_SND_MEE 0x6
#define FWCMD_H2C_FUNC_CSI_FIX_RATE 0x7
#define FWCMD_H2C_FUNC_CSI_RRSC 0x8
#define FWCMD_H2C_FUNC_SET_MU_TABLE 0x9
#define FWCMD_H2C_FUNC_SET_CSI_PARA_REG 0xA
#define FWCMD_H2C_FUNC_HW_SND_PR 0xB
#define FWCMD_H2C_FUNC_BYPASS_SND_STS 0xC
#define FWCMD_H2C_FUNC_SET_SND_PARA_V1 0xD
#define FWCMD_H2C_FUNC_SET_SND_PARA_V2 0xE

// CLASS 12 - BACAM
#define FWCMD_H2C_FUNC_BA_CAM 0x0
#define FWCMD_H2C_FUNC_BA_CAM_V1 0x1
#define FWCMD_H2C_FUNC_BA_CAM_INIT 0x2

// CLASS 13 - IECAM
#define FWCMD_H2C_FUNC_IE_CAM 0x0

// CLASS 14 - MCC
#define FWCMD_H2C_FUNC_ADD_MCC 0x0
#define FWCMD_H2C_FUNC_START_MCC 0x1
#define FWCMD_H2C_FUNC_STOP_MCC 0x2
#define FWCMD_H2C_FUNC_DEL_MCC_GROUP 0x3
#define FWCMD_H2C_FUNC_RESET_MCC_GROUP 0x4
#define FWCMD_H2C_FUNC_MCC_REQ_TSF 0x5
#define FWCMD_H2C_FUNC_MCC_MACID_BITMAP 0x6
#define FWCMD_H2C_FUNC_MCC_SYNC 0x7
#define FWCMD_H2C_FUNC_MCC_SET_DURATION 0x8
#define FWCMD_H2C_FUNC_MCC_DBG_NOTIFY 0x9

// CLASS 15 - SCSI
#define FWCMD_H2C_FUNC_SCSI_TX 0x0
#define FWCMD_H2C_FUNC_USB_SWITCH 0x1

// CLASS 16 - FLASH
#define FWCMD_H2C_FUNC_PLAT_FLASH_WRITE 0x0
#define FWCMD_H2C_FUNC_PLAT_FLASH_ERASE 0x1
#define FWCMD_H2C_FUNC_PLAT_FLASH_READ 0x2

// CLASS 17 - FCS
#define FWCMD_H2C_FUNC_FCS 0x0

// CLASS 18 - MISC
#define FWCMD_H2C_FUNC_CFG_WPS 0x0
#define FWCMD_H2C_FUNC_PUNC_UPD 0x1

// CLASS 19 - MPORT
#define FWCMD_H2C_FUNC_PORT_INIT 0x0
#define FWCMD_H2C_FUNC_PORT_CFG 0x1

// CLASS 20 - MLO
#define FWCMD_H2C_FUNC_MLOTBL_CFG 0x0
#define FWCMD_H2C_FUNC_MLO_STAFUNC_CFG 0x1
#define FWCMD_H2C_FUNC_MLO_TID_TO_LINK_MAP 0x2
#define FWCMD_H2C_FUNC_MLO_DM_CFG 0x3
#define FWCMD_H2C_FUNC_EMLSR_STA_CFG 0x4
#define FWCMD_H2C_FUNC_MCMLO_RELINK_DROP 0x5
#define FWCMD_H2C_FUNC_MCMLO_SN_SYNC 0x6
#define FWCMD_H2C_FUNC_MLO_RELINK 0x7
#define FWCMD_H2C_FUNC_MLO_LINK_CFG 0x8
#define FWCMD_H2C_FUNC_MLO_DM_DBG 0x9
#define FWCMD_H2C_FUNC_MCMLO_TABLE_ACC 0xa
#define FWCMD_H2C_FUNC_MCMLO_OPEN_QSTS 0xb
#define FWCMD_H2C_FUNC_MCMLO_INIT 0xc

// CLASS 21 - PROXY
#define FWCMD_H2C_FUNC_PROXY 0x0
#define FWCMD_H2C_FUNC_MDNS 0x1
#define FWCMD_H2C_FUNC_PTCL_PATTERN 0x2
#define FWCMD_H2C_FUNC_SNMP 0x3
#define FWCMD_H2C_FUNC_LLMNR 0x4
#define FWCMD_H2C_FUNC_MDNS_OFLD 0x8
#define FWCMD_H2C_FUNC_APF_SET 0x10
#define FWCMD_H2C_FUNC_APF_GET 0x11

// CLASS 22 - NAN
#define FWCMD_H2C_FUNC_ACT_SCHEDULE_REQ 0x0
#define FWCMD_H2C_FUNC_BCN_REQ 0x1
#define FWCMD_H2C_FUNC_NAN_FUNC_CTRL 0x2
#define FWCMD_H2C_FUNC_NAN_DE_INFO 0x3
#define FWCMD_H2C_FUNC_NAN_JOIN_CLUSTER 0x4
#define FWCMD_H2C_FUNC_PAUSE_FAW_TX 0x5
#define FWCMD_H2C_FUNC_NAN_GET_CLUSTER_INFO 0x6
#define FWCMD_H2C_FUNC_NAN_AVAIL_T_BITMAP 0x7

// CLASS 23 - FW_CMDREQ
#define FWCMD_H2C_FUNC_FW_CMDREQ 0x0

// CLASS 24 - MRC
#define FWCMD_H2C_FUNC_MRC_REQ_TSF 0x0
#define FWCMD_H2C_FUNC_ADD_MRC 0x1
#define FWCMD_H2C_FUNC_START_MRC 0x2
#define FWCMD_H2C_FUNC_DEL_MRC 0x3
#define FWCMD_H2C_FUNC_MRC_SYNC 0x4
#define FWCMD_H2C_FUNC_MRC_UPD_DURATION 0x5
#define FWCMD_H2C_FUNC_MRC_UPD_BITMAP 0x6
#define FWCMD_H2C_FUNC_MRC_DBG_DUMP_CFG 0x7

// CLASS 25 - BF_SENS
#define FWCMD_H2C_FUNC_SENS_TBL_UPD 0x0
#define FWCMD_H2C_FUNC_SENS_NTB_TX_OFLD 0x1
#define FWCMD_H2C_FUNC_SENS_INVLD_SMR 0x2

// CLASS 26 - OFFLOAD_AGG
#define FWCMD_H2C_FUNC_SUB_OFFLOAD_AGG 0x0
#define FWCMD_H2C_FUNC_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE 0x1
#define FWCMD_H2C_FUNC_SUB_OFFLOAD_AGG_WITH_NUM 0x2

// CLASS 27 - ECO_PATCH
#define FWCMD_H2C_FUNC_OM_ADV_RPT 0x0

// CLASS 28 - SER
#define FWCMD_H2C_FUNC_SER_DBG_CASE_SET 0x0

// CLASS 29 - NAT2.5
#define FWCMD_H2C_FUNC_NAT2P5_UPD 0x0

// CLASS 30 - FTM
#define FWCMD_H2C_FUNC_AZ_EN 0x0
#define FWCMD_H2C_FUNC_AZ_PROC 0x1
#define FWCMD_H2C_FUNC_AZ_UPDATE 0x2
#define FWCMD_H2C_FUNC_AZ_CANCEL 0x3

// CLASS 31 - WOW_DIAG
#define FWCMD_H2C_FUNC_WOW_DIAG_CTRL 0x0

// CLASS 32 - WOW_TRI_EVT
#define FWCMD_H2C_FUNC_WOW_REQ_RX_PKT 0x0
#define FWCMD_H2C_FUNC_WOW_REQ_MEM 0x1
#define FWCMD_H2C_FUNC_WOW_REQ_ROLE_INFO 0x2
#define FWCMD_H2C_FUNC_WOW_REQ_BB_RF_REG 0x3

// CLASS 33 - AP_SELF_DIAG
#define FWCMD_H2C_FUNC_AP_SELF_DIAG 0x0

// CLASS 34 - STA_DIAG
#define FWCMD_H2C_FUNC_REQ_STA_DIAG_RPT 0x0

// CLASS 35 - ADDBA_OFLD
#define FWCMD_H2C_FUNC_ADDBA_OFLD_REQ 0x0

// CLASS 36 - SoftAP
#define FWCMD_H2C_FUNC_SAP_INFO 0x0

// CLASS 37 - HOST_REL
#define FWCMD_H2C_FUNC_PCIE_WP_TO_CTRL 0x0
#define FWCMD_H2C_FUNC_PCIE_WP_TO_GET 0x1
#define FWCMD_H2C_FUNC_PCIE_WP_TO_RESET 0x2

// CLASS 38 - HCI
#define FWCMD_H2C_FUNC_USB_TP_DBG_MON 0x0
#define FWCMD_H2C_FUNC_OLT_HCI_LBK 0x1

/*----------------------------------- H2CPKT - CAT(Table) --------------------------*/

/*----------------------------------- H2CPKT - CAT(OutSrc,Phydm) -------------------*/
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2
#define FWCMD_H2C_CL_RUA 0x0
#define FWCMD_H2C_CL_RA 0x1

// CLASS 0 (RUA)
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 1 (RA)
#define FWCMD_H2C_FUNC_MACID_CFG 0x0
#define FWCMD_H2C_FUNC_RSSI_RA_CONFIG 0x1
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 2
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 3
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 4
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 5
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 6
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 7
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

/*----------------------------------- H2CPKT - CAT(OutSrc, RF) ---------------------*/
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2

// CLASS 8
#define FWCMD_H2C_FUNC_RADIO_INIT_0 0x0
#define FWCMD_H2C_FUNC_RADIO_INIT_1 0x1
#define FWCMD_H2C_FUNC_RADIO_INIT_2 0x2
#define FWCMD_H2C_FUNC_RADIO_INIT_3 0x3
#define FWCMD_H2C_FUNC_RADIO_INIT_4 0x4
#define FWCMD_H2C_FUNC_RADIO_INIT_5 0x5
#define FWCMD_H2C_FUNC_RADIO_INIT_6 0x6
#define FWCMD_H2C_FUNC_RADIO_INIT_7 0x7
#define FWCMD_H2C_FUNC_RADIO_INIT_8 0x8
#define FWCMD_H2C_FUNC_RADIO_INIT_9 0x9

// CLASS 9
#define FWCMD_H2C_FUNC_DACK_BACKUP 0x0
#define FWCMD_H2C_FUNC_DACK_RELOAD 0x1

// CLASS 10
#define FWCMD_H2C_FUNC_FCS_BACKUP_RFK 0x0
#define FWCMD_H2C_FUNC_FCS_RELOAD_RFK 0x1
#define FWCMD_H2C_FUNC_GET_MCCCH 0x2
#define FWCMD_H2C_FUNC_FWIQK_TRIGGER 0x4
#define FWCMD_H2C_FUNC_FW_SCAN_LOAD_PWR_TABLE 0x5
#define FWCMD_H2C_FUNC_BCN_MOD 0x7
#define FWCMD_H2C_FUNC_FT_RFQ 0x8
#define FWCMD_H2C_FUNC_LPS_CFG 0x9
#define FWCMD_H2C_FUNC_RF_REG_FCS 0xA
#define FWCMD_H2C_FUNC_BB_REG_FCS 0xB
#define FWCMD_H2C_FUNC_KIP_REG_FCS 0xC
#define FWCMD_H2C_FUNC_MCC_CFG 0xD
#define FWCMD_H2C_FUNC_RF_INIT_CFG 0xE
#define FWCMD_H2C_FUNC_MCC_INFO 0xF
#define FWCMD_H2C_FUNC_PS_INFO 0x10

// CLASS 11
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 12
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 13
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 14
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 15
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

/*----------------------------------- H2CPKT - CAT(OutSrc, BTC) --------------------*/
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2

// CLASS 16
#define FWCMD_H2C_FUNC_TDMA 0x0

/*----------------------------------- C2HPKT - CAT(TEST) ---------------------------*/
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2
#define FWCMD_C2H_CL_CMD_PATH 0x0
#define FWCMD_C2H_CL_PLAT_AUTO 0x2
#define FWCMD_C2H_CL_FW_AUTO 0x3
#define FWCMD_C2H_CL_FW_STATUS 0x4

// CLASS 0 - CMD_PATH
#define FWCMD_C2H_FUNC_C2H_LB 0x00
#define FWCMD_C2H_FUNC_TEST_PHY_RPT 0x01
#define FWCMD_C2H_FUNC_C2H_LOG_TEST 0x2
#define FWCMD_C2H_FUNC_SEND_NULL_TEST 0x3
#define FWCMD_C2H_FUNC_C2H_L1_2_TEST 0x4

// CLASS 2 - PLATFORM_AUTO_TEST
#define FWCMD_C2H_FUNC_SPIC 0x00
#define FWCMD_C2H_FUNC_SPIC2 0x01

// CLASS 3 - FW_AUTO_TEST
#define FWCMD_C2H_FUNC_LPS_TEST 0x00
#define FWCMD_C2H_FUNC_LPS_ONOFF_TEST 0x1
#define FWCMD_C2H_FUNC_MPIO_TEST 0x2
#define FWCMD_C2H_FUNC_SENDNULL_TEST 0x3
#define FWCMD_C2H_FUNC_MPIOV2_TEST 0x4
#define FWCMD_C2H_FUNC_MIO_TEST 0x5
#define FWCMD_C2H_FUNC_ANYTESTBUSYCALL_TEST 0x6
#define FWCMD_C2H_FUNC_ANYRW_TEST 0x7

// CLASS 4 - FW_STATUS
#define FWCMD_C2H_FUNC_FW_STATUS 0x00
#define FWCMD_C2H_FUNC_TRIGGER_CPU_EXCEPTION 0x1
#define FWCMD_C2H_FUNC_FW_PROFILING 0x2

// CLASS 5 - MAC_TEST
#define FWCMD_C2H_FUNC_CPUIO_TEST 0x00

/*----------------------------------- C2HPKT - CAT(MAC) ----------------------------*/
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2
#define FWCMD_C2H_CL_FW_INFO 0x0
#define FWCMD_C2H_CL_FW_OFLD 0x1
#define FWCMD_C2H_CL_TWT 0x2
#define FWCMD_C2H_CL_WOW 0x3
#define FWCMD_C2H_CL_MCC 0x4
#define FWCMD_C2H_CL_FW_DBG 0x5
#define FWCMD_C2H_CL_FLASH 0x6
#define FWCMD_C2H_CL_SCSI 0x7
#define FWCMD_C2H_CL_FCS 0x8
#define FWCMD_C2H_CL_MISC 0x9
#define FWCMD_C2H_CL_MPORT 0xA
#define FWCMD_C2H_CL_OFDMA_INFO 0xB
#define FWCMD_C2H_CL_MLO 0xC
#define FWCMD_C2H_CL_NAN 0xD
#define FWCMD_C2H_CL_MRC 0xE
#define FWCMD_C2H_CL_PS 0xF
#define FWCMD_C2H_CL_DCTL_INFO 0x10
#define FWCMD_C2H_CL_ECO_PATCH 0x11
#define FWCMD_C2H_CL_WOW_DIAG 0x12
#define FWCMD_C2H_CL_WOW_TRI_EVT 0x13
#define FWCMD_C2H_CL_FTM_AZ 0x14
#define FWCMD_C2H_CL_FTM_MC 0x15
#define FWCMD_C2H_CL_AP_SELF_DIAG_RST 0x16
#define FWCMD_C2H_CL_STA_DIAG 0x17
#define FWCMD_C2H_CL_SOFTAP 0x18
#define FWCMD_C2H_CL_HOST_REL 0x19
#define FWCMD_C2H_CL_HCI 0x1A

// CLASS 0 - FW_INFO
#define FWCMD_C2H_FUNC_REC_ACK 0x00
#define FWCMD_C2H_FUNC_DONE_ACK 0x01
#define FWCMD_C2H_FUNC_C2H_LOG 0x02
#define FWCMD_C2H_FUNC_BCN_CNT 0x03
#define FWCMD_C2H_FUNC_BCN_CSAZERO 0x04
#define FWCMD_C2H_FUNC_BCN_CRITICAL_RST 0x05
#define FWCMD_C2H_FUNC_BCN_UPD_DONE 0x06
#define FWCMD_C2H_FUNC_BCN_BC_CHG_ZERO 0x07
#define FWCMD_C2H_FUNC_FW_SELF_DX_INFO 0x08

// CLASS 1 - FW_OFLD
#define FWCMD_C2H_FUNC_EFUSE_DUMP 0x00
#define FWCMD_C2H_FUNC_READ_RSP 0x01
#define FWCMD_C2H_FUNC_PKT_OFLD_RSP 0x02
#define FWCMD_C2H_FUNC_BEACON_RESEND 0x3
#define FWCMD_C2H_FUNC_MACID_PAUSE 0x4
#define FWCMD_C2H_FUNC_FW_GETPKT_RPT 0x5
#define FWCMD_C2H_FUNC_TSF32_TOGL_RPT 0x6
#define FWCMD_C2H_FUNC_USR_TX_RPT_INFO 0x7
#define FWCMD_C2H_FUNC_CMD_OFLD_RSP 0x8
#define FWCMD_C2H_FUNC_SCANOFLD_RSP 0x9
#define FWCMD_C2H_FUNC_TX_DUTY_RPT 0xA
#define FWCMD_C2H_FUNC_CH_SWITCH_RPT 0xB
#define FWCMD_C2H_FUNC_BCNERLYNTFY 0xC
#define FWCMD_C2H_FUNC_BCNFLTR_RPT 0xD
#define FWCMD_C2H_FUNC_WIFI_SENSING_CSI_TX_RESULT 0xE
#define FWCMD_C2H_FUNC_TBTT_SH_STAT_RPT 0xF
#define FWCMD_C2H_FUNC_BCN_OFLD_RPT 0x10
#define FWCMD_C2H_FUNC_FRAME_TO_ACT_RPT 0x11
#define FWCMD_C2H_FUNC_EFUSE_DUMP_V2 0x12
#define FWCMD_C2H_FUNC_TXRPT_STATS 0x13
#define FWCMD_C2H_FUNC_BCN_SYNC_RPT 0x14
#define FWCMD_C2H_FUNC_TRX_TIME_STATS 0x15

// CLASS 2 - TWT
#define FWCMD_C2H_FUNC_WAIT_ANNOUNCE 0x00
#define FWCMD_C2H_FUNC_STAT_RPT 0x01

// CLASS 3 - WOW
#define FWCMD_C2H_FUNC_AOAC_REPORT 0x00
#define FWCMD_C2H_FUNC_READ_WOW_CAM 0x01
#define FWCMD_C2H_FUNC_APF_RPT 0x02

// CLASS 4 - MCC
#define FWCMD_C2H_FUNC_MCC_RCV_ACK 0x00
#define FWCMD_C2H_FUNC_MCC_REQ_ACK 0x01
#define FWCMD_C2H_FUNC_MCC_TSF_RPT 0x02
#define FWCMD_C2H_FUNC_MCC_STATUS_RPT 0x03

// CLASS 5 - FW_DBG
#define FWCMD_C2H_FUNC_RX_DBG 0x00

// CLASS 6 - FLASH
#define FWCMD_C2H_FUNC_PLAT_FLASH_WRITE 0x0
#define FWCMD_C2H_FUNC_PLAT_FLASH_ERASE 0x1
#define FWCMD_C2H_FUNC_PLAT_FLASH_READ 0x2

// CLASS 7 - SCSI
#define FWCMD_C2H_FUNC_SCSI_RX 0x00

// CLASS 8 - FCS
#define FWCMD_C2H_FUNC_FCS_RPT 0x00

// CLASS 9 - MISC
#define FWCMD_C2H_FUNC_WPS_RPT 0x0
#define FWCMD_C2H_FUNC_CCXRPT 0x1
#define FWCMD_C2H_FUNC_BF_SENS_FEEDBACK 0x4
#define FWCMD_C2H_FUNC_RX_FORWARD 0x5
#define FWCMD_C2H_FUNC_GET_PUNC 0x6

// CLASS 10 - MPORT
#define FWCMD_C2H_FUNC_PORT_INIT_STAT 0x0
#define FWCMD_C2H_FUNC_PORT_CFG_STAT 0x1

// CLASS 11 - OFDMA_INFO
#define FWCMD_C2H_FUNC_OFDMA_STS 0x0
#define FWCMD_C2H_FUNC_OFDMA_STS_V1 0x0

// CLASS 12 - MLO
#define FWCMD_C2H_FUNC_MLO_GET_TBL 0x0
#define FWCMD_C2H_FUNC_EMLSR_TRANS_DONE 0x1
#define FWCMD_C2H_FUNC_EMLSR_STA_CFG_DONE 0x2
#define FWCMD_C2H_FUNC_MCMLO_RELINK_RPT 0x3
#define FWCMD_C2H_FUNC_MCMLO_SN_SYNC_RPT 0x4
#define FWCMD_C2H_FUNC_MLO_LINK_CFG_STAT 0x5
#define FWCMD_C2H_FUNC_MLO_DM_DBG_DUMP 0x6
#define FWCMD_C2H_FUNC_MLO_DM_STATUS_DUMP 0x7
#define FWCMD_C2H_FUNC_MCMLO_TABLE_ACC_RPT 0x8

// CLASS 13 - NAN
#define FWCMD_C2H_FUNC_ACT_SCHEDULE_REQ_ACK 0x0
#define FWCMD_C2H_FUNC_BCN_REQ_ACK 0x1
#define FWCMD_C2H_FUNC_NAN_FUNC_CTRL_ACK 0x2
#define FWCMD_C2H_FUNC_NAN_DE_INFO_ACK 0x3
#define FWCMD_C2H_FUNC_NAN_JOIN_CLUSTER_ACK 0x4
#define FWCMD_C2H_FUNC_NAN_PAUSE_FAW_TX_ACK 0x5
#define FWCMD_C2H_FUNC_NAN_INFO_NOTIFY_CLUSTER_INFO 0x6
#define FWCMD_C2H_FUNC_NAN_INFO_NOTIFY_TSF_INFO 0x7
#define FWCMD_C2H_FUNC_NAN_INFO_NOTIFY_CLUSTER_JOIN 0x8
#define FWCMD_C2H_FUNC_NAN_DEINIT_RPT 0x9

// CLASS 14 - MRC
#define FWCMD_C2H_FUNC_MRC_TSF_RPT 0x0
#define FWCMD_C2H_FUNC_MRC_STATUS_RPT 0x1
#define FWCMD_C2H_FUNC_MRC_NOTIFY_EVT 0x2

// CLASS 15 - PS
#define FWCMD_C2H_FUNC_DOZE_TIME_RPT 0x0

// CLASS 16 - OFFLOAD_AGG
#define FWCMD_C2H_FUNC_DCTL_INFO_DWORD 0x0

// CLASS 17 - ECO_PATCH
#define FWCMD_C2H_FUNC_OM_ADV_RPT 0x0

// CLASS 18 - WOW_DIAG
#define FWCMD_C2H_FUNC_WOW_DIAG_RPT 0x00
#define FWCMD_C2H_FUNC_WOW_DIAG_GTK 0x01
#define FWCMD_C2H_FUNC_WOW_DIAG_AP_LOST 0x02
#define FWCMD_C2H_FUNC_WOW_DIAG_SER 0x03
#define FWCMD_C2H_FUNC_WOW_DIAG_RX_EVT 0x04
#define FWCMD_C2H_FUNC_WOW_DIAG_KEEPALIVE 0x05
#define FWCMD_C2H_FUNC_WOW_DIAG_ARP 0x06
#define FWCMD_C2H_FUNC_WOW_DIAG_NS 0x07
#define FWCMD_C2H_FUNC_WOW_DIAG_PMF 0x08
#define FWCMD_C2H_FUNC_WOW_DIAG_PER_WAKE 0x09
#define FWCMD_C2H_FUNC_WOW_DIAG_NLO 0x0A
#define FWCMD_C2H_FUNC_WOW_DIAG_STA_CSA 0x0B
#define FWCMD_C2H_FUNC_WOW_DIAG_TCP_KEEPALIVE 0x0C
#define FWCMD_C2H_FUNC_WOW_DIAG_PROXY_OFLD 0x0D

// CLASS 19 - WOW_TRI_EVT
#define FWCMD_C2H_FUNC_WOW_DUMP_RX 0x00
#define FWCMD_C2H_FUNC_WOW_DUMP_MEM 0x01
#define FWCMD_C2H_FUNC_WOW_DUMP_ROLE 0x02
#define FWCMD_C2H_FUNC_WOW_DUMP_BB_RF_REG 0x03

// CLASS 20 - FTM_AZ
#define FWCMD_C2H_FUNC_FTM_AZ_PKTID_CONTENT 0x00
#define FWCMD_C2H_FUNC_FTM_AZ_PARA_DUMP 0x01
#define FWCMD_C2H_FUNC_FTM_AZ_DBG_DUMP 0x02
#define FWCMD_C2H_FUNC_FTM_AZ_RPT_HDL 0x03

// CLASS 21 - FTM_MC
#define FWCMD_C2H_FUNC_FTM_MC_PKTID_CONTENT 0x00

// CLASS 22 - AP_SELF_DIAG_RST
#define FWCMD_C2H_FUNC_AP_SELF_DIAG_RST 0x00

// CLASS 23 - STA_DIAG
#define FWCMD_C2H_FUNC_STA_DIAG_RPT 0x00
#define FWCMD_C2H_FUNC_STA_DIAG_SCAN 0x01
#define FWCMD_C2H_FUNC_STA_DIAG_CSA 0x02
#define FWCMD_C2H_FUNC_STA_DIAG_PS 0x03
#define FWCMD_C2H_FUNC_STA_DIAG_MCC 0x04
#define FWCMD_C2H_FUNC_STA_DIAG_EFUSE 0x05
#define FWCMD_C2H_FUNC_STA_DIAG_MRC 0x06

// CLASS 24 - SoftAP
#define FWCMD_C2H_FUNC_PWR_INT_NOTIFY 0x00

// CLASS 25 - HOST_REL
#define FWCMD_C2H_FUNC_PCIE_WP_TO_CNTER_INFO 0x00

// CLASS 26 - HCI
#define FWCMD_C2H_FUNC_USB_TP_DBG_MON_RPT_INFO 0x00

/*----------------------------------- C2HPKT - CAT(OutSrc, Phydm) ------------------*/
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2
#define FWCMD_C2H_CL_RUA 0x0
#define FWCMD_C2H_CL_RA 0x1
#define FWCMD_C2H_CL_HALBB 0x2
#define FWCMD_C2H_CL_DBG 0x7

// CLASS 0
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 1
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 2
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 3
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 4
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 5
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 6
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 7
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

/*----------------------------------- C2HPKT - CAT(OutSrc, RF) ---------------------*/
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2

// CLASS 9 - HALRF_C2H_REPORT
#define FWCMD_C2H_FUNC_RF_REPORT 0x0

// CLASS 10
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 11
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 12
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 13
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 14
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 15
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

/*----------------------------------- C2HPKT - CAT(OutSrc, BTC) --------------------*/
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2

// CLASS 16
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// Bit definition//

/*----------------------------------- H2CREG ---------------------------------------*/
#define FWCMD_H2CREG_H2CREG_HDR_FUNC_SH 0
#define FWCMD_H2CREG_H2CREG_HDR_FUNC_MSK 0x7f
#define FWCMD_H2CREG_H2CREG_HDR_ACK BIT(7)
#define FWCMD_H2CREG_H2CREG_HDR_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_H2CREG_HDR_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_H2CREG_HDR_SEQ_NUM_SH 12
#define FWCMD_H2CREG_H2CREG_HDR_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_H2CREG_DWORD0_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD0_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_DWORD1_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD1_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_DWORD2_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD2_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_DWORD3_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD3_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_LB_FUNC_SH 0
#define FWCMD_H2CREG_H2CREG_LB_FUNC_MSK 0x7f
#define FWCMD_H2CREG_H2CREG_LB_ACK BIT(7)
#define FWCMD_H2CREG_H2CREG_LB_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_H2CREG_LB_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_H2CREG_LB_SEQ_NUM_SH 12
#define FWCMD_H2CREG_H2CREG_LB_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD0_SH 16
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD0_MSK 0xffff
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD1_SH 0
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2CREG_CNSL_CMD_FUNC_SH 0
#define FWCMD_H2CREG_CNSL_CMD_FUNC_MSK 0x7f
#define FWCMD_H2CREG_CNSL_CMD_ACK BIT(7)
#define FWCMD_H2CREG_CNSL_CMD_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_CNSL_CMD_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_CNSL_CMD_SEQ_NUM_SH 12
#define FWCMD_H2CREG_CNSL_CMD_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_CNSL_CMD_CMD_ID_SH 16
#define FWCMD_H2CREG_CNSL_CMD_CMD_ID_MSK 0xff
#define FWCMD_H2CREG_CNSL_CMD_ARG_NUM_SH 24
#define FWCMD_H2CREG_CNSL_CMD_ARG_NUM_MSK 0xf
#define FWCMD_H2CREG_CNSL_CMD_ARG_UNIT_SH 28
#define FWCMD_H2CREG_CNSL_CMD_ARG_UNIT_MSK 0x3
#define FWCMD_H2CREG_FWERR_FUNC_SH 0
#define FWCMD_H2CREG_FWERR_FUNC_MSK 0x7f
#define FWCMD_H2CREG_FWERR_ACK BIT(7)
#define FWCMD_H2CREG_FWERR_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_FWERR_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_FWERR_SEQ_NUM_SH 12
#define FWCMD_H2CREG_FWERR_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_FWERR_OP_SH 16
#define FWCMD_H2CREG_FWERR_OP_MSK 0xf
#define FWCMD_H2CREG_FWERR_IDX_SH 0
#define FWCMD_H2CREG_FWERR_IDX_MSK 0xffffffff
#define FWCMD_H2CREG_HIDDEN_GET_FUNC_SH 0
#define FWCMD_H2CREG_HIDDEN_GET_FUNC_MSK 0x7f
#define FWCMD_H2CREG_HIDDEN_GET_ACK BIT(7)
#define FWCMD_H2CREG_HIDDEN_GET_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_HIDDEN_GET_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_HIDDEN_GET_SEQ_NUM_SH 12
#define FWCMD_H2CREG_HIDDEN_GET_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_HIDDEN_GET_PART_NUM_SH 16
#define FWCMD_H2CREG_HIDDEN_GET_PART_NUM_MSK 0xff
#define FWCMD_H2CREG_GETPKT_INFORM_FUNC_SH 0
#define FWCMD_H2CREG_GETPKT_INFORM_FUNC_MSK 0x7f
#define FWCMD_H2CREG_GETPKT_INFORM_ACK BIT(7)
#define FWCMD_H2CREG_GETPKT_INFORM_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_GETPKT_INFORM_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_GETPKT_INFORM_SEQ_NUM_SH 12
#define FWCMD_H2CREG_GETPKT_INFORM_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_GETPKT_INFORM_MACID_SH 16
#define FWCMD_H2CREG_GETPKT_INFORM_MACID_MSK 0xff
#define FWCMD_H2CREG_GETPKT_INFORM_PKTTYPE_SH 24
#define FWCMD_H2CREG_GETPKT_INFORM_PKTTYPE_MSK 0xff
#define FWCMD_H2CREG_GETPKT_INFORM_MACID_EXT_SH 0
#define FWCMD_H2CREG_GETPKT_INFORM_MACID_EXT_MSK 0xff
#define FWCMD_H2CREG_GETPKT_INFORM_BAND_SH 8
#define FWCMD_H2CREG_GETPKT_INFORM_BAND_MSK 0xff
#define FWCMD_H2CREG_SCH_TX_EN_FUNC_SH 0
#define FWCMD_H2CREG_SCH_TX_EN_FUNC_MSK 0x7f
#define FWCMD_H2CREG_SCH_TX_EN_ACK BIT(7)
#define FWCMD_H2CREG_SCH_TX_EN_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_SCH_TX_EN_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_SCH_TX_EN_SEQ_NUM_SH 12
#define FWCMD_H2CREG_SCH_TX_EN_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BE0 BIT(16)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BK0 BIT(17)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VI0 BIT(18)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VO0 BIT(19)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BE1 BIT(20)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BK1 BIT(21)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VI1 BIT(22)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VO1 BIT(23)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_MG0 BIT(24)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_MG1 BIT(25)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_MG2 BIT(26)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_HI BIT(27)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BCN BIT(28)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_UL BIT(29)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_TWT0 BIT(30)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_TWT1 BIT(31)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BE0 BIT(0)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BK0 BIT(1)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VI0 BIT(2)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VO0 BIT(3)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BE1 BIT(4)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BK1 BIT(5)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VI1 BIT(6)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VO1 BIT(7)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_MG0 BIT(8)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_MG1 BIT(9)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_MG2 BIT(10)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_HI BIT(11)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BCN BIT(12)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_UL BIT(13)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_TWT0 BIT(14)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_TWT1 BIT(15)
#define FWCMD_H2CREG_SCH_TX_EN_BAND BIT(16)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_TWT2 BIT(17)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_TWT3 BIT(18)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_SPEQ0 BIT(19)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_SPEQ1 BIT(20)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_TWT2 BIT(21)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_TWT3 BIT(22)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_SPEQ0 BIT(23)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_SPEQ1 BIT(24)
#define FWCMD_H2CREG_WOW_TRX_STOP_FUNC_SH 0
#define FWCMD_H2CREG_WOW_TRX_STOP_FUNC_MSK 0x7f
#define FWCMD_H2CREG_WOW_TRX_STOP_ACK BIT(7)
#define FWCMD_H2CREG_WOW_TRX_STOP_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_WOW_TRX_STOP_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_WOW_TRX_STOP_SEQ_NUM_SH 12
#define FWCMD_H2CREG_WOW_TRX_STOP_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_1_FUNC_SH 0
#define FWCMD_H2CREG_AOAC_RPT_1_FUNC_MSK 0x7f
#define FWCMD_H2CREG_AOAC_RPT_1_ACK BIT(7)
#define FWCMD_H2CREG_AOAC_RPT_1_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_AOAC_RPT_1_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_1_SEQ_NUM_SH 12
#define FWCMD_H2CREG_AOAC_RPT_1_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_1_RPT_SH 16
#define FWCMD_H2CREG_AOAC_RPT_1_RPT_MSK 0xffff
#define FWCMD_H2CREG_AOAC_RPT_2_FUNC_SH 0
#define FWCMD_H2CREG_AOAC_RPT_2_FUNC_MSK 0x7f
#define FWCMD_H2CREG_AOAC_RPT_2_ACK BIT(7)
#define FWCMD_H2CREG_AOAC_RPT_2_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_AOAC_RPT_2_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_2_SEQ_NUM_SH 12
#define FWCMD_H2CREG_AOAC_RPT_2_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_2_RPT_SH 16
#define FWCMD_H2CREG_AOAC_RPT_2_RPT_MSK 0xffff
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_FUNC_SH 0
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_FUNC_MSK 0x7f
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_ACK BIT(7)
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_SEQ_NUM_SH 12
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_RPT_SH 16
#define FWCMD_H2CREG_AOAC_RPT_3_REQ_RPT_MSK 0xffff
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_FUNC_SH 0
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_FUNC_MSK 0x7f
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_ACK BIT(7)
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_SEQ_NUM_SH 12
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_FW_RX_EN_SH 16
#define FWCMD_H2CREG_WOW_CPUIO_RX_CTRL_FW_RX_EN_MSK 0xff
#define FWCMD_H2CREG_SET_GPIO_FUNC_SH 0
#define FWCMD_H2CREG_SET_GPIO_FUNC_MSK 0x7f
#define FWCMD_H2CREG_SET_GPIO_ACK BIT(7)
#define FWCMD_H2CREG_SET_GPIO_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_SET_GPIO_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_SET_GPIO_SEQ_NUM_SH 12
#define FWCMD_H2CREG_SET_GPIO_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_FUNC_SH 0
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_FUNC_MSK 0x7f
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_ACK BIT(7)
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_SEQ_NUM_SH 12
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_BACKTRACE_ADDR_SH 0
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_BACKTRACE_ADDR_MSK 0xffffffff
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_DBGREG_ADDR_SH 0
#define FWCMD_H2CREG_FWDBG_ADDR_CFG_DBGREG_ADDR_MSK 0xffffffff

/*----------------------------------- C2HREG ---------------------------------------*/
#define FWCMD_C2HREG_C2HREG_HDR_FUNC_SH 0
#define FWCMD_C2HREG_C2HREG_HDR_FUNC_MSK 0x7f
#define FWCMD_C2HREG_C2HREG_HDR_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_C2HREG_HDR_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_C2HREG_HDR_SEQ_NUM_SH 12
#define FWCMD_C2HREG_C2HREG_HDR_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_C2HREG_DWORD0_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD0_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_DWORD1_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD1_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_DWORD2_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD2_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_DWORD3_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD3_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_LB_FUNC_SH 0
#define FWCMD_C2HREG_C2HREG_LB_FUNC_MSK 0x7f
#define FWCMD_C2HREG_C2HREG_LB_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_C2HREG_LB_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_C2HREG_LB_SEQ_NUM_SH 12
#define FWCMD_C2HREG_C2HREG_LB_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD0_SH 16
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD0_MSK 0xffff
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD1_SH 0
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD1_MSK 0xffffffff
#define FWCMD_C2HREG_ERR_RPT_FUNC_SH 0
#define FWCMD_C2HREG_ERR_RPT_FUNC_MSK 0x7f
#define FWCMD_C2HREG_ERR_RPT_ACK BIT(7)
#define FWCMD_C2HREG_ERR_RPT_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_ERR_RPT_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_ERR_RPT_SEQ_NUM_SH 12
#define FWCMD_C2HREG_ERR_RPT_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_ERR_RPT_IDX_SH 16
#define FWCMD_C2HREG_ERR_RPT_IDX_MSK 0xf
#define FWCMD_C2HREG_ERR_RPT_CODE_SH 0
#define FWCMD_C2HREG_ERR_RPT_CODE_MSK 0xffffffff
#define FWCMD_C2HREG_ERR_MSG_FUNC_SH 0
#define FWCMD_C2HREG_ERR_MSG_FUNC_MSK 0x7f
#define FWCMD_C2HREG_ERR_MSG_ACK BIT(7)
#define FWCMD_C2HREG_ERR_MSG_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_ERR_MSG_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_ERR_MSG_SEQ_NUM_SH 12
#define FWCMD_C2HREG_ERR_MSG_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_ERR_MSG_MSG_SH 16
#define FWCMD_C2HREG_ERR_MSG_MSG_MSK 0xffff
#define FWCMD_C2HREG_EFUSE_HIDDEN_FUNC_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_FUNC_MSK 0x7f
#define FWCMD_C2HREG_EFUSE_HIDDEN_ACK BIT(7)
#define FWCMD_C2HREG_EFUSE_HIDDEN_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_EFUSE_HIDDEN_SEQ_NUM_SH 12
#define FWCMD_C2HREG_EFUSE_HIDDEN_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_EFUSE_HIDDEN_RX_NSS_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_RX_NSS_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_BW_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_BW_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_TX_NSS_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_TX_NSS_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PROT80211_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_PROT80211_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_NIC_ROUTER_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_NIC_ROUTER_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_WL_FUNC_SUPPORT_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_WL_FUNC_SUPPORT_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_HW_SPECIAL_TYPE_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_HW_SPECIAL_TYPE_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_0_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_0_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_1_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_1_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_2_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_2_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_3_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_UUID_BYTE_3_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_TX_PATH_NUM_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_TX_PATH_NUM_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_RX_PATH_NUM_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_RX_PATH_NUM_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_BAND_SEL_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_BAND_SEL_MSK 0xff
#define FWCMD_C2HREG_TX_PAUSE_RPT_FUNC_SH 0
#define FWCMD_C2HREG_TX_PAUSE_RPT_FUNC_MSK 0x7f
#define FWCMD_C2HREG_TX_PAUSE_RPT_ACK BIT(7)
#define FWCMD_C2HREG_TX_PAUSE_RPT_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_TX_PAUSE_RPT_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_TX_PAUSE_RPT_SEQ_NUM_SH 12
#define FWCMD_C2HREG_TX_PAUSE_RPT_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_TX_PAUSE_RPT_RPT_SH 16
#define FWCMD_C2HREG_TX_PAUSE_RPT_RPT_MSK 0xffff
#define FWCMD_C2HREG_AOAC_RPT_1_FUNC_SH 0
#define FWCMD_C2HREG_AOAC_RPT_1_FUNC_MSK 0x7f
#define FWCMD_C2HREG_AOAC_RPT_1_ACK BIT(7)
#define FWCMD_C2HREG_AOAC_RPT_1_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_AOAC_RPT_1_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_1_SEQ_NUM_SH 12
#define FWCMD_C2HREG_AOAC_RPT_1_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_1_KEY_IDX_SH 16
#define FWCMD_C2HREG_AOAC_RPT_1_KEY_IDX_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_REKEY_OK_SH 24
#define FWCMD_C2HREG_AOAC_RPT_1_REKEY_OK_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_0_SH 0
#define FWCMD_C2HREG_AOAC_RPT_1_IV_0_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_1_SH 8
#define FWCMD_C2HREG_AOAC_RPT_1_IV_1_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_2_SH 16
#define FWCMD_C2HREG_AOAC_RPT_1_IV_2_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_3_SH 24
#define FWCMD_C2HREG_AOAC_RPT_1_IV_3_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_4_SH 0
#define FWCMD_C2HREG_AOAC_RPT_1_IV_4_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_5_SH 8
#define FWCMD_C2HREG_AOAC_RPT_1_IV_5_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_6_SH 16
#define FWCMD_C2HREG_AOAC_RPT_1_IV_6_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_IV_7_SH 24
#define FWCMD_C2HREG_AOAC_RPT_1_IV_7_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_0_SH 0
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_0_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_1_SH 8
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_1_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_2_SH 16
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_2_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_3_SH 24
#define FWCMD_C2HREG_AOAC_RPT_1_PKT_IV_3_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_FUNC_SH 0
#define FWCMD_C2HREG_AOAC_RPT_2_FUNC_MSK 0x7f
#define FWCMD_C2HREG_AOAC_RPT_2_ACK BIT(7)
#define FWCMD_C2HREG_AOAC_RPT_2_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_AOAC_RPT_2_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_2_SEQ_NUM_SH 12
#define FWCMD_C2HREG_AOAC_RPT_2_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_4_SH 16
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_4_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_5_SH 24
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_5_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_6_SH 0
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_6_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_7_SH 8
#define FWCMD_C2HREG_AOAC_RPT_2_PKT_IV_7_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_0_SH 16
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_0_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_1_SH 24
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_1_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_2_SH 0
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_2_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_3_SH 8
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_3_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_4_SH 16
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_4_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_5_SH 24
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_5_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_6_SH 0
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_6_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_7_SH 8
#define FWCMD_C2HREG_AOAC_RPT_2_IGTK_IPN_7_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_3_FUNC_SH 0
#define FWCMD_C2HREG_AOAC_RPT_3_FUNC_MSK 0x7f
#define FWCMD_C2HREG_AOAC_RPT_3_ACK BIT(7)
#define FWCMD_C2HREG_AOAC_RPT_3_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_AOAC_RPT_3_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_3_SEQ_NUM_SH 12
#define FWCMD_C2HREG_AOAC_RPT_3_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_3_RPT_SH 16
#define FWCMD_C2HREG_AOAC_RPT_3_RPT_MSK 0xffff
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_PRI_CH_SH 0
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_PRI_CH_MSK 0xff
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_BW_SH 8
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_BW_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_CH_OFFSET_SH 12
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_CH_OFFSET_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_CHSW_FAILED BIT(16)
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_CH_BAND_SH 17
#define FWCMD_C2HREG_AOAC_RPT_3_CSA_CH_BAND_MSK 0x3
#define FWCMD_C2HREG_WOW_TRX_STOP_FUNC_SH 0
#define FWCMD_C2HREG_WOW_TRX_STOP_FUNC_MSK 0x7f
#define FWCMD_C2HREG_WOW_TRX_STOP_ACK BIT(7)
#define FWCMD_C2HREG_WOW_TRX_STOP_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_WOW_TRX_STOP_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_WOW_TRX_STOP_SEQ_NUM_SH 12
#define FWCMD_C2HREG_WOW_TRX_STOP_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_WOW_TRX_STOP_RPT_SH 16
#define FWCMD_C2HREG_WOW_TRX_STOP_RPT_MSK 0xffff
#define FWCMD_C2HREG_IO_OFLD_RESULT_FUNC_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_FUNC_MSK 0x7f
#define FWCMD_C2HREG_IO_OFLD_RESULT_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_IO_OFLD_RESULT_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_IO_OFLD_RESULT_SEQ_NUM_SH 12
#define FWCMD_C2HREG_IO_OFLD_RESULT_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_IO_OFLD_RESULT_RET_SH 16
#define FWCMD_C2HREG_IO_OFLD_RESULT_RET_MSK 0xff
#define FWCMD_C2HREG_IO_OFLD_RESULT_CMD_NUM_SH 24
#define FWCMD_C2HREG_IO_OFLD_RESULT_CMD_NUM_MSK 0xff
#define FWCMD_C2HREG_IO_OFLD_RESULT_OFFSET_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_OFFSET_MSK 0xffffffff
#define FWCMD_C2HREG_IO_OFLD_RESULT_EXP_VAL_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_EXP_VAL_MSK 0xffffffff
#define FWCMD_C2HREG_IO_OFLD_RESULT_R_VAL_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_R_VAL_MSK 0xffffffff
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_FUNC_SH 0
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_FUNC_MSK 0x7f
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_ACK BIT(7)
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_SEQ_NUM_SH 12
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_FW_RX_EN_SH 16
#define FWCMD_C2HREG_WOW_CPUIO_RX_ACK_FW_RX_EN_MSK 0xff
#define FWCMD_C2HREG_FWDBG_ADDR_STS_FUNC_SH 0
#define FWCMD_C2HREG_FWDBG_ADDR_STS_FUNC_MSK 0x7f
#define FWCMD_C2HREG_FWDBG_ADDR_STS_ACK BIT(7)
#define FWCMD_C2HREG_FWDBG_ADDR_STS_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_FWDBG_ADDR_STS_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_FWDBG_ADDR_STS_SEQ_NUM_SH 12
#define FWCMD_C2HREG_FWDBG_ADDR_STS_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_FWDBG_ADDR_STS_RET_SH 16
#define FWCMD_C2HREG_FWDBG_ADDR_STS_RET_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_FUNC_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_FUNC_MSK 0x7f
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_ACK BIT(7)
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_SEQ_NUM_SH 12
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA0_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA0_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA1_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA1_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA2_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA2_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA3_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA3_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA4_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA4_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA5_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA5_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA6_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA6_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA7_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA7_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA8_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA8_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA9_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA9_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA10_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA10_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA11_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA11_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA12_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA12_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA13_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_PART1_DATA13_MSK 0xff

/*----------------------------------- H2CPKT - CAT(TEST) ---------------------------*/
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_H2C_LB_PAYLOAD0_SH 0
#define FWCMD_H2C_H2C_LB_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_H2C_LB_PAYLOAD1_SH 0
#define FWCMD_H2C_H2C_LB_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_LOG_TEST_LEN_SH 0
#define FWCMD_H2C_LOG_TEST_LEN_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD0_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD1_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD2_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD2_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD3_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD3_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD4_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD4_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD5_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD5_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_WRITE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FL_WRITE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_WRITE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FL_WRITE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_ERASE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FL_ERASE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_ERASE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FL_ERASE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PL_FLASH_READ_ADDR_SH 0
#define FWCMD_H2C_PL_FLASH_READ_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PL_FLASH_READ_LENGTH_SH 0
#define FWCMD_H2C_PL_FLASH_READ_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_LONG_RUN_PAYLOAD0_SH 0
#define FWCMD_H2C_LONG_RUN_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_LONG_RUN_PAYLOAD1_SH 0
#define FWCMD_H2C_LONG_RUN_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_LPS_TEST_COUNT_SH 0
#define FWCMD_H2C_LPS_TEST_COUNT_MSK 0xffffffff
#define FWCMD_H2C_LPS_ONOFF_TEST_TYPE_SH 0
#define FWCMD_H2C_LPS_ONOFF_TEST_TYPE_MSK 0xffffffff
#define FWCMD_H2C_LPS_ONOFF_TEST_PARA_SH 0
#define FWCMD_H2C_LPS_ONOFF_TEST_PARA_MSK 0xffffffff
#define FWCMD_H2C_CPUMGENQ_TEST_PKTLEN_SH 0
#define FWCMD_H2C_CPUMGENQ_TEST_PKTLEN_MSK 0xffff
#define FWCMD_H2C_CPUMGENQ_TEST_MACID_SH 16
#define FWCMD_H2C_CPUMGENQ_TEST_MACID_MSK 0xffff
#define FWCMD_H2C_MPIO_TEST_PKTLEN_SH 0
#define FWCMD_H2C_MPIO_TEST_PKTLEN_MSK 0xffff
#define FWCMD_H2C_MPIO_TEST_MACID_SH 16
#define FWCMD_H2C_MPIO_TEST_MACID_MSK 0xff
#define FWCMD_H2C_MPIOV2_TEST_TYPE_SH 0
#define FWCMD_H2C_MPIOV2_TEST_TYPE_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_TEST_ADDR_SH 0
#define FWCMD_H2C_MPIOV2_TEST_TEST_ADDR_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD0_SH 0
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD1_SH 0
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD2_SH 0
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD2_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD3_SH 0
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD3_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD4_SH 0
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD4_MSK 0xffffffff
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD5_SH 0
#define FWCMD_H2C_MPIOV2_TEST_PAYLOAD5_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_SEQNUM_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_SEQNUM_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_TEST_FUNC_MODE_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_TEST_FUNC_MODE_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_TEST_CNT_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_TEST_CNT_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_BUFFERSIZE_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_BUFFERSIZE_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT_NUM_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT_NUM_MSK 0xffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT_BUFFER_MODE_SH 16
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT_BUFFER_MODE_MSK 0xffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT0_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT0_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT1_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT1_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT2_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT2_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT3_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT3_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT4_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT4_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT5_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT5_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT6_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT6_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT7_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INPUT7_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_RETURN_VALUE_EXPECT_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_RETURN_VALUE_EXPECT_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_RETURN_VALUE_MASK_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_RETURN_VALUE_MASK_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_RETURN_VAL_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_RETURN_VAL_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_CPU_CYCLE_START_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_CPU_CYCLE_START_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_CPU_CYCLE_END_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_CPU_CYCLE_END_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INST_CNT_START_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INST_CNT_START_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INST_CNT_END_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_INST_CNT_END_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_FREERUN_CNT_START_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_FREERUN_CNT_START_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_FREERUN_CNT_END_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_FREERUN_CNT_END_MSK 0xffffffff
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_BUFFER_SH 0
#define FWCMD_H2C_ANYTESTBUSYCALL_TEST_BUFFER_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_SEQNUM_SH 0
#define FWCMD_H2C_ANYRW_TEST_SEQNUM_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_OP_MODE_SH 0
#define FWCMD_H2C_ANYRW_TEST_OP_MODE_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_BUFFERSIZE_SH 0
#define FWCMD_H2C_ANYRW_TEST_BUFFERSIZE_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_INPUT0_SH 0
#define FWCMD_H2C_ANYRW_TEST_INPUT0_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_INPUT1_SH 0
#define FWCMD_H2C_ANYRW_TEST_INPUT1_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_INPUT2_SH 0
#define FWCMD_H2C_ANYRW_TEST_INPUT2_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_INPUT3_SH 0
#define FWCMD_H2C_ANYRW_TEST_INPUT3_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_INPUT4_SH 0
#define FWCMD_H2C_ANYRW_TEST_INPUT4_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_INPUT5_SH 0
#define FWCMD_H2C_ANYRW_TEST_INPUT5_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_RETURN_VAL_SH 0
#define FWCMD_H2C_ANYRW_TEST_RETURN_VAL_MSK 0xffffffff
#define FWCMD_H2C_ANYRW_TEST_BUFFER_SH 0
#define FWCMD_H2C_ANYRW_TEST_BUFFER_MSK 0xffffffff
#define FWCMD_H2C_FW_STATUS_COUNT_SH 0
#define FWCMD_H2C_FW_STATUS_COUNT_MSK 0xffffffff
#define FWCMD_H2C_TRIGGER_CPU_EXCEPTION_TYPE_SH 0
#define FWCMD_H2C_TRIGGER_CPU_EXCEPTION_TYPE_MSK 0xffffffff
#define FWCMD_H2C_FW_PROFILING_TYPE_SH 0
#define FWCMD_H2C_FW_PROFILING_TYPE_MSK 0xffffffff
#define FWCMD_H2C_WOW_AUTO_TEST_RX_TEST BIT(0)
#define FWCMD_H2C_WOW_AUTO_TEST_TX_TEST BIT(1)

/*----------------------------------- H2CPKT - CAT(MAC) ----------------------------*/
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_LOG_CFG_DBG_LV_SH 0
#define FWCMD_H2C_LOG_CFG_DBG_LV_MSK 0xff
#define FWCMD_H2C_LOG_CFG_PATH_SH 8
#define FWCMD_H2C_LOG_CFG_PATH_MSK 0xff
#define FWCMD_H2C_LOG_CFG_COMP_SH 0
#define FWCMD_H2C_LOG_CFG_COMP_MSK 0xffffffff
#define FWCMD_H2C_LOG_CFG_COMP_EXT_SH 0
#define FWCMD_H2C_LOG_CFG_COMP_EXT_MSK 0xffffffff
#define FWCMD_H2C_GENERAL_PKT_MACID_SH 0
#define FWCMD_H2C_GENERAL_PKT_MACID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_PROBRSP_ID_SH 8
#define FWCMD_H2C_GENERAL_PKT_PROBRSP_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_PSPOLL_ID_SH 16
#define FWCMD_H2C_GENERAL_PKT_PSPOLL_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_NULL_ID_SH 24
#define FWCMD_H2C_GENERAL_PKT_NULL_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_QOS_NULL_ID_SH 0
#define FWCMD_H2C_GENERAL_PKT_QOS_NULL_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_CTS2SELF_ID_SH 8
#define FWCMD_H2C_GENERAL_PKT_CTS2SELF_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_PROBREQ_ID_SH 16
#define FWCMD_H2C_GENERAL_PKT_PROBREQ_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_APCSA_ID_SH 24
#define FWCMD_H2C_GENERAL_PKT_APCSA_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_MACID_EXT_SH 0
#define FWCMD_H2C_GENERAL_PKT_MACID_EXT_MSK 0xff
#define FWCMD_H2C_C2H_RPT_CFG_TX_STATISTIC_EN BIT(0)
#define FWCMD_H2C_C2H_RPT_CFG_RX_STATISTIC_EN BIT(1)
#define FWCMD_H2C_C2H_RPT_CFG_BEACON_STATISTIC_EN BIT(2)
#define FWCMD_H2C_C2H_RPT_CFG_DL_STATISTIC_EN BIT(3)
#define FWCMD_H2C_C2H_RPT_CFG_RPT_INTERVAL_SH 0
#define FWCMD_H2C_C2H_RPT_CFG_RPT_INTERVAL_MSK 0xffff
#define FWCMD_H2C_FW_DBGREG_CFG_FW_DBG_LOCK BIT(0)
#define FWCMD_H2C_FW_REDL_CFG_STOP_WATCHDOG BIT(0)
#define FWCMD_H2C_FW_REDL_CFG_RESET_IDMEM_MODE BIT(1)
#define FWCMD_H2C_FW_SELF_DX_FWDX_TIME_INTERVAL_SH 0
#define FWCMD_H2C_FW_SELF_DX_FWDX_TIME_INTERVAL_MSK 0xffff
#define FWCMD_H2C_FW_SELF_DX_FWDX_GET_ENABLE_ITEM BIT(16)
#define FWCMD_H2C_FW_SELF_DX_FWDX_HEAP_REMAIN BIT(0)
#define FWCMD_H2C_FW_SELF_DX_FWDX_IRQ_CNT BIT(1)
#define FWCMD_H2C_FW_SELF_DX_FWDX_AXIDMA_DEBUG_INFO BIT(2)
#define FWCMD_H2C_FW_SELF_DX_FWDX_CPUIO_DEBUG_INFO BIT(3)
#define FWCMD_H2C_FW_DBG_ADDR_CFG_BACKTRACE_ADDR_SH 0
#define FWCMD_H2C_FW_DBG_ADDR_CFG_BACKTRACE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_FW_DBG_ADDR_CFG_DBGREG_ADDR_SH 0
#define FWCMD_H2C_FW_DBG_ADDR_CFG_DBGREG_ADDR_MSK 0xffffffff
#define FWCMD_H2C_KEEP_ALIVE_KEEPALIVE_EN BIT(0)
#define FWCMD_H2C_KEEP_ALIVE_TX_TYPE_SH 1
#define FWCMD_H2C_KEEP_ALIVE_TX_TYPE_MSK 0x7f
#define FWCMD_H2C_KEEP_ALIVE_PACKET_ID_SH 8
#define FWCMD_H2C_KEEP_ALIVE_PACKET_ID_MSK 0xff
#define FWCMD_H2C_KEEP_ALIVE_PERIOD_SH 16
#define FWCMD_H2C_KEEP_ALIVE_PERIOD_MSK 0xff
#define FWCMD_H2C_KEEP_ALIVE_MAC_ID_SH 24
#define FWCMD_H2C_KEEP_ALIVE_MAC_ID_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_DISCONNECT_DETECT_EN BIT(0)
#define FWCMD_H2C_DISCONNECT_DETECT_TRYOK_BCNFAIL_COUNT_EN BIT(1)
#define FWCMD_H2C_DISCONNECT_DETECT_DISCONNECT_EN BIT(2)
#define FWCMD_H2C_DISCONNECT_DETECT_MAC_ID_SH 8
#define FWCMD_H2C_DISCONNECT_DETECT_MAC_ID_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_CHECK_PERIOD_SH 16
#define FWCMD_H2C_DISCONNECT_DETECT_CHECK_PERIOD_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_TRY_PKT_COUNT_SH 24
#define FWCMD_H2C_DISCONNECT_DETECT_TRY_PKT_COUNT_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_TRYOK_BCNFAIL_COUNT_LIMIT_SH 0
#define FWCMD_H2C_DISCONNECT_DETECT_TRYOK_BCNFAIL_COUNT_LIMIT_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_WOW_EN BIT(0)
#define FWCMD_H2C_WOW_GLOBAL_DROP_ALL_PKT BIT(1)
#define FWCMD_H2C_WOW_GLOBAL_RX_PARSE_AFTER_WAKE BIT(2)
#define FWCMD_H2C_WOW_GLOBAL_WAKE_BAR_PULLED BIT(3)
#define FWCMD_H2C_WOW_GLOBAL_PMF_BIP_SEC_ALGO_SH 6
#define FWCMD_H2C_WOW_GLOBAL_PMF_BIP_SEC_ALGO_MSK 0x3
#define FWCMD_H2C_WOW_GLOBAL_MAC_ID_SH 8
#define FWCMD_H2C_WOW_GLOBAL_MAC_ID_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_PAIRWISE_SEC_ALGO_SH 16
#define FWCMD_H2C_WOW_GLOBAL_PAIRWISE_SEC_ALGO_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_GROUP_SEC_ALGO_SH 24
#define FWCMD_H2C_WOW_GLOBAL_GROUP_SEC_ALGO_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_REMOTECTRL_INFO_CONTENT_SH 0
#define FWCMD_H2C_WOW_GLOBAL_REMOTECTRL_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_GTK_OFLD_GTK_EN BIT(0)
#define FWCMD_H2C_GTK_OFLD_TKIP_EN BIT(1)
#define FWCMD_H2C_GTK_OFLD_IEEE80211W_EN BIT(2)
#define FWCMD_H2C_GTK_OFLD_PAIRWISE_WAKEUP BIT(3)
#define FWCMD_H2C_GTK_OFLD_NOREKEY_WAKEUP BIT(4)
#define FWCMD_H2C_GTK_OFLD_BCN_PROT_EN BIT(5)
#define FWCMD_H2C_GTK_OFLD_AOAC_REPORT_ID_SH 8
#define FWCMD_H2C_GTK_OFLD_AOAC_REPORT_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_MAC_ID_SH 16
#define FWCMD_H2C_GTK_OFLD_MAC_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_GTK_RSP_ID_SH 24
#define FWCMD_H2C_GTK_OFLD_GTK_RSP_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_PMF_SA_QUERY_ID_SH 0
#define FWCMD_H2C_GTK_OFLD_PMF_SA_QUERY_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_PMF_BIP_SEC_ALGO_SH 8
#define FWCMD_H2C_GTK_OFLD_PMF_BIP_SEC_ALGO_MSK 0x3
#define FWCMD_H2C_GTK_OFLD_ALGO_AKM_SUIT_SH 10
#define FWCMD_H2C_GTK_OFLD_ALGO_AKM_SUIT_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_MAC_ID_EXT_SH 18
#define FWCMD_H2C_GTK_OFLD_MAC_ID_EXT_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_MLD_LINK_ID_SH 26
#define FWCMD_H2C_GTK_OFLD_MLD_LINK_ID_MSK 0xf
#define FWCMD_H2C_GTK_OFLD_GTK_INFO_CONTENT_SH 0
#define FWCMD_H2C_GTK_OFLD_GTK_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_ARP_OFLD_ARP_EN BIT(0)
#define FWCMD_H2C_ARP_OFLD_ARP_ACTION BIT(1)
#define FWCMD_H2C_ARP_OFLD_MAC_ID_SH 16
#define FWCMD_H2C_ARP_OFLD_MAC_ID_MSK 0xff
#define FWCMD_H2C_ARP_OFLD_ARP_RSP_ID_SH 24
#define FWCMD_H2C_ARP_OFLD_ARP_RSP_ID_MSK 0xff
#define FWCMD_H2C_ARP_OFLD_ARP_INFO_CONTENT_SH 0
#define FWCMD_H2C_ARP_OFLD_ARP_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_NDP_OFLD_NDP_EN BIT(0)
#define FWCMD_H2C_NDP_OFLD_MAC_ID_SH 16
#define FWCMD_H2C_NDP_OFLD_MAC_ID_MSK 0xff
#define FWCMD_H2C_NDP_OFLD_NA_ID_SH 24
#define FWCMD_H2C_NDP_OFLD_NA_ID_MSK 0xff
#define FWCMD_H2C_NDP_OFLD_NDP_INFO_CONTENT_SH 0
#define FWCMD_H2C_NDP_OFLD_NDP_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_REALWOW_REALWOW_EN BIT(0)
#define FWCMD_H2C_REALWOW_AUTO_WAKEUP BIT(1)
#define FWCMD_H2C_REALWOW_MAC_ID_SH 24
#define FWCMD_H2C_REALWOW_MAC_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_KEEPALIVE_ID_SH 0
#define FWCMD_H2C_REALWOW_KEEPALIVE_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_WAKEUP_PATTERN_ID_SH 8
#define FWCMD_H2C_REALWOW_WAKEUP_PATTERN_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_ACK_PATTERN_ID_SH 16
#define FWCMD_H2C_REALWOW_ACK_PATTERN_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_REALWOW_INFO_CONTENT_SH 0
#define FWCMD_H2C_REALWOW_REALWOW_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_NLO_NLO_EN BIT(0)
#define FWCMD_H2C_NLO_NLO_32K_EN BIT(1)
#define FWCMD_H2C_NLO_IGNORE_CIPHER_TYPE BIT(2)
#define FWCMD_H2C_NLO_MAC_ID_SH 24
#define FWCMD_H2C_NLO_MAC_ID_MSK 0xff
#define FWCMD_H2C_NLO_NLO_NETWORKLISTINFO_CONTENT_SH 0
#define FWCMD_H2C_NLO_NLO_NETWORKLISTINFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_WAKEUP_CTRL_PATTERN_MATCH_EN BIT(0)
#define FWCMD_H2C_WAKEUP_CTRL_MAGIC_EN BIT(1)
#define FWCMD_H2C_WAKEUP_CTRL_HW_UNICAST_EN BIT(2)
#define FWCMD_H2C_WAKEUP_CTRL_FW_UNICAST_EN BIT(3)
#define FWCMD_H2C_WAKEUP_CTRL_DEAUTH_WAKEUP BIT(4)
#define FWCMD_H2C_WAKEUP_CTRL_REKEY_WAKEUP BIT(5)
#define FWCMD_H2C_WAKEUP_CTRL_EAP_WAKEUP BIT(6)
#define FWCMD_H2C_WAKEUP_CTRL_ALL_DATA_WAKEUP BIT(7)
#define FWCMD_H2C_WAKEUP_CTRL_MAGIC_MLD_EN BIT(8)
#define FWCMD_H2C_WAKEUP_CTRL_MAC_ID_SH 24
#define FWCMD_H2C_WAKEUP_CTRL_MAC_ID_MSK 0xff
#define FWCMD_H2C_NEGATIVE_PATTERN_NEGATIVE_PATTERN_EN BIT(0)
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_COUNT_SH 20
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_COUNT_MSK 0xf
#define FWCMD_H2C_NEGATIVE_PATTERN_MAC_ID_SH 24
#define FWCMD_H2C_NEGATIVE_PATTERN_MAC_ID_MSK 0xff
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_CONTENT_SH 0
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_DEV2HST_GPIO_DEV2HST_GPIO_EN BIT(0)
#define FWCMD_H2C_DEV2HST_GPIO_DISABLE_INBAND BIT(1)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_OUTPUT_INPUT BIT(2)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_ACTIVE BIT(3)
#define FWCMD_H2C_DEV2HST_GPIO_TOGGLE_PULSE BIT(4)
#define FWCMD_H2C_DEV2HST_GPIO_DATA_PIN_WAKEUP BIT(5)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_NONSTOP BIT(6)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_TIME_UNIT BIT(7)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_NUM_SH 8
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_NUM_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_DURATION_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_DURATION_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_PERIOD_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_PERIOD_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_SH 0
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_NUM_EXTEND_RSN_SH 8
#define FWCMD_H2C_DEV2HST_GPIO_NUM_EXTEND_RSN_MSK 0xf
#define FWCMD_H2C_DEV2HST_GPIO_INDICATE_DURATION_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_INDICATE_DURATION_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_INDICATE_INTERMISSION_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_INDICATE_INTERMISSION_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_CUSTOMER_ID_SH 0
#define FWCMD_H2C_DEV2HST_GPIO_CUSTOMER_ID_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_EN BIT(0)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_TOGGLE_PULSE BIT(1)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_NONSTOP BIT(2)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_TIME_UNIT BIT(3)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_SH 0
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_DURATION_SH 8
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_DURATION_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_PERIOD_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_PERIOD_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_COUNT_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_RSN_A_PULSE_COUNT_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_EN BIT(0)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_TOGGLE_PULSE BIT(1)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_NONSTOP BIT(2)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_TIME_UNIT BIT(3)
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_SH 0
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_DURATION_SH 8
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_DURATION_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_PERIOD_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_PERIOD_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_COUNT_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_RSN_B_PULSE_COUNT_MSK 0xff
#define FWCMD_H2C_HST2DEV_CTRL_DISABLE_UPHY BIT(0)
#define FWCMD_H2C_HST2DEV_CTRL_HANDSHAKE_MODE_SH 1
#define FWCMD_H2C_HST2DEV_CTRL_HANDSHAKE_MODE_MSK 0x7
#define FWCMD_H2C_HST2DEV_CTRL_RISE_HST2DEV_DIS_UPHY BIT(8)
#define FWCMD_H2C_HST2DEV_CTRL_UPHY_DIS_DELAY_UNIT BIT(9)
#define FWCMD_H2C_HST2DEV_CTRL_PDN_AS_UPHY_DIS BIT(10)
#define FWCMD_H2C_HST2DEV_CTRL_PDN_TO_ENABLE_UPHY BIT(11)
#define FWCMD_H2C_HST2DEV_CTRL_HST2DEV_EN BIT(12)
#define FWCMD_H2C_HST2DEV_CTRL_HST2DEV_GPIO_NUM_SH 16
#define FWCMD_H2C_HST2DEV_CTRL_HST2DEV_GPIO_NUM_MSK 0xff
#define FWCMD_H2C_HST2DEV_CTRL_UPHY_DIS_DELAY_COUNT_SH 24
#define FWCMD_H2C_HST2DEV_CTRL_UPHY_DIS_DELAY_COUNT_MSK 0xff
#define FWCMD_H2C_WOW_CAM_UPD_R_W BIT(0)
#define FWCMD_H2C_WOW_CAM_UPD_IDX_SH 1
#define FWCMD_H2C_WOW_CAM_UPD_IDX_MSK 0x7f
#define FWCMD_H2C_WOW_CAM_UPD_WKFM1_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM1_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_WKFM2_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM2_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_WKFM3_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM3_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_WKFM4_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM4_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_CRC_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_CRC_MSK 0xffff
#define FWCMD_H2C_WOW_CAM_UPD_NEGATIVE_PATTERN_MATCH BIT(22)
#define FWCMD_H2C_WOW_CAM_UPD_SKIP_MAC_HDR BIT(23)
#define FWCMD_H2C_WOW_CAM_UPD_UC BIT(24)
#define FWCMD_H2C_WOW_CAM_UPD_MC BIT(25)
#define FWCMD_H2C_WOW_CAM_UPD_BC BIT(26)
#define FWCMD_H2C_WOW_CAM_UPD_VALID BIT(31)
#define FWCMD_H2C_AOAC_REPORT_REQ_RX_READY BIT(0)
#define FWCMD_H2C_AOAC_REPORT_REQ_MACID_SH 8
#define FWCMD_H2C_AOAC_REPORT_REQ_MACID_MSK 0xff
#define FWCMD_H2C_AOAC_REPORT_REQ_MACID_EXT_SH 16
#define FWCMD_H2C_AOAC_REPORT_REQ_MACID_EXT_MSK 0xff
#define FWCMD_H2C_WOW_CSA_WOW_CSA_EN BIT(0)
#define FWCMD_H2C_WOW_CSA_SIZE_OF_CHINFO_SH 1
#define FWCMD_H2C_WOW_CSA_SIZE_OF_CHINFO_MSK 0x7f
#define FWCMD_H2C_WOW_CSA_NUM_OF_CHINFO_SH 8
#define FWCMD_H2C_WOW_CSA_NUM_OF_CHINFO_MSK 0xff
#define FWCMD_H2C_WOW_CSA_MACID_SH 16
#define FWCMD_H2C_WOW_CSA_MACID_MSK 0xff
#define FWCMD_H2C_WOW_CSA_MAX_AP_GONE_TIME_SH 24
#define FWCMD_H2C_WOW_CSA_MAX_AP_GONE_TIME_MSK 0xff
#define FWCMD_H2C_MAGIC_WAKER_FILTER_WAKER_NUM_SH 0
#define FWCMD_H2C_MAGIC_WAKER_FILTER_WAKER_NUM_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_MACID_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_MACID_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_PERIOD_SH 8
#define FWCMD_H2C_TCP_KEEPALIVE_PERIOD_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_TX_PKTID_SH 16
#define FWCMD_H2C_TCP_KEEPALIVE_TX_PKTID_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_ENABLE BIT(24)
#define FWCMD_H2C_TCP_KEEPALIVE_RETRY_INTVL_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_RETRY_INTVL_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_MAX_RETRY_CNT_SH 8
#define FWCMD_H2C_TCP_KEEPALIVE_MAX_RETRY_CNT_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_IMMED_TX BIT(16)
#define FWCMD_H2C_TCP_KEEPALIVE_MACID_EXT_SH 17
#define FWCMD_H2C_TCP_KEEPALIVE_MACID_EXT_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_ACK_PKTID_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_ACK_PKTID_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_RECV_KEEPALIVE_TIMEOUT_SH 8
#define FWCMD_H2C_TCP_KEEPALIVE_RECV_KEEPALIVE_TIMEOUT_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_SEQ_INCREASE BIT(16)
#define FWCMD_H2C_TCP_KEEPALIVE_CHK_SRV_IP BIT(17)
#define FWCMD_H2C_TCP_KEEPALIVE_CHK_SRV_PORT BIT(18)
#define FWCMD_H2C_TCP_KEEPALIVE_CHK_CLI_IP BIT(19)
#define FWCMD_H2C_TCP_KEEPALIVE_CHK_CLI_PORT BIT(20)
#define FWCMD_H2C_TCP_KEEPALIVE_PLD_SIZE_THRESH_SH 24
#define FWCMD_H2C_TCP_KEEPALIVE_PLD_SIZE_THRESH_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_RECV_TIMEOUT_FULL_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_RECV_TIMEOUT_FULL_MSK 0xffff
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_PORT_SH 16
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_PORT_MSK 0xffff
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_0_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_0_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_1_SH 8
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_1_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_2_SH 16
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_2_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_3_SH 24
#define FWCMD_H2C_TCP_KEEPALIVE_SRV_IP_3_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_0_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_0_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_1_SH 8
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_1_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_2_SH 16
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_2_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_3_SH 24
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_IP_3_MSK 0xff
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_PORT_SH 0
#define FWCMD_H2C_TCP_KEEPALIVE_CLI_PORT_MSK 0xffff
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_R_W BIT(0)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_IDX_SH 1
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_IDX_MSK 0x7f
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM1_SH 0
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM1_MSK 0xffffffff
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM2_SH 0
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM2_MSK 0xffffffff
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM3_SH 0
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM3_MSK 0xffffffff
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM4_SH 0
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_WKFM4_MSK 0xffffffff
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_UC BIT(0)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_MC BIT(1)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_BC BIT(2)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_SKIP_MAC_HDR BIT(7)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_CRC_SH 0
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_CRC_MSK 0xffff
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_NEGATIVE_PATTERN_MATCH BIT(0)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_VALID BIT(0)
#define FWCMD_H2C_WOW_PAYLOAD_CAM_UPD_IS_WOW_PTN BIT(1)
#define FWCMD_H2C_LPS_PARM_MACID_SH 0
#define FWCMD_H2C_LPS_PARM_MACID_MSK 0xff
#define FWCMD_H2C_LPS_PARM_PSMODE_SH 8
#define FWCMD_H2C_LPS_PARM_PSMODE_MSK 0xff
#define FWCMD_H2C_LPS_PARM_RLBM_SH 16
#define FWCMD_H2C_LPS_PARM_RLBM_MSK 0xf
#define FWCMD_H2C_LPS_PARM_SMARTPS_SH 20
#define FWCMD_H2C_LPS_PARM_SMARTPS_MSK 0xf
#define FWCMD_H2C_LPS_PARM_AWAKEINTERVAL_SH 24
#define FWCMD_H2C_LPS_PARM_AWAKEINTERVAL_MSK 0xff
#define FWCMD_H2C_LPS_PARM_VOUAPSD BIT(0)
#define FWCMD_H2C_LPS_PARM_VIUAPSD BIT(1)
#define FWCMD_H2C_LPS_PARM_BEUAPSD BIT(2)
#define FWCMD_H2C_LPS_PARM_BKUAPSD BIT(3)
#define FWCMD_H2C_LPS_PARM_LASTRPWM_SH 8
#define FWCMD_H2C_LPS_PARM_LASTRPWM_MSK 0xff
#define FWCMD_H2C_LPS_PARM_BCNNOHIT_EN BIT(16)
#define FWCMD_H2C_LPS_PARM_NULLTYPE BIT(17)
#define FWCMD_H2C_LPS_PARM_DYNTXANTNUM_EN BIT(18)
#define FWCMD_H2C_LPS_PARM_MAXTXANTNUM BIT(19)
#define FWCMD_H2C_LPS_PARM_LPSTXANTNUM BIT(20)
#define FWCMD_H2C_LPS_PARM_MACID_EXT_SH 24
#define FWCMD_H2C_LPS_PARM_MACID_EXT_MSK 0xff
#define FWCMD_H2C_P2P_ACT_MACID_SH 0
#define FWCMD_H2C_P2P_ACT_MACID_MSK 0xff
#define FWCMD_H2C_P2P_ACT_P2PID_SH 8
#define FWCMD_H2C_P2P_ACT_P2PID_MSK 0xf
#define FWCMD_H2C_P2P_ACT_NOAID_SH 12
#define FWCMD_H2C_P2P_ACT_NOAID_MSK 0xf
#define FWCMD_H2C_P2P_ACT_ACT_SH 16
#define FWCMD_H2C_P2P_ACT_ACT_MSK 0xf
#define FWCMD_H2C_P2P_ACT_TYPE BIT(20)
#define FWCMD_H2C_P2P_ACT_ALL_SLEP BIT(21)
#define FWCMD_H2C_P2P_ACT_MACID_EXT_SH 24
#define FWCMD_H2C_P2P_ACT_MACID_EXT_MSK 0xff
#define FWCMD_H2C_P2P_ACT_SRT_SH 0
#define FWCMD_H2C_P2P_ACT_SRT_MSK 0xffffffff
#define FWCMD_H2C_P2P_ACT_ITVL_SH 0
#define FWCMD_H2C_P2P_ACT_ITVL_MSK 0xffffffff
#define FWCMD_H2C_P2P_ACT_DUR_SH 0
#define FWCMD_H2C_P2P_ACT_DUR_MSK 0xffffffff
#define FWCMD_H2C_P2P_ACT_CNT_SH 0
#define FWCMD_H2C_P2P_ACT_CNT_MSK 0xff
#define FWCMD_H2C_P2P_ACT_CTW_SH 8
#define FWCMD_H2C_P2P_ACT_CTW_MSK 0xffff
#define FWCMD_H2C_P2P_MACID_CTRL_P2PID_SH 0
#define FWCMD_H2C_P2P_MACID_CTRL_P2PID_MSK 0xf
#define FWCMD_H2C_P2P_MACID_CTRL_CTRL_TYPE_SH 4
#define FWCMD_H2C_P2P_MACID_CTRL_CTRL_TYPE_MSK 0xf
#define FWCMD_H2C_P2P_MACID_CTRL_MACID_SRT_SH 8
#define FWCMD_H2C_P2P_MACID_CTRL_MACID_SRT_MSK 0xff
#define FWCMD_H2C_P2P_MACID_CTRL_BMAP_LEN_SH 16
#define FWCMD_H2C_P2P_MACID_CTRL_BMAP_LEN_MSK 0xff
#define FWCMD_H2C_P2P_MACID_CTRL_MACID_SRT_EXT_SH 24
#define FWCMD_H2C_P2P_MACID_CTRL_MACID_SRT_EXT_MSK 0xff
#define FWCMD_H2C_P2P_MACID_CTRL_BMAP_SRT_SH 0
#define FWCMD_H2C_P2P_MACID_CTRL_BMAP_SRT_MSK 0xffffffff
#define FWCMD_H2C_IPS_CFG_MACID_SH 0
#define FWCMD_H2C_IPS_CFG_MACID_MSK 0xff
#define FWCMD_H2C_IPS_CFG_ENABLE BIT(8)
#define FWCMD_H2C_IPS_CFG_MACID_EXT_SH 16
#define FWCMD_H2C_IPS_CFG_MACID_EXT_MSK 0xff
#define FWCMD_H2C_PS_ADVANCE_PARM_MACID_SH 0
#define FWCMD_H2C_PS_ADVANCE_PARM_MACID_MSK 0xff
#define FWCMD_H2C_PS_ADVANCE_PARM_TRXTIMEOUTTIMESET_SH 8
#define FWCMD_H2C_PS_ADVANCE_PARM_TRXTIMEOUTTIMESET_MSK 0x3
#define FWCMD_H2C_PS_ADVANCE_PARM_ENSMARTPSDTIMRX BIT(10)
#define FWCMD_H2C_PS_ADVANCE_PARM_TRXEXTMODE BIT(11)
#define FWCMD_H2C_PS_ADVANCE_PARM_TRXTIMEOUTTIMEVAL_SH 0
#define FWCMD_H2C_PS_ADVANCE_PARM_TRXTIMEOUTTIMEVAL_MSK 0xff
#define FWCMD_H2C_PS_ADVANCE_PARM_EXTNUM_SH 8
#define FWCMD_H2C_PS_ADVANCE_PARM_EXTNUM_MSK 0xff
#define FWCMD_H2C_PS_ADVANCE_PARM_MACID_EXT_SH 16
#define FWCMD_H2C_PS_ADVANCE_PARM_MACID_EXT_MSK 0xff
#define FWCMD_H2C_PERIODIC_WAKE_MACID_SH 0
#define FWCMD_H2C_PERIODIC_WAKE_MACID_MSK 0xff
#define FWCMD_H2C_PERIODIC_WAKE_ENABLE BIT(8)
#define FWCMD_H2C_PERIODIC_WAKE_BAND BIT(9)
#define FWCMD_H2C_PERIODIC_WAKE_PORT_SH 10
#define FWCMD_H2C_PERIODIC_WAKE_PORT_MSK 0x7
#define FWCMD_H2C_PERIODIC_WAKE_MACID_EXT_SH 13
#define FWCMD_H2C_PERIODIC_WAKE_MACID_EXT_MSK 0xff
#define FWCMD_H2C_PERIODIC_WAKE_WAKE_PERIOD_SH 0
#define FWCMD_H2C_PERIODIC_WAKE_WAKE_PERIOD_MSK 0xffffffff
#define FWCMD_H2C_PERIODIC_WAKE_WAKE_DURATIOIN_SH 0
#define FWCMD_H2C_PERIODIC_WAKE_WAKE_DURATIOIN_MSK 0xffffffff
#define FWCMD_H2C_BB_RF_PWR_ST_BB_RF_PWR_REQ_ST_SH 0
#define FWCMD_H2C_BB_RF_PWR_ST_BB_RF_PWR_REQ_ST_MSK 0xff
#define FWCMD_H2C_PS_POWER_LEVEL_MACID_SH 0
#define FWCMD_H2C_PS_POWER_LEVEL_MACID_MSK 0xff
#define FWCMD_H2C_PS_POWER_LEVEL_BCN_TO_VAL_SH 8
#define FWCMD_H2C_PS_POWER_LEVEL_BCN_TO_VAL_MSK 0xff
#define FWCMD_H2C_PS_POWER_LEVEL_PS_LVL_SH 16
#define FWCMD_H2C_PS_POWER_LEVEL_PS_LVL_MSK 0xf
#define FWCMD_H2C_PS_POWER_LEVEL_TRX_LVL_SH 20
#define FWCMD_H2C_PS_POWER_LEVEL_TRX_LVL_MSK 0xf
#define FWCMD_H2C_PS_POWER_LEVEL_BCN_TO_LVL_SH 24
#define FWCMD_H2C_PS_POWER_LEVEL_BCN_TO_LVL_MSK 0xf
#define FWCMD_H2C_PS_POWER_LEVEL_DTIM_TO_VAL_SH 28
#define FWCMD_H2C_PS_POWER_LEVEL_DTIM_TO_VAL_MSK 0xf
#define FWCMD_H2C_PS_POWER_LEVEL_MACID_EXT_SH 0
#define FWCMD_H2C_PS_POWER_LEVEL_MACID_EXT_MSK 0xff
#define FWCMD_H2C_LPS_OPTION_CFG_REQ_XTAL_OPTION BIT(0)
#define FWCMD_H2C_DOZE_TIME_STATS_MACID_SH 0
#define FWCMD_H2C_DOZE_TIME_STATS_MACID_MSK 0xff
#define FWCMD_H2C_DOZE_TIME_STATS_RPT_PERIOD_SH 8
#define FWCMD_H2C_DOZE_TIME_STATS_RPT_PERIOD_MSK 0xffff
#define FWCMD_H2C_DOZE_TIME_STATS_ENABLE BIT(24)
#define FWCMD_H2C_TBTT_TUNING_BAND_SH 0
#define FWCMD_H2C_TBTT_TUNING_BAND_MSK 0xf
#define FWCMD_H2C_TBTT_TUNING_PORT_SH 4
#define FWCMD_H2C_TBTT_TUNING_PORT_MSK 0xf
#define FWCMD_H2C_TBTT_TUNING_SHIFT_VAL_SH 0
#define FWCMD_H2C_TBTT_TUNING_SHIFT_VAL_MSK 0xffffffff
#define FWCMD_H2C_BKP_CAM_CFG_PL_CAM_NUM_SH 0
#define FWCMD_H2C_BKP_CAM_CFG_PL_CAM_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_WOW_CAM_NUM_SH 8
#define FWCMD_H2C_BKP_CAM_CFG_WOW_CAM_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_ADDR_CAM_NUM_SH 16
#define FWCMD_H2C_BKP_CAM_CFG_ADDR_CAM_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_BSSID_CAM_NUM_SH 24
#define FWCMD_H2C_BKP_CAM_CFG_BSSID_CAM_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_S_DCTRL_NUM_SH 0
#define FWCMD_H2C_BKP_CAM_CFG_S_DCTRL_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_L_DCTRL_NUM_SH 8
#define FWCMD_H2C_BKP_CAM_CFG_L_DCTRL_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_S_CCTRL_NUM_SH 16
#define FWCMD_H2C_BKP_CAM_CFG_S_CCTRL_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_L_CCTRL_NUM_SH 24
#define FWCMD_H2C_BKP_CAM_CFG_L_CCTRL_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_SEC_CAM_NUM_SH 0
#define FWCMD_H2C_BKP_CAM_CFG_SEC_CAM_NUM_MSK 0xff
#define FWCMD_H2C_BKP_CAM_CFG_BA_CAM_NUM_SH 8
#define FWCMD_H2C_BKP_CAM_CFG_BA_CAM_NUM_MSK 0xff
#define FWCMD_H2C_SMPS_CFG_MACID_SH 0
#define FWCMD_H2C_SMPS_CFG_MACID_MSK 0xffff
#define FWCMD_H2C_SMPS_CFG_SMPS_MODE_SH 16
#define FWCMD_H2C_SMPS_CFG_SMPS_MODE_MSK 0x7
#define FWCMD_H2C_RTD3_CFG_RTD3_EN BIT(0)
#define FWCMD_H2C_RTD3_CFG_RTD3_KEEPALIVE_EN BIT(1)
#define FWCMD_H2C_RTD3_CFG_RTD3_PVB_HIT_WAKE BIT(2)
#define FWCMD_H2C_RTD3_CFG_RTD3_KA_PKT_TYPE BIT(4)
#define FWCMD_H2C_RTD3_CFG_KEEPALIVE_INTERVAL_SH 8
#define FWCMD_H2C_RTD3_CFG_KEEPALIVE_INTERVAL_MSK 0xff
#define FWCMD_H2C_LPS_DBG_CFG_ERR_DETECT_EN BIT(0)
#define FWCMD_H2C_LPS_DBG_CFG_LOG_EXPORT_EN BIT(1)
#define FWCMD_H2C_FWHDR_DL_FWHDR_SH 0
#define FWCMD_H2C_FWHDR_DL_FWHDR_MSK 0xffffffff
#define FWCMD_H2C_FWHDR_REDL_FWHDR_SH 0
#define FWCMD_H2C_FWHDR_REDL_FWHDR_MSK 0xffffffff
#define FWCMD_H2C_TWT_ANNOUNCE_UPD_MACID_SH 0
#define FWCMD_H2C_TWT_ANNOUNCE_UPD_MACID_MSK 0xff
#define FWCMD_H2C_TWT_ANNOUNCE_UPD_MACID_EXT_SH 8
#define FWCMD_H2C_TWT_ANNOUNCE_UPD_MACID_EXT_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_NEGOTYPE_SH 0
#define FWCMD_H2C_TWTINFO_UPD_NEGOTYPE_MSK 0x3
#define FWCMD_H2C_TWTINFO_UPD_TRIGGER BIT(2)
#define FWCMD_H2C_TWTINFO_UPD_FLOWTYPE BIT(3)
#define FWCMD_H2C_TWTINFO_UPD_IMPT BIT(4)
#define FWCMD_H2C_TWTINFO_UPD_WAKEDURUNIT BIT(5)
#define FWCMD_H2C_TWTINFO_UPD_RSPPM BIT(6)
#define FWCMD_H2C_TWTINFO_UPD_FLOWID_SH 7
#define FWCMD_H2C_TWTINFO_UPD_FLOWID_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_PROT BIT(10)
#define FWCMD_H2C_TWTINFO_UPD_ACT_SH 11
#define FWCMD_H2C_TWTINFO_UPD_ACT_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_ID_SH 14
#define FWCMD_H2C_TWTINFO_UPD_ID_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_BAND BIT(17)
#define FWCMD_H2C_TWTINFO_UPD_PORT_SH 18
#define FWCMD_H2C_TWTINFO_UPD_PORT_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_TWT_TYPE_SH 21
#define FWCMD_H2C_TWTINFO_UPD_TWT_TYPE_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_UNAVAILABILITY BIT(24)
#define FWCMD_H2C_TWTINFO_UPD_NIC_ROLE BIT(25)
#define FWCMD_H2C_TWTINFO_UPD_UNAVAIL_IND BIT(26)
#define FWCMD_H2C_TWTINFO_UPD_WAKE_MAN_SH 0
#define FWCMD_H2C_TWTINFO_UPD_WAKE_MAN_MSK 0xffff
#define FWCMD_H2C_TWTINFO_UPD_WAKE_EXP_SH 16
#define FWCMD_H2C_TWTINFO_UPD_WAKE_EXP_MSK 0x1f
#define FWCMD_H2C_TWTINFO_UPD_ULFIXMODE_SH 21
#define FWCMD_H2C_TWTINFO_UPD_ULFIXMODE_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_DUR_SH 24
#define FWCMD_H2C_TWTINFO_UPD_DUR_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_TGT_L_SH 0
#define FWCMD_H2C_TWTINFO_UPD_TGT_L_MSK 0xffffffff
#define FWCMD_H2C_TWTINFO_UPD_TGT_H_SH 0
#define FWCMD_H2C_TWTINFO_UPD_TGT_H_MSK 0xffffffff
#define FWCMD_H2C_TWTINFO_UPD_PTT_BEF_SH 0
#define FWCMD_H2C_TWTINFO_UPD_PTT_BEF_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_PTT_AFT_SH 8
#define FWCMD_H2C_TWTINFO_UPD_PTT_AFT_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_DMA_CH_SH 16
#define FWCMD_H2C_TWTINFO_UPD_DMA_CH_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_STRERLY_INTV_SH 24
#define FWCMD_H2C_TWTINFO_UPD_STRERLY_INTV_MSK 0xf
#define FWCMD_H2C_TWTINFO_UPD_ENDERLY_INTV_SH 28
#define FWCMD_H2C_TWTINFO_UPD_ENDERLY_INTV_MSK 0xf
#define FWCMD_H2C_TWTINFO_UPD_MBSSID_IDX_SH 0
#define FWCMD_H2C_TWTINFO_UPD_MBSSID_IDX_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_FLOWID_EXT_SH 8
#define FWCMD_H2C_TWTINFO_UPD_FLOWID_EXT_MSK 0x3
#define FWCMD_H2C_TWT_STANSP_UPD_MACID_SH 0
#define FWCMD_H2C_TWT_STANSP_UPD_MACID_MSK 0xff
#define FWCMD_H2C_TWT_STANSP_UPD_ID_SH 8
#define FWCMD_H2C_TWT_STANSP_UPD_ID_MSK 0x7
#define FWCMD_H2C_TWT_STANSP_UPD_ACT_SH 11
#define FWCMD_H2C_TWT_STANSP_UPD_ACT_MSK 0xf
#define FWCMD_H2C_TWT_STANSP_UPD_BAND BIT(15)
#define FWCMD_H2C_TWT_STANSP_UPD_UL_MAP_SH 16
#define FWCMD_H2C_TWT_STANSP_UPD_UL_MAP_MSK 0xff
#define FWCMD_H2C_TWT_STANSP_UPD_DL_MAP_SH 24
#define FWCMD_H2C_TWT_STANSP_UPD_DL_MAP_MSK 0xff
#define FWCMD_H2C_TWT_STANSP_UPD_MACID_EXT_SH 0
#define FWCMD_H2C_TWT_STANSP_UPD_MACID_EXT_MSK 0xff
#define FWCMD_H2C_TBLUD_R_W BIT(0)
#define FWCMD_H2C_TBLUD_MACID_GROUP_SH 1
#define FWCMD_H2C_TBLUD_MACID_GROUP_MSK 0x7f
#define FWCMD_H2C_TBLUD_OFFSET_SH 8
#define FWCMD_H2C_TBLUD_OFFSET_MSK 0x1f
#define FWCMD_H2C_TBLUD_LENGTH_SH 13
#define FWCMD_H2C_TBLUD_LENGTH_MSK 0x3ff
#define FWCMD_H2C_TBLUD_TYPE BIT(23)
#define FWCMD_H2C_TBLUD_TABLE_CLASS_SH 24
#define FWCMD_H2C_TBLUD_TABLE_CLASS_MSK 0xff
#define FWCMD_H2C_DCTLINFO_UD_MACID_SH 0
#define FWCMD_H2C_DCTLINFO_UD_MACID_MSK 0x7f
#define FWCMD_H2C_DCTLINFO_UD_OP BIT(7)
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_MACID_SH 0
#define FWCMD_H2C_CCTLINFO_UD_MACID_MSK 0x7f
#define FWCMD_H2C_CCTLINFO_UD_OP BIT(7)
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D0_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D0_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D1_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D1_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D2_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D2_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D3_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D3_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D4_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D4_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D5_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D5_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D6_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D6_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D7_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D7_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D8_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D8_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D9_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D9_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D10_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D10_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D11_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D11_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D12_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D12_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D13_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D13_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D14_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D14_MSK 0xffffffff
#define FWCMD_H2C_BCN_UPD_PORT_SH 0
#define FWCMD_H2C_BCN_UPD_PORT_MSK 0xff
#define FWCMD_H2C_BCN_UPD_MBSSID_SH 8
#define FWCMD_H2C_BCN_UPD_MBSSID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BAND_SH 16
#define FWCMD_H2C_BCN_UPD_BAND_MSK 0xff
#define FWCMD_H2C_BCN_UPD_GRP_IE_OFST_SH 24
#define FWCMD_H2C_BCN_UPD_GRP_IE_OFST_MSK 0xff
#define FWCMD_H2C_BCN_UPD_MACID_SH 0
#define FWCMD_H2C_BCN_UPD_MACID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_SSN_SEL_SH 8
#define FWCMD_H2C_BCN_UPD_SSN_SEL_MSK 0x3
#define FWCMD_H2C_BCN_UPD_SSN_MODE_SH 10
#define FWCMD_H2C_BCN_UPD_SSN_MODE_MSK 0x3
#define FWCMD_H2C_BCN_UPD_RATE_SH 12
#define FWCMD_H2C_BCN_UPD_RATE_MSK 0x1ff
#define FWCMD_H2C_BCN_UPD_TXPWR_SH 21
#define FWCMD_H2C_BCN_UPD_TXPWR_MSK 0x7
#define FWCMD_H2C_BCN_UPD_TXINFO_CTRL_EN BIT(0)
#define FWCMD_H2C_BCN_UPD_NTX_PATH_EN_SH 1
#define FWCMD_H2C_BCN_UPD_NTX_PATH_EN_MSK 0xf
#define FWCMD_H2C_BCN_UPD_PATH_MAP_A_SH 5
#define FWCMD_H2C_BCN_UPD_PATH_MAP_A_MSK 0x3
#define FWCMD_H2C_BCN_UPD_PATH_MAP_B_SH 7
#define FWCMD_H2C_BCN_UPD_PATH_MAP_B_MSK 0x3
#define FWCMD_H2C_BCN_UPD_PATH_MAP_C_SH 9
#define FWCMD_H2C_BCN_UPD_PATH_MAP_C_MSK 0x3
#define FWCMD_H2C_BCN_UPD_PATH_MAP_D_SH 11
#define FWCMD_H2C_BCN_UPD_PATH_MAP_D_MSK 0x3
#define FWCMD_H2C_BCN_UPD_ANTSEL_A BIT(13)
#define FWCMD_H2C_BCN_UPD_ANTSEL_B BIT(14)
#define FWCMD_H2C_BCN_UPD_ANTSEL_C BIT(15)
#define FWCMD_H2C_BCN_UPD_ANTSEL_D BIT(16)
#define FWCMD_H2C_BCN_UPD_CSA_OFST_SH 17
#define FWCMD_H2C_BCN_UPD_CSA_OFST_MSK 0x7fff
#define FWCMD_H2C_SS_ULSTA_UPD_MODE_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_MODE_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_TH_SEL BIT(8)
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U0_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U0_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U1_SH 8
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U1_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U2_SH 16
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U2_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U3_SH 24
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U3_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U0_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U0_MSK 0xffff
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U1_SH 16
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U1_MSK 0xffff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U0_EXT_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U0_EXT_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U1_EXT_SH 8
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U1_EXT_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U2_EXT_SH 16
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U2_EXT_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U3_EXT_SH 24
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U3_EXT_MSK 0xff
#define FWCMD_H2C_F2PDBG_SET_SET_TXDBG BIT(0)
#define FWCMD_H2C_F2PDBG_SET_TXDBG_EN BIT(1)
#define FWCMD_H2C_F2PDBG_SET_SET_TPPKTSIZE BIT(2)
#define FWCMD_H2C_F2PDBG_SET_PKT_SIZE_SH 3
#define FWCMD_H2C_F2PDBG_SET_PKT_SIZE_MSK 0xffff
#define FWCMD_H2C_WLANINFO_GET_INFO_SEL_SH 0
#define FWCMD_H2C_WLANINFO_GET_INFO_SEL_MSK 0xf
#define FWCMD_H2C_WLANINFO_GET_ARGV0_SH 8
#define FWCMD_H2C_WLANINFO_GET_ARGV0_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV1_SH 16
#define FWCMD_H2C_WLANINFO_GET_ARGV1_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV2_SH 24
#define FWCMD_H2C_WLANINFO_GET_ARGV2_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV3_SH 0
#define FWCMD_H2C_WLANINFO_GET_ARGV3_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV4_SH 8
#define FWCMD_H2C_WLANINFO_GET_ARGV4_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV5_SH 16
#define FWCMD_H2C_WLANINFO_GET_ARGV5_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV6_SH 24
#define FWCMD_H2C_WLANINFO_GET_ARGV6_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV7_SH 0
#define FWCMD_H2C_WLANINFO_GET_ARGV7_MSK 0xff
#define FWCMD_H2C_DCTLINFO_UD_V1_MACID_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_MACID_MSK 0x7f
#define FWCMD_H2C_DCTLINFO_UD_V1_OP BIT(7)
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL0_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL1_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL2_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL3_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL4_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL5_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL6_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL7_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL0_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL1_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL2_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL3_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL4_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL5_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL6_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL7_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V1_DCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_MACID_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_MACID_MSK 0x7f
#define FWCMD_H2C_CCTLINFO_UD_V1_OP BIT(7)
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL0_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL1_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL2_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL3_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL4_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL5_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL6_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL7_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL0_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL1_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL2_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL3_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL4_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL5_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL6_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL7_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_V1_CCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_FW_STS_PARA_EN BIT(0)
#define FWCMD_H2C_FW_STS_PARA_BAND BIT(1)
#define FWCMD_H2C_FW_STS_PARA_INTVL_MS_SH 16
#define FWCMD_H2C_FW_STS_PARA_INTVL_MS_MSK 0xffff
#define FWCMD_H2C_DCTLINFO_UD_V2_MACID_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_MACID_MSK 0x7f
#define FWCMD_H2C_DCTLINFO_UD_V2_OP BIT(7)
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL0_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL1_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL2_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL3_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL4_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL5_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL6_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL7_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL8_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL8_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL9_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL9_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL10_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL10_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL11_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL11_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL12_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL12_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL13_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL13_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL14_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL14_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL15_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL15_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL0_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL1_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL2_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL3_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL4_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL5_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL6_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL7_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL8_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL8_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL9_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL9_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL10_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL10_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL11_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL11_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL12_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL12_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL13_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL13_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL14_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL14_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL15_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V2_DCTRL15_MSK_MSK 0xffffffff
#define FWCMD_H2C_BCN_UPD_BE_PORT_SH 0
#define FWCMD_H2C_BCN_UPD_BE_PORT_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_MBSSID_SH 8
#define FWCMD_H2C_BCN_UPD_BE_MBSSID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_BAND_SH 16
#define FWCMD_H2C_BCN_UPD_BE_BAND_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_GRP_IE_OFST_SH 24
#define FWCMD_H2C_BCN_UPD_BE_GRP_IE_OFST_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_MACID_SH 0
#define FWCMD_H2C_BCN_UPD_BE_MACID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_SSN_SEL_SH 8
#define FWCMD_H2C_BCN_UPD_BE_SSN_SEL_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_SSN_MODE_SH 10
#define FWCMD_H2C_BCN_UPD_BE_SSN_MODE_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_RATE_SH 12
#define FWCMD_H2C_BCN_UPD_BE_RATE_MSK 0x1ff
#define FWCMD_H2C_BCN_UPD_BE_TXPWR_SH 21
#define FWCMD_H2C_BCN_UPD_BE_TXPWR_MSK 0x7
#define FWCMD_H2C_BCN_UPD_BE_MACID_EXT_SH 24
#define FWCMD_H2C_BCN_UPD_BE_MACID_EXT_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_TXINFO_CTRL_EN BIT(0)
#define FWCMD_H2C_BCN_UPD_BE_NTX_PATH_EN_SH 1
#define FWCMD_H2C_BCN_UPD_BE_NTX_PATH_EN_MSK 0xf
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_A_SH 5
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_A_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_B_SH 7
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_B_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_C_SH 9
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_C_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_D_SH 11
#define FWCMD_H2C_BCN_UPD_BE_PATH_MAP_D_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_ANTSEL_A BIT(13)
#define FWCMD_H2C_BCN_UPD_BE_ANTSEL_B BIT(14)
#define FWCMD_H2C_BCN_UPD_BE_ANTSEL_C BIT(15)
#define FWCMD_H2C_BCN_UPD_BE_ANTSEL_D BIT(16)
#define FWCMD_H2C_BCN_UPD_BE_CSA_OFST_SH 17
#define FWCMD_H2C_BCN_UPD_BE_CSA_OFST_MSK 0x7fff
#define FWCMD_H2C_BCN_UPD_BE_MLIE_CSA_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_MLIE_CSA_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_CRITICAL_UPD_FLAG_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_CRITICAL_UPD_FLAG_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP1_DTIM_CNT_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_VAP1_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP2_DTIM_CNT_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_VAP2_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP3_DTIM_CNT_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_VAP3_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP4_DTIM_CNT_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_VAP4_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP5_DTIM_CNT_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_VAP5_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP6_DTIM_CNT_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_VAP6_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_VAP7_DTIM_CNT_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_VAP7_DTIM_CNT_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_ECSA_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_ECSA_OFST_MSK 0x7fff
#define FWCMD_H2C_BCN_UPD_BE_PROTECTION_KEY_ID BIT(31)
#define FWCMD_H2C_BCN_UPD_BE_SEC_ENABLE BIT(0)
#define FWCMD_H2C_BCN_UPD_BE_PN_RESET BIT(1)
#define FWCMD_H2C_BCN_UPD_BE_SEC_ALGO_SH 2
#define FWCMD_H2C_BCN_UPD_BE_SEC_ALGO_MSK 0x3
#define FWCMD_H2C_BCN_UPD_BE_CSA_RESET BIT(4)
#define FWCMD_H2C_BCN_UPD_BE_ECSA_RESET BIT(5)
#define FWCMD_H2C_BCN_UPD_BE_PN_HIGH_SH 16
#define FWCMD_H2C_BCN_UPD_BE_PN_HIGH_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_PN_LOW_SH 0
#define FWCMD_H2C_BCN_UPD_BE_PN_LOW_MSK 0xffffffff
#define FWCMD_H2C_BCN_UPD_BE_MLIE_ECSA_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_MLIE_ECSA_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_BC_CHG_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_BC_CHG_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_MLIE1_CSA_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_BE_MLIE1_CSA_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_MLIE1_ECSA_OFST_SH 16
#define FWCMD_H2C_BCN_UPD_BE_MLIE1_ECSA_OFST_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST0_SH 0
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST0_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST1_SH 16
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST1_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST2_SH 0
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST2_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST3_SH 16
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST3_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST0_ID_SH 0
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST0_ID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST1_ID_SH 8
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST1_ID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST2_ID_SH 16
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST2_ID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST3_ID_SH 24
#define FWCMD_H2C_BCN_UPD_BE_TWT_OFST3_ID_MSK 0xff
#define FWCMD_H2C_BCN_IGNORE_EDCCA_PORT_SH 0
#define FWCMD_H2C_BCN_IGNORE_EDCCA_PORT_MSK 0xff
#define FWCMD_H2C_BCN_IGNORE_EDCCA_MBSSID_SH 8
#define FWCMD_H2C_BCN_IGNORE_EDCCA_MBSSID_MSK 0xff
#define FWCMD_H2C_BCN_IGNORE_EDCCA_BAND_SH 16
#define FWCMD_H2C_BCN_IGNORE_EDCCA_BAND_MSK 0xff
#define FWCMD_H2C_BCN_IGNORE_EDCCA_IGNORE_EDCCA_EN BIT(24)
#define FWCMD_H2C_BCN_UPD_V1_PORT_SH 0
#define FWCMD_H2C_BCN_UPD_V1_PORT_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_MBSSID_SH 8
#define FWCMD_H2C_BCN_UPD_V1_MBSSID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_BAND_SH 16
#define FWCMD_H2C_BCN_UPD_V1_BAND_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_GRP_IE_OFST_SH 24
#define FWCMD_H2C_BCN_UPD_V1_GRP_IE_OFST_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_MACID_SH 0
#define FWCMD_H2C_BCN_UPD_V1_MACID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_SSN_SEL_SH 8
#define FWCMD_H2C_BCN_UPD_V1_SSN_SEL_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_SSN_MODE_SH 10
#define FWCMD_H2C_BCN_UPD_V1_SSN_MODE_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_RATE_SH 12
#define FWCMD_H2C_BCN_UPD_V1_RATE_MSK 0x1ff
#define FWCMD_H2C_BCN_UPD_V1_TXPWR_SH 21
#define FWCMD_H2C_BCN_UPD_V1_TXPWR_MSK 0x7
#define FWCMD_H2C_BCN_UPD_V1_ECSA_SUPPORT BIT(24)
#define FWCMD_H2C_BCN_UPD_V1_PROTECTION_KEY_ID BIT(25)
#define FWCMD_H2C_BCN_UPD_V1_SEC_ALGO_SH 26
#define FWCMD_H2C_BCN_UPD_V1_SEC_ALGO_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_SEC_ENABLE BIT(28)
#define FWCMD_H2C_BCN_UPD_V1_PN_RESET BIT(29)
#define FWCMD_H2C_BCN_UPD_V1_TXINFO_CTRL_EN BIT(0)
#define FWCMD_H2C_BCN_UPD_V1_NTX_PATH_EN_SH 1
#define FWCMD_H2C_BCN_UPD_V1_NTX_PATH_EN_MSK 0xf
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_A_SH 5
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_A_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_B_SH 7
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_B_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_C_SH 9
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_C_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_D_SH 11
#define FWCMD_H2C_BCN_UPD_V1_PATH_MAP_D_MSK 0x3
#define FWCMD_H2C_BCN_UPD_V1_ANTSEL_A BIT(13)
#define FWCMD_H2C_BCN_UPD_V1_ANTSEL_B BIT(14)
#define FWCMD_H2C_BCN_UPD_V1_ANTSEL_C BIT(15)
#define FWCMD_H2C_BCN_UPD_V1_ANTSEL_D BIT(16)
#define FWCMD_H2C_BCN_UPD_V1_CSA_OFST_SH 17
#define FWCMD_H2C_BCN_UPD_V1_CSA_OFST_MSK 0x7fff
#define FWCMD_H2C_BCN_UPD_V1_ECSA_OFST_SH 0
#define FWCMD_H2C_BCN_UPD_V1_ECSA_OFST_MSK 0x7fff
#define FWCMD_H2C_BCN_UPD_V1_BC_CHG_OFST_SH 15
#define FWCMD_H2C_BCN_UPD_V1_BC_CHG_OFST_MSK 0x7fff
#define FWCMD_H2C_BCN_UPD_V1_CSA_RESET BIT(30)
#define FWCMD_H2C_BCN_UPD_V1_ECSA_RESET BIT(31)
#define FWCMD_H2C_BCN_UPD_V1_PN_LOW_SH 0
#define FWCMD_H2C_BCN_UPD_V1_PN_LOW_MSK 0xffffffff
#define FWCMD_H2C_BCN_UPD_V1_PN_HIGH_SH 0
#define FWCMD_H2C_BCN_UPD_V1_PN_HIGH_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST0_SH 0
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST0_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST1_SH 16
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST1_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST2_SH 0
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST2_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST3_SH 16
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST3_MSK 0xffff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST0_ID_SH 0
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST0_ID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST1_ID_SH 8
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST1_ID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST2_ID_SH 16
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST2_ID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST3_ID_SH 24
#define FWCMD_H2C_BCN_UPD_V1_TWT_OFST3_ID_MSK 0xff
#define FWCMD_H2C_DCTLINFO_UD_V3_MACID_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_MACID_MSK 0xffff
#define FWCMD_H2C_DCTLINFO_UD_V3_OP BIT(16)
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL0_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL1_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL2_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL3_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL4_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL5_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL6_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL7_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL8_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL8_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL9_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL9_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL10_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL10_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL11_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL11_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL12_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL12_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL13_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL13_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL14_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL14_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL15_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL15_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL0_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL1_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL2_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL3_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL4_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL5_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL6_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL7_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL8_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL8_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL9_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL9_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL10_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL10_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL11_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL11_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL12_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL12_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL13_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL13_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL14_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL14_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL15_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_V3_DCTRL15_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_MACID_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_MACID_MSK 0x7f
#define FWCMD_H2C_CCTLINFO_UD_G7_OP BIT(7)
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL0_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL1_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL2_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL3_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL4_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL5_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL6_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL7_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL8_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL8_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL9_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL9_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL10_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL10_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL11_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL11_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL12_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL12_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL13_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL13_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL14_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL14_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL15_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL15_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL0_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL1_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL2_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL3_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL4_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL5_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL6_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL7_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL8_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL8_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL9_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL9_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL10_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL10_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL11_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL11_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL12_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL12_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL13_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL13_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL14_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL14_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL15_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_G7_CCTRL15_MSK_MSK 0xffffffff
#define FWCMD_H2C_SWTX_STACFG_MACID_SH 0
#define FWCMD_H2C_SWTX_STACFG_MACID_MSK 0x3ff
#define FWCMD_H2C_SWTX_STACFG_RATE_SH 16
#define FWCMD_H2C_SWTX_STACFG_RATE_MSK 0xfff
#define FWCMD_H2C_TXMODE_SWITCH_MODE BIT(0)
#define FWCMD_H2C_TXMODE_SWITCH_SW_MODE_MAX_CHAIN_NUM_SH 1
#define FWCMD_H2C_TXMODE_SWITCH_SW_MODE_MAX_CHAIN_NUM_MSK 0x7
#define FWCMD_H2C_TXMODE_SWITCH_DECISION_GAIN_SH 4
#define FWCMD_H2C_TXMODE_SWITCH_DECISION_GAIN_MSK 0xff
#define FWCMD_H2C_TXMODE_SWITCH_SWAP_PRIMARY_ENABLE BIT(12)
#define FWCMD_H2C_BCN_DYNAMIC_MECH_BCN_DM_TBTT_SHFT_EN BIT(0)
#define FWCMD_H2C_BCN_DYNAMIC_MECH_BCN_DM_HOLD_TIME_CHANGE_EN BIT(1)
#define FWCMD_H2C_ADDRCAM_INFO_R_W_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_R_W_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_IDX_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_OFFSET_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_OFFSET_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_LEN_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_LEN_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_IDX_EXT_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_IDX_EXT_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_VALID BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_NET_TYPE_SH 1
#define FWCMD_H2C_ADDRCAM_INFO_NET_TYPE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_BCN_HIT_COND_SH 3
#define FWCMD_H2C_ADDRCAM_INFO_BCN_HIT_COND_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_HIT_RULE_SH 5
#define FWCMD_H2C_ADDRCAM_INFO_HIT_RULE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_BB_SEL BIT(7)
#define FWCMD_H2C_ADDRCAM_INFO_ADDR_MASK_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_ADDR_MASK_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_MASK_SEL_SH 14
#define FWCMD_H2C_ADDRCAM_INFO_MASK_SEL_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SMA_HASH_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA_HASH_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID_CAM_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_BSSID_CAM_IDX_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_IS_MUL_ENT BIT(8)
#define FWCMD_H2C_ADDRCAM_INFO_SMA0_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SMA0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA1_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SMA1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA2_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SMA2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA3_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SMA3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA4_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SMA4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA5_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SMA5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA0_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_TMA0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA1_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TMA1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA2_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_TMA2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA3_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_TMA3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA4_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_TMA4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA5_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TMA5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_MACID_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_MACID_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_PORT_INT_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_PORT_INT_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_TSF_SYNC_SH 11
#define FWCMD_H2C_ADDRCAM_INFO_TSF_SYNC_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_TF_TRS BIT(14)
#define FWCMD_H2C_ADDRCAM_INFO_LSIG_TXOP BIT(15)
#define FWCMD_H2C_ADDRCAM_INFO_MACID_EXT_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_MACID_EXT_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TGT_IND_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_FRM_TGT_IND_SH 27
#define FWCMD_H2C_ADDRCAM_INFO_FRM_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_TB_RANGING BIT(30)
#define FWCMD_H2C_ADDRCAM_INFO_AID12_0_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_AID12_0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_AID12_1_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_AID12_1_MSK 0xf
#define FWCMD_H2C_ADDRCAM_INFO_WOL_PATTERN BIT(12)
#define FWCMD_H2C_ADDRCAM_INFO_WOL_UC BIT(13)
#define FWCMD_H2C_ADDRCAM_INFO_WOL_MAGIC BIT(14)
#define FWCMD_H2C_ADDRCAM_INFO_WAPI BIT(15)
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_B_IDX_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_OFFSET_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_B_OFFSET_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_LEN_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_B_LEN_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_VALID BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_B_BB_SEL BIT(1)
#define FWCMD_H2C_ADDRCAM_INFO_B_MSK_SH 2
#define FWCMD_H2C_ADDRCAM_INFO_B_MSK_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_BSS_COLOR_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_BSS_COLOR_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_BSSID0_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_BSSID0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID1_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_BSSID1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID2_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_BSSID2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID3_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_BSSID3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID4_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_BSSID4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID5_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_BSSID5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_R_W_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_R_W_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_IDX_MSK 0x3ff
#define FWCMD_H2C_ADDRCAM_INFO_V1_OFFSET_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_OFFSET_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_LEN_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_LEN_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_VALID BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_V1_NET_TYPE_SH 1
#define FWCMD_H2C_ADDRCAM_INFO_V1_NET_TYPE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_BCN_HIT_COND_SH 3
#define FWCMD_H2C_ADDRCAM_INFO_V1_BCN_HIT_COND_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_HIT_RULE_SH 5
#define FWCMD_H2C_ADDRCAM_INFO_V1_HIT_RULE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_BB_SEL BIT(7)
#define FWCMD_H2C_ADDRCAM_INFO_V1_ADDR_MASK_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_ADDR_MASK_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_V1_MASK_SEL_SH 14
#define FWCMD_H2C_ADDRCAM_INFO_V1_MASK_SEL_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA_HASH_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA_HASH_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID_CAM_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID_CAM_IDX_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_V1_IS_MUL_ENT BIT(8)
#define FWCMD_H2C_ADDRCAM_INFO_V1_A_ENTRY_TYPE_SH 9
#define FWCMD_H2C_ADDRCAM_INFO_V1_A_ENTRY_TYPE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA0_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA1_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA2_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA3_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA4_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA5_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_SMA5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA0_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA1_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA2_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA3_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA4_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA5_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_TMA5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_MACID_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_MACID_MSK 0x3ff
#define FWCMD_H2C_ADDRCAM_INFO_V1_PORT_INT_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_PORT_INT_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_V1_TSF_SYNC_SH 19
#define FWCMD_H2C_ADDRCAM_INFO_V1_TSF_SYNC_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_V1_TF_TRS BIT(22)
#define FWCMD_H2C_ADDRCAM_INFO_V1_LSIG_TXOP BIT(23)
#define FWCMD_H2C_ADDRCAM_INFO_V1_TB_RANGING BIT(24)
#define FWCMD_H2C_ADDRCAM_INFO_V1_TB_SENSING BIT(25)
#define FWCMD_H2C_ADDRCAM_INFO_V1_SENS_EN BIT(26)
#define FWCMD_H2C_ADDRCAM_INFO_V1_AID12_0_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_AID12_0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_AID12_1_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_AID12_1_MSK 0xf
#define FWCMD_H2C_ADDRCAM_INFO_V1_WOL_PATTERN BIT(12)
#define FWCMD_H2C_ADDRCAM_INFO_V1_WOL_UC BIT(13)
#define FWCMD_H2C_ADDRCAM_INFO_V1_WOL_MAGIC BIT(14)
#define FWCMD_H2C_ADDRCAM_INFO_V1_WAPI BIT(15)
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT0_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT1_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT2_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT3_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT4_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT5_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT6_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_IDX_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_OFFSET_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_OFFSET_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_LEN_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_LEN_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_VALID BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_BB_SEL BIT(1)
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_MSK_SH 2
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_MSK_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSS_COLOR_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSS_COLOR_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_V1_B_ENTRY_TYPE BIT(15)
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID0_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID1_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID2_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID3_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID4_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID5_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_V1_BSSID5_MSK 0xff
#define FWCMD_H2C_JOININFO_MACID_SH 0
#define FWCMD_H2C_JOININFO_MACID_MSK 0xff
#define FWCMD_H2C_JOININFO_OPMODE BIT(8)
#define FWCMD_H2C_JOININFO_BAND BIT(9)
#define FWCMD_H2C_JOININFO_WMM_SH 10
#define FWCMD_H2C_JOININFO_WMM_MSK 0x3
#define FWCMD_H2C_JOININFO_TRIGGER BIT(12)
#define FWCMD_H2C_JOININFO_ISHESTA BIT(13)
#define FWCMD_H2C_JOININFO_DL_BW_SH 14
#define FWCMD_H2C_JOININFO_DL_BW_MSK 0x3
#define FWCMD_H2C_JOININFO_TF_MAC_PADDING_SH 16
#define FWCMD_H2C_JOININFO_TF_MAC_PADDING_MSK 0x3
#define FWCMD_H2C_JOININFO_DL_T_PE_SH 18
#define FWCMD_H2C_JOININFO_DL_T_PE_MSK 0x7
#define FWCMD_H2C_JOININFO_PORT_ID_SH 21
#define FWCMD_H2C_JOININFO_PORT_ID_MSK 0x7
#define FWCMD_H2C_JOININFO_NET_TYPE_SH 24
#define FWCMD_H2C_JOININFO_NET_TYPE_MSK 0x3
#define FWCMD_H2C_JOININFO_WIFI_ROLE_SH 26
#define FWCMD_H2C_JOININFO_WIFI_ROLE_MSK 0xf
#define FWCMD_H2C_JOININFO_SELF_ROLE_SH 30
#define FWCMD_H2C_JOININFO_SELF_ROLE_MSK 0x3
#define FWCMD_H2C_JOININFO_STA_TYPE_SH 0
#define FWCMD_H2C_JOININFO_STA_TYPE_MSK 0x7
#define FWCMD_H2C_JOININFO_IS_MLD BIT(3)
#define FWCMD_H2C_JOININFO_MAIN_MACID_SH 4
#define FWCMD_H2C_JOININFO_MAIN_MACID_MSK 0xff
#define FWCMD_H2C_JOININFO_MLO_MODE BIT(12)
#define FWCMD_H2C_JOININFO_EMLSR_CAB BIT(13)
#define FWCMD_H2C_JOININFO_NSTR_EN BIT(14)
#define FWCMD_H2C_JOININFO_INIT_PWR_STATE BIT(15)
#define FWCMD_H2C_JOININFO_EMLSR_PADDING_SH 16
#define FWCMD_H2C_JOININFO_EMLSR_PADDING_MSK 0x7
#define FWCMD_H2C_JOININFO_EMLSR_TRANS_DELAY_SH 19
#define FWCMD_H2C_JOININFO_EMLSR_TRANS_DELAY_MSK 0x7
#define FWCMD_H2C_JOININFO_IS_MLD_EXT BIT(22)
#define FWCMD_H2C_JOININFO_MACID_EXT_SH 0
#define FWCMD_H2C_JOININFO_MACID_EXT_MSK 0xff
#define FWCMD_H2C_JOININFO_MAIN_MACID_EXT_SH 8
#define FWCMD_H2C_JOININFO_MAIN_MACID_EXT_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_GRP_VALID BIT(0)
#define FWCMD_H2C_DL_GRP_UPD_GRP_ID_SH 1
#define FWCMD_H2C_DL_GRP_UPD_GRP_ID_MSK 0x1f
#define FWCMD_H2C_DL_GRP_UPD_IS_HWGRP BIT(6)
#define FWCMD_H2C_DL_GRP_UPD_MACID_U0_SH 8
#define FWCMD_H2C_DL_GRP_UPD_MACID_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U1_SH 16
#define FWCMD_H2C_DL_GRP_UPD_MACID_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U2_SH 24
#define FWCMD_H2C_DL_GRP_UPD_MACID_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U3_SH 0
#define FWCMD_H2C_DL_GRP_UPD_MACID_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U4_SH 8
#define FWCMD_H2C_DL_GRP_UPD_MACID_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U5_SH 16
#define FWCMD_H2C_DL_GRP_UPD_MACID_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U6_SH 24
#define FWCMD_H2C_DL_GRP_UPD_MACID_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U7_SH 0
#define FWCMD_H2C_DL_GRP_UPD_MACID_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U0_SH 8
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U0_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U1_SH 12
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U1_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U2_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U3_SH 20
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U3_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U4_SH 24
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U4_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U5_SH 28
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U5_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U6_SH 0
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U6_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U7_SH 4
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U7_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_NEXT_PROTECTTYPE_SH 8
#define FWCMD_H2C_DL_GRP_UPD_NEXT_PROTECTTYPE_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_NEXT_RSPTYPE_SH 12
#define FWCMD_H2C_DL_GRP_UPD_NEXT_RSPTYPE_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_TRIGGER_LEN_SH 16
#define FWCMD_H2C_DL_GRP_UPD_TRIGGER_LEN_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_TRIGGER_UL_THRESHOLD_SH 24
#define FWCMD_H2C_DL_GRP_UPD_TRIGGER_UL_THRESHOLD_MSK 0xff
#define FWCMD_H2C_UL_GRP_UPD_MACID_U0_SH 0
#define FWCMD_H2C_UL_GRP_UPD_MACID_U0_MSK 0xff
#define FWCMD_H2C_UL_GRP_UPD_MACID_U1_SH 8
#define FWCMD_H2C_UL_GRP_UPD_MACID_U1_MSK 0xff
#define FWCMD_H2C_UL_GRP_UPD_GRP_BITMAP_SH 16
#define FWCMD_H2C_UL_GRP_UPD_GRP_BITMAP_MSK 0xffff
#define FWCMD_H2C_UL_GRP_UPD_MACID_U0_EXT_SH 0
#define FWCMD_H2C_UL_GRP_UPD_MACID_U0_EXT_MSK 0xff
#define FWCMD_H2C_UL_GRP_UPD_MACID_U1_EXT_SH 8
#define FWCMD_H2C_UL_GRP_UPD_MACID_U1_EXT_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_MACID_SH 0
#define FWCMD_H2C_MU_STA_UPD_MACID_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_MU_IDX_SH 8
#define FWCMD_H2C_MU_STA_UPD_MU_IDX_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_0_SH 16
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_0_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_1_SH 24
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_1_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_2_SH 0
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_2_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_3_SH 8
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_3_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_4_SH 16
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_4_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_MUGRP_BITMAP_SH 24
#define FWCMD_H2C_MU_STA_UPD_MUGRP_BITMAP_MSK 0x1f
#define FWCMD_H2C_MU_STA_UPD_DIS_256Q BIT(29)
#define FWCMD_H2C_MU_STA_UPD_DIS_1024Q BIT(30)
#define FWCMD_H2C_MU_STA_UPD_ACTION BIT(31)
#define FWCMD_H2C_MU_STA_UPD_MACID_EXT_SH 0
#define FWCMD_H2C_MU_STA_UPD_MACID_EXT_MSK 0xff
#define FWCMD_H2C_FWROLE_MAINTAIN_MACID_SH 0
#define FWCMD_H2C_FWROLE_MAINTAIN_MACID_MSK 0xff
#define FWCMD_H2C_FWROLE_MAINTAIN_SELF_ROLE_SH 8
#define FWCMD_H2C_FWROLE_MAINTAIN_SELF_ROLE_MSK 0x3
#define FWCMD_H2C_FWROLE_MAINTAIN_UPD_MODE_SH 10
#define FWCMD_H2C_FWROLE_MAINTAIN_UPD_MODE_MSK 0x7
#define FWCMD_H2C_FWROLE_MAINTAIN_WIFI_ROLE_SH 13
#define FWCMD_H2C_FWROLE_MAINTAIN_WIFI_ROLE_MSK 0xf
#define FWCMD_H2C_FWROLE_MAINTAIN_BAND_SH 17
#define FWCMD_H2C_FWROLE_MAINTAIN_BAND_MSK 0x3
#define FWCMD_H2C_FWROLE_MAINTAIN_PORT_SH 19
#define FWCMD_H2C_FWROLE_MAINTAIN_PORT_MSK 0x7
#define FWCMD_H2C_FWROLE_MAINTAIN_MACID_EXT_SH 24
#define FWCMD_H2C_FWROLE_MAINTAIN_MACID_EXT_MSK 0xff
#define FWCMD_H2C_NOTIFY_DBCC_EN BIT(0)
#define FWCMD_H2C_DL_GRP_UPD_V2_GRP_VALID_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_GRP_VALID_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_GRP_ID_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_GRP_ID_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_IS_HWGRP_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_IS_HWGRP_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MRU_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_MRU_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U0_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U1_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U3_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U4_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U5_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U6_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U7_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_MACID_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U0_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U1_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U3_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U4_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U5_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U6_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U7_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_AC_BITMAP_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_NEXT_PROTECTTYPE_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_NEXT_PROTECTTYPE_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_NEXT_RSPTYPE_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_NEXT_RSPTYPE_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_W_IDX_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_W_IDX_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_BAND BIT(24)
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U0_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U1_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U3_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U4_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U5_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U6_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U7_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_DCM_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U0_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U1_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U3_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U4_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U5_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U6_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U7_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_SS_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U0_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U1_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U3_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U4_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U5_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U6_SH 16
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U7_SH 24
#define FWCMD_H2C_DL_GRP_UPD_V2_RATE_IDX_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_TRIGGER_LEN_SH 0
#define FWCMD_H2C_DL_GRP_UPD_V2_TRIGGER_LEN_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_V2_TRIGGER_UL_THRESHOLD_SH 8
#define FWCMD_H2C_DL_GRP_UPD_V2_TRIGGER_UL_THRESHOLD_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FW_FLOW_CONTROL_EN BIT(0)
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_NUMS_SH 1
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_NUMS_MSK 0xf
#define FWCMD_H2C_FW_FLOW_CTRL_NORMAL_FLOW_WMM BIT(5)
#define FWCMD_H2C_FW_FLOW_CTRL_NORMAL_FLOW_AC_SH 6
#define FWCMD_H2C_FW_FLOW_CTRL_NORMAL_FLOW_AC_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_LATENCY_FLOW_WMM BIT(8)
#define FWCMD_H2C_FW_FLOW_CTRL_LATENCY_FLOW_AC_SH 9
#define FWCMD_H2C_FW_FLOW_CTRL_LATENCY_FLOW_AC_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_THROUGHPUT_FLOW_WMM BIT(11)
#define FWCMD_H2C_FW_FLOW_CTRL_THROUGHPUT_FLOW_AC_SH 12
#define FWCMD_H2C_FW_FLOW_CTRL_THROUGHPUT_FLOW_AC_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_HYBRID_FLOW_WMM BIT(14)
#define FWCMD_H2C_FW_FLOW_CTRL_HYBRID_FLOW_AC_SH 15
#define FWCMD_H2C_FW_FLOW_CTRL_HYBRID_FLOW_AC_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_NORMAL_FLOW_FORWARD_EN BIT(17)
#define FWCMD_H2C_FW_FLOW_CTRL_LATENCY_FLOW_FORWARD_EN BIT(18)
#define FWCMD_H2C_FW_FLOW_CTRL_THROUGHPUT_FLOW_FORWARD_EN BIT(19)
#define FWCMD_H2C_FW_FLOW_CTRL_HYBRID_FLOW_FORWARD_EN BIT(20)
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U0_TO_U7_IS_MAIN_MACID_BM_SH 24
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U0_TO_U7_IS_MAIN_MACID_BM_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U0_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U0_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U0_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U0_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U0_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U0_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U0_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U0_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U0_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U0_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U1_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U1_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U1_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U1_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U1_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U1_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U1_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U1_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U1_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U1_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U2_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U2_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U2_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U2_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U2_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U2_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U2_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U2_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U2_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U2_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U3_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U3_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U3_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U3_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U3_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U3_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U3_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U3_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U3_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U3_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U4_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U4_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U4_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U4_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U4_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U4_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U4_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U4_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U4_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U4_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U5_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U5_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U5_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U5_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U5_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U5_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U5_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U5_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U5_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U5_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U6_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U6_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U6_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U6_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U6_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U6_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U6_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U6_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U6_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U6_MSK 0x3f
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U7_SH 0
#define FWCMD_H2C_FW_FLOW_CTRL_MACID_U7_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U7_SH 8
#define FWCMD_H2C_FW_FLOW_CTRL_FLOW_TYPE_U7_MSK 0x3
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U7_SH 10
#define FWCMD_H2C_FW_FLOW_CTRL_MAX_TX_INTERVAL_U7_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U7_SH 18
#define FWCMD_H2C_FW_FLOW_CTRL_MIN_TX_INTERVAL_U7_MSK 0xff
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U7_SH 26
#define FWCMD_H2C_FW_FLOW_CTRL_TARGET_THROUGHPUT_U7_MSK 0x3f
#define FWCMD_H2C_TXRPT_FORWARD_EN BIT(0)
#define FWCMD_H2C_MRU_GRP_UPD_UL_DL BIT(0)
#define FWCMD_H2C_MRU_GRP_UPD_GRP_VALID BIT(1)
#define FWCMD_H2C_MRU_GRP_UPD_IS_HWGRP BIT(2)
#define FWCMD_H2C_MRU_GRP_UPD_MRU BIT(3)
#define FWCMD_H2C_MRU_GRP_UPD_BAND_SH 4
#define FWCMD_H2C_MRU_GRP_UPD_BAND_MSK 0x3
#define FWCMD_H2C_MRU_GRP_UPD_STA_CNT_SH 8
#define FWCMD_H2C_MRU_GRP_UPD_STA_CNT_MSK 0xff
#define FWCMD_H2C_MRU_GRP_UPD_GPR_ID_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_GPR_ID_MSK 0xff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U0_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U0_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U1_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U1_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U2_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U2_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U3_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U3_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U4_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U4_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U5_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U5_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U6_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U6_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U7_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U7_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U8_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U8_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U9_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U9_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U10_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U10_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U11_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U11_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U12_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U12_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U13_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U13_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U14_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U14_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U15_SH 16
#define FWCMD_H2C_MRU_GRP_UPD_MACID_U15_MSK 0xffff
#define FWCMD_H2C_MRU_GRP_UPD_U0_BSR_SEL_BE BIT(0)
#define FWCMD_H2C_MRU_GRP_UPD_U1_BSR_SEL_BE BIT(1)
#define FWCMD_H2C_MRU_GRP_UPD_U2_BSR_SEL_BE BIT(2)
#define FWCMD_H2C_MRU_GRP_UPD_U3_BSR_SEL_BE BIT(3)
#define FWCMD_H2C_MRU_GRP_UPD_U4_BSR_SEL_BE BIT(4)
#define FWCMD_H2C_MRU_GRP_UPD_U5_BSR_SEL_BE BIT(5)
#define FWCMD_H2C_MRU_GRP_UPD_U6_BSR_SEL_BE BIT(6)
#define FWCMD_H2C_MRU_GRP_UPD_U7_BSR_SEL_BE BIT(7)
#define FWCMD_H2C_MRU_GRP_UPD_U8_BSR_SEL_BE BIT(8)
#define FWCMD_H2C_MRU_GRP_UPD_U9_BSR_SEL_BE BIT(9)
#define FWCMD_H2C_MRU_GRP_UPD_U10_BSR_SEL_BE BIT(10)
#define FWCMD_H2C_MRU_GRP_UPD_U11_BSR_SEL_BE BIT(11)
#define FWCMD_H2C_MRU_GRP_UPD_U12_BSR_SEL_BE BIT(12)
#define FWCMD_H2C_MRU_GRP_UPD_U13_BSR_SEL_BE BIT(13)
#define FWCMD_H2C_MRU_GRP_UPD_U14_BSR_SEL_BE BIT(14)
#define FWCMD_H2C_MRU_GRP_UPD_U15_BSR_SEL_BE BIT(15)
#define FWCMD_H2C_MRU_GRP_UPD_U0_BSR_SEL_BK BIT(16)
#define FWCMD_H2C_MRU_GRP_UPD_U1_BSR_SEL_BK BIT(17)
#define FWCMD_H2C_MRU_GRP_UPD_U2_BSR_SEL_BK BIT(18)
#define FWCMD_H2C_MRU_GRP_UPD_U3_BSR_SEL_BK BIT(19)
#define FWCMD_H2C_MRU_GRP_UPD_U4_BSR_SEL_BK BIT(20)
#define FWCMD_H2C_MRU_GRP_UPD_U5_BSR_SEL_BK BIT(21)
#define FWCMD_H2C_MRU_GRP_UPD_U6_BSR_SEL_BK BIT(22)
#define FWCMD_H2C_MRU_GRP_UPD_U7_BSR_SEL_BK BIT(23)
#define FWCMD_H2C_MRU_GRP_UPD_U8_BSR_SEL_BK BIT(24)
#define FWCMD_H2C_MRU_GRP_UPD_U9_BSR_SEL_BK BIT(25)
#define FWCMD_H2C_MRU_GRP_UPD_U10_BSR_SEL_BK BIT(26)
#define FWCMD_H2C_MRU_GRP_UPD_U11_BSR_SEL_BK BIT(27)
#define FWCMD_H2C_MRU_GRP_UPD_U12_BSR_SEL_BK BIT(28)
#define FWCMD_H2C_MRU_GRP_UPD_U13_BSR_SEL_BK BIT(29)
#define FWCMD_H2C_MRU_GRP_UPD_U14_BSR_SEL_BK BIT(30)
#define FWCMD_H2C_MRU_GRP_UPD_U15_BSR_SEL_BK BIT(31)
#define FWCMD_H2C_MRU_GRP_UPD_U0_BSR_SEL_VI BIT(0)
#define FWCMD_H2C_MRU_GRP_UPD_U1_BSR_SEL_VI BIT(1)
#define FWCMD_H2C_MRU_GRP_UPD_U2_BSR_SEL_VI BIT(2)
#define FWCMD_H2C_MRU_GRP_UPD_U3_BSR_SEL_VI BIT(3)
#define FWCMD_H2C_MRU_GRP_UPD_U4_BSR_SEL_VI BIT(4)
#define FWCMD_H2C_MRU_GRP_UPD_U5_BSR_SEL_VI BIT(5)
#define FWCMD_H2C_MRU_GRP_UPD_U6_BSR_SEL_VI BIT(6)
#define FWCMD_H2C_MRU_GRP_UPD_U7_BSR_SEL_VI BIT(7)
#define FWCMD_H2C_MRU_GRP_UPD_U8_BSR_SEL_VI BIT(8)
#define FWCMD_H2C_MRU_GRP_UPD_U9_BSR_SEL_VI BIT(9)
#define FWCMD_H2C_MRU_GRP_UPD_U10_BSR_SEL_VI BIT(10)
#define FWCMD_H2C_MRU_GRP_UPD_U11_BSR_SEL_VI BIT(11)
#define FWCMD_H2C_MRU_GRP_UPD_U12_BSR_SEL_VI BIT(12)
#define FWCMD_H2C_MRU_GRP_UPD_U13_BSR_SEL_VI BIT(13)
#define FWCMD_H2C_MRU_GRP_UPD_U14_BSR_SEL_VI BIT(14)
#define FWCMD_H2C_MRU_GRP_UPD_U15_BSR_SEL_VI BIT(15)
#define FWCMD_H2C_MRU_GRP_UPD_U0_BSR_SEL_VO BIT(16)
#define FWCMD_H2C_MRU_GRP_UPD_U1_BSR_SEL_VO BIT(17)
#define FWCMD_H2C_MRU_GRP_UPD_U2_BSR_SEL_VO BIT(18)
#define FWCMD_H2C_MRU_GRP_UPD_U3_BSR_SEL_VO BIT(19)
#define FWCMD_H2C_MRU_GRP_UPD_U4_BSR_SEL_VO BIT(20)
#define FWCMD_H2C_MRU_GRP_UPD_U5_BSR_SEL_VO BIT(21)
#define FWCMD_H2C_MRU_GRP_UPD_U6_BSR_SEL_VO BIT(22)
#define FWCMD_H2C_MRU_GRP_UPD_U7_BSR_SEL_VO BIT(23)
#define FWCMD_H2C_MRU_GRP_UPD_U8_BSR_SEL_VO BIT(24)
#define FWCMD_H2C_MRU_GRP_UPD_U9_BSR_SEL_VO BIT(25)
#define FWCMD_H2C_MRU_GRP_UPD_U10_BSR_SEL_VO BIT(26)
#define FWCMD_H2C_MRU_GRP_UPD_U11_BSR_SEL_VO BIT(27)
#define FWCMD_H2C_MRU_GRP_UPD_U12_BSR_SEL_VO BIT(28)
#define FWCMD_H2C_MRU_GRP_UPD_U13_BSR_SEL_VO BIT(29)
#define FWCMD_H2C_MRU_GRP_UPD_U14_BSR_SEL_VO BIT(30)
#define FWCMD_H2C_MRU_GRP_UPD_U15_BSR_SEL_VO BIT(31)
#define FWCMD_H2C_MRU_GRP_UPD_TRIGGER_LEN_SH 0
#define FWCMD_H2C_MRU_GRP_UPD_TRIGGER_LEN_MSK 0xff
#define FWCMD_H2C_MRU_GRP_UPD_TRIGGER_UL_THRESHOLD_SH 8
#define FWCMD_H2C_MRU_GRP_UPD_TRIGGER_UL_THRESHOLD_MSK 0xff
#define FWCMD_H2C_DUMP_EFUSE_DUMP_SIZE_SH 0
#define FWCMD_H2C_DUMP_EFUSE_DUMP_SIZE_MSK 0x7ff
#define FWCMD_H2C_DUMP_EFUSE_IS_HIDDEN BIT(11)
#define FWCMD_H2C_DUMP_EFUSE_IS_DAV BIT(12)
#define FWCMD_H2C_DUMP_EFUSE_IS_BT BIT(13)
#define FWCMD_H2C_PACKET_OFLD_PKT_IDX_SH 0
#define FWCMD_H2C_PACKET_OFLD_PKT_IDX_MSK 0xff
#define FWCMD_H2C_PACKET_OFLD_PKT_OP_SH 8
#define FWCMD_H2C_PACKET_OFLD_PKT_OP_MSK 0x7
#define FWCMD_H2C_PACKET_OFLD_PKT_LENGTH_SH 16
#define FWCMD_H2C_PACKET_OFLD_PKT_LENGTH_MSK 0xffff
#define FWCMD_H2C_PACKET_OFLD_PKT_START_SH 0
#define FWCMD_H2C_PACKET_OFLD_PKT_START_MSK 0xffffffff
#define FWCMD_H2C_READ_OFLD_VALUE_LEN_SH 0
#define FWCMD_H2C_READ_OFLD_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_READ_OFLD_LS BIT(15)
#define FWCMD_H2C_READ_OFLD_OFLD_ID_SH 16
#define FWCMD_H2C_READ_OFLD_OFLD_ID_MSK 0xff
#define FWCMD_H2C_READ_OFLD_ENTRY_NUM_SH 24
#define FWCMD_H2C_READ_OFLD_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_READ_OFLD_OFFSET_SH 0
#define FWCMD_H2C_READ_OFLD_OFFSET_MSK 0xffff
#define FWCMD_H2C_WRITE_OFLD_VALUE_LEN_SH 0
#define FWCMD_H2C_WRITE_OFLD_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_WRITE_OFLD_POLLING BIT(13)
#define FWCMD_H2C_WRITE_OFLD_MASK_EN BIT(14)
#define FWCMD_H2C_WRITE_OFLD_LS BIT(15)
#define FWCMD_H2C_WRITE_OFLD_OFLD_ID_SH 16
#define FWCMD_H2C_WRITE_OFLD_OFLD_ID_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_ENTRY_NUM_SH 24
#define FWCMD_H2C_WRITE_OFLD_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_OFFSET_SH 0
#define FWCMD_H2C_WRITE_OFLD_OFFSET_MSK 0xffff
#define FWCMD_H2C_WRITE_OFLD_START_SH 0
#define FWCMD_H2C_WRITE_OFLD_START_MSK 0xffffffff
#define FWCMD_H2C_CONF_OFLD_PATTERN_COUNT_SH 0
#define FWCMD_H2C_CONF_OFLD_PATTERN_COUNT_MSK 0xffff
#define FWCMD_H2C_CONF_OFLD_START_SH 0
#define FWCMD_H2C_CONF_OFLD_START_MSK 0xffffffff
#define FWCMD_H2C_TRX_INIT_TRX_MODE_SH 0
#define FWCMD_H2C_TRX_INIT_TRX_MODE_MSK 0xff
#define FWCMD_H2C_TRX_INIT_QTA_MODE_SH 8
#define FWCMD_H2C_TRX_INIT_QTA_MODE_MSK 0x1ff
#define FWCMD_H2C_INTF_INIT_TXBD_TRUNC_MODE BIT(0)
#define FWCMD_H2C_INTF_INIT_RXBD_TRUNC_MODE BIT(1)
#define FWCMD_H2C_INTF_INIT_RXBD_MODE BIT(2)
#define FWCMD_H2C_INTF_INIT_TAG_MODE BIT(3)
#define FWCMD_H2C_INTF_INIT_TX_BURST_MODE_SH 4
#define FWCMD_H2C_INTF_INIT_TX_BURST_MODE_MSK 0xf
#define FWCMD_H2C_INTF_INIT_RX_BURST_MODE_SH 8
#define FWCMD_H2C_INTF_INIT_RX_BURST_MODE_MSK 0xf
#define FWCMD_H2C_INTF_INIT_WD_DMA_IDLE_INTVL_SH 12
#define FWCMD_H2C_INTF_INIT_WD_DMA_IDLE_INTVL_MSK 0xf
#define FWCMD_H2C_INTF_INIT_WD_DMA_ACT_INTVL_SH 16
#define FWCMD_H2C_INTF_INIT_WD_DMA_ACT_INTVL_MSK 0xf
#define FWCMD_H2C_INTF_INIT_SKIP_ALL_SH 24
#define FWCMD_H2C_INTF_INIT_SKIP_ALL_MSK 0xff
#define FWCMD_H2C_INTF_INIT_RX_SEP_APPEND_LEN_SH 0
#define FWCMD_H2C_INTF_INIT_RX_SEP_APPEND_LEN_MSK 0xffff
#define FWCMD_H2C_INTF_INIT_TXBD_BUF_SH 16
#define FWCMD_H2C_INTF_INIT_TXBD_BUF_MSK 0xff
#define FWCMD_H2C_INTF_INIT_RXBD_BUF_SH 24
#define FWCMD_H2C_INTF_INIT_RXBD_BUF_MSK 0xff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_4_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_4_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_TYPE_SH 0
#define FWCMD_H2C_RX_FWD_TYPE_MSK 0xff
#define FWCMD_H2C_RX_FWD_FRAME_SH 8
#define FWCMD_H2C_RX_FWD_FRAME_MSK 0xff
#define FWCMD_H2C_RX_FWD_FWD_TG_SH 16
#define FWCMD_H2C_RX_FWD_FWD_TG_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_INDEX_SH 0
#define FWCMD_H2C_RX_FWD_AF_UD_INDEX_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_FWD_TG_SH 8
#define FWCMD_H2C_RX_FWD_AF_UD_FWD_TG_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_CATEGORY_SH 16
#define FWCMD_H2C_RX_FWD_AF_UD_CATEGORY_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_ACTION_FIELD_SH 24
#define FWCMD_H2C_RX_FWD_AF_UD_ACTION_FIELD_MSK 0xff
#define FWCMD_H2C_RX_FWD_PM_CAM_VALID BIT(0)
#define FWCMD_H2C_RX_FWD_PM_CAM_TYPE_SH 1
#define FWCMD_H2C_RX_FWD_PM_CAM_TYPE_MSK 0x3
#define FWCMD_H2C_RX_FWD_PM_CAM_SUBTYPE_SH 3
#define FWCMD_H2C_RX_FWD_PM_CAM_SUBTYPE_MSK 0xf
#define FWCMD_H2C_RX_FWD_PM_CAM_SKIP_MAC_IV_HDR BIT(7)
#define FWCMD_H2C_RX_FWD_PM_CAM_TARGET_IND_SH 8
#define FWCMD_H2C_RX_FWD_PM_CAM_TARGET_IND_MSK 0x7
#define FWCMD_H2C_RX_FWD_PM_CAM_INDEX_SH 12
#define FWCMD_H2C_RX_FWD_PM_CAM_INDEX_MSK 0xf
#define FWCMD_H2C_RX_FWD_PM_CAM_CRC16_SH 16
#define FWCMD_H2C_RX_FWD_PM_CAM_CRC16_MSK 0xffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK0_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK0_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK1_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK1_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK2_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK2_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK3_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK3_MSK 0xffffffff
#define FWCMD_H2C_EN_MAC_HDR_CONV_ENABLE BIT(0)
#define FWCMD_H2C_SET_HWSEQ_REG_REG_IDX_SH 0
#define FWCMD_H2C_SET_HWSEQ_REG_REG_IDX_MSK 0x3
#define FWCMD_H2C_SET_HWSEQ_REG_SEQ_VAL_SH 2
#define FWCMD_H2C_SET_HWSEQ_REG_SEQ_VAL_MSK 0xfff
#define FWCMD_H2C_HWAMSDU_REG_ENABLE BIT(0)
#define FWCMD_H2C_HWAMSDU_REG_MAX_AMSDU_SUBFRAME_NUMBER_SH 1
#define FWCMD_H2C_HWAMSDU_REG_MAX_AMSDU_SUBFRAME_NUMBER_MSK 0x3
#define FWCMD_H2C_HWAMSDU_REG_ENABLE_SINGLE_AMSDU BIT(3)
#define FWCMD_H2C_HWAMSDU_REG_ENABLE_LAST_AMSDU_PADDING BIT(4)
#define FWCMD_H2C_AMSDU_CUT_REG_ENABLE BIT(0)
#define FWCMD_H2C_AMSDU_CUT_REG_LOW_THRESHOLD_SH 1
#define FWCMD_H2C_AMSDU_CUT_REG_LOW_THRESHOLD_MSK 0x1ff
#define FWCMD_H2C_AMSDU_CUT_REG_HIGH_THRESHOLD_SH 10
#define FWCMD_H2C_AMSDU_CUT_REG_HIGH_THRESHOLD_MSK 0xffff
#define FWCMD_H2C_AMSDU_CUT_REG_EXTRA_SHIFT_SH 26
#define FWCMD_H2C_AMSDU_CUT_REG_EXTRA_SHIFT_MSK 0x3
#define FWCMD_H2C_TCPIP_CHKSUM_OFFLOAD_REG_ENABLE_TX_TCPIP_CHECKSUM_OFFLOAD BIT(0)
#define FWCMD_H2C_TCPIP_CHKSUM_OFFLOAD_REG_ENABLE_RX_TCPIP_CHECKSUM_OFFLOAD BIT(1)
#define FWCMD_H2C_USR_EDCA_PARAM_SEL_SH 0
#define FWCMD_H2C_USR_EDCA_PARAM_SEL_MSK 0x3
#define FWCMD_H2C_USR_EDCA_ENABLE BIT(2)
#define FWCMD_H2C_USR_EDCA_BAND BIT(3)
#define FWCMD_H2C_USR_EDCA_WMM BIT(4)
#define FWCMD_H2C_USR_EDCA_AC_SH 5
#define FWCMD_H2C_USR_EDCA_AC_MSK 0x3
#define FWCMD_H2C_USR_EDCA_AGGRESSIVE_SH 0
#define FWCMD_H2C_USR_EDCA_AGGRESSIVE_MSK 0xffffffff
#define FWCMD_H2C_USR_EDCA_MODERATE_SH 0
#define FWCMD_H2C_USR_EDCA_MODERATE_MSK 0xffffffff
#define FWCMD_H2C_TSF32_TOGL_BAND BIT(0)
#define FWCMD_H2C_TSF32_TOGL_EN BIT(1)
#define FWCMD_H2C_TSF32_TOGL_PORT_SH 2
#define FWCMD_H2C_TSF32_TOGL_PORT_MSK 0x7
#define FWCMD_H2C_TSF32_TOGL_EARLY_SH 16
#define FWCMD_H2C_TSF32_TOGL_EARLY_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D0_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D1_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D1_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D2_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D2_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D3_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D3_MSK 0xffffffff
#define FWCMD_H2C_USR_TX_RPT_MODE_SH 0
#define FWCMD_H2C_USR_TX_RPT_MODE_MSK 0x7
#define FWCMD_H2C_USR_TX_RPT_RTP_START BIT(3)
#define FWCMD_H2C_USR_TX_RPT_MACID_SH 0
#define FWCMD_H2C_USR_TX_RPT_MACID_MSK 0xff
#define FWCMD_H2C_USR_TX_RPT_AC_SH 8
#define FWCMD_H2C_USR_TX_RPT_AC_MSK 0x3
#define FWCMD_H2C_USR_TX_RPT_BAND BIT(10)
#define FWCMD_H2C_USR_TX_RPT_PORT_SH 11
#define FWCMD_H2C_USR_TX_RPT_PORT_MSK 0x7
#define FWCMD_H2C_USR_TX_RPT_MACID_EXT_SH 24
#define FWCMD_H2C_USR_TX_RPT_MACID_EXT_MSK 0xff
#define FWCMD_H2C_USR_TX_RPT_RPT_PERIOD_SH 0
#define FWCMD_H2C_USR_TX_RPT_RPT_PERIOD_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D0_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D1_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D1_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D2_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D2_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D3_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D3_MSK 0xffffffff
#define FWCMD_H2C_OFLD_CFG_MODE_SH 0
#define FWCMD_H2C_OFLD_CFG_MODE_MSK 0x7
#define FWCMD_H2C_OFLD_CFG_USR_TXOP_BE BIT(3)
#define FWCMD_H2C_OFLD_CFG_USR_TXOP_BE_VAL_SH 0
#define FWCMD_H2C_OFLD_CFG_USR_TXOP_BE_VAL_MSK 0xffff
#define FWCMD_H2C_H2C_AGG_PLD_SH 0
#define FWCMD_H2C_H2C_AGG_PLD_MSK 0xffffffff
#define FWCMD_H2C_ADD_SCANOFLD_CH_NUM_OF_CH_SH 0
#define FWCMD_H2C_ADD_SCANOFLD_CH_NUM_OF_CH_MSK 0xff
#define FWCMD_H2C_ADD_SCANOFLD_CH_SIZE_OF_CHINFO_SH 8
#define FWCMD_H2C_ADD_SCANOFLD_CH_SIZE_OF_CHINFO_MSK 0xff
#define FWCMD_H2C_ADD_SCANOFLD_CH_BAND BIT(16)
#define FWCMD_H2C_ADD_SCANOFLD_CH_APPEND BIT(17)
#define FWCMD_H2C_SCANOFLD_MACID_SH 0
#define FWCMD_H2C_SCANOFLD_MACID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_NORM_CY_SH 8
#define FWCMD_H2C_SCANOFLD_NORM_CY_MSK 0xff
#define FWCMD_H2C_SCANOFLD_PORT_ID_SH 16
#define FWCMD_H2C_SCANOFLD_PORT_ID_MSK 0x7
#define FWCMD_H2C_SCANOFLD_BAND BIT(19)
#define FWCMD_H2C_SCANOFLD_OPERATION_SH 20
#define FWCMD_H2C_SCANOFLD_OPERATION_MSK 0x3
#define FWCMD_H2C_SCANOFLD_TARGET_CH_CH_BAND_SH 22
#define FWCMD_H2C_SCANOFLD_TARGET_CH_CH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_C2H_NOTIFY_END BIT(0)
#define FWCMD_H2C_SCANOFLD_TARGET_CH_MODE BIT(1)
#define FWCMD_H2C_SCANOFLD_START_MODE BIT(2)
#define FWCMD_H2C_SCANOFLD_SCAN_TYPE_SH 3
#define FWCMD_H2C_SCANOFLD_SCAN_TYPE_MSK 0x3
#define FWCMD_H2C_SCANOFLD_TARGET_CH_BW_SH 5
#define FWCMD_H2C_SCANOFLD_TARGET_CH_BW_MSK 0x7
#define FWCMD_H2C_SCANOFLD_TARGET_PRI_CH_SH 8
#define FWCMD_H2C_SCANOFLD_TARGET_PRI_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_TARGET_CENTRAL_CH_SH 16
#define FWCMD_H2C_SCANOFLD_TARGET_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_TARGET_NUM_PKTS_SH 24
#define FWCMD_H2C_SCANOFLD_TARGET_NUM_PKTS_MSK 0xff
#define FWCMD_H2C_SCANOFLD_NORM_PD_SH 0
#define FWCMD_H2C_SCANOFLD_NORM_PD_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_SLOW_PD_SH 16
#define FWCMD_H2C_SCANOFLD_SLOW_PD_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_TSF_HIGH_SH 0
#define FWCMD_H2C_SCANOFLD_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_TSF_LOW_SH 0
#define FWCMD_H2C_SCANOFLD_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT0_SH 0
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT0_MSK 0xff
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT1_SH 8
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT1_MSK 0xff
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT2_SH 16
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT2_MSK 0xff
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT3_SH 24
#define FWCMD_H2C_SCANOFLD_TARGET_CH_PKT3_MSK 0xff
#define FWCMD_H2C_SCANOFLD_NUMSSID_SH 0
#define FWCMD_H2C_SCANOFLD_NUMSSID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_NUMSHORTSSID_SH 8
#define FWCMD_H2C_SCANOFLD_NUMSHORTSSID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_NUMBSSID_SH 16
#define FWCMD_H2C_SCANOFLD_NUMBSSID_MSK 0xff
#define FWCMD_H2C_TX_DUTY_PAUSE_INTVL_SH 0
#define FWCMD_H2C_TX_DUTY_PAUSE_INTVL_MSK 0xffff
#define FWCMD_H2C_TX_DUTY_TX_INTVL_SH 16
#define FWCMD_H2C_TX_DUTY_TX_INTVL_MSK 0xffff
#define FWCMD_H2C_TX_DUTY_STOP BIT(0)
#define FWCMD_H2C_DISABLE_RF_FUNC_SH 0
#define FWCMD_H2C_DISABLE_RF_FUNC_MSK 0xf
#define FWCMD_H2C_DISABLE_RF_NET_TYPE_SH 4
#define FWCMD_H2C_DISABLE_RF_NET_TYPE_MSK 0x3
#define FWCMD_H2C_TX_ADDBA_PKT_PKT_ID_SH 0
#define FWCMD_H2C_TX_ADDBA_PKT_PKT_ID_MSK 0xff
#define FWCMD_H2C_TX_ADDBA_PKT_PORT_SH 8
#define FWCMD_H2C_TX_ADDBA_PKT_PORT_MSK 0x7
#define FWCMD_H2C_TX_ADDBA_PKT_BAND BIT(11)
#define FWCMD_H2C_PKT_DROP_DROP_SEL_SH 0
#define FWCMD_H2C_PKT_DROP_DROP_SEL_MSK 0xff
#define FWCMD_H2C_PKT_DROP_MACID_SH 8
#define FWCMD_H2C_PKT_DROP_MACID_MSK 0xff
#define FWCMD_H2C_PKT_DROP_BAND_SH 16
#define FWCMD_H2C_PKT_DROP_BAND_MSK 0xff
#define FWCMD_H2C_PKT_DROP_PORT_SH 24
#define FWCMD_H2C_PKT_DROP_PORT_MSK 0xff
#define FWCMD_H2C_PKT_DROP_MBSSID_SH 0
#define FWCMD_H2C_PKT_DROP_MBSSID_MSK 0xff
#define FWCMD_H2C_PKT_DROP_ROLE_A_INFO_TF_TRS_SH 8
#define FWCMD_H2C_PKT_DROP_ROLE_A_INFO_TF_TRS_MSK 0xff
#define FWCMD_H2C_PKT_DROP_MACID_EXT_SH 16
#define FWCMD_H2C_PKT_DROP_MACID_EXT_MSK 0xff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_0_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_0_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_1_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_1_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_2_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_2_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_3_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_3_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_4_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_4_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_5_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_5_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_6_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_6_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_7_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_7_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_8_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_8_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_9_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_9_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_10_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_10_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_11_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_11_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_12_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_12_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_13_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_13_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_14_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_14_MSK 0xffffffff
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_15_SH 0
#define FWCMD_H2C_PKT_DROP_MACID_BAND_SEL_15_MSK 0xffffffff
#define FWCMD_H2C_CH_SWITCH_PRI_CH_SH 0
#define FWCMD_H2C_CH_SWITCH_PRI_CH_MSK 0xff
#define FWCMD_H2C_CH_SWITCH_CENTRAL_CH_SH 8
#define FWCMD_H2C_CH_SWITCH_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_CH_SWITCH_BW_SH 16
#define FWCMD_H2C_CH_SWITCH_BW_MSK 0x7
#define FWCMD_H2C_CH_SWITCH_CH_BAND_SH 19
#define FWCMD_H2C_CH_SWITCH_CH_BAND_MSK 0x3
#define FWCMD_H2C_CH_SWITCH_BAND BIT(21)
#define FWCMD_H2C_CH_SWITCH_RELOAD_RF BIT(22)
#define FWCMD_H2C_BCNERLYRPT_PORT_SH 0
#define FWCMD_H2C_BCNERLYRPT_PORT_MSK 0x7
#define FWCMD_H2C_BCNERLYRPT_BAND BIT(3)
#define FWCMD_H2C_BCNERLYRPT_CONTROL BIT(4)
#define FWCMD_H2C_BCNERLYRPT_RPT_INTVL_SH 5
#define FWCMD_H2C_BCNERLYRPT_RPT_INTVL_MSK 0xff
#define FWCMD_H2C_CFG_BCNFLTR_MON_RSSI BIT(0)
#define FWCMD_H2C_CFG_BCNFLTR_MON_BCN BIT(1)
#define FWCMD_H2C_CFG_BCNFLTR_MON_TP BIT(2)
#define FWCMD_H2C_CFG_BCNFLTR_TP_THLD_SH 3
#define FWCMD_H2C_CFG_BCNFLTR_TP_THLD_MSK 0x3
#define FWCMD_H2C_CFG_BCNFLTR_BCN_LOSS_CNT_SH 8
#define FWCMD_H2C_CFG_BCNFLTR_BCN_LOSS_CNT_MSK 0xf
#define FWCMD_H2C_CFG_BCNFLTR_RSSI_HYS_SH 12
#define FWCMD_H2C_CFG_BCNFLTR_RSSI_HYS_MSK 0xf
#define FWCMD_H2C_CFG_BCNFLTR_RSSI_THLD_SH 16
#define FWCMD_H2C_CFG_BCNFLTR_RSSI_THLD_MSK 0xff
#define FWCMD_H2C_CFG_BCNFLTR_MACID_SH 24
#define FWCMD_H2C_CFG_BCNFLTR_MACID_MSK 0xff
#define FWCMD_H2C_CFG_BCNFLTR_MACID_EXT_SH 0
#define FWCMD_H2C_CFG_BCNFLTR_MACID_EXT_MSK 0xff
#define FWCMD_H2C_OFLD_RSSI_MACID_SH 0
#define FWCMD_H2C_OFLD_RSSI_MACID_MSK 0xff
#define FWCMD_H2C_OFLD_RSSI_NUM_RSSI_SH 8
#define FWCMD_H2C_OFLD_RSSI_NUM_RSSI_MSK 0xff
#define FWCMD_H2C_OFLD_RSSI_MACID_EXT_SH 16
#define FWCMD_H2C_OFLD_RSSI_MACID_EXT_MSK 0xff
#define FWCMD_H2C_OFLD_TP_MACID_SH 0
#define FWCMD_H2C_OFLD_TP_MACID_MSK 0xff
#define FWCMD_H2C_OFLD_TP_TXTP_SH 8
#define FWCMD_H2C_OFLD_TP_TXTP_MSK 0x3ff
#define FWCMD_H2C_OFLD_TP_RXTP_SH 18
#define FWCMD_H2C_OFLD_TP_RXTP_MSK 0x3ff
#define FWCMD_H2C_OFLD_TP_MACID_EXT_SH 0
#define FWCMD_H2C_OFLD_TP_MACID_EXT_MSK 0xff
#define FWCMD_H2C_HOST_EFUSE_REC_HOST_ID_SH 0
#define FWCMD_H2C_HOST_EFUSE_REC_HOST_ID_MSK 0xffffffff
#define FWCMD_H2C_HOST_EFUSE_REC_EFUSE_VAL_SH 0
#define FWCMD_H2C_HOST_EFUSE_REC_EFUSE_VAL_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_PRI_CH_SH 0
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_PRI_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_CH_BAND_SH 8
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_CH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_CMD_SH 10
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_CMD_MSK 0x7
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_BAND BIT(13)
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_NUM_TBL_SH 16
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_NUM_TBL_MSK 0xff
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_SIZEOF_TBL_SH 24
#define FWCMD_H2C_SCANOFLD_DRV_CTRL_SIZEOF_TBL_MSK 0xff
#define FWCMD_H2C_WIFI_SENSING_CSI_MACID_SH 0
#define FWCMD_H2C_WIFI_SENSING_CSI_MACID_MSK 0xff
#define FWCMD_H2C_WIFI_SENSING_CSI_EN BIT(8)
#define FWCMD_H2C_WIFI_SENSING_CSI_PERIOD_SH 16
#define FWCMD_H2C_WIFI_SENSING_CSI_PERIOD_MSK 0xffff
#define FWCMD_H2C_WIFI_SENSING_CSI_RETRY_CNT_SH 0
#define FWCMD_H2C_WIFI_SENSING_CSI_RETRY_CNT_MSK 0xff
#define FWCMD_H2C_WIFI_SENSING_CSI_RATE_SH 8
#define FWCMD_H2C_WIFI_SENSING_CSI_RATE_MSK 0xffff
#define FWCMD_H2C_WIFI_SENSING_CSI_PKT_NUM_SH 24
#define FWCMD_H2C_WIFI_SENSING_CSI_PKT_NUM_MSK 0xff
#define FWCMD_H2C_WIFI_SENSING_CSI_MACID_EXT_SH 0
#define FWCMD_H2C_WIFI_SENSING_CSI_MACID_EXT_MSK 0xff
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D0_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D1_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D1_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D2_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D2_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D3_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_REG_CMD_OFLD_D3_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D0_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D1_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D1_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D2_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D2_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D3_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_PKT_CMD_OFLD_D3_MSK 0xffffffff
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_BE0 BIT(0)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_BK0 BIT(1)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_VI0 BIT(2)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_VO0 BIT(3)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_BE1 BIT(4)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_BK1 BIT(5)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_VI1 BIT(6)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_VO1 BIT(7)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_MG0 BIT(8)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_MG1 BIT(9)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_MG2 BIT(10)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_HI BIT(11)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_BCN BIT(12)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_UL BIT(13)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_TWT0 BIT(14)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_TWT1 BIT(15)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_TWT2 BIT(16)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_TWT3 BIT(17)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_SPEQ0 BIT(18)
#define FWCMD_H2C_SCH_TX_EN_PKT_TX_EN_SPEQ1 BIT(19)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_BE0 BIT(0)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_BK0 BIT(1)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_VI0 BIT(2)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_VO0 BIT(3)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_BE1 BIT(4)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_BK1 BIT(5)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_VI1 BIT(6)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_VO1 BIT(7)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_MG0 BIT(8)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_MG1 BIT(9)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_MG2 BIT(10)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_HI BIT(11)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_BCN BIT(12)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_UL BIT(13)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_TWT0 BIT(14)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_TWT1 BIT(15)
#define FWCMD_H2C_SCH_TX_EN_PKT_BAND BIT(16)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_TWT2 BIT(17)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_TWT3 BIT(18)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_SPEQ0 BIT(19)
#define FWCMD_H2C_SCH_TX_EN_PKT_MASK_SPEQ1 BIT(20)
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_4_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_4_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_4_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_4_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_5_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_5_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_6_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_6_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_7_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_7_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_8_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_8_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_5_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_5_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_6_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_6_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_7_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_7_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_8_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_8_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_5_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_5_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_6_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_6_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_7_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_7_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_8_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_8_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_5_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_5_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_6_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_6_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_7_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_7_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_8_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_8_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_9_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_9_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_10_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_10_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_11_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_11_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_12_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_12_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_9_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_9_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_10_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_10_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_11_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_11_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_12_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_12_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_9_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_9_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_10_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_10_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_11_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_11_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_12_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_12_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_9_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_9_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_10_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_10_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_11_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_11_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_12_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_12_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_13_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_13_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_14_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_14_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_15_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_15_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_16_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_EN_16_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_13_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_13_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_14_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_14_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_15_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_15_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_16_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_PAUSE_GRP_MASK_16_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_13_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_13_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_14_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_14_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_15_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_15_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_16_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_EN_16_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_13_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_13_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_14_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_14_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_15_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_15_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_16_SH 0
#define FWCMD_H2C_MACID_PAUSE_SLEEP_SLEEP_GRP_MASK_16_MSK 0xffffffff
#define FWCMD_H2C_BCN_OFLD_BAND BIT(0)
#define FWCMD_H2C_BCN_OFLD_PORT_SH 1
#define FWCMD_H2C_BCN_OFLD_PORT_MSK 0x7
#define FWCMD_H2C_BCN_OFLD_TYPE_SH 4
#define FWCMD_H2C_BCN_OFLD_TYPE_MSK 0x7
#define FWCMD_H2C_BCN_OFLD_RST_CAM BIT(7)
#define FWCMD_H2C_BCN_OFLD_HIT_FWD_EN BIT(8)
#define FWCMD_H2C_BCN_OFLD_MISS_FWD_EN BIT(9)
#define FWCMD_H2C_BCN_OFLD_ERR_FWD_EN BIT(10)
#define FWCMD_H2C_BCN_OFLD_CAM_NUM_SH 11
#define FWCMD_H2C_BCN_OFLD_CAM_NUM_MSK 0x1f
#define FWCMD_H2C_BCN_OFLD_HIT_FWD_SH 16
#define FWCMD_H2C_BCN_OFLD_HIT_FWD_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_MISS_FWD_SH 24
#define FWCMD_H2C_BCN_OFLD_MISS_FWD_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_ERR_FWD_SH 0
#define FWCMD_H2C_BCN_OFLD_ERR_FWD_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_RPT_PERIOD_SH 8
#define FWCMD_H2C_BCN_OFLD_RPT_PERIOD_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_RSSI_PERIOD_SH 16
#define FWCMD_H2C_BCN_OFLD_RSSI_PERIOD_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_RSSI_MAX_NUM_SH 24
#define FWCMD_H2C_BCN_OFLD_RSSI_MAX_NUM_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_DETN_PERIOD_SH 0
#define FWCMD_H2C_BCN_OFLD_DETN_PERIOD_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_DETN_MIN_BCN_CNT_SH 8
#define FWCMD_H2C_BCN_OFLD_DETN_MIN_BCN_CNT_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_DETN_RSSI_LOW_BND_SH 16
#define FWCMD_H2C_BCN_OFLD_DETN_RSSI_LOW_BND_MSK 0xff
#define FWCMD_H2C_BCN_OFLD_DETN_RSSI_HIGH_BND_SH 24
#define FWCMD_H2C_BCN_OFLD_DETN_RSSI_HIGH_BND_MSK 0xff
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_BAND_SH 0
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_BAND_MSK 0xff
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_PORT_SH 8
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_PORT_MSK 0xff
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_NUM_INTV_SH 16
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_NUM_INTV_MSK 0xff
#define FWCMD_H2C_TBTT_SH_STAT_OFLD_ENABLE BIT(24)
#define FWCMD_H2C_STA_CSA_STA_CSA_EN BIT(0)
#define FWCMD_H2C_STA_CSA_SIZE_OF_CHINFO_SH 1
#define FWCMD_H2C_STA_CSA_SIZE_OF_CHINFO_MSK 0x7f
#define FWCMD_H2C_STA_CSA_NUM_OF_CHINFO_SH 8
#define FWCMD_H2C_STA_CSA_NUM_OF_CHINFO_MSK 0xff
#define FWCMD_H2C_STA_CSA_MACID_SH 16
#define FWCMD_H2C_STA_CSA_MACID_MSK 0xff
#define FWCMD_H2C_STA_CSA_MAX_AP_GONE_TIME_SH 24
#define FWCMD_H2C_STA_CSA_MAX_AP_GONE_TIME_MSK 0xff
#define FWCMD_H2C_STA_CSA_MACID_EXT_SH 0
#define FWCMD_H2C_STA_CSA_MACID_EXT_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_OPERATION_SH 0
#define FWCMD_H2C_SCANOFLD_V2_OPERATION_MSK 0x3
#define FWCMD_H2C_SCANOFLD_V2_SCAN_MODE_SH 2
#define FWCMD_H2C_SCANOFLD_V2_SCAN_MODE_MSK 0x3
#define FWCMD_H2C_SCANOFLD_V2_REPEAT_TYPE_SH 4
#define FWCMD_H2C_SCANOFLD_V2_REPEAT_TYPE_MSK 0x3
#define FWCMD_H2C_SCANOFLD_V2_NOTIFY_END BIT(6)
#define FWCMD_H2C_SCANOFLD_V2_GEN_LEARNED_CH BIT(7)
#define FWCMD_H2C_SCANOFLD_V2_MACID_SH 8
#define FWCMD_H2C_SCANOFLD_V2_MACID_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_V2_PORT_ID_SH 24
#define FWCMD_H2C_SCANOFLD_V2_PORT_ID_MSK 0x7
#define FWCMD_H2C_SCANOFLD_V2_BAND_SH 27
#define FWCMD_H2C_SCANOFLD_V2_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_V2_PROBE_WITH_RATE BIT(29)
#define FWCMD_H2C_SCANOFLD_V2_NUMMACCROLE_SH 0
#define FWCMD_H2C_SCANOFLD_V2_NUMMACCROLE_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_NUMOP_SH 8
#define FWCMD_H2C_SCANOFLD_V2_NUMOP_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_NORM_PD_SH 16
#define FWCMD_H2C_SCANOFLD_V2_NORM_PD_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_V2_SLOW_PD_SH 0
#define FWCMD_H2C_SCANOFLD_V2_SLOW_PD_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_V2_NORM_CY_SH 16
#define FWCMD_H2C_SCANOFLD_V2_NORM_CY_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_OPCH_END_SH 24
#define FWCMD_H2C_SCANOFLD_V2_OPCH_END_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_NUMSSID_SH 0
#define FWCMD_H2C_SCANOFLD_V2_NUMSSID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_NUMSHORTSSID_SH 8
#define FWCMD_H2C_SCANOFLD_V2_NUMSHORTSSID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_NUMBSSID_SH 16
#define FWCMD_H2C_SCANOFLD_V2_NUMBSSID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_PROBE_ID_24G_SH 24
#define FWCMD_H2C_SCANOFLD_V2_PROBE_ID_24G_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_PROBE_ID_5G_SH 0
#define FWCMD_H2C_SCANOFLD_V2_PROBE_ID_5G_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_PROBE_ID_6G_SH 8
#define FWCMD_H2C_SCANOFLD_V2_PROBE_ID_6G_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_SEC_DELAY_START_SH 16
#define FWCMD_H2C_SCANOFLD_V2_SEC_DELAY_START_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_V2_SCAN_MLO_MODE_SH 0
#define FWCMD_H2C_SCANOFLD_V2_SCAN_MLO_MODE_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_V2_PROHIB_6G_20M_0_SH 0
#define FWCMD_H2C_SCANOFLD_V2_PROHIB_6G_20M_0_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_V2_PROHIB_6G_20M_1_SH 0
#define FWCMD_H2C_SCANOFLD_V2_PROHIB_6G_20M_1_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_V2_PROBE_RATE_24G_SH 0
#define FWCMD_H2C_SCANOFLD_V2_PROBE_RATE_24G_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_PROBE_RATE_5G_SH 8
#define FWCMD_H2C_SCANOFLD_V2_PROBE_RATE_5G_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_PROBE_RATE_6G_SH 16
#define FWCMD_H2C_SCANOFLD_V2_PROBE_RATE_6G_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_SIZEOF_CFG_SH 0
#define FWCMD_H2C_SCANOFLD_V2_SIZEOF_CFG_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_SIZEOF_MACC_ROLE_SH 8
#define FWCMD_H2C_SCANOFLD_V2_SIZEOF_MACC_ROLE_MSK 0xff
#define FWCMD_H2C_SCANOFLD_V2_SIZEOF_OP_SH 16
#define FWCMD_H2C_SCANOFLD_V2_SIZEOF_OP_MSK 0xff
#define FWCMD_H2C_FRAME_TO_ACT_MODE_SH 0
#define FWCMD_H2C_FRAME_TO_ACT_MODE_MSK 0xf
#define FWCMD_H2C_FRAME_TO_ACT_TRIGGER_CNT_SH 8
#define FWCMD_H2C_FRAME_TO_ACT_TRIGGER_CNT_MSK 0xff
#define FWCMD_H2C_FRAME_TO_ACT_SW_DEF_SH 16
#define FWCMD_H2C_FRAME_TO_ACT_SW_DEF_MSK 0xffff
#define FWCMD_H2C_FRAME_TO_ACT_TO_THR_SH 0
#define FWCMD_H2C_FRAME_TO_ACT_TO_THR_MSK 0xffffffff
#define FWCMD_H2C_DUMP_EFUSE_V2_DUMP_SIZE_SH 0
#define FWCMD_H2C_DUMP_EFUSE_V2_DUMP_SIZE_MSK 0xffff
#define FWCMD_H2C_DUMP_EFUSE_V2_IS_HIDDEN BIT(16)
#define FWCMD_H2C_DUMP_EFUSE_V2_IS_DAV BIT(17)
#define FWCMD_H2C_DUMP_EFUSE_V2_END_BREAK BIT(18)
#define FWCMD_H2C_DUMP_EFUSE_V2_DAV_CHIP_ID BIT(19)
#define FWCMD_H2C_DUMP_EFUSE_V2_START_OFFSET_SH 0
#define FWCMD_H2C_DUMP_EFUSE_V2_START_OFFSET_MSK 0xffff
#define FWCMD_H2C_TXRPT_STATS_EN_MACID_NUM_SH 0
#define FWCMD_H2C_TXRPT_STATS_EN_MACID_NUM_MSK 0xff
#define FWCMD_H2C_TXRPT_STATS_EN_STATS_EN BIT(8)
#define FWCMD_H2C_TXRPT_STATS_EN_ONLY_MAIN_MACID BIT(9)
#define FWCMD_H2C_TXRPT_STATS_EN_C2H_MODE BIT(10)
#define FWCMD_H2C_TXRPT_STATS_EN_DURATION_SH 16
#define FWCMD_H2C_TXRPT_STATS_EN_DURATION_MSK 0x3ff
#define FWCMD_H2C_TXRPT_STATS_EN_MACID_X_SH 0
#define FWCMD_H2C_TXRPT_STATS_EN_MACID_X_MSK 0xffff
#define FWCMD_H2C_TXRPT_STATS_EN_MACID_Y_SH 16
#define FWCMD_H2C_TXRPT_STATS_EN_MACID_Y_MSK 0xffff
#define FWCMD_H2C_CPUMGPKT_TX_PKT_LEN_SH 0
#define FWCMD_H2C_CPUMGPKT_TX_PKT_LEN_MSK 0xffff
#define FWCMD_H2C_CPUMGPKT_TX_MACID_SH 16
#define FWCMD_H2C_CPUMGPKT_TX_MACID_MSK 0xffff
#define FWCMD_H2C_CPUMGPKT_TX_TX_NUM_SH 0
#define FWCMD_H2C_CPUMGPKT_TX_TX_NUM_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_RX_BCN_EN BIT(0)
#define FWCMD_H2C_BCN_CNT_GPIO_RX_OUTPUT_INTPUT BIT(1)
#define FWCMD_H2C_BCN_CNT_GPIO_RX_ACTIVE BIT(2)
#define FWCMD_H2C_BCN_CNT_GPIO_RX_TOGGLE_PULSE BIT(3)
#define FWCMD_H2C_BCN_CNT_GPIO_RX_TIME_UNIT BIT(4)
#define FWCMD_H2C_BCN_CNT_GPIO_RX_DEBUG BIT(5)
#define FWCMD_H2C_BCN_CNT_GPIO_RX_GPIO_NUM_SH 8
#define FWCMD_H2C_BCN_CNT_GPIO_RX_GPIO_NUM_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_RX_MACID_SH 16
#define FWCMD_H2C_BCN_CNT_GPIO_RX_MACID_MSK 0xffff
#define FWCMD_H2C_BCN_CNT_GPIO_RX_PULSE_CNT_SH 0
#define FWCMD_H2C_BCN_CNT_GPIO_RX_PULSE_CNT_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_RX_PULSE_DURATION_SH 8
#define FWCMD_H2C_BCN_CNT_GPIO_RX_PULSE_DURATION_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_RX_PULSE_PERIOD_SH 16
#define FWCMD_H2C_BCN_CNT_GPIO_RX_PULSE_PERIOD_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_TX_BCN_EN BIT(0)
#define FWCMD_H2C_BCN_CNT_GPIO_TX_OUTPUT_INTPUT BIT(1)
#define FWCMD_H2C_BCN_CNT_GPIO_TX_ACTIVE BIT(2)
#define FWCMD_H2C_BCN_CNT_GPIO_TX_TOGGLE_PULSE BIT(3)
#define FWCMD_H2C_BCN_CNT_GPIO_TX_TIME_UNIT BIT(4)
#define FWCMD_H2C_BCN_CNT_GPIO_TX_DEBUG BIT(5)
#define FWCMD_H2C_BCN_CNT_GPIO_TX_GPIO_NUM_SH 8
#define FWCMD_H2C_BCN_CNT_GPIO_TX_GPIO_NUM_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_TX_MACID_SH 16
#define FWCMD_H2C_BCN_CNT_GPIO_TX_MACID_MSK 0xffff
#define FWCMD_H2C_BCN_CNT_GPIO_TX_PULSE_CNT_SH 0
#define FWCMD_H2C_BCN_CNT_GPIO_TX_PULSE_CNT_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_TX_PULSE_DURATION_SH 8
#define FWCMD_H2C_BCN_CNT_GPIO_TX_PULSE_DURATION_MSK 0xff
#define FWCMD_H2C_BCN_CNT_GPIO_TX_PULSE_PERIOD_SH 16
#define FWCMD_H2C_BCN_CNT_GPIO_TX_PULSE_PERIOD_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_TYPE_SH 0
#define FWCMD_H2C_RX_FWD_BE_TYPE_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_FRAME_SH 8
#define FWCMD_H2C_RX_FWD_BE_FRAME_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_FWD_TG_SH 16
#define FWCMD_H2C_RX_FWD_BE_FWD_TG_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_AF_UD_INDEX_SH 0
#define FWCMD_H2C_RX_FWD_BE_AF_UD_INDEX_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_AF_UD_FWD_TG_SH 8
#define FWCMD_H2C_RX_FWD_BE_AF_UD_FWD_TG_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_AF_UD_CATEGORY_SH 16
#define FWCMD_H2C_RX_FWD_BE_AF_UD_CATEGORY_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_AF_UD_ACTION_FIELD_SH 24
#define FWCMD_H2C_RX_FWD_BE_AF_UD_ACTION_FIELD_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_VALID BIT(0)
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_TYPE_SH 1
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_TYPE_MSK 0x3
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_SUBTYPE_SH 3
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_SUBTYPE_MSK 0xf
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_SKIP_MAC_IV_HDR BIT(7)
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_TARGET_IND_V1_SH 8
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_TARGET_IND_V1_MSK 0xff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_CRC16_SH 16
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_CRC16_MSK 0xffff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK0_SH 0
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK0_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK1_SH 0
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK1_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK2_SH 0
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK2_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK3_SH 0
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_PLD_MASK3_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_INDEX_V1_SH 0
#define FWCMD_H2C_RX_FWD_BE_PM_CAM_INDEX_V1_MSK 0x1f
#define FWCMD_H2C_RX_FWD_BE_IGNORE_SUBTYPE BIT(8)
#define FWCMD_H2C_TRX_TIME_STATS_EN_BAND_BITMAP_SH 0
#define FWCMD_H2C_TRX_TIME_STATS_EN_BAND_BITMAP_MSK 0xf
#define FWCMD_H2C_TRX_TIME_STATS_EN_STATS_EN BIT(7)
#define FWCMD_H2C_TRX_TIME_STATS_EN_DURATION_SH 16
#define FWCMD_H2C_TRX_TIME_STATS_EN_DURATION_MSK 0xffff
#define FWCMD_H2C_TRX_PROTECT_OFLD_BAND_BITMAP_SH 0
#define FWCMD_H2C_TRX_PROTECT_OFLD_BAND_BITMAP_MSK 0x7
#define FWCMD_H2C_TRX_PROTECT_OFLD_OP_MODE_SH 3
#define FWCMD_H2C_TRX_PROTECT_OFLD_OP_MODE_MSK 0x3
#define FWCMD_H2C_TRX_PROTECT_OFLD_RX_IN BIT(0)
#define FWCMD_H2C_TRX_PROTECT_OFLD_PPDU_STS BIT(4)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MSK_RX_IN BIT(16)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MSK_PPDU_STS BIT(20)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_BE0 BIT(0)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_BK0 BIT(1)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_VI0 BIT(2)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_VO0 BIT(3)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_BE1 BIT(4)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_BK1 BIT(5)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_VI1 BIT(6)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_VO1 BIT(7)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_MG0 BIT(8)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_MG1 BIT(9)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_MG2 BIT(10)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_HI BIT(11)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_BCN BIT(12)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_UL BIT(13)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_TWT0 BIT(14)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_TWT1 BIT(15)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_TWT2 BIT(16)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_TWT3 BIT(17)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_SPEQ0 BIT(18)
#define FWCMD_H2C_TRX_PROTECT_OFLD_TXEN_SPEQ1 BIT(19)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_BE0 BIT(0)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_BK0 BIT(1)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_VI0 BIT(2)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_VO0 BIT(3)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_BE1 BIT(4)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_BK1 BIT(5)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_VI1 BIT(6)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_VO1 BIT(7)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_MG0 BIT(8)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_MG1 BIT(9)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_MG2 BIT(10)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_HI BIT(11)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_BCN BIT(12)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_UL BIT(13)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_TWT0 BIT(14)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_TWT1 BIT(15)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_TWT2 BIT(16)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_TWT3 BIT(17)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_SPEQ0 BIT(18)
#define FWCMD_H2C_TRX_PROTECT_OFLD_MASK_TXEN_SPEQ1 BIT(19)
#define FWCMD_H2C_TB_PPDU_CTRL_BAND_SH 0
#define FWCMD_H2C_TB_PPDU_CTRL_BAND_MSK 0x3
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_SH 2
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_MSK 0x7
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_0_SH 5
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_0_MSK 0x7
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_1_SH 8
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_1_MSK 0x7
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_2_SH 11
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_2_MSK 0x7
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_3_SH 14
#define FWCMD_H2C_TB_PPDU_CTRL_PRI_AC_3_MSK 0x7
#define FWCMD_H2C_TB_PPDU_CTRL_PREFER_AC_MODE BIT(17)
#define FWCMD_H2C_TB_PPDU_CTRL_ON_THE_FLY_MODE BIT(18)
#define FWCMD_H2C_TB_PPDU_CTRL_BE_DIS BIT(19)
#define FWCMD_H2C_TB_PPDU_CTRL_BK_DIS BIT(20)
#define FWCMD_H2C_TB_PPDU_CTRL_VI_DIS BIT(21)
#define FWCMD_H2C_TB_PPDU_CTRL_VO_DIS BIT(22)
#define FWCMD_H2C_TB_PPDU_CTRL_CTRL_FULL_SETTING BIT(23)
#define FWCMD_H2C_APF_OFLD_CTRL_MACID_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_MACID_MSK 0xffff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_EN_SH 16
#define FWCMD_H2C_APF_OFLD_CTRL_APF_EN_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_PROG_FRAG_NUM_SH 24
#define FWCMD_H2C_APF_OFLD_CTRL_APF_PROG_FRAG_NUM_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_MACPKTID_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_MACPKTID_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID1_SH 8
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID1_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID2_SH 16
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID2_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID3_SH 24
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID3_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID4_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID4_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID5_SH 8
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID5_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID6_SH 16
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID6_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID7_SH 24
#define FWCMD_H2C_APF_OFLD_CTRL_APF_OFLD_PKTID7_MSK 0xff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_RAM_SIZE_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_APF_RAM_SIZE_MSK 0xffff
#define FWCMD_H2C_APF_OFLD_CTRL_APF_PROG_SIZE_SH 16
#define FWCMD_H2C_APF_OFLD_CTRL_APF_PROG_SIZE_MSK 0xffff
#define FWCMD_H2C_APF_OFLD_CTRL_VERSION1_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_VERSION1_MSK 0xffffffff
#define FWCMD_H2C_APF_OFLD_CTRL_VERSION2_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_VERSION2_MSK 0xffffffff
#define FWCMD_H2C_APF_OFLD_CTRL_PTR_APF_RAM_BUFFER_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_PTR_APF_RAM_BUFFER_MSK 0xffffffff
#define FWCMD_H2C_APF_OFLD_CTRL_MULTICAST_MASK_SH 0
#define FWCMD_H2C_APF_OFLD_CTRL_MULTICAST_MASK_MSK 0xffff
#define FWCMD_H2C_SECCAM_INFO_IDX_SH 0
#define FWCMD_H2C_SECCAM_INFO_IDX_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_OFFSET_SH 8
#define FWCMD_H2C_SECCAM_INFO_OFFSET_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_LEN_SH 16
#define FWCMD_H2C_SECCAM_INFO_LEN_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_TYPE_SH 0
#define FWCMD_H2C_SECCAM_INFO_TYPE_MSK 0xf
#define FWCMD_H2C_SECCAM_INFO_EXT_KEY BIT(4)
#define FWCMD_H2C_SECCAM_INFO_SPP_MODE BIT(5)
#define FWCMD_H2C_SECCAM_INFO_KEY_0_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_0_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_1_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_1_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_2_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_2_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_3_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_3_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_4_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_4_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_5_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_5_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_6_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_6_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_7_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_7_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_IDX_V1_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_IDX_V1_MSK 0xffff
#define FWCMD_H2C_SECCAM_INFO_V1_OFFSET_V1_SH 16
#define FWCMD_H2C_SECCAM_INFO_V1_OFFSET_V1_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_V1_LEN_V1_SH 24
#define FWCMD_H2C_SECCAM_INFO_V1_LEN_V1_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_V1_TYPE_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_TYPE_MSK 0xf
#define FWCMD_H2C_SECCAM_INFO_V1_EXT_KEY BIT(4)
#define FWCMD_H2C_SECCAM_INFO_V1_SPP_MODE BIT(5)
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_0_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_0_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_1_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_1_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_2_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_2_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_3_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_3_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_4_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_4_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_5_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_5_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_6_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_6_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_7_SH 0
#define FWCMD_H2C_SECCAM_INFO_V1_KEY_7_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_FREXCH_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_FREXCH_TYPE_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_MODE_SH 6
#define FWCMD_H2C_SET_SND_PARA_MODE_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_USER_NUM_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_USER_NUM_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_USER_NUM_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_USER_NUM_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_MACID0_SH 0
#define FWCMD_H2C_SET_SND_PARA_MACID0_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID1_SH 8
#define FWCMD_H2C_SET_SND_PARA_MACID1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID2_SH 16
#define FWCMD_H2C_SET_SND_PARA_MACID2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID3_SH 24
#define FWCMD_H2C_SET_SND_PARA_MACID3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID4_SH 0
#define FWCMD_H2C_SET_SND_PARA_MACID4_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID5_SH 8
#define FWCMD_H2C_SET_SND_PARA_MACID5_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID6_SH 16
#define FWCMD_H2C_SET_SND_PARA_MACID6_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID7_SH 24
#define FWCMD_H2C_SET_SND_PARA_MACID7_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_NDPA_FRAME_CTRL_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_FRAME_CTRL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_NDPA_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_SND_DLG_HE BIT(0)
#define FWCMD_H2C_SET_SND_PARA_NDPA_SND_DLG_DIALOG_SH 1
#define FWCMD_H2C_SET_SND_PARA_NDPA_SND_DLG_DIALOG_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_HT_SEQ_CONTROL_SH 16
#define FWCMD_H2C_SET_SND_PARA_HT_SEQ_CONTROL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_BFRP0_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP0_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP1_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP2_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP0_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP0_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP1_FB_REXMIT_SH 8
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP1_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP2_FB_REXMIT_SH 16
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP2_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD0_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD0_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD0_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD0_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD0 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD0 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD0 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD0 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD0_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD0_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD0_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD0_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD0 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD0 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD0_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD0_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD0_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD1_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD1_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD1_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD1_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD1 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD1 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD1 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD1 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD1_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD1_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD1_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD1_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD1 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD1 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD1_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD1_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD1_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD2_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD2_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD2_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD2_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD2 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD2 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD2 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD2 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD2 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD2_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD2_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD2_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD2_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD2 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD2 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD2_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD2_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD2_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD3_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD3_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD3_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD3_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD3 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD3 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD3 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD3 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD3 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD3_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD3_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD3_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD3_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD3 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD3 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD3_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD3_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD3_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD4_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD4_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD4_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD4_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD4 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD4 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD4 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD4 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD4 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD4_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD4_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD4_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD4_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD4 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD4 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD4_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD4_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD4_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP0_SH 0
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP0_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP0_SH 12
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP0_SH 14
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_UL_CQI_RPT_TRI_BFRP0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP0_SH 17
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP0_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_FIX_GAIN_EN_BFRP0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP1_SH 0
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP1_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP1_SH 12
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP1_SH 14
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_UL_CQI_RPT_TRI_BFRP1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP1_SH 17
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP1_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_FIX_GAIN_EN_BFRP1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_F2P_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_TYPE_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_INDEX_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_PERIOD_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_PERIOD_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_F2P_UPDCNT_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_UPDCNT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_CR_IDX_SH 8
#define FWCMD_H2C_SET_SND_PARA_CR_IDX_MSK 0x3fffff
#define FWCMD_H2C_SET_SND_PARA_SOUNDING_EN BIT(31)
#define FWCMD_H2C_GET_CSI_BUF_BAND_SH 0
#define FWCMD_H2C_GET_CSI_BUF_BAND_MSK 0xff
#define FWCMD_H2C_GET_CSI_BUF_CSI_BUF_ID_SH 8
#define FWCMD_H2C_GET_CSI_BUF_CSI_BUF_ID_MSK 0xff
#define FWCMD_H2C_SET_CSI_BUF_BAND_SH 0
#define FWCMD_H2C_SET_CSI_BUF_BAND_MSK 0xff
#define FWCMD_H2C_SET_CSI_BUF_MACID_SH 8
#define FWCMD_H2C_SET_CSI_BUF_MACID_MSK 0xff
#define FWCMD_H2C_SET_CSI_BUF_CSI_BUF_ID_SH 16
#define FWCMD_H2C_SET_CSI_BUF_CSI_BUF_ID_MSK 0xffff
#define FWCMD_H2C_SET_CSI_BUF_BUF_IDX_SH 0
#define FWCMD_H2C_SET_CSI_BUF_BUF_IDX_MSK 0xffff
#define FWCMD_H2C_GET_SND_STS_BAND_SH 0
#define FWCMD_H2C_GET_SND_STS_BAND_MSK 0xff
#define FWCMD_H2C_GET_SND_STS_INDEX_SH 8
#define FWCMD_H2C_GET_SND_STS_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_STS_BAND_SH 0
#define FWCMD_H2C_SET_SND_STS_BAND_MSK 0xff
#define FWCMD_H2C_SET_SND_STS_MACID_SH 8
#define FWCMD_H2C_SET_SND_STS_MACID_MSK 0xff
#define FWCMD_H2C_SET_SND_STS_INDEX_SH 16
#define FWCMD_H2C_SET_SND_STS_INDEX_MSK 0xff
#define FWCMD_H2C_INIT_SND_MER_BAND_SH 0
#define FWCMD_H2C_INIT_SND_MER_BAND_MSK 0xff
#define FWCMD_H2C_INIT_SND_MEE_BAND_SH 0
#define FWCMD_H2C_INIT_SND_MEE_BAND_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_BAND_SH 0
#define FWCMD_H2C_CSI_FIX_RATE_BAND_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_HT_RATE_SH 8
#define FWCMD_H2C_CSI_FIX_RATE_HT_RATE_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_VHT_RATE_SH 16
#define FWCMD_H2C_CSI_FIX_RATE_VHT_RATE_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_HE_RATE_SH 24
#define FWCMD_H2C_CSI_FIX_RATE_HE_RATE_MSK 0xff
#define FWCMD_H2C_CSI_RRSC_BAND_SH 0
#define FWCMD_H2C_CSI_RRSC_BAND_MSK 0xff
#define FWCMD_H2C_CSI_RRSC_RRSC_SH 0
#define FWCMD_H2C_CSI_RRSC_RRSC_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_CTRL_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_CTRL_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_0_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_0_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_1_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_1_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_2_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_2_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_3_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_3_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_4_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_4_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_5_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_5_MSK 0xffffffff
#define FWCMD_H2C_SET_CSI_PARA_REG_BAND BIT(0)
#define FWCMD_H2C_SET_CSI_PARA_REG_PORT_SEL BIT(1)
#define FWCMD_H2C_SET_CSI_PARA_REG_NC_SH 2
#define FWCMD_H2C_SET_CSI_PARA_REG_NC_MSK 0x7
#define FWCMD_H2C_SET_CSI_PARA_REG_NR_SH 5
#define FWCMD_H2C_SET_CSI_PARA_REG_NR_MSK 0x7
#define FWCMD_H2C_SET_CSI_PARA_REG_NG_SH 8
#define FWCMD_H2C_SET_CSI_PARA_REG_NG_MSK 0x3
#define FWCMD_H2C_SET_CSI_PARA_REG_CB_SH 10
#define FWCMD_H2C_SET_CSI_PARA_REG_CB_MSK 0x3
#define FWCMD_H2C_SET_CSI_PARA_REG_CS_SH 12
#define FWCMD_H2C_SET_CSI_PARA_REG_CS_MSK 0x3
#define FWCMD_H2C_SET_CSI_PARA_REG_LDPC_EN BIT(14)
#define FWCMD_H2C_SET_CSI_PARA_REG_STBC_EN BIT(15)
#define FWCMD_H2C_SET_CSI_PARA_REG_BF_EN BIT(16)
#define FWCMD_H2C_HW_SND_PR_BAND_SH 0
#define FWCMD_H2C_HW_SND_PR_BAND_MSK 0xff
#define FWCMD_H2C_HW_SND_PR_PR_SH 8
#define FWCMD_H2C_HW_SND_PR_PR_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_FREXCH_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_FREXCH_TYPE_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_MODE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V1_MODE_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_USER_NUM_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_USER_NUM_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_USER_NUM_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_USER_NUM_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID0_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID4_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID5_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID5_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID6_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID6_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID7_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID7_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID8_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID8_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID9_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID9_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID10_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID10_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID11_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID11_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID12_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID13_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID13_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID14_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID14_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID15_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID15_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_FRAME_CTRL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_FRAME_CTRL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_SND_DLG_HE BIT(0)
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_SND_DLG_DIALOG_SH 1
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_SND_DLG_DIALOG_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_HT_SEQ_CONTROL_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_HT_SEQ_CONTROL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP1_FEEDBACKSEG_REXMIT_BITMAP_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP2_FEEDBACKSEG_REXMIT_BITMAP_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD0_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD0_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD0_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD0_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD0 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD0 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD0 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD0 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD0_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD0_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD0_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD0_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD0 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD0 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD0_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD0_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD0_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD0 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD1_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD1_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD1_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD1_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD1 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD1 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD1 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD1 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD1_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD1_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD1_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD1 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD1 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD1_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD1_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD1_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD1 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD2_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD2_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD2_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD2_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD2 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD2 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD2 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD2 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD2 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD2_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD2_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD2_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD2_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD2 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD2 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD2_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD2_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD2_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD2 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD3_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD3_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD3_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD3_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD3 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD3 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD3 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD3 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD3 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD3_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD3_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD3_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD3_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD3 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD3 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD3_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD3_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD3 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD4_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD4_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD4_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD4_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD4 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD4 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD4 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD4 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD4 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD4_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD4_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD4_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD4_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD4 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD4 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD4_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD4_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD4_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD4 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP0_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP0_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP0_SH 14
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_UL_CQI_RPT_TRI_BFRP0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP0_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_V1_FIX_GAIN_EN_BFRP0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP0_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP1_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP1_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP1_SH 14
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_UL_CQI_RPT_TRI_BFRP1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP1_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_V1_FIX_GAIN_EN_BFRP1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP1_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_TYPE_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_INDEX_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_PERIOD_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_PERIOD_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_UPDCNT_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_UPDCNT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_CR_IDX_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_CR_IDX_MSK 0x3fffff
#define FWCMD_H2C_SET_SND_PARA_V1_SOUNDING_EN BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_FREXCH_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_FREXCH_TYPE_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_MODE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V2_MODE_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_USER_NUM_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_USER_NUM_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_USER_NUM_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_USER_NUM_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_RETRY_NUM_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_RETRY_NUM_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_BAND BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_PROTECTION_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_PROTECTION_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_MACID0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID5_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID5_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID6_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID6_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID7_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID7_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID8_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID8_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID9_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID9_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID10_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID10_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID11_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID11_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID12_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID13_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID13_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID14_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_MACID14_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_MACID15_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_MACID15_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_FRAME_CTRL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_FRAME_CTRL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_SND_DLG_RANGING BIT(0)
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_SND_DLG_HE BIT(1)
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_SND_DLG_DIALOG_SH 2
#define FWCMD_H2C_SET_SND_PARA_V2_NDPA_SND_DLG_DIALOG_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HT_NDPA_A3_L_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HT_NDPA_A3_L_MSK 0xffffff
#define FWCMD_H2C_SET_SND_PARA_V2_HT_NDPA_A3_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HT_NDPA_A3_H_MSK 0xffffff
#define FWCMD_H2C_SET_SND_PARA_V2_HT_SEQ_CONTROL_L_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_HT_SEQ_CONTROL_L_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HT_SEQ_CONTROL_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HT_SEQ_CONTROL_H_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HTC_L_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HTC_L_MSK 0xffffff
#define FWCMD_H2C_SET_SND_PARA_V2_HTC_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HTC_H_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HT_OUI1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HT_OUI1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HT_OUI2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_HT_OUI2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HT_OUI3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_HT_OUI3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA0_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA0_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA1_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA1_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA2_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA2_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA3_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA3_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA4_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA5_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA6_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA7_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA8_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA9_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA10_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA11_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA12_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA13_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA14_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V2_HE_STA15_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA0_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA1_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA2_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA3_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA4_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA5_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA6_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA7_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA8_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA9_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA10_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA11_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA12_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA13_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA14_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_BW_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_NC_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_NC_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_STA15_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP0_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP1_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_BFRP2_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP0_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_HE_BFRP1_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_BFRP0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_BFRP0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_BFRP1_FEEDBACKSEG_REXMIT_BITMAP_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_BFRP1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_BFRP2_FEEDBACKSEG_REXMIT_BITMAP_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_VHT_BFRP2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_HE_EHT_P160 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_SPECIAL_PRESENT BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_SPATIAL_REUSE2_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_UL_SPATIAL_REUSE2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_USIG_DISRGRD_AND_VLD_SH 20
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_USIG_DISRGRD_AND_VLD_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_PHY_VER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_PHY_VER_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_ULBW_EXT_SH 3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_ULBW_EXT_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U0_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U1_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U2_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U3_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U4_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U5_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U6_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP0_U7_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_HE_EHT_P160 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_SPECIAL_PRESENT BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_SPATIAL_REUSE2_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_UL_SPATIAL_REUSE2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_USIG_DISRGRD_AND_VLD_SH 20
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_USIG_DISRGRD_AND_VLD_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_PHY_VER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_PHY_VER_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_ULBW_EXT_SH 3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_ULBW_EXT_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U0_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U1_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U2_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U3_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U4_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U5_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U6_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_EHT_BFRP1_U7_PS160 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD0_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD0_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD0_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD0_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD0_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_STF_MODE_WD0 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DISDATAFB_WD0 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_SEL_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD0_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIFS_TX_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD0_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD0_SH 27
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_CQI_SND_WD0 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_LDPC_WD0 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD0_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_FORCE_TXOP_WD0 BIT(21)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD0_SH 22
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD0_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_ER_WD0 BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_DCM_WD0 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_STBC_WD0 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_ER_WD0 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD1_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD1_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD1_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD1_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_STF_MODE_WD1 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DISDATAFB_WD1 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_SEL_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD1_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIFS_TX_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD1_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD1_SH 27
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_CQI_SND_WD1 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_LDPC_WD1 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD1_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_FORCE_TXOP_WD1 BIT(21)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD1_SH 22
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD1_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_ER_WD1 BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_DCM_WD1 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_STBC_WD1 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_ER_WD1 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD2_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD2_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD2_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD2_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD2_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_STF_MODE_WD2 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DISDATAFB_WD2 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_SEL_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD2_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIFS_TX_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD2_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD2_SH 27
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_CQI_SND_WD2 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_LDPC_WD2 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD2_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_FORCE_TXOP_WD2 BIT(21)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD2_SH 22
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD2_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_ER_WD2 BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_DCM_WD2 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_STBC_WD2 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_ER_WD2 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD3_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD3_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD3_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD3_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD3_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_STF_MODE_WD3 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DISDATAFB_WD3 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_SEL_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD3_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIFS_TX_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD3_SH 27
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_CQI_SND_WD3 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_LDPC_WD3 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD3_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_FORCE_TXOP_WD3 BIT(21)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD3_SH 22
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD3_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_ER_WD3 BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_DCM_WD3 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_STBC_WD3 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_ER_WD3 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPKTSIZE_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_DURATION_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MACID_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATARATE_WD4_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD4_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MBSSID_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIGNALING_TA_PKT_SC_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD4_SH 4
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SW_DEFINE_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD4_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_WD_TXPWR_OFSET_TYPE_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD4_SH 11
#define FWCMD_H2C_SET_SND_PARA_V2_WD_LIFETIME_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_STF_MODE_WD4 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DISDATAFB_WD4 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_SEL_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_TXCNT_LMT_WD4_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SIFS_TX_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD4_SH 24
#define FWCMD_H2C_SET_SND_PARA_V2_WD_SND_PKT_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD4_SH 27
#define FWCMD_H2C_SET_SND_PARA_V2_WD_NDPA_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_CQI_SND_WD4 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_LDPC_WD4 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_PATTERN_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_WD_PUNC_MODE_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD4_SH 18
#define FWCMD_H2C_SET_SND_PARA_V2_WD_GI_LTF_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_FORCE_TXOP_WD4 BIT(21)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD4_SH 22
#define FWCMD_H2C_SET_SND_PARA_V2_WD_MULTIPORT_ID_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD4_SH 25
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_ER_WD4 BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_DCM_WD4 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_STBC_WD4 BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V2_WD_DATA_BW_ER_WD4 BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V2_CSI_LEN_BFRP0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_CSI_LEN_BFRP0_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_TB_T_PE_BFRP0_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_TB_T_PE_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_TRI_PAD_BFRP0_SH 14
#define FWCMD_H2C_SET_SND_PARA_V2_TRI_PAD_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_UL_CQI_RPT_TRI_BFRP0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_RF_GAIN_IDX_BFRP0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_RF_GAIN_IDX_BFRP0_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_V2_FIX_GAIN_EN_BFRP0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_UL_LEN_REF_BFRP0_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_UL_LEN_REF_BFRP0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_UL_ELNA_IDX_BFRP0 BIT(0)
#define FWCMD_H2C_SET_SND_PARA_V2_UL_PRI_EXP_RSSI_DBM_BFRP0_SH 1
#define FWCMD_H2C_SET_SND_PARA_V2_UL_PRI_EXP_RSSI_DBM_BFRP0_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_UL_CSI_RPT_TRI_BFRP0 BIT(8)
#define FWCMD_H2C_SET_SND_PARA_V2_UL_APEP_UNIT_BFRP0_SH 9
#define FWCMD_H2C_SET_SND_PARA_V2_UL_APEP_UNIT_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_UL_CSI_INT_EN_BFRP0 BIT(11)
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U5_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U5_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U6_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U6_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U7_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP0_U7_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_CSI_LEN_BFRP1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_CSI_LEN_BFRP1_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V2_TB_T_PE_BFRP1_SH 12
#define FWCMD_H2C_SET_SND_PARA_V2_TB_T_PE_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_TRI_PAD_BFRP1_SH 14
#define FWCMD_H2C_SET_SND_PARA_V2_TRI_PAD_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_UL_CQI_RPT_TRI_BFRP1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V2_RF_GAIN_IDX_BFRP1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V2_RF_GAIN_IDX_BFRP1_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_V2_FIX_GAIN_EN_BFRP1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V2_UL_LEN_REF_BFRP1_SH 28
#define FWCMD_H2C_SET_SND_PARA_V2_UL_LEN_REF_BFRP1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V2_UL_ELNA_IDX_BFRP1 BIT(0)
#define FWCMD_H2C_SET_SND_PARA_V2_UL_PRI_EXP_RSSI_DBM_BFRP1_SH 1
#define FWCMD_H2C_SET_SND_PARA_V2_UL_PRI_EXP_RSSI_DBM_BFRP1_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V2_UL_CSI_RPT_TRI_BFRP1 BIT(8)
#define FWCMD_H2C_SET_SND_PARA_V2_UL_APEP_UNIT_BFRP1_SH 9
#define FWCMD_H2C_SET_SND_PARA_V2_UL_APEP_UNIT_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V2_UL_CSI_INT_EN_BFRP1 BIT(11)
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U5_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U5_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U6_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U6_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U7_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_SND_BITMAP_BFRP1_U7_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_TYPE_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_INDEX_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_PERIOD_SH 16
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_PERIOD_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_UPDCNT_SH 0
#define FWCMD_H2C_SET_SND_PARA_V2_F2P_UPDCNT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V2_CR_IDX_SH 8
#define FWCMD_H2C_SET_SND_PARA_V2_CR_IDX_MSK 0x3fffff
#define FWCMD_H2C_BA_CAM_VALID BIT(0)
#define FWCMD_H2C_BA_CAM_INIT_REQ BIT(1)
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_SH 2
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_MSK 0x3
#define FWCMD_H2C_BA_CAM_TID_SH 4
#define FWCMD_H2C_BA_CAM_TID_MSK 0xf
#define FWCMD_H2C_BA_CAM_MACID_SH 8
#define FWCMD_H2C_BA_CAM_MACID_MSK 0xff
#define FWCMD_H2C_BA_CAM_BMAP_SIZE_SH 16
#define FWCMD_H2C_BA_CAM_BMAP_SIZE_MSK 0xf
#define FWCMD_H2C_BA_CAM_SSN_SH 20
#define FWCMD_H2C_BA_CAM_SSN_MSK 0xfff
#define FWCMD_H2C_BA_CAM_UID_VALUE_SH 0
#define FWCMD_H2C_BA_CAM_UID_VALUE_MSK 0xff
#define FWCMD_H2C_BA_CAM_STD_ENTRY_EN BIT(8)
#define FWCMD_H2C_BA_CAM_BAND_SEL BIT(9)
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_V1_SH 28
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_V1_MSK 0xf
#define FWCMD_H2C_BA_CAM_V1_VALID BIT(0)
#define FWCMD_H2C_BA_CAM_V1_INIT_REQ BIT(1)
#define FWCMD_H2C_BA_CAM_V1_TID_SH 4
#define FWCMD_H2C_BA_CAM_V1_TID_MSK 0xf
#define FWCMD_H2C_BA_CAM_V1_MACID_SH 8
#define FWCMD_H2C_BA_CAM_V1_MACID_MSK 0xff
#define FWCMD_H2C_BA_CAM_V1_BMAP_SIZE_SH 16
#define FWCMD_H2C_BA_CAM_V1_BMAP_SIZE_MSK 0xf
#define FWCMD_H2C_BA_CAM_V1_SSN_SH 20
#define FWCMD_H2C_BA_CAM_V1_SSN_MSK 0xfff
#define FWCMD_H2C_BA_CAM_V1_UID_VALUE_SH 0
#define FWCMD_H2C_BA_CAM_V1_UID_VALUE_MSK 0xff
#define FWCMD_H2C_BA_CAM_V1_STD_ENTRY_EN BIT(8)
#define FWCMD_H2C_BA_CAM_V1_BAND_SEL BIT(9)
#define FWCMD_H2C_BA_CAM_V1_MLD_EN BIT(10)
#define FWCMD_H2C_BA_CAM_V1_ENTRY_IDX_SH 24
#define FWCMD_H2C_BA_CAM_V1_ENTRY_IDX_MSK 0xff
#define FWCMD_H2C_BA_CAM_INIT_USERS_SH 0
#define FWCMD_H2C_BA_CAM_INIT_USERS_MSK 0xff
#define FWCMD_H2C_BA_CAM_INIT_OFFSET_SH 12
#define FWCMD_H2C_BA_CAM_INIT_OFFSET_MSK 0xff
#define FWCMD_H2C_BA_CAM_INIT_BAND_SEL BIT(24)
#define FWCMD_H2C_IE_CAM_BAND BIT(0)
#define FWCMD_H2C_IE_CAM_PORT_SH 1
#define FWCMD_H2C_IE_CAM_PORT_MSK 0x7
#define FWCMD_H2C_IE_CAM_CAM_EN BIT(4)
#define FWCMD_H2C_IE_CAM_HIT_FRWD_EN BIT(5)
#define FWCMD_H2C_IE_CAM_HIT_FRWD_SH 6
#define FWCMD_H2C_IE_CAM_HIT_FRWD_MSK 0x3
#define FWCMD_H2C_IE_CAM_MISS_FRWD_EN BIT(8)
#define FWCMD_H2C_IE_CAM_MISS_FRWD_SH 9
#define FWCMD_H2C_IE_CAM_MISS_FRWD_MSK 0x3
#define FWCMD_H2C_IE_CAM_UPD_NUM_SH 11
#define FWCMD_H2C_IE_CAM_UPD_NUM_MSK 0x1f
#define FWCMD_H2C_IE_CAM_RST BIT(16)
#define FWCMD_H2C_IE_CAM_IDX_SH 0
#define FWCMD_H2C_IE_CAM_IDX_MSK 0xff
#define FWCMD_H2C_IE_CAM_CAM_INFO0_SH 8
#define FWCMD_H2C_IE_CAM_CAM_INFO0_MSK 0xffffff
#define FWCMD_H2C_IE_CAM_CAM_INFO1_SH 0
#define FWCMD_H2C_IE_CAM_CAM_INFO1_MSK 0xffffffff
#define FWCMD_H2C_ADD_MCC_MACID_SH 0
#define FWCMD_H2C_ADD_MCC_MACID_MSK 0xff
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG0_SH 8
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG0_MSK 0xff
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG1_SH 16
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG1_MSK 0xff
#define FWCMD_H2C_ADD_MCC_PRIMARY_CH_SH 24
#define FWCMD_H2C_ADD_MCC_PRIMARY_CH_MSK 0xff
#define FWCMD_H2C_ADD_MCC_BANDWIDTH_SH 0
#define FWCMD_H2C_ADD_MCC_BANDWIDTH_MSK 0xf
#define FWCMD_H2C_ADD_MCC_GROUP_SH 4
#define FWCMD_H2C_ADD_MCC_GROUP_MSK 0x3
#define FWCMD_H2C_ADD_MCC_C2H_RPT_SH 6
#define FWCMD_H2C_ADD_MCC_C2H_RPT_MSK 0x3
#define FWCMD_H2C_ADD_MCC_DIS_TX_NULL BIT(8)
#define FWCMD_H2C_ADD_MCC_DIS_SW_RETRY BIT(9)
#define FWCMD_H2C_ADD_MCC_IN_CURR_CH BIT(10)
#define FWCMD_H2C_ADD_MCC_SW_RETRY_COUNT_SH 11
#define FWCMD_H2C_ADD_MCC_SW_RETRY_COUNT_MSK 0x7
#define FWCMD_H2C_ADD_MCC_TX_NULL_EARLY_SH 14
#define FWCMD_H2C_ADD_MCC_TX_NULL_EARLY_MSK 0xf
#define FWCMD_H2C_ADD_MCC_BTC_IN_2G BIT(18)
#define FWCMD_H2C_ADD_MCC_PTA_EN BIT(19)
#define FWCMD_H2C_ADD_MCC_RFK_BY_PASS BIT(20)
#define FWCMD_H2C_ADD_MCC_CH_BAND_TYPE_SH 21
#define FWCMD_H2C_ADD_MCC_CH_BAND_TYPE_MSK 0x3
#define FWCMD_H2C_ADD_MCC_DURATION_SH 0
#define FWCMD_H2C_ADD_MCC_DURATION_MSK 0xffffffff
#define FWCMD_H2C_ADD_MCC_COURTESY_EN BIT(0)
#define FWCMD_H2C_ADD_MCC_COURTESY_NUM_SH 8
#define FWCMD_H2C_ADD_MCC_COURTESY_NUM_MSK 0xff
#define FWCMD_H2C_ADD_MCC_COURTESY_TARGET_SH 16
#define FWCMD_H2C_ADD_MCC_COURTESY_TARGET_MSK 0xff
#define FWCMD_H2C_START_MCC_GROUP_SH 0
#define FWCMD_H2C_START_MCC_GROUP_MSK 0x3
#define FWCMD_H2C_START_MCC_BTC_IN_GROUP BIT(2)
#define FWCMD_H2C_START_MCC_OLD_GROUP_ACTION_SH 3
#define FWCMD_H2C_START_MCC_OLD_GROUP_ACTION_MSK 0x3
#define FWCMD_H2C_START_MCC_OLD_GROUP_SH 5
#define FWCMD_H2C_START_MCC_OLD_GROUP_MSK 0x3
#define FWCMD_H2C_START_MCC_START_TSF_OPT BIT(7)
#define FWCMD_H2C_START_MCC_NOTIFY_CNT_SH 16
#define FWCMD_H2C_START_MCC_NOTIFY_CNT_MSK 0x7
#define FWCMD_H2C_START_MCC_NOTIFY_RXDBG_EN BIT(21)
#define FWCMD_H2C_START_MCC_MACID_SH 24
#define FWCMD_H2C_START_MCC_MACID_MSK 0xff
#define FWCMD_H2C_START_MCC_TSF_LOW_SH 0
#define FWCMD_H2C_START_MCC_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_START_MCC_TSF_HIGH_SH 0
#define FWCMD_H2C_START_MCC_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_STOP_MCC_MACID_SH 0
#define FWCMD_H2C_STOP_MCC_MACID_MSK 0xff
#define FWCMD_H2C_STOP_MCC_GROUP_SH 8
#define FWCMD_H2C_STOP_MCC_GROUP_MSK 0x3
#define FWCMD_H2C_STOP_MCC_PREV_GROUPS BIT(10)
#define FWCMD_H2C_DEL_MCC_GROUP_GROUP_SH 0
#define FWCMD_H2C_DEL_MCC_GROUP_GROUP_MSK 0x3
#define FWCMD_H2C_DEL_MCC_GROUP_PREV_GROUPS BIT(2)
#define FWCMD_H2C_RESET_MCC_GROUP_GROUP_SH 0
#define FWCMD_H2C_RESET_MCC_GROUP_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_REQ_TSF_GROUP_SH 0
#define FWCMD_H2C_MCC_REQ_TSF_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_REQ_TSF_MACID_X_SH 8
#define FWCMD_H2C_MCC_REQ_TSF_MACID_X_MSK 0xff
#define FWCMD_H2C_MCC_REQ_TSF_MACID_Y_SH 16
#define FWCMD_H2C_MCC_REQ_TSF_MACID_Y_MSK 0xff
#define FWCMD_H2C_MCC_MACID_BITMAP_GROUP_SH 0
#define FWCMD_H2C_MCC_MACID_BITMAP_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_MACID_BITMAP_MACID_SH 8
#define FWCMD_H2C_MCC_MACID_BITMAP_MACID_MSK 0xff
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_LENGTH_SH 16
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_LENGTH_MSK 0xff
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_SH 0
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_MSK 0xffffffff
#define FWCMD_H2C_MCC_SYNC_GROUP_SH 0
#define FWCMD_H2C_MCC_SYNC_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_SYNC_MACID_SOURCE_SH 8
#define FWCMD_H2C_MCC_SYNC_MACID_SOURCE_MSK 0xff
#define FWCMD_H2C_MCC_SYNC_MACID_TARGET_SH 16
#define FWCMD_H2C_MCC_SYNC_MACID_TARGET_MSK 0xff
#define FWCMD_H2C_MCC_SYNC_SYNC_OFFSET_SH 24
#define FWCMD_H2C_MCC_SYNC_SYNC_OFFSET_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_GROUP_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_SET_DURATION_BTC_IN_GROUP BIT(2)
#define FWCMD_H2C_MCC_SET_DURATION_START_MACID_SH 8
#define FWCMD_H2C_MCC_SET_DURATION_START_MACID_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_MACID_X_SH 16
#define FWCMD_H2C_MCC_SET_DURATION_MACID_X_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_MACID_Y_SH 24
#define FWCMD_H2C_MCC_SET_DURATION_MACID_Y_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_LOW_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_HIGH_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_X_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_X_MSK 0xffffffff
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_Y_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_Y_MSK 0xffffffff
#define FWCMD_H2C_MCC_DBG_NOTIFY_NOTIFY_RXDBG_EN BIT(0)
#define FWCMD_H2C_MCC_DBG_NOTIFY_NOTIFY_CNT_SH 8
#define FWCMD_H2C_MCC_DBG_NOTIFY_NOTIFY_CNT_MSK 0x7
#define FWCMD_H2C_PLAT_FLASH_WRITE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FLASH_WRITE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_WRITE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FLASH_WRITE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_WRITE_PAYLOAD0_SH 0
#define FWCMD_H2C_PLAT_FLASH_WRITE_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_ERASE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FLASH_ERASE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_ERASE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FLASH_ERASE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_READ_ADDR_SH 0
#define FWCMD_H2C_PLAT_FLASH_READ_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_READ_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FLASH_READ_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_FCS_AP_PORT_ID_SH 0
#define FWCMD_H2C_FCS_AP_PORT_ID_MSK 0xf
#define FWCMD_H2C_FCS_CH_IDX_SH 4
#define FWCMD_H2C_FCS_CH_IDX_MSK 0xf
#define FWCMD_H2C_FCS_THERMAL_IDX_SH 8
#define FWCMD_H2C_FCS_THERMAL_IDX_MSK 0xf
#define FWCMD_H2C_FCS_PAUSE_REL_MODE_SH 12
#define FWCMD_H2C_FCS_PAUSE_REL_MODE_MSK 0xf
#define FWCMD_H2C_FCS_CON_STA_NUM_SH 16
#define FWCMD_H2C_FCS_CON_STA_NUM_MSK 0xff
#define FWCMD_H2C_FCS_BAND BIT(24)
#define FWCMD_H2C_FCS_BANDWIDTH_SH 25
#define FWCMD_H2C_FCS_BANDWIDTH_MSK 0x3
#define FWCMD_H2C_FCS_CH_BAND_SH 27
#define FWCMD_H2C_FCS_CH_BAND_MSK 0x3
#define FWCMD_H2C_FCS_PRI_CH_SH 0
#define FWCMD_H2C_FCS_PRI_CH_MSK 0xff
#define FWCMD_H2C_FCS_CENTRAL_CH_SH 8
#define FWCMD_H2C_FCS_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_FCS_CSA_RETRY_SH 16
#define FWCMD_H2C_FCS_CSA_RETRY_MSK 0xf
#define FWCMD_H2C_FCS_REL_PAUSE_TSFL_SH 0
#define FWCMD_H2C_FCS_REL_PAUSE_TSFL_MSK 0xffffffff
#define FWCMD_H2C_FCS_REL_PAUSE_TSFH_SH 0
#define FWCMD_H2C_FCS_REL_PAUSE_TSFH_MSK 0xffffffff
#define FWCMD_H2C_FCS_REL_PAUSE_DELAY_TIME_SH 0
#define FWCMD_H2C_FCS_REL_PAUSE_DELAY_TIME_MSK 0xffffffff
#define FWCMD_H2C_FCS_CSA_PKT_ID0_SH 0
#define FWCMD_H2C_FCS_CSA_PKT_ID0_MSK 0xff
#define FWCMD_H2C_FCS_CSA_PKT_ID1_SH 8
#define FWCMD_H2C_FCS_CSA_PKT_ID1_MSK 0xff
#define FWCMD_H2C_FCS_CSA_PKT_ID2_SH 16
#define FWCMD_H2C_FCS_CSA_PKT_ID2_MSK 0xff
#define FWCMD_H2C_FCS_CSA_PKT_ID3_SH 24
#define FWCMD_H2C_FCS_CSA_PKT_ID3_MSK 0xff
#define FWCMD_H2C_CFG_WPS_EN BIT(0)
#define FWCMD_H2C_CFG_WPS_GPIO_SH 8
#define FWCMD_H2C_CFG_WPS_GPIO_MSK 0xff
#define FWCMD_H2C_CFG_WPS_INTL_SH 16
#define FWCMD_H2C_CFG_WPS_INTL_MSK 0xff
#define FWCMD_H2C_PUNC_UPD_REF_SEL_SH 0
#define FWCMD_H2C_PUNC_UPD_REF_SEL_MSK 0xf
#define FWCMD_H2C_PUNC_UPD_BW_SH 4
#define FWCMD_H2C_PUNC_UPD_BW_MSK 0xf
#define FWCMD_H2C_PUNC_UPD_BAND BIT(8)
#define FWCMD_H2C_PUNC_UPD_OP BIT(9)
#define FWCMD_H2C_PUNC_UPD_BITMAP_SH 16
#define FWCMD_H2C_PUNC_UPD_BITMAP_MSK 0xffff
#define FWCMD_H2C_PORT_INIT_BAND BIT(0)
#define FWCMD_H2C_PORT_INIT_PORT_SH 1
#define FWCMD_H2C_PORT_INIT_PORT_MSK 0x7
#define FWCMD_H2C_PORT_INIT_NET_TYPE_SH 4
#define FWCMD_H2C_PORT_INIT_NET_TYPE_MSK 0x7
#define FWCMD_H2C_PORT_INIT_DTIM_PRD_SH 8
#define FWCMD_H2C_PORT_INIT_DTIM_PRD_MSK 0xff
#define FWCMD_H2C_PORT_INIT_MBSSID_NUM_SH 16
#define FWCMD_H2C_PORT_INIT_MBSSID_NUM_MSK 0xff
#define FWCMD_H2C_PORT_INIT_BSS_COLOR_SH 24
#define FWCMD_H2C_PORT_INIT_BSS_COLOR_MSK 0xff
#define FWCMD_H2C_PORT_INIT_BCN_ITVL_SH 0
#define FWCMD_H2C_PORT_INIT_BCN_ITVL_MSK 0xffff
#define FWCMD_H2C_PORT_INIT_HIQ_WND_SH 16
#define FWCMD_H2C_PORT_INIT_HIQ_WND_MSK 0xff
#define FWCMD_H2C_PORT_CFG_BAND BIT(0)
#define FWCMD_H2C_PORT_CFG_PORT_SH 1
#define FWCMD_H2C_PORT_CFG_PORT_MSK 0x7
#define FWCMD_H2C_PORT_CFG_MBSSID_IDX_SH 8
#define FWCMD_H2C_PORT_CFG_MBSSID_IDX_MSK 0xff
#define FWCMD_H2C_PORT_CFG_TYPE_SH 16
#define FWCMD_H2C_PORT_CFG_TYPE_MSK 0xff
#define FWCMD_H2C_PORT_CFG_VAL_SH 0
#define FWCMD_H2C_PORT_CFG_VAL_MSK 0xffffffff
#define FWCMD_H2C_MLOTBL_CFG_MACID_SH 0
#define FWCMD_H2C_MLOTBL_CFG_MACID_MSK 0xffff
#define FWCMD_H2C_MLOTBL_CFG_OPERATION BIT(16)
#define FWCMD_H2C_MLOTBL_CFG_GET_DEF_VAL BIT(17)
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B0_SH 0
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B0_SH 4
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B1_SH 8
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B1_SH 12
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B0_SH 16
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B0_SH 20
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B1_SH 24
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B1_SH 28
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B0_SH 0
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B0_SH 4
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B1_SH 8
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B1_SH 12
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B0_SH 16
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B0_SH 20
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B0_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B1_SH 24
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B1_SH 28
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B1_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_BA_LIMIT_SH 0
#define FWCMD_H2C_MLOTBL_CFG_BE_BA_LIMIT_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_BA_LIMIT_SH 4
#define FWCMD_H2C_MLOTBL_CFG_BK_BA_LIMIT_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_BA_LIMIT_SH 8
#define FWCMD_H2C_MLOTBL_CFG_VI_BA_LIMIT_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_BA_LIMIT_SH 12
#define FWCMD_H2C_MLOTBL_CFG_VO_BA_LIMIT_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_FIX_TO_B0 BIT(16)
#define FWCMD_H2C_MLOTBL_CFG_FIX_TO_B1 BIT(17)
#define FWCMD_H2C_MLOTBL_CFG_WAIT2C_EMPTY BIT(18)
#define FWCMD_H2C_MLOTBL_CFG_B0_CHK BIT(20)
#define FWCMD_H2C_MLOTBL_CFG_B1_CHK BIT(21)
#define FWCMD_H2C_MLOTBL_CFG_EXT0_CHK BIT(22)
#define FWCMD_H2C_MLOTBL_CFG_EXT1_CHK BIT(23)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_BE BIT(24)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_BK BIT(25)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_VI BIT(26)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_VO BIT(27)
#define FWCMD_H2C_MLOTBL_CFG_PRI_BAND BIT(28)
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B0_MASK_SH 0
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B0_MASK_SH 4
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B1_MASK_SH 8
#define FWCMD_H2C_MLOTBL_CFG_BE_MIN_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B1_MASK_SH 12
#define FWCMD_H2C_MLOTBL_CFG_BE_MAX_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B0_MASK_SH 16
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B0_MASK_SH 20
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B1_MASK_SH 24
#define FWCMD_H2C_MLOTBL_CFG_BK_MIN_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B1_MASK_SH 28
#define FWCMD_H2C_MLOTBL_CFG_BK_MAX_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B0_MASK_SH 0
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B0_MASK_SH 4
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B1_MASK_SH 8
#define FWCMD_H2C_MLOTBL_CFG_VI_MIN_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B1_MASK_SH 12
#define FWCMD_H2C_MLOTBL_CFG_VI_MAX_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B0_MASK_SH 16
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B0_MASK_SH 20
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B0_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B1_MASK_SH 24
#define FWCMD_H2C_MLOTBL_CFG_VO_MIN_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B1_MASK_SH 28
#define FWCMD_H2C_MLOTBL_CFG_VO_MAX_B1_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BE_BA_LIMIT_MASK_SH 0
#define FWCMD_H2C_MLOTBL_CFG_BE_BA_LIMIT_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_BK_BA_LIMIT_MASK_SH 4
#define FWCMD_H2C_MLOTBL_CFG_BK_BA_LIMIT_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VI_BA_LIMIT_MASK_SH 8
#define FWCMD_H2C_MLOTBL_CFG_VI_BA_LIMIT_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_VO_BA_LIMIT_MASK_SH 12
#define FWCMD_H2C_MLOTBL_CFG_VO_BA_LIMIT_MASK_MSK 0xf
#define FWCMD_H2C_MLOTBL_CFG_FIX_TO_B0_MASK BIT(16)
#define FWCMD_H2C_MLOTBL_CFG_FIX_TO_B1_MASK BIT(17)
#define FWCMD_H2C_MLOTBL_CFG_WAIT2C_EMPTY_MASK BIT(18)
#define FWCMD_H2C_MLOTBL_CFG_B0_CHK_MASK BIT(20)
#define FWCMD_H2C_MLOTBL_CFG_B1_CHK_MASK BIT(21)
#define FWCMD_H2C_MLOTBL_CFG_EXT0_CHK_MASK BIT(22)
#define FWCMD_H2C_MLOTBL_CFG_EXT1_CHK_MASK BIT(23)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_BE_MASK BIT(24)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_BK_MASK BIT(25)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_VI_MASK BIT(26)
#define FWCMD_H2C_MLOTBL_CFG_WD_DROP_VO_MASK BIT(27)
#define FWCMD_H2C_MLOTBL_CFG_PRI_BAND_MASK BIT(28)
#define FWCMD_H2C_MLO_STAFUNC_CFG_MACID_SH 0
#define FWCMD_H2C_MLO_STAFUNC_CFG_MACID_MSK 0xff
#define FWCMD_H2C_MLO_STAFUNC_CFG_CFG_EMLSR BIT(8)
#define FWCMD_H2C_MLO_STAFUNC_CFG_EMLSR_EN BIT(9)
#define FWCMD_H2C_MLO_STAFUNC_CFG_MACID_EXT_SH 10
#define FWCMD_H2C_MLO_STAFUNC_CFG_MACID_EXT_MSK 0xff
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_MACID_NUM_SH 0
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_MACID_NUM_MSK 0xffff
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_MACID_X_SH 0
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_MACID_X_MSK 0xffff
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_TID_TO_LINK_MAP_X_SH 16
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_TID_TO_LINK_MAP_X_MSK 0xff
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_MACID_Y_SH 0
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_MACID_Y_MSK 0xffff
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_TID_TO_LINK_MAP_Y_SH 16
#define FWCMD_H2C_MLO_TID_TO_LINK_MAP_TID_TO_LINK_MAP_Y_MSK 0xff
#define FWCMD_H2C_MLO_DM_CFG_ENABLE BIT(0)
#define FWCMD_H2C_MLO_DM_CFG_RELINK_SH 1
#define FWCMD_H2C_MLO_DM_CFG_RELINK_MSK 0x3
#define FWCMD_H2C_MLO_DM_CFG_INTERVAL_SH 3
#define FWCMD_H2C_MLO_DM_CFG_INTERVAL_MSK 0x1f
#define FWCMD_H2C_MLO_DM_CFG_STATUS BIT(8)
#define FWCMD_H2C_MLO_DM_CFG_ENABLE_MASK BIT(0)
#define FWCMD_H2C_MLO_DM_CFG_RELINK_MASK_SH 1
#define FWCMD_H2C_MLO_DM_CFG_RELINK_MASK_MSK 0x3
#define FWCMD_H2C_MLO_DM_CFG_INTERVAL_MASK_SH 3
#define FWCMD_H2C_MLO_DM_CFG_INTERVAL_MASK_MSK 0x1f
#define FWCMD_H2C_MLO_DM_CFG_STATUS_MASK BIT(8)
#define FWCMD_H2C_EMLSR_STA_CFG_MACID_SH 0
#define FWCMD_H2C_EMLSR_STA_CFG_MACID_MSK 0xffff
#define FWCMD_H2C_EMLSR_STA_CFG_ENABLE BIT(16)
#define FWCMD_H2C_EMLSR_STA_CFG_PAUSE_SH 17
#define FWCMD_H2C_EMLSR_STA_CFG_PAUSE_MSK 0x3
#define FWCMD_H2C_EMLSR_STA_CFG_NO_ACT BIT(19)
#define FWCMD_H2C_EMLSR_STA_CFG_PKTID_SH 20
#define FWCMD_H2C_EMLSR_STA_CFG_PKTID_MSK 0xfff
#define FWCMD_H2C_EMLSR_STA_CFG_TIMEOUT_SH 0
#define FWCMD_H2C_EMLSR_STA_CFG_TIMEOUT_MSK 0xf
#define FWCMD_H2C_EMLSR_STA_CFG_CTRL_SH 16
#define FWCMD_H2C_EMLSR_STA_CFG_CTRL_MSK 0xf
#define FWCMD_H2C_EMLSR_STA_CFG_SEC_TYPE_SH 20
#define FWCMD_H2C_EMLSR_STA_CFG_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_EMLSR_STA_CFG_HW_SEC_IV BIT(24)
#define FWCMD_H2C_EMLSR_STA_CFG_SEC_IV_L_SH 16
#define FWCMD_H2C_EMLSR_STA_CFG_SEC_IV_L_MSK 0xffff
#define FWCMD_H2C_EMLSR_STA_CFG_SEC_IV_H_SH 0
#define FWCMD_H2C_EMLSR_STA_CFG_SEC_IV_H_MSK 0xffffffff
#define FWCMD_H2C_MCMLO_RELINK_DROP_MACID_SH 0
#define FWCMD_H2C_MCMLO_RELINK_DROP_MACID_MSK 0xffff
#define FWCMD_H2C_MCMLO_RELINK_DROP_AC_BMP_SH 16
#define FWCMD_H2C_MCMLO_RELINK_DROP_AC_BMP_MSK 0xf
#define FWCMD_H2C_MCMLO_RELINK_DROP_BAND BIT(20)
#define FWCMD_H2C_MCMLO_RELINK_DROP_OP BIT(21)
#define FWCMD_H2C_MCMLO_SN_SYNC_OP_SH 0
#define FWCMD_H2C_MCMLO_SN_SYNC_OP_MSK 0x3
#define FWCMD_H2C_MCMLO_SN_SYNC_SRC_LINK_IDX_SH 2
#define FWCMD_H2C_MCMLO_SN_SYNC_SRC_LINK_IDX_MSK 0x3
#define FWCMD_H2C_MCMLO_SN_SYNC_MACID_START_SH 0
#define FWCMD_H2C_MCMLO_SN_SYNC_MACID_START_MSK 0xffff
#define FWCMD_H2C_MCMLO_SN_SYNC_MACID_NUM_SH 16
#define FWCMD_H2C_MCMLO_SN_SYNC_MACID_NUM_MSK 0xffff
#define FWCMD_H2C_MLO_RELINK_MACID_SH 0
#define FWCMD_H2C_MLO_RELINK_MACID_MSK 0xffff
#define FWCMD_H2C_MLO_RELINK_AC_BMP_SH 16
#define FWCMD_H2C_MLO_RELINK_AC_BMP_MSK 0xf
#define FWCMD_H2C_MLO_RELINK_BAND BIT(20)
#define FWCMD_H2C_MLO_LINK_CFG_MACID_SH 0
#define FWCMD_H2C_MLO_LINK_CFG_MACID_MSK 0xffff
#define FWCMD_H2C_MLO_LINK_CFG_OPTION_SH 16
#define FWCMD_H2C_MLO_LINK_CFG_OPTION_MSK 0xf
#define FWCMD_H2C_MLO_LINK_CFG_REPLACE_EN BIT(20)
#define FWCMD_H2C_MLO_LINK_CFG_NULL_TIMEOUT_MS_SH 24
#define FWCMD_H2C_MLO_LINK_CFG_NULL_TIMEOUT_MS_MSK 0xff
#define FWCMD_H2C_MLO_LINK_CFG_SRC_MACID_SH 0
#define FWCMD_H2C_MLO_LINK_CFG_SRC_MACID_MSK 0xffff
#define FWCMD_H2C_MLO_DM_DBG_MAIN_MACID_SH 0
#define FWCMD_H2C_MLO_DM_DBG_MAIN_MACID_MSK 0xffff
#define FWCMD_H2C_MLO_DM_DBG_MLO_DM_DBG_ID_SH 16
#define FWCMD_H2C_MLO_DM_DBG_MLO_DM_DBG_ID_MSK 0xf
#define FWCMD_H2C_MLO_DM_DBG_ACTION_SH 20
#define FWCMD_H2C_MLO_DM_DBG_ACTION_MSK 0xf
#define FWCMD_H2C_MCMLO_TABLE_ACC_MACID_SH 0
#define FWCMD_H2C_MCMLO_TABLE_ACC_MACID_MSK 0x3ff
#define FWCMD_H2C_MCMLO_TABLE_ACC_AC_SH 16
#define FWCMD_H2C_MCMLO_TABLE_ACC_AC_MSK 0x3
#define FWCMD_H2C_MCMLO_TABLE_ACC_WRITE BIT(20)
#define FWCMD_H2C_MCMLO_TABLE_ACC_WRITE_STROBE_SH 24
#define FWCMD_H2C_MCMLO_TABLE_ACC_WRITE_STROBE_MSK 0xf
#define FWCMD_H2C_MCMLO_TABLE_ACC_TBL_SEL_SH 28
#define FWCMD_H2C_MCMLO_TABLE_ACC_TBL_SEL_MSK 0x7
#define FWCMD_H2C_MCMLO_TABLE_ACC_WRITE_DATA_SH 0
#define FWCMD_H2C_MCMLO_TABLE_ACC_WRITE_DATA_MSK 0xffffffff
#define FWCMD_H2C_MCMLO_OPEN_QSTS_MACID_SH 0
#define FWCMD_H2C_MCMLO_OPEN_QSTS_MACID_MSK 0xffff
#define FWCMD_H2C_MCMLO_OPEN_QSTS_AC_SH 16
#define FWCMD_H2C_MCMLO_OPEN_QSTS_AC_MSK 0x3
#define FWCMD_H2C_MCMLO_INIT_OP BIT(0)
#define FWCMD_H2C_PROXY_PROXY_EN BIT(0)
#define FWCMD_H2C_PROXY_ARP_RSP BIT(1)
#define FWCMD_H2C_PROXY_NS_RSP BIT(2)
#define FWCMD_H2C_PROXY_ICMP_V4_RSP BIT(3)
#define FWCMD_H2C_PROXY_ICMP_V6_RSP BIT(4)
#define FWCMD_H2C_PROXY_NETBIOS_RSP BIT(5)
#define FWCMD_H2C_PROXY_LLMNR_V4_RSP BIT(6)
#define FWCMD_H2C_PROXY_LLMNR_V6_RSP BIT(7)
#define FWCMD_H2C_PROXY_SNMP_V4_RSP BIT(8)
#define FWCMD_H2C_PROXY_SNMP_V6_RSP BIT(9)
#define FWCMD_H2C_PROXY_SNMP_V4_WAKE BIT(10)
#define FWCMD_H2C_PROXY_SNMP_V6_WAKE BIT(11)
#define FWCMD_H2C_PROXY_SSDP_V4_WAKE BIT(12)
#define FWCMD_H2C_PROXY_SSDP_V6_WAKE BIT(13)
#define FWCMD_H2C_PROXY_WSD_V4_WAKE BIT(14)
#define FWCMD_H2C_PROXY_WSD_V6_WAKE BIT(15)
#define FWCMD_H2C_PROXY_SLP_V4_WAKE BIT(16)
#define FWCMD_H2C_PROXY_SLP_V6_WAKE BIT(17)
#define FWCMD_H2C_PROXY_MDNS_V4_RSP BIT(18)
#define FWCMD_H2C_PROXY_MDNS_V6_RSP BIT(19)
#define FWCMD_H2C_PROXY_TARGET_MAC_WAKE BIT(20)
#define FWCMD_H2C_PROXY_LLTD_WAKE BIT(21)
#define FWCMD_H2C_PROXY_MDNS_V4_WAKE BIT(22)
#define FWCMD_H2C_PROXY_MDNS_V6_WAKE BIT(23)
#define FWCMD_H2C_PROXY_V4ADD0_SH 0
#define FWCMD_H2C_PROXY_V4ADD0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V4ADD1_SH 0
#define FWCMD_H2C_PROXY_V4ADD1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V4ADD2_SH 0
#define FWCMD_H2C_PROXY_V4ADD2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V4ADD3_SH 0
#define FWCMD_H2C_PROXY_V4ADD3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD0_0_SH 0
#define FWCMD_H2C_PROXY_V6ADD0_0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD0_1_SH 0
#define FWCMD_H2C_PROXY_V6ADD0_1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD0_2_SH 0
#define FWCMD_H2C_PROXY_V6ADD0_2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD0_3_SH 0
#define FWCMD_H2C_PROXY_V6ADD0_3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD1_0_SH 0
#define FWCMD_H2C_PROXY_V6ADD1_0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD1_1_SH 0
#define FWCMD_H2C_PROXY_V6ADD1_1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD1_2_SH 0
#define FWCMD_H2C_PROXY_V6ADD1_2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD1_3_SH 0
#define FWCMD_H2C_PROXY_V6ADD1_3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD2_0_SH 0
#define FWCMD_H2C_PROXY_V6ADD2_0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD2_1_SH 0
#define FWCMD_H2C_PROXY_V6ADD2_1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD2_2_SH 0
#define FWCMD_H2C_PROXY_V6ADD2_2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD2_3_SH 0
#define FWCMD_H2C_PROXY_V6ADD2_3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD3_0_SH 0
#define FWCMD_H2C_PROXY_V6ADD3_0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD3_1_SH 0
#define FWCMD_H2C_PROXY_V6ADD3_1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD3_2_SH 0
#define FWCMD_H2C_PROXY_V6ADD3_2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_V6ADD3_3_SH 0
#define FWCMD_H2C_PROXY_V6ADD3_3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_HEADER_EN_SH 0
#define FWCMD_H2C_PROXY_HEADER_EN_MSK 0xff
#define FWCMD_H2C_PROXY_V4PKTID_SH 8
#define FWCMD_H2C_PROXY_V4PKTID_MSK 0xff
#define FWCMD_H2C_PROXY_V6PKTID_SH 16
#define FWCMD_H2C_PROXY_V6PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_V4PKTID_SH 0
#define FWCMD_H2C_MDNS_V4PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_V6PKTID_SH 8
#define FWCMD_H2C_MDNS_V6PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_NUMSUPPSERV_SH 16
#define FWCMD_H2C_MDNS_NUMSUPPSERV_MSK 0xff
#define FWCMD_H2C_MDNS_NUMMACHNAME_SH 24
#define FWCMD_H2C_MDNS_NUMMACHNAME_MSK 0xff
#define FWCMD_H2C_MDNS_MACID_SH 0
#define FWCMD_H2C_MDNS_MACID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV0PKTID_SH 8
#define FWCMD_H2C_MDNS_SERV0PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV1PKTID_SH 16
#define FWCMD_H2C_MDNS_SERV1PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV2PKTID_SH 24
#define FWCMD_H2C_MDNS_SERV2PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV3PKTID_SH 0
#define FWCMD_H2C_MDNS_SERV3PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV4PKTID_SH 8
#define FWCMD_H2C_MDNS_SERV4PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV5PKTID_SH 16
#define FWCMD_H2C_MDNS_SERV5PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV6PKTID_SH 24
#define FWCMD_H2C_MDNS_SERV6PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV7PKTID_SH 0
#define FWCMD_H2C_MDNS_SERV7PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV8PKTID_SH 8
#define FWCMD_H2C_MDNS_SERV8PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_SERV9PKTID_SH 16
#define FWCMD_H2C_MDNS_SERV9PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_MACID_EXT_SH 24
#define FWCMD_H2C_MDNS_MACID_EXT_MSK 0xff
#define FWCMD_H2C_MDNS_MACHINE0_LEN_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_LEN_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_0_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_0_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_1_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_1_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_2_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_2_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_3_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_3_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_4_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_4_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_5_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_5_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_6_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_6_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_7_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_7_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_8_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_8_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_9_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_9_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_10_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_10_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_11_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_11_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_12_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_12_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_13_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_13_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_14_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_14_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE0_15_SH 0
#define FWCMD_H2C_MDNS_MACHINE0_15_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_LEN_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_LEN_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_0_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_0_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_1_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_1_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_2_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_2_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_3_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_3_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_4_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_4_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_5_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_5_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_6_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_6_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_7_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_7_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_8_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_8_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_9_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_9_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_10_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_10_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_11_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_11_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_12_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_12_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_13_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_13_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_14_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_14_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE1_15_SH 0
#define FWCMD_H2C_MDNS_MACHINE1_15_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_LEN_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_LEN_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_0_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_0_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_1_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_1_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_2_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_2_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_3_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_3_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_4_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_4_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_5_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_5_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_6_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_6_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_7_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_7_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_8_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_8_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_9_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_9_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_10_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_10_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_11_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_11_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_12_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_12_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_13_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_13_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_14_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_14_MSK 0xffffffff
#define FWCMD_H2C_MDNS_MACHINE2_15_SH 0
#define FWCMD_H2C_MDNS_MACHINE2_15_MSK 0xffffffff
#define FWCMD_H2C_MDNS_A0_SH 0
#define FWCMD_H2C_MDNS_A0_MSK 0xffffffff
#define FWCMD_H2C_MDNS_A1_SH 0
#define FWCMD_H2C_MDNS_A1_MSK 0xffffffff
#define FWCMD_H2C_MDNS_A2_SH 0
#define FWCMD_H2C_MDNS_A2_MSK 0xffffffff
#define FWCMD_H2C_MDNS_A3_SH 0
#define FWCMD_H2C_MDNS_A3_MSK 0xffff
#define FWCMD_H2C_MDNS_AAAA0_SH 16
#define FWCMD_H2C_MDNS_AAAA0_MSK 0xffff
#define FWCMD_H2C_MDNS_AAAA1_SH 0
#define FWCMD_H2C_MDNS_AAAA1_MSK 0xffffffff
#define FWCMD_H2C_MDNS_AAAA2_SH 0
#define FWCMD_H2C_MDNS_AAAA2_MSK 0xffffffff
#define FWCMD_H2C_MDNS_AAAA3_SH 0
#define FWCMD_H2C_MDNS_AAAA3_MSK 0xffffffff
#define FWCMD_H2C_MDNS_AAAA4_SH 0
#define FWCMD_H2C_MDNS_AAAA4_MSK 0xffffffff
#define FWCMD_H2C_MDNS_AAAA5_SH 0
#define FWCMD_H2C_MDNS_AAAA5_MSK 0xffffffff
#define FWCMD_H2C_MDNS_AAAA7_SH 0
#define FWCMD_H2C_MDNS_AAAA7_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR0_SH 0
#define FWCMD_H2C_MDNS_PTR0_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR1_SH 0
#define FWCMD_H2C_MDNS_PTR1_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR2_SH 0
#define FWCMD_H2C_MDNS_PTR2_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR3_SH 0
#define FWCMD_H2C_MDNS_PTR3_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR4_SH 0
#define FWCMD_H2C_MDNS_PTR4_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR5_SH 0
#define FWCMD_H2C_MDNS_PTR5_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR6_SH 0
#define FWCMD_H2C_MDNS_PTR6_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR7_SH 0
#define FWCMD_H2C_MDNS_PTR7_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR8_SH 0
#define FWCMD_H2C_MDNS_PTR8_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR9_SH 0
#define FWCMD_H2C_MDNS_PTR9_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR10_SH 0
#define FWCMD_H2C_MDNS_PTR10_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR11_SH 0
#define FWCMD_H2C_MDNS_PTR11_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR12_SH 0
#define FWCMD_H2C_MDNS_PTR12_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR13_SH 0
#define FWCMD_H2C_MDNS_PTR13_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR14_SH 0
#define FWCMD_H2C_MDNS_PTR14_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR15_SH 0
#define FWCMD_H2C_MDNS_PTR15_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR16_SH 0
#define FWCMD_H2C_MDNS_PTR16_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR17_SH 0
#define FWCMD_H2C_MDNS_PTR17_MSK 0xffffffff
#define FWCMD_H2C_MDNS_PTR18_SH 0
#define FWCMD_H2C_MDNS_PTR18_MSK 0xffffffff
#define FWCMD_H2C_PTCL_PATTERN_MACID_SH 0
#define FWCMD_H2C_PTCL_PATTERN_MACID_MSK 0xff
#define FWCMD_H2C_PTCL_PATTERN_PTCL_SH 8
#define FWCMD_H2C_PTCL_PATTERN_PTCL_MSK 0x7
#define FWCMD_H2C_PTCL_PATTERN_NUM_PATTERN_SH 11
#define FWCMD_H2C_PTCL_PATTERN_NUM_PATTERN_MSK 0x7
#define FWCMD_H2C_PTCL_PATTERN_MACID_EXT_SH 14
#define FWCMD_H2C_PTCL_PATTERN_MACID_EXT_MSK 0xff
#define FWCMD_H2C_SNMP_IPV4_PKTID_SH 0
#define FWCMD_H2C_SNMP_IPV4_PKTID_MSK 0xff
#define FWCMD_H2C_SNMP_IPV6_PKTID_SH 8
#define FWCMD_H2C_SNMP_IPV6_PKTID_MSK 0xff
#define FWCMD_H2C_SNMP_COMMUNITY0_LEN_SH 16
#define FWCMD_H2C_SNMP_COMMUNITY0_LEN_MSK 0xff
#define FWCMD_H2C_SNMP_COMMUNITY1_LEN_SH 24
#define FWCMD_H2C_SNMP_COMMUNITY1_LEN_MSK 0xff
#define FWCMD_H2C_SNMP_COMMUNITY0_0_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY0_0_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY0_1_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY0_1_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY0_2_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY0_2_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY0_3_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY0_3_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY1_0_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY1_0_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY1_1_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY1_1_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY1_2_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY1_2_MSK 0xffffffff
#define FWCMD_H2C_SNMP_COMMUNITY1_3_SH 0
#define FWCMD_H2C_SNMP_COMMUNITY1_3_MSK 0xffffffff
#define FWCMD_H2C_SNMP_DEVICE_STATUS_SH 0
#define FWCMD_H2C_SNMP_DEVICE_STATUS_MSK 0xff
#define FWCMD_H2C_SNMP_PRINTER_STATUS_SH 8
#define FWCMD_H2C_SNMP_PRINTER_STATUS_MSK 0xff
#define FWCMD_H2C_SNMP_PRINTER_ERR_STATE_SH 16
#define FWCMD_H2C_SNMP_PRINTER_ERR_STATE_MSK 0xffff
#define FWCMD_H2C_SNMP_MACID_SH 0
#define FWCMD_H2C_SNMP_MACID_MSK 0xff
#define FWCMD_H2C_SNMP_SYS_DESCR_LEN_SH 8
#define FWCMD_H2C_SNMP_SYS_DESCR_LEN_MSK 0xff
#define FWCMD_H2C_SNMP_OBJ_ID_LEN_SH 16
#define FWCMD_H2C_SNMP_OBJ_ID_LEN_MSK 0xff
#define FWCMD_H2C_SNMP_NUM_ENTERPRISE_MIB_SH 24
#define FWCMD_H2C_SNMP_NUM_ENTERPRISE_MIB_MSK 0xff
#define FWCMD_H2C_SNMP_SYS_DESCR0_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR0_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR1_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR1_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR2_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR2_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR3_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR3_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR4_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR4_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR5_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR5_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR6_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR6_MSK 0xffffffff
#define FWCMD_H2C_SNMP_SYS_DESCR7_SH 0
#define FWCMD_H2C_SNMP_SYS_DESCR7_MSK 0xffffffff
#define FWCMD_H2C_SNMP_ENTERPRISE_ID_LEN_SH 0
#define FWCMD_H2C_SNMP_ENTERPRISE_ID_LEN_MSK 0xff
#define FWCMD_H2C_SNMP_ENTERPRISE_ID0_SH 8
#define FWCMD_H2C_SNMP_ENTERPRISE_ID0_MSK 0xffffff
#define FWCMD_H2C_SNMP_OBJ_ID0_SH 0
#define FWCMD_H2C_SNMP_OBJ_ID0_MSK 0xffffffff
#define FWCMD_H2C_SNMP_OBJ_ID1_SH 0
#define FWCMD_H2C_SNMP_OBJ_ID1_MSK 0xffffffff
#define FWCMD_H2C_SNMP_MACID_EXT_SH 0
#define FWCMD_H2C_SNMP_MACID_EXT_MSK 0xff
#define FWCMD_H2C_LLMNR_MACID_SH 0
#define FWCMD_H2C_LLMNR_MACID_MSK 0xffff
#define FWCMD_H2C_LLMNR_MACHINE0_LEN_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_LEN_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_0_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_0_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_1_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_1_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_2_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_2_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_3_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_3_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_4_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_4_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_5_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_5_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_6_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_6_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_7_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_7_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_8_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_8_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_9_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_9_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_10_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_10_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_11_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_11_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_12_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_12_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_13_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_13_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_14_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_14_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE0_15_SH 0
#define FWCMD_H2C_LLMNR_MACHINE0_15_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_LEN_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_LEN_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_0_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_0_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_1_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_1_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_2_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_2_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_3_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_3_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_4_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_4_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_5_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_5_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_6_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_6_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_7_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_7_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_8_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_8_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_9_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_9_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_10_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_10_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_11_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_11_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_12_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_12_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_13_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_13_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_14_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_14_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE1_15_SH 0
#define FWCMD_H2C_LLMNR_MACHINE1_15_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_LEN_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_LEN_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_0_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_0_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_1_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_1_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_2_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_2_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_3_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_3_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_4_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_4_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_5_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_5_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_6_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_6_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_7_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_7_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_8_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_8_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_9_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_9_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_10_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_10_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_11_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_11_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_12_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_12_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_13_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_13_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_14_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_14_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_MACHINE2_15_SH 0
#define FWCMD_H2C_LLMNR_MACHINE2_15_MSK 0xffffffff
#define FWCMD_H2C_LLMNR_V4PKTID_SH 0
#define FWCMD_H2C_LLMNR_V4PKTID_MSK 0xff
#define FWCMD_H2C_LLMNR_V6PKTID_SH 8
#define FWCMD_H2C_LLMNR_V6PKTID_MSK 0xff
#define FWCMD_H2C_LLMNR_NUM_MACHINE_NAMES_SH 16
#define FWCMD_H2C_LLMNR_NUM_MACHINE_NAMES_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_V4PKTID_SH 0
#define FWCMD_H2C_MDNS_OFLD_V4PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_V6PKTID_SH 8
#define FWCMD_H2C_MDNS_OFLD_V6PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_MDNS_PROTOCOL_DATA_PKTID_SH 16
#define FWCMD_H2C_MDNS_OFLD_MDNS_PROTOCOL_DATA_PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_LIST_PKTID_SH 24
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_LIST_PKTID_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_MDNS_OFFLOAD_EN_SH 0
#define FWCMD_H2C_MDNS_OFLD_MDNS_OFFLOAD_EN_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_OFFLOAD_STATE_SH 8
#define FWCMD_H2C_MDNS_OFLD_OFFLOAD_STATE_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_BEHAVIOR_SH 16
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_BEHAVIOR_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_MACID_SH 24
#define FWCMD_H2C_MDNS_OFLD_MACID_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_0_SH 0
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_0_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_1_SH 8
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_1_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_2_SH 16
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_2_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_3_SH 24
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_3_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_4_SH 0
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_4_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_5_SH 8
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_5_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_6_SH 16
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_6_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_7_SH 24
#define FWCMD_H2C_MDNS_OFLD_DATA_PKTID_7_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_0_SH 0
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_0_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_1_SH 8
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_1_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_2_SH 16
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_2_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_3_SH 24
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_3_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_4_SH 0
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_4_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_5_SH 8
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_5_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_6_SH 16
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_6_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_7_SH 24
#define FWCMD_H2C_MDNS_OFLD_PASSTHRU_NAME_PKTID_7_MSK 0xff
#define FWCMD_H2C_MDNS_OFLD_MACID_EXT_SH 0
#define FWCMD_H2C_MDNS_OFLD_MACID_EXT_MSK 0xffff
#define FWCMD_H2C_MDNS_OFLD_TYPE_SH 16
#define FWCMD_H2C_MDNS_OFLD_TYPE_MSK 0xff
#define FWCMD_H2C_APF_SET_MACID_SH 0
#define FWCMD_H2C_APF_SET_MACID_MSK 0xffff
#define FWCMD_H2C_APF_SET_MACPKTID_SH 0
#define FWCMD_H2C_APF_SET_MACPKTID_MSK 0xff
#define FWCMD_H2C_APF_SET_APF_EN_SH 0
#define FWCMD_H2C_APF_SET_APF_EN_MSK 0xff
#define FWCMD_H2C_APF_SET_PACKET_MASK_SH 16
#define FWCMD_H2C_APF_SET_PACKET_MASK_MSK 0xffff
#define FWCMD_H2C_APF_SET_VERSION1_SH 0
#define FWCMD_H2C_APF_SET_VERSION1_MSK 0xffffffff
#define FWCMD_H2C_APF_SET_VERSION2_SH 0
#define FWCMD_H2C_APF_SET_VERSION2_MSK 0xffffffff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID0_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID0_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID1_SH 8
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID1_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID2_SH 16
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID2_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID3_SH 24
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID3_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID4_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID4_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID5_SH 8
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID5_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID6_SH 16
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID6_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID7_SH 24
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID7_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID8_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID8_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID9_SH 8
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID9_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID10_SH 16
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID10_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID11_SH 24
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID11_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID12_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID12_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID13_SH 8
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID13_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID14_SH 16
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID14_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID15_SH 24
#define FWCMD_H2C_APF_SET_PROGRAM_PKTID15_MSK 0xff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN0_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN0_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN0_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN0_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN1_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN1_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN1_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN1_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN2_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN2_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN2_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN2_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN3_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN3_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN3_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN3_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN4_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN4_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN4_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN4_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN5_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN5_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN5_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN5_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN6_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN6_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN6_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN6_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN7_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN7_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN7_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN7_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN8_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN8_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN8_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN8_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN9_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN9_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN9_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN9_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN10_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN10_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN10_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN10_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN11_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN11_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN11_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN11_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN12_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN12_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN12_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN12_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN13_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN13_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN13_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN13_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN14_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN14_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN14_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN14_MSK 0xffff
#define FWCMD_H2C_APF_SET_PROGRAM_LEN15_SH 0
#define FWCMD_H2C_APF_SET_PROGRAM_LEN15_MSK 0xffff
#define FWCMD_H2C_APF_SET_DATA_LEN15_SH 16
#define FWCMD_H2C_APF_SET_DATA_LEN15_MSK 0xffff
#define FWCMD_H2C_APF_GET_PROGRAM_NUM_SH 0
#define FWCMD_H2C_APF_GET_PROGRAM_NUM_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_MODULE_ID_SH 0
#define FWCMD_H2C_ACT_SCHEDULE_REQ_MODULE_ID_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_PRIORITY_SH 8
#define FWCMD_H2C_ACT_SCHEDULE_REQ_PRIORITY_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_OPTIONS_SH 16
#define FWCMD_H2C_ACT_SCHEDULE_REQ_OPTIONS_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_FAW_EN BIT(24)
#define FWCMD_H2C_ACT_SCHEDULE_REQ_START_TIME_SH 0
#define FWCMD_H2C_ACT_SCHEDULE_REQ_START_TIME_MSK 0xffffffff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_DURATION_SH 0
#define FWCMD_H2C_ACT_SCHEDULE_REQ_DURATION_MSK 0xffffffff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_PERIOD_SH 0
#define FWCMD_H2C_ACT_SCHEDULE_REQ_PERIOD_MSK 0xffffffff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_TSF_IDX_SH 0
#define FWCMD_H2C_ACT_SCHEDULE_REQ_TSF_IDX_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_CHANNEL_SH 8
#define FWCMD_H2C_ACT_SCHEDULE_REQ_CHANNEL_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_BW_SH 16
#define FWCMD_H2C_ACT_SCHEDULE_REQ_BW_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_PRIMARY_CH_SH 24
#define FWCMD_H2C_ACT_SCHEDULE_REQ_PRIMARY_CH_MSK 0xff
#define FWCMD_H2C_ACT_SCHEDULE_REQ_CH_BAND_TYPE_SH 0
#define FWCMD_H2C_ACT_SCHEDULE_REQ_CH_BAND_TYPE_MSK 0x3
#define FWCMD_H2C_BCN_REQ_MODULE_ID_SH 0
#define FWCMD_H2C_BCN_REQ_MODULE_ID_MSK 0xff
#define FWCMD_H2C_BCN_REQ_BCN_INTVL_MS_SH 16
#define FWCMD_H2C_BCN_REQ_BCN_INTVL_MS_MSK 0xff
#define FWCMD_H2C_BCN_REQ_PRIORITY_SH 24
#define FWCMD_H2C_BCN_REQ_PRIORITY_MSK 0xff
#define FWCMD_H2C_BCN_REQ_BCN_OFFSET_US_SH 0
#define FWCMD_H2C_BCN_REQ_BCN_OFFSET_US_MSK 0xffffffff
#define FWCMD_H2C_BCN_REQ_CUR_TBTT_SH 0
#define FWCMD_H2C_BCN_REQ_CUR_TBTT_MSK 0xffffffff
#define FWCMD_H2C_BCN_REQ_CUR_TBTT_FR_SH 0
#define FWCMD_H2C_BCN_REQ_CUR_TBTT_FR_MSK 0xffffffff
#define FWCMD_H2C_BCN_REQ_PROHIBIT_BEFORE_MS_SH 0
#define FWCMD_H2C_BCN_REQ_PROHIBIT_BEFORE_MS_MSK 0xff
#define FWCMD_H2C_BCN_REQ_PROHIBIT_AFTER_MS_SH 8
#define FWCMD_H2C_BCN_REQ_PROHIBIT_AFTER_MS_MSK 0xff
#define FWCMD_H2C_BCN_REQ_PORT_IDX_SH 16
#define FWCMD_H2C_BCN_REQ_PORT_IDX_MSK 0xff
#define FWCMD_H2C_BCN_REQ_OPTIONS_SH 24
#define FWCMD_H2C_BCN_REQ_OPTIONS_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_PORT_IDX_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_PORT_IDX_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_MASTER_PREF_SH 16
#define FWCMD_H2C_NAN_FUNC_CTRL_MASTER_PREF_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_RANDOM_FACTOR_SH 24
#define FWCMD_H2C_NAN_FUNC_CTRL_RANDOM_FACTOR_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_OP_CH_24G_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_OP_CH_24G_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_OP_CH_5G_SH 8
#define FWCMD_H2C_NAN_FUNC_CTRL_OP_CH_5G_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_OPTIONS_SH 16
#define FWCMD_H2C_NAN_FUNC_CTRL_OPTIONS_MSK 0xffff
#define FWCMD_H2C_NAN_FUNC_CTRL_TIME_INDICATE_PERIOD_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_TIME_INDICATE_PERIOD_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID0_SH 8
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID0_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID1_SH 16
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID1_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID2_SH 24
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID2_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID3_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID3_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID4_SH 8
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID4_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID5_SH 16
#define FWCMD_H2C_NAN_FUNC_CTRL_NAN_CLUSTER_ID5_MSK 0xff
#define FWCMD_H2C_NAN_FUNC_CTRL_PARA_OPTIONS_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_PARA_OPTIONS_MSK 0xffff
#define FWCMD_H2C_NAN_FUNC_CTRL_MAC_ID_BCN_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_MAC_ID_BCN_MSK 0xffff
#define FWCMD_H2C_NAN_FUNC_CTRL_MAC_ID_MGN_SH 16
#define FWCMD_H2C_NAN_FUNC_CTRL_MAC_ID_MGN_MSK 0xffff
#define FWCMD_H2C_NAN_FUNC_CTRL_MAC_ID_BCN_DISC_SH 0
#define FWCMD_H2C_NAN_FUNC_CTRL_MAC_ID_BCN_DISC_MSK 0xffff
#define FWCMD_H2C_NAN_DE_INFO_STATUS_SH 0
#define FWCMD_H2C_NAN_DE_INFO_STATUS_MSK 0xff
#define FWCMD_H2C_NAN_DE_INFO_LOC_BCAST_SDF_SH 8
#define FWCMD_H2C_NAN_DE_INFO_LOC_BCAST_SDF_MSK 0xff
#define FWCMD_H2C_NAN_JOIN_CLUSTER_IS_ALLOW_SH 0
#define FWCMD_H2C_NAN_JOIN_CLUSTER_IS_ALLOW_MSK 0xff
#define FWCMD_H2C_PAUSE_FAW_TX_ID_MAP_SH 0
#define FWCMD_H2C_PAUSE_FAW_TX_ID_MAP_MSK 0xffffffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_MODULE_ID_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_MODULE_ID_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_OPTION_SH 8
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_OPTION_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_START_OFFSET_16TU_SH 16
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_START_OFFSET_16TU_MSK 0xffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_PERIOD_TU_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_PERIOD_TU_MSK 0xffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_BIT_DURATION_TU_SH 16
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_BIT_DURATION_TU_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_LEN_SH 24
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_LEN_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_0_3_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_0_3_MSK 0xffffffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_4_7_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_4_7_MSK 0xffffffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_8_11_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_8_11_MSK 0xffffffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_12_15_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TIME_BITMAP_12_15_MSK 0xffffffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_CHANNEL_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_CHANNEL_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_BW_SH 8
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_BW_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_PRIMARY_CH_SH 16
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_PRIMARY_CH_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_CH_BAND_TYPE_SH 24
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_CH_BAND_TYPE_MSK 0x3
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_MAC_ID_SH 0
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_MAC_ID_MSK 0xffff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_PRIORITY_SH 16
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_PRIORITY_MSK 0xff
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TYPE_SH 24
#define FWCMD_H2C_NAN_AVAIL_T_BITMAP_TYPE_MSK 0xff
#define FWCMD_H2C_FW_CMDREQ_STR_SH 0
#define FWCMD_H2C_FW_CMDREQ_STR_MSK 0xffffffff
#define FWCMD_H2C_MRC_REQ_TSF_REQ_TSF_NUM_SH 0
#define FWCMD_H2C_MRC_REQ_TSF_REQ_TSF_NUM_MSK 0xff
#define FWCMD_H2C_MRC_REQ_TSF_BAND_SH 8
#define FWCMD_H2C_MRC_REQ_TSF_BAND_MSK 0xf
#define FWCMD_H2C_MRC_REQ_TSF_PORT_SH 12
#define FWCMD_H2C_MRC_REQ_TSF_PORT_MSK 0xf
#define FWCMD_H2C_ADD_MRC_SCH_IDX_SH 0
#define FWCMD_H2C_ADD_MRC_SCH_IDX_MSK 0xf
#define FWCMD_H2C_ADD_MRC_SCH_TYPE_SH 4
#define FWCMD_H2C_ADD_MRC_SCH_TYPE_MSK 0xf
#define FWCMD_H2C_ADD_MRC_SLOT_NUM_SH 8
#define FWCMD_H2C_ADD_MRC_SLOT_NUM_MSK 0xff
#define FWCMD_H2C_ADD_MRC_IS_BTC_SCH BIT(16)
#define FWCMD_H2C_ADD_MRC_IS_EMLSR BIT(17)
#define FWCMD_H2C_ADD_MRC_B0_CH_NUM_SH 18
#define FWCMD_H2C_ADD_MRC_B0_CH_NUM_MSK 0x3
#define FWCMD_H2C_ADD_MRC_B1_CH_NUM_SH 20
#define FWCMD_H2C_ADD_MRC_B1_CH_NUM_MSK 0x3
#define FWCMD_H2C_ADD_MRC_DURATION_SH 0
#define FWCMD_H2C_ADD_MRC_DURATION_MSK 0xffff
#define FWCMD_H2C_ADD_MRC_COURTESY_EN BIT(17)
#define FWCMD_H2C_ADD_MRC_ROLE_NUM_SH 24
#define FWCMD_H2C_ADD_MRC_ROLE_NUM_MSK 0xff
#define FWCMD_H2C_ADD_MRC_COURTESY_PERIOD_SH 0
#define FWCMD_H2C_ADD_MRC_COURTESY_PERIOD_MSK 0xff
#define FWCMD_H2C_ADD_MRC_COURTESY_TARGET_SH 8
#define FWCMD_H2C_ADD_MRC_COURTESY_TARGET_MSK 0xff
#define FWCMD_H2C_ADD_MRC_MACID_SH 0
#define FWCMD_H2C_ADD_MRC_MACID_MSK 0xffff
#define FWCMD_H2C_ADD_MRC_ROLE_TYPE_SH 16
#define FWCMD_H2C_ADD_MRC_ROLE_TYPE_MSK 0xff
#define FWCMD_H2C_ADD_MRC_IS_MASTER BIT(24)
#define FWCMD_H2C_ADD_MRC_IS_ALT_ROLE BIT(25)
#define FWCMD_H2C_ADD_MRC_TX_NULL_EN BIT(26)
#define FWCMD_H2C_ADD_MRC_ROLE_ALT_EN BIT(27)
#define FWCMD_H2C_ADD_MRC_CENTRAL_CH_SEG_SH 0
#define FWCMD_H2C_ADD_MRC_CENTRAL_CH_SEG_MSK 0xff
#define FWCMD_H2C_ADD_MRC_PRI_CH_SH 8
#define FWCMD_H2C_ADD_MRC_PRI_CH_MSK 0xff
#define FWCMD_H2C_ADD_MRC_BW_SH 16
#define FWCMD_H2C_ADD_MRC_BW_MSK 0xf
#define FWCMD_H2C_ADD_MRC_CH_BAND_TYPE_SH 20
#define FWCMD_H2C_ADD_MRC_CH_BAND_TYPE_MSK 0x3
#define FWCMD_H2C_ADD_MRC_RFK_BY_PASS BIT(22)
#define FWCMD_H2C_ADD_MRC_IS_BTC BIT(23)
#define FWCMD_H2C_ADD_MRC_NULL_EARLY_SH 24
#define FWCMD_H2C_ADD_MRC_NULL_EARLY_MSK 0xff
#define FWCMD_H2C_ADD_MRC_ALT_PERIOD_SH 0
#define FWCMD_H2C_ADD_MRC_ALT_PERIOD_MSK 0xff
#define FWCMD_H2C_ADD_MRC_ALT_ROLE_TYPE_SH 8
#define FWCMD_H2C_ADD_MRC_ALT_ROLE_TYPE_MSK 0xff
#define FWCMD_H2C_ADD_MRC_ALT_ROLE_MACID_SH 16
#define FWCMD_H2C_ADD_MRC_ALT_ROLE_MACID_MSK 0xff
#define FWCMD_H2C_ADD_MRC_MACID_MAIN_BM_SH 0
#define FWCMD_H2C_ADD_MRC_MACID_MAIN_BM_MSK 0xffffffff
#define FWCMD_H2C_ADD_MRC_MACID_PAIRED_BM_SH 0
#define FWCMD_H2C_ADD_MRC_MACID_PAIRED_BM_MSK 0xffffffff
#define FWCMD_H2C_START_MRC_SCH_IDX_SH 0
#define FWCMD_H2C_START_MRC_SCH_IDX_MSK 0xf
#define FWCMD_H2C_START_MRC_OLD_SCH_IDX_SH 4
#define FWCMD_H2C_START_MRC_OLD_SCH_IDX_MSK 0xf
#define FWCMD_H2C_START_MRC_ACTION_SH 8
#define FWCMD_H2C_START_MRC_ACTION_MSK 0xff
#define FWCMD_H2C_START_MRC_START_TSF_LOW_SH 0
#define FWCMD_H2C_START_MRC_START_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_START_MRC_START_TSF_HIGH_SH 0
#define FWCMD_H2C_START_MRC_START_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_DEL_MRC_SCH_IDX_SH 0
#define FWCMD_H2C_DEL_MRC_SCH_IDX_MSK 0xf
#define FWCMD_H2C_DEL_MRC_DEL_ALL BIT(4)
#define FWCMD_H2C_DEL_MRC_STOP_ONLY BIT(5)
#define FWCMD_H2C_DEL_MRC_SPECIFIC_ROLE_EN BIT(6)
#define FWCMD_H2C_DEL_MRC_STOP_SLOT_IDX_SH 8
#define FWCMD_H2C_DEL_MRC_STOP_SLOT_IDX_MSK 0xff
#define FWCMD_H2C_DEL_MRC_SPECIFIC_ROLE_MACID_SH 16
#define FWCMD_H2C_DEL_MRC_SPECIFIC_ROLE_MACID_MSK 0xffff
#define FWCMD_H2C_MRC_SYNC_SYNC_EN BIT(0)
#define FWCMD_H2C_MRC_SYNC_SRC_PORT_SH 8
#define FWCMD_H2C_MRC_SYNC_SRC_PORT_MSK 0xf
#define FWCMD_H2C_MRC_SYNC_SRC_BAND_SH 12
#define FWCMD_H2C_MRC_SYNC_SRC_BAND_MSK 0xf
#define FWCMD_H2C_MRC_SYNC_DEST_PORT_SH 16
#define FWCMD_H2C_MRC_SYNC_DEST_PORT_MSK 0xf
#define FWCMD_H2C_MRC_SYNC_DEST_BAND_SH 20
#define FWCMD_H2C_MRC_SYNC_DEST_BAND_MSK 0xf
#define FWCMD_H2C_MRC_SYNC_OFFSET_SH 0
#define FWCMD_H2C_MRC_SYNC_OFFSET_MSK 0xffff
#define FWCMD_H2C_MRC_UPD_DURATION_SCH_IDX_SH 0
#define FWCMD_H2C_MRC_UPD_DURATION_SCH_IDX_MSK 0xf
#define FWCMD_H2C_MRC_UPD_DURATION_SLOT_NUM_SH 8
#define FWCMD_H2C_MRC_UPD_DURATION_SLOT_NUM_MSK 0xff
#define FWCMD_H2C_MRC_UPD_DURATION_IS_BTC_SCH BIT(16)
#define FWCMD_H2C_MRC_UPD_DURATION_START_TSF_LOW_SH 0
#define FWCMD_H2C_MRC_UPD_DURATION_START_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_MRC_UPD_DURATION_START_TSF_HIGH_SH 0
#define FWCMD_H2C_MRC_UPD_DURATION_START_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_MRC_UPD_DURATION_SLOT_IDX_SH 0
#define FWCMD_H2C_MRC_UPD_DURATION_SLOT_IDX_MSK 0xff
#define FWCMD_H2C_MRC_UPD_DURATION_DURATION_SH 16
#define FWCMD_H2C_MRC_UPD_DURATION_DURATION_MSK 0xffff
#define FWCMD_H2C_MRC_UPD_BITMAP_SCH_IDX_SH 0
#define FWCMD_H2C_MRC_UPD_BITMAP_SCH_IDX_MSK 0xf
#define FWCMD_H2C_MRC_UPD_BITMAP_ACTION BIT(4)
#define FWCMD_H2C_MRC_UPD_BITMAP_MACID_SH 16
#define FWCMD_H2C_MRC_UPD_BITMAP_MACID_MSK 0xffff
#define FWCMD_H2C_MRC_UPD_BITMAP_CLIENT_MACID_SH 0
#define FWCMD_H2C_MRC_UPD_BITMAP_CLIENT_MACID_MSK 0xffff
#define FWCMD_H2C_MRC_DBG_DUMP_CFG_FW_DBG_CFG_SH 0
#define FWCMD_H2C_MRC_DBG_DUMP_CFG_FW_DBG_CFG_MSK 0xf
#define FWCMD_H2C_MRC_DBG_DUMP_CFG_DBG_LVL_SH 6
#define FWCMD_H2C_MRC_DBG_DUMP_CFG_DBG_LVL_MSK 0x3
#define FWCMD_H2C_SENS_TBL_UPD_VALID BIT(0)
#define FWCMD_H2C_SENS_TBL_UPD_RPT_EN BIT(1)
#define FWCMD_H2C_SENS_TBL_UPD_RPT_DELAY BIT(2)
#define FWCMD_H2C_SENS_TBL_UPD_RPT_TS BIT(3)
#define FWCMD_H2C_SENS_TBL_UPD_SENS_ROLE_RX BIT(4)
#define FWCMD_H2C_SENS_TBL_UPD_SENS_ROLE_TX BIT(5)
#define FWCMD_H2C_SENS_TBL_UPD_INST_TYPE_SH 6
#define FWCMD_H2C_SENS_TBL_UPD_INST_TYPE_MSK 0x3
#define FWCMD_H2C_SENS_TBL_UPD_WIENER_COEF_TAU_SH 8
#define FWCMD_H2C_SENS_TBL_UPD_WIENER_COEF_TAU_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_MACID_SH 12
#define FWCMD_H2C_SENS_TBL_UPD_MACID_MSK 0x3ff
#define FWCMD_H2C_SENS_TBL_UPD_MSR_SETUP_ID_SH 22
#define FWCMD_H2C_SENS_TBL_UPD_MSR_SETUP_ID_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_N_RX_SH 25
#define FWCMD_H2C_SENS_TBL_UPD_N_RX_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_I_NG BIT(28)
#define FWCMD_H2C_SENS_TBL_UPD_N_B BIT(29)
#define FWCMD_H2C_SENS_TBL_UPD_SR2SR_EN BIT(30)
#define FWCMD_H2C_SENS_TBL_UPD_STBC_EN BIT(31)
#define FWCMD_H2C_SENS_TBL_UPD_SMR_RATE_SH 0
#define FWCMD_H2C_SENS_TBL_UPD_SMR_RATE_MSK 0xfff
#define FWCMD_H2C_SENS_TBL_UPD_RPT_TO_HOST_EN BIT(12)
#define FWCMD_H2C_SENS_TBL_UPD_HT_CTRL_EN BIT(13)
#define FWCMD_H2C_SENS_TBL_UPD_USE_INVLD BIT(14)
#define FWCMD_H2C_SENS_TBL_UPD_SMR_LOCK BIT(15)
#define FWCMD_H2C_SENS_TBL_UPD_SMR_HOST_RPT_PLDID_SH 16
#define FWCMD_H2C_SENS_TBL_UPD_SMR_HOST_RPT_PLDID_MSK 0xff
#define FWCMD_H2C_SENS_TBL_UPD_WIENER_COEF_SNR_SH 24
#define FWCMD_H2C_SENS_TBL_UPD_WIENER_COEF_SNR_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_POLL_REQUIRE BIT(27)
#define FWCMD_H2C_SENS_TBL_UPD_INVLD_BUF_PLDID_SH 28
#define FWCMD_H2C_SENS_TBL_UPD_INVLD_BUF_PLDID_MSK 0xf
#define FWCMD_H2C_SENS_TBL_UPD_MAX_TX_NSTS_SH 0
#define FWCMD_H2C_SENS_TBL_UPD_MAX_TX_NSTS_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_MAX_RX_NSTS_SH 3
#define FWCMD_H2C_SENS_TBL_UPD_MAX_RX_NSTS_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_MIN_TIME_BTW_MSR_SH 6
#define FWCMD_H2C_SENS_TBL_UPD_MIN_TIME_BTW_MSR_MSK 0x7fffff
#define FWCMD_H2C_SENS_TBL_UPD_BW_SH 29
#define FWCMD_H2C_SENS_TBL_UPD_BW_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_BAND BIT(0)
#define FWCMD_H2C_SENS_TBL_UPD_ENTRY_IDX_SH 1
#define FWCMD_H2C_SENS_TBL_UPD_ENTRY_IDX_MSK 0x7
#define FWCMD_H2C_SENS_TBL_UPD_ENTRY_IDX_EN BIT(4)
#define FWCMD_H2C_SENS_NTB_TX_OFLD_MACID_SH 0
#define FWCMD_H2C_SENS_NTB_TX_OFLD_MACID_MSK 0x3ff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SMS_ID_SH 10
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SMS_ID_MSK 0x7
#define FWCMD_H2C_SENS_NTB_TX_OFLD_ENTRY_IDX_SH 13
#define FWCMD_H2C_SENS_NTB_TX_OFLD_ENTRY_IDX_MSK 0x7
#define FWCMD_H2C_SENS_NTB_TX_OFLD_ENABLE BIT(16)
#define FWCMD_H2C_SENS_NTB_TX_OFLD_BW_SIG_EN BIT(17)
#define FWCMD_H2C_SENS_NTB_TX_OFLD_TXBF_EN BIT(18)
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SEC_EN BIT(19)
#define FWCMD_H2C_SENS_NTB_TX_OFLD_RATE_SH 20
#define FWCMD_H2C_SENS_NTB_TX_OFLD_RATE_MSK 0xfff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_MIN_MSR_INTVAL_SH 0
#define FWCMD_H2C_SENS_NTB_TX_OFLD_MIN_MSR_INTVAL_MSK 0x7fffff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SENS_BW_SH 23
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SENS_BW_MSK 0x7
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SENS_TX_NSTS_SH 26
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SENS_TX_NSTS_MSK 0x7
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SENS_RX_NSTS_SH 29
#define FWCMD_H2C_SENS_NTB_TX_OFLD_SENS_RX_NSTS_MSK 0x7
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_1_SH 0
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_1_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_2_SH 8
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_2_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_3_SH 16
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_3_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_4_SH 24
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_4_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_5_SH 0
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_5_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_6_SH 8
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A1_ADDR_6_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_I2R_NDP_PWR_SH 16
#define FWCMD_H2C_SENS_NTB_TX_OFLD_I2R_NDP_PWR_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_R2I_TAR_RSSI_SH 24
#define FWCMD_H2C_SENS_NTB_TX_OFLD_R2I_TAR_RSSI_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_1_SH 0
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_1_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_2_SH 8
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_2_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_3_SH 16
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_3_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_4_SH 24
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_4_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_5_SH 0
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_5_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_6_SH 8
#define FWCMD_H2C_SENS_NTB_TX_OFLD_A2_ADDR_6_MSK 0xff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_AID11_SH 16
#define FWCMD_H2C_SENS_NTB_TX_OFLD_AID11_MSK 0x7ff
#define FWCMD_H2C_SENS_NTB_TX_OFLD_BAND BIT(27)
#define FWCMD_H2C_SENS_NTB_TX_OFLD_PORT_SH 28
#define FWCMD_H2C_SENS_NTB_TX_OFLD_PORT_MSK 0xf
#define FWCMD_H2C_SENS_INVLD_SMR_BAND_SEL BIT(0)
#define FWCMD_H2C_SENS_INVLD_SMR_ENTRY_IDX_SH 1
#define FWCMD_H2C_SENS_INVLD_SMR_ENTRY_IDX_MSK 0x7
#define FWCMD_H2C_SENS_INVLD_SMR_MACID_SH 4
#define FWCMD_H2C_SENS_INVLD_SMR_MACID_MSK 0x3ff
#define FWCMD_H2C_SENS_INVLD_SMR_SMEID_SH 14
#define FWCMD_H2C_SENS_INVLD_SMR_SMEID_MSK 0x3f
#define FWCMD_H2C_SENS_INVLD_SMR_SMSID_SH 20
#define FWCMD_H2C_SENS_INVLD_SMR_SMSID_MSK 0x7
#define FWCMD_H2C_SENS_INVLD_SMR_USE_PKTID BIT(23)
#define FWCMD_H2C_SENS_INVLD_SMR_SEC_TYPE_SH 24
#define FWCMD_H2C_SENS_INVLD_SMR_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_SENS_INVLD_SMR_TX_STA_ID_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_TX_STA_ID_MSK 0xfff
#define FWCMD_H2C_SENS_INVLD_SMR_RX_STA_ID_SH 12
#define FWCMD_H2C_SENS_INVLD_SMR_RX_STA_ID_MSK 0xfff
#define FWCMD_H2C_SENS_INVLD_SMR_PKTID_SH 24
#define FWCMD_H2C_SENS_INVLD_SMR_PKTID_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_1_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_1_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_2_SH 8
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_2_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_3_SH 16
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_3_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_4_SH 24
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_4_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_5_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_5_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_6_SH 8
#define FWCMD_H2C_SENS_INVLD_SMR_A1_ADDR_6_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_1_SH 16
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_1_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_2_SH 24
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_2_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_3_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_3_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_4_SH 8
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_4_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_5_SH 16
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_5_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_6_SH 24
#define FWCMD_H2C_SENS_INVLD_SMR_A2_ADDR_6_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_1_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_1_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_2_SH 8
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_2_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_3_SH 16
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_3_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_4_SH 24
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_4_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_5_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_5_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_6_SH 8
#define FWCMD_H2C_SENS_INVLD_SMR_A3_ADDR_6_MSK 0xff
#define FWCMD_H2C_SENS_INVLD_SMR_PLE_PG_SIZE_IND_SH 16
#define FWCMD_H2C_SENS_INVLD_SMR_PLE_PG_SIZE_IND_MSK 0x3
#define FWCMD_H2C_SENS_INVLD_SMR_PLE_PG_START_OFST_SH 0
#define FWCMD_H2C_SENS_INVLD_SMR_PLE_PG_START_OFST_MSK 0xffffffff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_SUB_CONTENT_LEN_SH 0
#define FWCMD_H2C_SUB_OFFLOAD_AGG_SUB_CONTENT_LEN_MSK 0xfffff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_SUB_CONTENT_TYPE_SH 20
#define FWCMD_H2C_SUB_OFFLOAD_AGG_SUB_CONTENT_TYPE_MSK 0xfff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_MACID_SH 0
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_MACID_MSK 0x7f
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_OP BIT(7)
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_NUM_SH 8
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_NUM_MSK 0xffffff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_VAL_SH 0
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_VAL_MSK 0xff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_MASK_SH 8
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_MASK_MSK 0xff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_SHIFT_SH 16
#define FWCMD_H2C_SUB_OFFLOAD_AGG_DCTL_INFO_BYTE_SHIFT_MSK 0xff
#define FWCMD_H2C_SUB_OFFLOAD_AGG_WITH_NUM_NUM_SH 0
#define FWCMD_H2C_SUB_OFFLOAD_AGG_WITH_NUM_NUM_MSK 0xffff
#define FWCMD_H2C_OM_ADV_RPT_MACID_SH 0
#define FWCMD_H2C_OM_ADV_RPT_MACID_MSK 0xffff
#define FWCMD_H2C_OM_ADV_RPT_TYPE_SH 16
#define FWCMD_H2C_OM_ADV_RPT_TYPE_MSK 0xf
#define FWCMD_H2C_OM_ADV_RPT_ENABLE BIT(24)
#define FWCMD_H2C_SER_DBG_CASE_SET_CMAC_CASE_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_CMAC_CASE_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_DMAC_CASE_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_DMAC_CASE_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_ADDRESS_0_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_ADDRESS_0_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_SUBMODULE_FLAG_0_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_SUBMODULE_FLAG_0_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_ADDRESS_1_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_ADDRESS_1_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_SUBMODULE_FLAG_1_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_SUBMODULE_FLAG_1_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_ADDRESS_2_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_ADDRESS_2_MSK 0xffffffff
#define FWCMD_H2C_SER_DBG_CASE_SET_SUBMODULE_FLAG_2_SH 0
#define FWCMD_H2C_SER_DBG_CASE_SET_SUBMODULE_FLAG_2_MSK 0xffffffff
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_IDX_SH 0
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_IDX_MSK 0xf
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_EN BIT(31)
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_IP_ADDRESS_SH 0
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_IP_ADDRESS_MSK 0xffffffff
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_MAC_LOW_ADDRESS_SH 0
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_MAC_LOW_ADDRESS_MSK 0xffffffff
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_MAC_HIGH_ADDRESS_SH 0
#define FWCMD_H2C_NAT2P5_UPD_NAT2P5_MAC_HIGH_ADDRESS_MSK 0xffff
#define FWCMD_H2C_AZ_EN_MAC_ID_SH 0
#define FWCMD_H2C_AZ_EN_MAC_ID_MSK 0xffff
#define FWCMD_H2C_AZ_EN_INITIALSTA_SH 16
#define FWCMD_H2C_AZ_EN_INITIALSTA_MSK 0xff
#define FWCMD_H2C_AZ_EN_NONTB_SH 24
#define FWCMD_H2C_AZ_EN_NONTB_MSK 0xff
#define FWCMD_H2C_AZ_EN_BILMR_SH 0
#define FWCMD_H2C_AZ_EN_BILMR_MSK 0xff
#define FWCMD_H2C_AZ_EN_DELAYLMR_SH 8
#define FWCMD_H2C_AZ_EN_DELAYLMR_MSK 0xff
#define FWCMD_H2C_AZ_EN_TERMINATION_SH 16
#define FWCMD_H2C_AZ_EN_TERMINATION_MSK 0xff
#define FWCMD_H2C_AZ_EN_SECEN_SH 24
#define FWCMD_H2C_AZ_EN_SECEN_MSK 0xff
#define FWCMD_H2C_AZ_EN_ENABLE_SH 0
#define FWCMD_H2C_AZ_EN_ENABLE_MSK 0xff
#define FWCMD_H2C_AZ_EN_PWR_CTRL_EN_SH 8
#define FWCMD_H2C_AZ_EN_PWR_CTRL_EN_MSK 0xff
#define FWCMD_H2C_AZ_PROC_ASAP_SH 0
#define FWCMD_H2C_AZ_PROC_ASAP_MSK 0xff
#define FWCMD_H2C_AZ_PROC_PKTID_IFTMR_SH 8
#define FWCMD_H2C_AZ_PROC_PKTID_IFTMR_MSK 0xff
#define FWCMD_H2C_AZ_PROC_PKTID_FTMR_SH 16
#define FWCMD_H2C_AZ_PROC_PKTID_FTMR_MSK 0xff
#define FWCMD_H2C_AZ_PROC_TSF_TIMER_OFFSET_SH 24
#define FWCMD_H2C_AZ_PROC_TSF_TIMER_OFFSET_MSK 0xff
#define FWCMD_H2C_AZ_PROC_PARTIAL_TSF_TIMER_SH 0
#define FWCMD_H2C_AZ_PROC_PARTIAL_TSF_TIMER_MSK 0xffff
#define FWCMD_H2C_AZ_PROC_RSP_CH_SH 16
#define FWCMD_H2C_AZ_PROC_RSP_CH_MSK 0xff
#define FWCMD_H2C_AZ_PROC_MODE_SH 24
#define FWCMD_H2C_AZ_PROC_MODE_MSK 0xff
#define FWCMD_H2C_AZ_PROC_FIRST_PSTIMER_HIGH_SH 0
#define FWCMD_H2C_AZ_PROC_FIRST_PSTIMER_HIGH_MSK 0xffffffff
#define FWCMD_H2C_AZ_PROC_FIRST_PSTIMER_LOW_SH 0
#define FWCMD_H2C_AZ_PROC_FIRST_PSTIMER_LOW_MSK 0xffffffff
#define FWCMD_H2C_AZ_PROC_ITVL_SH 0
#define FWCMD_H2C_AZ_PROC_ITVL_MSK 0xffffffff
#define FWCMD_H2C_AZ_PROC_BURST_CNT_SH 0
#define FWCMD_H2C_AZ_PROC_BURST_CNT_MSK 0xff
#define FWCMD_H2C_AZ_PROC_PTK_KEYID_SH 8
#define FWCMD_H2C_AZ_PROC_PTK_KEYID_MSK 0xff
#define FWCMD_H2C_AZ_PROC_AID_SH 0
#define FWCMD_H2C_AZ_PROC_AID_MSK 0xffff
#define FWCMD_H2C_AZ_PROC_MACID_SH 16
#define FWCMD_H2C_AZ_PROC_MACID_MSK 0xffff
#define FWCMD_H2C_AZ_PROC_BILMR_SH 0
#define FWCMD_H2C_AZ_PROC_BILMR_MSK 0xff
#define FWCMD_H2C_AZ_PROC_DELAYLMR_SH 8
#define FWCMD_H2C_AZ_PROC_DELAYLMR_MSK 0xff
#define FWCMD_H2C_AZ_PROC_TERMINATION_SH 16
#define FWCMD_H2C_AZ_PROC_TERMINATION_MSK 0xff
#define FWCMD_H2C_AZ_PROC_SECEN_SH 24
#define FWCMD_H2C_AZ_PROC_SECEN_MSK 0xff
#define FWCMD_H2C_AZ_UPDATE_UPD_PSTIMER_HIGH_SH 0
#define FWCMD_H2C_AZ_UPDATE_UPD_PSTIMER_HIGH_MSK 0xffffffff
#define FWCMD_H2C_AZ_UPDATE_UPD_PSTIMER_LOW_SH 0
#define FWCMD_H2C_AZ_UPDATE_UPD_PSTIMER_LOW_MSK 0xffffffff
#define FWCMD_H2C_AZ_UPDATE_ITVL_SH 0
#define FWCMD_H2C_AZ_UPDATE_ITVL_MSK 0xffffffff
#define FWCMD_H2C_AZ_UPDATE_UPD_BURST_CNT_SH 0
#define FWCMD_H2C_AZ_UPDATE_UPD_BURST_CNT_MSK 0xff
#define FWCMD_H2C_AZ_UPDATE_TERMINATION_SH 8
#define FWCMD_H2C_AZ_UPDATE_TERMINATION_MSK 0xff
#define FWCMD_H2C_AZ_UPDATE_BW_SH 16
#define FWCMD_H2C_AZ_UPDATE_BW_MSK 0xff
#define FWCMD_H2C_AZ_UPDATE_MACID_SH 24
#define FWCMD_H2C_AZ_UPDATE_MACID_MSK 0xff
#define FWCMD_H2C_AZ_CANCEL_PRI_CH_SH 0
#define FWCMD_H2C_AZ_CANCEL_PRI_CH_MSK 0xff
#define FWCMD_H2C_AZ_CANCEL_CENTRAL_CH_SH 8
#define FWCMD_H2C_AZ_CANCEL_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_AZ_CANCEL_BW_SH 16
#define FWCMD_H2C_AZ_CANCEL_BW_MSK 0xff
#define FWCMD_H2C_AZ_CANCEL_CH_BAND_SH 24
#define FWCMD_H2C_AZ_CANCEL_CH_BAND_MSK 0xff
#define FWCMD_H2C_AZ_CANCEL_BAND_SH 0
#define FWCMD_H2C_AZ_CANCEL_BAND_MSK 0xff
#define FWCMD_H2C_AZ_CANCEL_RELOAD_RF_SH 8
#define FWCMD_H2C_AZ_CANCEL_RELOAD_RF_MSK 0xff
#define FWCMD_H2C_WOW_DIAG_CTRL_STOP BIT(0)
#define FWCMD_H2C_WOW_REQ_RX_PKT_PKT_NUM_SH 0
#define FWCMD_H2C_WOW_REQ_RX_PKT_PKT_NUM_MSK 0xff
#define FWCMD_H2C_WOW_REQ_RX_PKT_PLD_SIZE_SH 8
#define FWCMD_H2C_WOW_REQ_RX_PKT_PLD_SIZE_MSK 0xff
#define FWCMD_H2C_WOW_REQ_RX_PKT_PERIOD_SH 16
#define FWCMD_H2C_WOW_REQ_RX_PKT_PERIOD_MSK 0xffff
#define FWCMD_H2C_WOW_REQ_MEM_HEAP_INFO BIT(0)
#define FWCMD_H2C_WOW_REQ_MEM_MEM_INFO BIT(1)
#define FWCMD_H2C_WOW_REQ_MEM_WOW_START BIT(2)
#define FWCMD_H2C_WOW_REQ_MEM_WOW_END BIT(3)
#define FWCMD_H2C_WOW_REQ_BB_RF_REG_BB BIT(0)
#define FWCMD_H2C_WOW_REQ_BB_RF_REG_RF BIT(1)
#define FWCMD_H2C_AP_SELF_DIAG_FEATURE_SH 0
#define FWCMD_H2C_AP_SELF_DIAG_FEATURE_MSK 0xff
#define FWCMD_H2C_AP_SELF_DIAG_MODE_SH 8
#define FWCMD_H2C_AP_SELF_DIAG_MODE_MSK 0xff
#define FWCMD_H2C_REQ_STA_DIAG_RPT_REQ_WOW_RPT BIT(0)
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_SSN_MODE_SH 0
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_SSN_MODE_MSK 0x3
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_SSN_INDEX_SH 2
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_SSN_INDEX_MSK 0x7
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_MACID_SH 5
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_MACID_MSK 0xff
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_SW_SEQ_NUM_SH 20
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_OFLD_SW_SEQ_NUM_MSK 0xfff
#define FWCMD_H2C_ADDBA_OFLD_REQ_SSN_MODE_SH 0
#define FWCMD_H2C_ADDBA_OFLD_REQ_SSN_MODE_MSK 0x3
#define FWCMD_H2C_ADDBA_OFLD_REQ_SSN_INDEX_SH 2
#define FWCMD_H2C_ADDBA_OFLD_REQ_SSN_INDEX_MSK 0x7
#define FWCMD_H2C_ADDBA_OFLD_REQ_MACID_SH 5
#define FWCMD_H2C_ADDBA_OFLD_REQ_MACID_MSK 0xff
#define FWCMD_H2C_ADDBA_OFLD_REQ_SW_SEQ_NUM_SH 20
#define FWCMD_H2C_ADDBA_OFLD_REQ_SW_SEQ_NUM_MSK 0xfff
#define FWCMD_H2C_ADDBA_OFLD_REQ_BAND BIT(0)
#define FWCMD_H2C_ADDBA_OFLD_REQ_SEC_TYPE_SH 1
#define FWCMD_H2C_ADDBA_OFLD_REQ_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_ADDBA_OFLD_REQ_SEC_CAM_IDX_SH 5
#define FWCMD_H2C_ADDBA_OFLD_REQ_SEC_CAM_IDX_MSK 0x3ff
#define FWCMD_H2C_ADDBA_OFLD_REQ_FORCE_KEY_EN BIT(15)
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_REQ_START_SH 0
#define FWCMD_H2C_ADDBA_OFLD_REQ_ADDBA_REQ_START_MSK 0xffffffff
#define FWCMD_H2C_SAP_INFO_SAP_PWR_INT_EN BIT(0)
#define FWCMD_H2C_PCIE_WP_TO_CTRL_ISR_CHK_TIMER_SH 0
#define FWCMD_H2C_PCIE_WP_TO_CTRL_ISR_CHK_TIMER_MSK 0xffff
#define FWCMD_H2C_PCIE_WP_TO_CTRL_RPT_CHK_NUM_SH 16
#define FWCMD_H2C_PCIE_WP_TO_CTRL_RPT_CHK_NUM_MSK 0xffff
#define FWCMD_H2C_PCIE_WP_TO_CTRL_WPDMA_TIMER_SEL_SH 0
#define FWCMD_H2C_PCIE_WP_TO_CTRL_WPDMA_TIMER_SEL_MSK 0x1f
#define FWCMD_H2C_USB_TP_DBG_MON_MACID_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_MACID_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_TIME_SCALE_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_TIME_SCALE_MSK 0xff
#define FWCMD_H2C_USB_TP_DBG_MON_GNRL_EN BIT(24)
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_EN BIT(0)
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_DIR BIT(1)
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_EP_SH 2
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_EP_MSK 0xf
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_EN BIT(16)
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_DIR BIT(17)
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_EP_SH 18
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_EP_MSK 0xf
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_N2E_TH_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_N2E_TH_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_N2E_TH_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_N2E_TH_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_E2H_TH_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON0_E2H_TH_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_E2H_TH_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_EPMON1_E2H_TH_MSK 0xffff

/*----------------------------------- H2CPKT - CAT(Table) --------------------------*/
#define FWCMD_H2C_MUDE_PARA_TBLUD_TBLUD_SH 0
#define FWCMD_H2C_MUDE_PARA_TBLUD_TBLUD_MSK 0xffffffff
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA0_SH 0
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA0_MSK 0xffffffff
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA1_SH 0
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA1_MSK 0xffffffff
#define FWCMD_H2C_MUDECISION_PARA_MUINFO_THOLD_SH 0
#define FWCMD_H2C_MUDECISION_PARA_MUINFO_THOLD_MSK 0x3fffffff
#define FWCMD_H2C_MUDECISION_PARA_BYPASS_THOLD BIT(30)
#define FWCMD_H2C_MUDECISION_PARA_BYPASS_TP BIT(31)
#define FWCMD_H2C_MUDECISION_PARA_INIT_RATE_SH 0
#define FWCMD_H2C_MUDECISION_PARA_INIT_RATE_MSK 0xf
#define FWCMD_H2C_MUDECISION_PARA_RETRY_TH_SH 4
#define FWCMD_H2C_MUDECISION_PARA_RETRY_TH_MSK 0x7
#define FWCMD_H2C_MU_FIXINFO_MUINFO_THOLDEN BIT(0)
#define FWCMD_H2C_MU_FIXINFO_MUINFO_THOLD_SH 1
#define FWCMD_H2C_MU_FIXINFO_MUINFO_THOLD_MSK 0x3fffffff
#define FWCMD_H2C_MU_FIXINFO_BYPASS_THOLD BIT(31)
#define FWCMD_H2C_MU_FIXINFO_FIXMU_EN BIT(0)
#define FWCMD_H2C_MU_FIXINFO_FIXMU_ID_SH 1
#define FWCMD_H2C_MU_FIXINFO_FIXMU_ID_MSK 0x7f
#define FWCMD_H2C_UL_FIXINFO_TBLUD_TBLUD_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_TBLUD_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D2_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D2_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D3_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D3_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D4_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D4_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D5_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D5_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D6_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D6_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D7_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D7_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D8_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D8_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D9_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D9_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D10_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D10_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D11_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D11_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D12_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D12_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D13_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D13_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D14_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D14_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D15_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D15_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_CFG_MODE_SH 0
#define FWCMD_H2C_UL_FIXINFO_CFG_MODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_CFG_INTERVAL_SH 2
#define FWCMD_H2C_UL_FIXINFO_CFG_INTERVAL_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_CFG_BSR_THOLD_SH 8
#define FWCMD_H2C_UL_FIXINFO_CFG_BSR_THOLD_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_CFG_STOREMODE_SH 16
#define FWCMD_H2C_UL_FIXINFO_CFG_STOREMODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_DUR_SH 0
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_DUR_MSK 0xffff
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TF_TYPE_SH 16
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TF_TYPE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SIGEN BIT(19)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SIGSC_SH 20
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SIGSC_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MURTS BIT(24)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_SH 25
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SNDPKT_SH 27
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SNDPKT_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_GI_LTF_SH 29
#define FWCMD_H2C_UL_FIXINFO_ULINFO_GI_LTF_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATART_SH 0
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATART_MSK 0x1ff
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATAER BIT(9)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATABW_SH 10
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATABW_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STBC_SH 12
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STBC_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_LDPC BIT(14)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATADCM BIT(15)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_APEPLEN_SH 16
#define FWCMD_H2C_UL_FIXINFO_ULINFO_APEPLEN_MSK 0xfff
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MORETF BIT(28)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATA_VWER BIT(29)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_ISTWT BIT(30)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_UL_LOGO_TEST BIT(31)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MULTIPORT_SH 0
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MULTIPORT_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MBSSID_SH 3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MBSSID_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TXPWR_MODE_SH 7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TXPWR_MODE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_ULFIX_USAGE_SH 10
#define FWCMD_H2C_UL_FIXINFO_ULINFO_ULFIX_USAGE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TWTGRP_STANUM_SEL_SH 13
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TWTGRP_STANUM_SEL_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STORE_IDX_SH 15
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STORE_IDX_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NO_NEXT_SS BIT(19)
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_0_1_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_0_1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_2_3_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_2_3_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RU2SU BIT(0)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_PPDU_BW_SH 1
#define FWCMD_H2C_UL_FIXINFO_ULRUA_PPDU_BW_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GI_LTF_SH 3
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GI_LTF_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULRUA_STBC BIT(6)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_DOPPLER BIT(7)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_LTF_MA_SH 8
#define FWCMD_H2C_UL_FIXINFO_ULRUA_LTF_MA_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULRUA_STANUM_SH 11
#define FWCMD_H2C_UL_FIXINFO_ULRUA_STANUM_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RFGFIX BIT(16)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RFGIDX_SH 17
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RFGIDX_MSK 0x3ff
#define FWCMD_H2C_UL_FIXINFO_ULRUA_TB_NOM_SH 27
#define FWCMD_H2C_UL_FIXINFO_ULRUA_TB_NOM_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GRP_MODE BIT(0)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GRP_ID_SH 1
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GRP_ID_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_ULRUA_FIX_MODE BIT(7)
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_0_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_0_SH 8
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_0_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_1_SH 16
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_1_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_1_SH 24
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_1_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_DROP BIT(0)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_TGT_RSSI_SH 1
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MAC_ID_SH 8
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MAC_ID_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RU_POS_SH 16
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RU_POS_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_CODE BIT(24)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_VIP BIT(25)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_BSRLEN_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_BSRLEN_MSK 0x7fff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_DCM BIT(16)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_SS_SH 17
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_SS_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MCS_SH 20
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MCS_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RT_TBLCOL_SH 24
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RT_TBLCOL_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_PRTL_ALLOC BIT(30)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RATE_CHG BIT(31)
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_MODE_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_MODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_INTERVAL_SH 2
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_INTERVAL_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_BSR_THOLD_SH 8
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_BSR_THOLD_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_STOREMODE_SH 16
#define FWCMD_H2C_UL_FIXINFO_V2_CFG_STOREMODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_NDPA_DUR_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_NDPA_DUR_MSK 0xffff
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_TF_TYPE_SH 16
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_TF_TYPE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_SIGEN BIT(19)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_SIGSC_SH 20
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_SIGSC_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_MURTS BIT(24)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_NDPA_SH 25
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_NDPA_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_SNDPKT_SH 27
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_SNDPKT_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_GI_LTF_SH 29
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_GI_LTF_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATART_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATART_MSK 0xfff
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATAER BIT(12)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATABW_SH 13
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATABW_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_STBC_SH 15
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_STBC_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_LDPC BIT(17)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATADCM BIT(18)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_APEPLEN_SH 19
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_APEPLEN_MSK 0xfff
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_MORETF BIT(31)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_MULTIPORT_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_MULTIPORT_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_MBSSID_SH 3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_MBSSID_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_TXPWR_MODE_SH 7
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_TXPWR_MODE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_ULFIX_USAGE_SH 10
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_ULFIX_USAGE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_TWTGRP_STANUM_SEL_SH 13
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_TWTGRP_STANUM_SEL_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_STORE_IDX_SH 15
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_STORE_IDX_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_BAND BIT(19)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_NO_NEXT_SS BIT(20)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_DATA_VWER BIT(21)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_ISTWT BIT(22)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_UL_LOGO_TEST BIT(23)
#define FWCMD_H2C_UL_FIXINFO_V2_DL_TCP_TRIGGER BIT(24)
#define FWCMD_H2C_UL_FIXINFO_V2_DL_AC_SH 25
#define FWCMD_H2C_UL_FIXINFO_V2_DL_AC_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_UL_CSI_SND_EN BIT(27)
#define FWCMD_H2C_UL_FIXINFO_V2_ULINFO_UL_CSI_SND_INT_EN BIT(28)
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_0_3_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_0_3_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_4_7_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_4_7_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_8_11_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_8_11_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_12_15_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_UL_FIXINFO_STA_INFO_V2_12_15_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_RU2SU BIT(0)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_TX_MODE_SH 1
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_TX_MODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_GRP_MODE BIT(3)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_BAND BIT(4)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_PPDU_BW_SH 5
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_PPDU_BW_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_STANUM_SH 8
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_STANUM_MSK 0x1f
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_BW_EXT_SH 13
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_BW_EXT_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_GI_LTF_SH 16
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_GI_LTF_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_FIX_MODE BIT(19)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_RFGFIX BIT(20)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_TFRPT_FMT BIT(21)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_GRP_ID_SH 24
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_GRP_ID_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_RFGIDX_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_RFGIDX_MSK 0x3ff
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_STBC BIT(16)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_DOPPLER BIT(17)
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_TB_NOM_SH 18
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_TB_NOM_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_LTF_MA_SH 20
#define FWCMD_H2C_UL_FIXINFO_V2_ULRUA_LTF_MA_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U0_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U0_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U0_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U0_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U1_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U1_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U1_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U1_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U2_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U2_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U2_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U2_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U3_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U3_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U3_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U3_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U4_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U4_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U4_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U4_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U5_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U5_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U5_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U5_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U6_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U6_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U6_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U6_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U7_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U7_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U7_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U7_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U8_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U8_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U8_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U8_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U9_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U9_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U9_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U9_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U10_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U10_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U10_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U10_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U11_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U11_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U11_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U11_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U12_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U12_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U12_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U12_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U13_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U13_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U13_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U13_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U14_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U14_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U14_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U14_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U15_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U15_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U15_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_V2_STA_ENT_V2_U15_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_0_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_1_SH 8
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_1_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_2_SH 16
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_2_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_3_SH 24
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_V2_PREF_AC_3_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_MAC_ID_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_MAC_ID_MSK 0xffff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_RU_POS_SH 16
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_RU_POS_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_PS160 BIT(24)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_CODE BIT(25)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_RATE_MODE_SH 27
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_RATE_MODE_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_BSRLEN_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_BSRLEN_MSK 0x7fff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_DCM BIT(16)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_SS_SH 17
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_SS_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_MCS_SH 20
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_MCS_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_TGT_RSSI_SH 24
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_V2_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_ADDR_CAM_VALID BIT(0)
#define FWCMD_H2C_ADDR_CAM_NET_TYPE_SH 1
#define FWCMD_H2C_ADDR_CAM_NET_TYPE_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_BCN_HIT_COND_SH 3
#define FWCMD_H2C_ADDR_CAM_BCN_HIT_COND_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_HIT_RULE_SH 5
#define FWCMD_H2C_ADDR_CAM_HIT_RULE_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_BB_SEL BIT(7)
#define FWCMD_H2C_ADDR_CAM_ADDR_MASK_SH 8
#define FWCMD_H2C_ADDR_CAM_ADDR_MASK_MSK 0x3f
#define FWCMD_H2C_ADDR_CAM_MASK_SEL_SH 14
#define FWCMD_H2C_ADDR_CAM_MASK_SEL_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SMA_HASH_SH 16
#define FWCMD_H2C_ADDR_CAM_SMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA_HASH_SH 24
#define FWCMD_H2C_ADDR_CAM_TMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_BSSID_CAM_IDX_SH 0
#define FWCMD_H2C_ADDR_CAM_BSSID_CAM_IDX_MSK 0x3f
#define FWCMD_H2C_ADDR_CAM_SMA0_SH 0
#define FWCMD_H2C_ADDR_CAM_SMA0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA1_SH 8
#define FWCMD_H2C_ADDR_CAM_SMA1_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA2_SH 16
#define FWCMD_H2C_ADDR_CAM_SMA2_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA3_SH 24
#define FWCMD_H2C_ADDR_CAM_SMA3_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA4_SH 0
#define FWCMD_H2C_ADDR_CAM_SMA4_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA5_SH 8
#define FWCMD_H2C_ADDR_CAM_SMA5_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA0_SH 16
#define FWCMD_H2C_ADDR_CAM_TMA0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA1_SH 24
#define FWCMD_H2C_ADDR_CAM_TMA1_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA2_SH 0
#define FWCMD_H2C_ADDR_CAM_TMA2_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA3_SH 8
#define FWCMD_H2C_ADDR_CAM_TMA3_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA4_SH 16
#define FWCMD_H2C_ADDR_CAM_TMA4_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA5_SH 24
#define FWCMD_H2C_ADDR_CAM_TMA5_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_MACID_SH 0
#define FWCMD_H2C_ADDR_CAM_MACID_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_PORT_INT_SH 8
#define FWCMD_H2C_ADDR_CAM_PORT_INT_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_TSF_SYNC_SH 11
#define FWCMD_H2C_ADDR_CAM_TSF_SYNC_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_TF_TRS BIT(14)
#define FWCMD_H2C_ADDR_CAM_LSIG_TXOP BIT(15)
#define FWCMD_H2C_ADDR_CAM_TGT_IND_SH 24
#define FWCMD_H2C_ADDR_CAM_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_FRM_TGT_IND_SH 27
#define FWCMD_H2C_ADDR_CAM_FRM_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_AID12_0_SH 0
#define FWCMD_H2C_ADDR_CAM_AID12_0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_AID12_1_SH 8
#define FWCMD_H2C_ADDR_CAM_AID12_1_MSK 0xf
#define FWCMD_H2C_ADDR_CAM_WOL_PATTERN BIT(12)
#define FWCMD_H2C_ADDR_CAM_WOL_UC BIT(13)
#define FWCMD_H2C_ADDR_CAM_WOL_MAGIC BIT(14)
#define FWCMD_H2C_ADDR_CAM_WAPI BIT(15)
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_SH 8
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_SH 16
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_SH 24
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_SH 0
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_SH 8
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_SH 16
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_SH 24
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID_VALID BIT(0)
#define FWCMD_H2C_BSSID_CAM_BB_SEL BIT(1)
#define FWCMD_H2C_BSSID_CAM_MSK_SH 2
#define FWCMD_H2C_BSSID_CAM_MSK_MSK 0x3f
#define FWCMD_H2C_BSSID_CAM_BSS_COLOR_SH 8
#define FWCMD_H2C_BSSID_CAM_BSS_COLOR_MSK 0x7f
#define FWCMD_H2C_BSSID_CAM_BSSID0_SH 16
#define FWCMD_H2C_BSSID_CAM_BSSID0_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID1_SH 24
#define FWCMD_H2C_BSSID_CAM_BSSID1_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID2_SH 0
#define FWCMD_H2C_BSSID_CAM_BSSID2_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID3_SH 8
#define FWCMD_H2C_BSSID_CAM_BSSID3_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID4_SH 16
#define FWCMD_H2C_BSSID_CAM_BSSID4_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID5_SH 24
#define FWCMD_H2C_BSSID_CAM_BSSID5_MSK 0xff
#define FWCMD_H2C_SEC_CAM_SEC_TYPE_SH 0
#define FWCMD_H2C_SEC_CAM_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_SEC_CAM_EXT_KEY BIT(4)
#define FWCMD_H2C_SEC_CAM_SPP_MODE BIT(5)
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_TBLUD_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_TBLUD_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D0_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D0_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D1_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D1_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D2_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D2_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D3_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D3_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_FORCE_SUMURU_EN BIT(0)
#define FWCMD_H2C_FIXMODE_PARA_FORCESU BIT(1)
#define FWCMD_H2C_FIXMODE_PARA_FORCEMU BIT(2)
#define FWCMD_H2C_FIXMODE_PARA_FORCERU BIT(3)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_SU_EN BIT(4)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_VHTMU_EN BIT(5)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_HEMU_EN BIT(6)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_HERU_EN BIT(7)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_UL_EN BIT(8)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_SU BIT(9)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_VHTMU BIT(10)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_HEMU BIT(11)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_HERU BIT(12)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_UL BIT(13)
#define FWCMD_H2C_FIXMODE_PARA_IS_DLRUHWGRP BIT(14)
#define FWCMD_H2C_FIXMODE_PARA_IS_ULRUHWGRP BIT(15)
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_SU_SH 16
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_SU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_VHTMU_SH 20
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_VHTMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_VHTMU_SH 24
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_VHTMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HEMU_SH 28
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HEMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HEMU_SH 0
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HEMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HERU_SH 4
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HERU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HERU_SH 8
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HERU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_UL_PROT_TYPE_SH 12
#define FWCMD_H2C_FIXMODE_PARA_UL_PROT_TYPE_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RUGRPID_SH 16
#define FWCMD_H2C_FIXMODE_PARA_RUGRPID_MSK 0x1f
#define FWCMD_H2C_FIXMODE_PARA_MUGRPID_SH 21
#define FWCMD_H2C_FIXMODE_PARA_MUGRPID_MSK 0x1f
#define FWCMD_H2C_FIXMODE_PARA_ULGRPID_SH 26
#define FWCMD_H2C_FIXMODE_PARA_ULGRPID_MSK 0x1f
#define FWCMD_H2C_FIXMODE_PARA_BAND BIT(31)
#define FWCMD_H2C_FIXMODE_PARA_FIX_TXCMDNUM_EN BIT(0)
#define FWCMD_H2C_FIXMODE_PARA_FORCE_TO_ONE BIT(1)
#define FWCMD_H2C_FIXMODE_PARA_SET_ULMODE BIT(2)
#define FWCMD_H2C_FIXMODE_PARA_ULMODE_SH 3
#define FWCMD_H2C_FIXMODE_PARA_ULMODE_MSK 0x3
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_UL_MU_EN BIT(5)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_UL_MU BIT(6)
#define FWCMD_H2C_FIXMODE_PARA_IS_ULMUHWGRP BIT(7)
#define FWCMD_H2C_FIXMODE_PARA_UL_MU_PROT_TYPE_SH 8
#define FWCMD_H2C_FIXMODE_PARA_UL_MU_PROT_TYPE_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_MACID_EXT_SH 12
#define FWCMD_H2C_FIXMODE_PARA_MACID_EXT_MSK 0xfff
#define FWCMD_H2C_FIXMODE_PARA_FIX_WEIGHTED BIT(24)
#define FWCMD_H2C_FIXMODE_PARA_SURUWEIGHTED_EN BIT(25)
#define FWCMD_H2C_FIXMODE_PARA_FIX_RURATIOREQUESTBYDRIVERMODE BIT(26)
#define FWCMD_H2C_FIXMODE_PARA_RURATIOREQUESTBYDRIVERMODE_EN BIT(27)
#define FWCMD_H2C_FIXMODE_PARA_RUTXWEIGHTED_SH 0
#define FWCMD_H2C_FIXMODE_PARA_RUTXWEIGHTED_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_SUTXWEIGHTED_SH 4
#define FWCMD_H2C_FIXMODE_PARA_SUTXWEIGHTED_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RURATIOREQUESTBYDRIVERMODERATIO_SH 8
#define FWCMD_H2C_FIXMODE_PARA_RURATIOREQUESTBYDRIVERMODERATIO_MSK 0x7f
#define FWCMD_H2C_WRITE_OFLD_REQ_VALUE_LEN_SH 0
#define FWCMD_H2C_WRITE_OFLD_REQ_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_WRITE_OFLD_REQ_POLLING BIT(13)
#define FWCMD_H2C_WRITE_OFLD_REQ_MASK_EN BIT(14)
#define FWCMD_H2C_WRITE_OFLD_REQ_LS BIT(15)
#define FWCMD_H2C_WRITE_OFLD_REQ_OFLD_ID_SH 16
#define FWCMD_H2C_WRITE_OFLD_REQ_OFLD_ID_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_REQ_ENTRY_NUM_SH 24
#define FWCMD_H2C_WRITE_OFLD_REQ_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_REQ_OFFSET_SH 0
#define FWCMD_H2C_WRITE_OFLD_REQ_OFFSET_MSK 0xffff
#define FWCMD_H2C_READ_OFLD_REQ_VALUE_LEN_SH 0
#define FWCMD_H2C_READ_OFLD_REQ_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_READ_OFLD_REQ_LS BIT(15)
#define FWCMD_H2C_READ_OFLD_REQ_OFLD_ID_SH 16
#define FWCMD_H2C_READ_OFLD_REQ_OFLD_ID_MSK 0xff
#define FWCMD_H2C_READ_OFLD_REQ_ENTRY_NUM_SH 24
#define FWCMD_H2C_READ_OFLD_REQ_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_READ_OFLD_REQ_OFFSET_SH 0
#define FWCMD_H2C_READ_OFLD_REQ_OFFSET_MSK 0xffff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DEVICE_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DEVICE_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_HIOE_OP_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_HIOE_OP_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_INST_TYPE_SH 8
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_INST_TYPE_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DATA_MODE_SH 24
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DATA_MODE_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_REGISTER_ADDR_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_REGISTER_ADDR_MSK 0xffffffff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_H_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_H_MSK 0xffff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_L_SH 16
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_QOS_FIELD_H_SH 0
#define FWCMD_H2C_DCTRL_QOS_FIELD_H_MSK 0xff
#define FWCMD_H2C_DCTRL_HW_EXSEQ_MACID_SH 8
#define FWCMD_H2C_DCTRL_HW_EXSEQ_MACID_MSK 0x7f
#define FWCMD_H2C_DCTRL_QOS_FIELD_H_EN BIT(15)
#define FWCMD_H2C_DCTRL_AES_IV_L_SH 16
#define FWCMD_H2C_DCTRL_AES_IV_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_AES_IV_H_SH 0
#define FWCMD_H2C_DCTRL_AES_IV_H_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_SEQ0_SH 0
#define FWCMD_H2C_DCTRL_SEQ0_MSK 0xfff
#define FWCMD_H2C_DCTRL_SEQ1_SH 12
#define FWCMD_H2C_DCTRL_SEQ1_MSK 0xfff
#define FWCMD_H2C_DCTRL_AMSDU_MAX_LEN_SH 24
#define FWCMD_H2C_DCTRL_AMSDU_MAX_LEN_MSK 0x7
#define FWCMD_H2C_DCTRL_STA_AMSDU_EN BIT(27)
#define FWCMD_H2C_DCTRL_CHKSUM_OFLD_EN BIT(28)
#define FWCMD_H2C_DCTRL_WITH_LLC BIT(29)
#define FWCMD_H2C_DCTRL_SEC_HW_ENC BIT(31)
#define FWCMD_H2C_DCTRL_SEQ2_SH 0
#define FWCMD_H2C_DCTRL_SEQ2_MSK 0xfff
#define FWCMD_H2C_DCTRL_SEQ3_SH 12
#define FWCMD_H2C_DCTRL_SEQ3_MSK 0xfff
#define FWCMD_H2C_DCTRL_SEC_CAM_IDX_SH 24
#define FWCMD_H2C_DCTRL_SEC_CAM_IDX_MSK 0xff
#define FWCMD_H2C_CCTRL_DATARATE_SH 0
#define FWCMD_H2C_CCTRL_DATARATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_FORCE_TXOP BIT(9)
#define FWCMD_H2C_CCTRL_DATA_BW_SH 10
#define FWCMD_H2C_CCTRL_DATA_BW_MSK 0x3
#define FWCMD_H2C_CCTRL_DATA_GI_LTF_SH 12
#define FWCMD_H2C_CCTRL_DATA_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_DARF_TC_INDEX BIT(15)
#define FWCMD_H2C_CCTRL_ARFR_CTRL_SH 16
#define FWCMD_H2C_CCTRL_ARFR_CTRL_MSK 0xf
#define FWCMD_H2C_CCTRL_ACQ_RPT_EN BIT(20)
#define FWCMD_H2C_CCTRL_MGQ_RPT_EN BIT(21)
#define FWCMD_H2C_CCTRL_ULQ_RPT_EN BIT(22)
#define FWCMD_H2C_CCTRL_TWTQ_RPT_EN BIT(23)
#define FWCMD_H2C_CCTRL_DISRTSFB BIT(25)
#define FWCMD_H2C_CCTRL_DISDATAFB BIT(26)
#define FWCMD_H2C_CCTRL_TRYRATE BIT(27)
#define FWCMD_H2C_CCTRL_AMPDU_DENSITY_SH 28
#define FWCMD_H2C_CCTRL_AMPDU_DENSITY_MSK 0xf
#define FWCMD_H2C_CCTRL_DATA_RTY_LOWEST_RATE_SH 0
#define FWCMD_H2C_CCTRL_DATA_RTY_LOWEST_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_AMPDU_TIME_SEL BIT(9)
#define FWCMD_H2C_CCTRL_AMPDU_LEN_SEL BIT(10)
#define FWCMD_H2C_CCTRL_RTS_TXCNT_LMT_SEL BIT(11)
#define FWCMD_H2C_CCTRL_RTS_TXCNT_LMT_SH 12
#define FWCMD_H2C_CCTRL_RTS_TXCNT_LMT_MSK 0xf
#define FWCMD_H2C_CCTRL_RTSRATE_SH 16
#define FWCMD_H2C_CCTRL_RTSRATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_VCS_STBC BIT(27)
#define FWCMD_H2C_CCTRL_RTS_RTY_LOWEST_RATE_SH 28
#define FWCMD_H2C_CCTRL_RTS_RTY_LOWEST_RATE_MSK 0xf
#define FWCMD_H2C_CCTRL_DATA_TX_CNT_LMT_SH 0
#define FWCMD_H2C_CCTRL_DATA_TX_CNT_LMT_MSK 0x3f
#define FWCMD_H2C_CCTRL_DATA_TXCNT_LMT_SEL BIT(6)
#define FWCMD_H2C_CCTRL_MAX_AGG_NUM_SEL BIT(7)
#define FWCMD_H2C_CCTRL_RTS_EN BIT(8)
#define FWCMD_H2C_CCTRL_CTS2SELF_EN BIT(9)
#define FWCMD_H2C_CCTRL_CCA_RTS_SH 10
#define FWCMD_H2C_CCTRL_CCA_RTS_MSK 0x3
#define FWCMD_H2C_CCTRL_HW_RTS_EN BIT(12)
#define FWCMD_H2C_CCTRL_RTS_DROP_DATA_MODE_SH 13
#define FWCMD_H2C_CCTRL_RTS_DROP_DATA_MODE_MSK 0x3
#define FWCMD_H2C_CCTRL_PRELD_EN BIT(15)
#define FWCMD_H2C_CCTRL_AMPDU_MAX_LEN_SH 16
#define FWCMD_H2C_CCTRL_AMPDU_MAX_LEN_MSK 0x7ff
#define FWCMD_H2C_CCTRL_UL_MU_DIS BIT(27)
#define FWCMD_H2C_CCTRL_AMPDU_MAX_TIME_SH 28
#define FWCMD_H2C_CCTRL_AMPDU_MAX_TIME_MSK 0xf
#define FWCMD_H2C_CCTRL_MAX_AGG_NUM_SH 0
#define FWCMD_H2C_CCTRL_MAX_AGG_NUM_MSK 0xff
#define FWCMD_H2C_CCTRL_BA_BMAP_SH 8
#define FWCMD_H2C_CCTRL_BA_BMAP_MSK 0x3
#define FWCMD_H2C_CCTRL_VO_LFTIME_SEL_SH 16
#define FWCMD_H2C_CCTRL_VO_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_VI_LFTIME_SEL_SH 19
#define FWCMD_H2C_CCTRL_VI_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_BE_LFTIME_SEL_SH 22
#define FWCMD_H2C_CCTRL_BE_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_BK_LFTIME_SEL_SH 25
#define FWCMD_H2C_CCTRL_BK_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_SECTYPE_SH 28
#define FWCMD_H2C_CCTRL_SECTYPE_MSK 0xf
#define FWCMD_H2C_CCTRL_MULTI_PORT_ID_SH 0
#define FWCMD_H2C_CCTRL_MULTI_PORT_ID_MSK 0x7
#define FWCMD_H2C_CCTRL_BMC BIT(3)
#define FWCMD_H2C_CCTRL_MBSSID_SH 4
#define FWCMD_H2C_CCTRL_MBSSID_MSK 0xf
#define FWCMD_H2C_CCTRL_NAVUSEHDR BIT(8)
#define FWCMD_H2C_CCTRL_TXPWR_MODE_SH 9
#define FWCMD_H2C_CCTRL_TXPWR_MODE_MSK 0x7
#define FWCMD_H2C_CCTRL_DATA_DCM BIT(12)
#define FWCMD_H2C_CCTRL_DATA_ER BIT(13)
#define FWCMD_H2C_CCTRL_DATA_LDPC BIT(14)
#define FWCMD_H2C_CCTRL_DATA_STBC BIT(15)
#define FWCMD_H2C_CCTRL_A_CTRL_BQR BIT(16)
#define FWCMD_H2C_CCTRL_A_CTRL_UPH BIT(17)
#define FWCMD_H2C_CCTRL_A_CTRL_BSR BIT(18)
#define FWCMD_H2C_CCTRL_A_CTRL_CAS BIT(19)
#define FWCMD_H2C_CCTRL_DATA_BW_ER BIT(20)
#define FWCMD_H2C_CCTRL_LSIG_TXOP_EN BIT(21)
#define FWCMD_H2C_CCTRL_CTRL_CNT_VLD BIT(27)
#define FWCMD_H2C_CCTRL_CTRL_CNT_SH 28
#define FWCMD_H2C_CCTRL_CTRL_CNT_MSK 0xf
#define FWCMD_H2C_CCTRL_RESP_REF_RATE_SH 0
#define FWCMD_H2C_CCTRL_RESP_REF_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_ALL_ACK_SUPPORT BIT(12)
#define FWCMD_H2C_CCTRL_BSR_QUEUE_SIZE_FORMAT BIT(13)
#define FWCMD_H2C_CCTRL_NTX_PATH_EN_SH 16
#define FWCMD_H2C_CCTRL_NTX_PATH_EN_MSK 0xf
#define FWCMD_H2C_CCTRL_PATH_MAP_A_SH 20
#define FWCMD_H2C_CCTRL_PATH_MAP_A_MSK 0x3
#define FWCMD_H2C_CCTRL_PATH_MAP_B_SH 22
#define FWCMD_H2C_CCTRL_PATH_MAP_B_MSK 0x3
#define FWCMD_H2C_CCTRL_PATH_MAP_C_SH 24
#define FWCMD_H2C_CCTRL_PATH_MAP_C_MSK 0x3
#define FWCMD_H2C_CCTRL_PATH_MAP_D_SH 26
#define FWCMD_H2C_CCTRL_PATH_MAP_D_MSK 0x3
#define FWCMD_H2C_CCTRL_ANTSEL_A BIT(28)
#define FWCMD_H2C_CCTRL_ANTSEL_B BIT(29)
#define FWCMD_H2C_CCTRL_ANTSEL_C BIT(30)
#define FWCMD_H2C_CCTRL_ANTSEL_D BIT(31)
#define FWCMD_H2C_CCTRL_ADDR_CAM_INDEX_SH 0
#define FWCMD_H2C_CCTRL_ADDR_CAM_INDEX_MSK 0xff
#define FWCMD_H2C_CCTRL_PAID_SH 8
#define FWCMD_H2C_CCTRL_PAID_MSK 0x1ff
#define FWCMD_H2C_CCTRL_ULDL BIT(17)
#define FWCMD_H2C_CCTRL_DOPPLER_CTRL_SH 18
#define FWCMD_H2C_CCTRL_DOPPLER_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING_SH 20
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING_MSK 0x3
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING40_SH 22
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING40_MSK 0x3
#define FWCMD_H2C_CCTRL_TXPWR_TOLERENCE_SH 24
#define FWCMD_H2C_CCTRL_TXPWR_TOLERENCE_MSK 0x3f
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING80_SH 30
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING80_MSK 0x3
#define FWCMD_H2C_CCTRL_NC_SH 0
#define FWCMD_H2C_CCTRL_NC_MSK 0x7
#define FWCMD_H2C_CCTRL_NR_SH 3
#define FWCMD_H2C_CCTRL_NR_MSK 0x7
#define FWCMD_H2C_CCTRL_NG_SH 6
#define FWCMD_H2C_CCTRL_NG_MSK 0x3
#define FWCMD_H2C_CCTRL_CB_SH 8
#define FWCMD_H2C_CCTRL_CB_MSK 0x3
#define FWCMD_H2C_CCTRL_CS_SH 10
#define FWCMD_H2C_CCTRL_CS_MSK 0x3
#define FWCMD_H2C_CCTRL_CSI_TXBF_EN BIT(12)
#define FWCMD_H2C_CCTRL_CSI_STBC_EN BIT(13)
#define FWCMD_H2C_CCTRL_CSI_LDPC_EN BIT(14)
#define FWCMD_H2C_CCTRL_CSI_PARA_EN BIT(15)
#define FWCMD_H2C_CCTRL_CSI_FIX_RATE_SH 16
#define FWCMD_H2C_CCTRL_CSI_FIX_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_CSI_GI_LTF_SH 25
#define FWCMD_H2C_CCTRL_CSI_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING160_SH 28
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING160_MSK 0x3
#define FWCMD_H2C_CCTRL_CSI_BW_SH 30
#define FWCMD_H2C_CCTRL_CSI_BW_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_QOS_FIELD_H_SH 0
#define FWCMD_H2C_DCTRL_V1_QOS_FIELD_H_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_HW_EXSEQ_MACID_SH 8
#define FWCMD_H2C_DCTRL_V1_HW_EXSEQ_MACID_MSK 0x7f
#define FWCMD_H2C_DCTRL_V1_QOS_DATA BIT(15)
#define FWCMD_H2C_DCTRL_V1_AES_IV_L_SH 16
#define FWCMD_H2C_DCTRL_V1_AES_IV_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_V1_AES_IV_H_SH 0
#define FWCMD_H2C_DCTRL_V1_AES_IV_H_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_V1_SEQ0_SH 0
#define FWCMD_H2C_DCTRL_V1_SEQ0_MSK 0xfff
#define FWCMD_H2C_DCTRL_V1_SEQ1_SH 12
#define FWCMD_H2C_DCTRL_V1_SEQ1_MSK 0xfff
#define FWCMD_H2C_DCTRL_V1_AMSDU_MAX_LEN_SH 24
#define FWCMD_H2C_DCTRL_V1_AMSDU_MAX_LEN_MSK 0x7
#define FWCMD_H2C_DCTRL_V1_STA_AMSDU_EN BIT(27)
#define FWCMD_H2C_DCTRL_V1_CHKSUM_OFLD_EN BIT(28)
#define FWCMD_H2C_DCTRL_V1_WITH_LLC BIT(29)
#define FWCMD_H2C_DCTRL_V1_SEQ2_SH 0
#define FWCMD_H2C_DCTRL_V1_SEQ2_MSK 0xfff
#define FWCMD_H2C_DCTRL_V1_SEQ3_SH 12
#define FWCMD_H2C_DCTRL_V1_SEQ3_MSK 0xfff
#define FWCMD_H2C_DCTRL_V1_TGT_IND_SH 24
#define FWCMD_H2C_DCTRL_V1_TGT_IND_MSK 0xf
#define FWCMD_H2C_DCTRL_V1_TGT_IND_EN BIT(28)
#define FWCMD_H2C_DCTRL_V1_HTC_LB_SH 29
#define FWCMD_H2C_DCTRL_V1_HTC_LB_MSK 0x7
#define FWCMD_H2C_DCTRL_V1_MHDR_LEN_SH 0
#define FWCMD_H2C_DCTRL_V1_MHDR_LEN_MSK 0x1f
#define FWCMD_H2C_DCTRL_V1_VLAN_TAG_VALID BIT(5)
#define FWCMD_H2C_DCTRL_V1_VLAN_TAG_SEL_SH 6
#define FWCMD_H2C_DCTRL_V1_VLAN_TAG_SEL_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_HTC_ORDER BIT(8)
#define FWCMD_H2C_DCTRL_V1_SEC_KEY_ID_SH 9
#define FWCMD_H2C_DCTRL_V1_SEC_KEY_ID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_RVSD_SH 11
#define FWCMD_H2C_DCTRL_V1_RVSD_MSK 0xf
#define FWCMD_H2C_DCTRL_V1_WAPI BIT(15)
#define FWCMD_H2C_DCTRL_V1_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_DCTRL_V1_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_DCTRL_V1_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_DCTRL_V1_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_DCTRL_V1_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_DCTRL_V1_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_DCTRL_V1_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_DCTRL_V1_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_DCTRL_V1_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V1_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_DCTRL_V1_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT0_SH 8
#define FWCMD_H2C_DCTRL_V1_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT1_SH 16
#define FWCMD_H2C_DCTRL_V1_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT2_SH 24
#define FWCMD_H2C_DCTRL_V1_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT3_SH 0
#define FWCMD_H2C_DCTRL_V1_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT4_SH 8
#define FWCMD_H2C_DCTRL_V1_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT5_SH 16
#define FWCMD_H2C_DCTRL_V1_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_DCTRL_V1_SEC_ENT6_SH 24
#define FWCMD_H2C_DCTRL_V1_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_CCTRL_V1_DATARATE_SH 0
#define FWCMD_H2C_CCTRL_V1_DATARATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_V1_FORCE_TXOP BIT(9)
#define FWCMD_H2C_CCTRL_V1_DATA_BW_SH 10
#define FWCMD_H2C_CCTRL_V1_DATA_BW_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_DATA_GI_LTF_SH 12
#define FWCMD_H2C_CCTRL_V1_DATA_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_DARF_TC_INDEX BIT(15)
#define FWCMD_H2C_CCTRL_V1_ARFR_CTRL_SH 16
#define FWCMD_H2C_CCTRL_V1_ARFR_CTRL_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_ACQ_RPT_EN BIT(20)
#define FWCMD_H2C_CCTRL_V1_MGQ_RPT_EN BIT(21)
#define FWCMD_H2C_CCTRL_V1_ULQ_RPT_EN BIT(22)
#define FWCMD_H2C_CCTRL_V1_TWTQ_RPT_EN BIT(23)
#define FWCMD_H2C_CCTRL_V1_DISRTSFB BIT(25)
#define FWCMD_H2C_CCTRL_V1_DISDATAFB BIT(26)
#define FWCMD_H2C_CCTRL_V1_TRYRATE BIT(27)
#define FWCMD_H2C_CCTRL_V1_AMPDU_DENSITY_SH 28
#define FWCMD_H2C_CCTRL_V1_AMPDU_DENSITY_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_DATA_RTY_LOWEST_RATE_SH 0
#define FWCMD_H2C_CCTRL_V1_DATA_RTY_LOWEST_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_V1_AMPDU_TIME_SEL BIT(9)
#define FWCMD_H2C_CCTRL_V1_AMPDU_LEN_SEL BIT(10)
#define FWCMD_H2C_CCTRL_V1_RTS_TXCNT_LMT_SEL BIT(11)
#define FWCMD_H2C_CCTRL_V1_RTS_TXCNT_LMT_SH 12
#define FWCMD_H2C_CCTRL_V1_RTS_TXCNT_LMT_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_RTSRATE_SH 16
#define FWCMD_H2C_CCTRL_V1_RTSRATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_V1_VCS_STBC BIT(27)
#define FWCMD_H2C_CCTRL_V1_RTS_RTY_LOWEST_RATE_SH 28
#define FWCMD_H2C_CCTRL_V1_RTS_RTY_LOWEST_RATE_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_DATA_TX_CNT_LMT_SH 0
#define FWCMD_H2C_CCTRL_V1_DATA_TX_CNT_LMT_MSK 0x3f
#define FWCMD_H2C_CCTRL_V1_DATA_TXCNT_LMT_SEL BIT(6)
#define FWCMD_H2C_CCTRL_V1_MAX_AGG_NUM_SEL BIT(7)
#define FWCMD_H2C_CCTRL_V1_RTS_EN BIT(8)
#define FWCMD_H2C_CCTRL_V1_CTS2SELF_EN BIT(9)
#define FWCMD_H2C_CCTRL_V1_CCA_RTS_SH 10
#define FWCMD_H2C_CCTRL_V1_CCA_RTS_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_HW_RTS_EN BIT(12)
#define FWCMD_H2C_CCTRL_V1_RTS_DROP_DATA_MODE_SH 13
#define FWCMD_H2C_CCTRL_V1_RTS_DROP_DATA_MODE_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_PRELD_EN BIT(15)
#define FWCMD_H2C_CCTRL_V1_AMPDU_MAX_LEN_SH 16
#define FWCMD_H2C_CCTRL_V1_AMPDU_MAX_LEN_MSK 0x7ff
#define FWCMD_H2C_CCTRL_V1_UL_MU_DIS BIT(27)
#define FWCMD_H2C_CCTRL_V1_AMPDU_MAX_TIME_SH 28
#define FWCMD_H2C_CCTRL_V1_AMPDU_MAX_TIME_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_MAX_AGG_NUM_SH 0
#define FWCMD_H2C_CCTRL_V1_MAX_AGG_NUM_MSK 0xff
#define FWCMD_H2C_CCTRL_V1_BA_BMAP_SH 8
#define FWCMD_H2C_CCTRL_V1_BA_BMAP_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_VO_LFTIME_SEL_SH 16
#define FWCMD_H2C_CCTRL_V1_VO_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_VI_LFTIME_SEL_SH 19
#define FWCMD_H2C_CCTRL_V1_VI_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_BE_LFTIME_SEL_SH 22
#define FWCMD_H2C_CCTRL_V1_BE_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_BK_LFTIME_SEL_SH 25
#define FWCMD_H2C_CCTRL_V1_BK_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_MULTI_PORT_ID_SH 0
#define FWCMD_H2C_CCTRL_V1_MULTI_PORT_ID_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_BMC BIT(3)
#define FWCMD_H2C_CCTRL_V1_MBSSID_SH 4
#define FWCMD_H2C_CCTRL_V1_MBSSID_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_DATA_DCM BIT(12)
#define FWCMD_H2C_CCTRL_V1_DATA_ER BIT(13)
#define FWCMD_H2C_CCTRL_V1_DATA_LDPC BIT(14)
#define FWCMD_H2C_CCTRL_V1_DATA_STBC BIT(15)
#define FWCMD_H2C_CCTRL_V1_A_CTRL_BQR BIT(16)
#define FWCMD_H2C_CCTRL_V1_A_CTRL_UPH BIT(17)
#define FWCMD_H2C_CCTRL_V1_A_CTRL_BSR BIT(18)
#define FWCMD_H2C_CCTRL_V1_A_CTRL_CAS BIT(19)
#define FWCMD_H2C_CCTRL_V1_DATA_BW_ER BIT(20)
#define FWCMD_H2C_CCTRL_V1_LSIG_TXOP_EN BIT(21)
#define FWCMD_H2C_CCTRL_V1_CTRL_CNT_VLD BIT(27)
#define FWCMD_H2C_CCTRL_V1_CTRL_CNT_SH 28
#define FWCMD_H2C_CCTRL_V1_CTRL_CNT_MSK 0xf
#define FWCMD_H2C_CCTRL_V1_RESP_REF_RATE_SH 0
#define FWCMD_H2C_CCTRL_V1_RESP_REF_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_V1_ALL_ACK_SUPPORT BIT(12)
#define FWCMD_H2C_CCTRL_V1_BSR_QUEUE_SIZE_FORMAT BIT(13)
#define FWCMD_H2C_CCTRL_V1_BSR_OM_UPD_EN BIT(14)
#define FWCMD_H2C_CCTRL_V1_MACID_FWD_IDC BIT(15)
#define FWCMD_H2C_CCTRL_V1_ADDR_CAM_INDEX_SH 24
#define FWCMD_H2C_CCTRL_V1_ADDR_CAM_INDEX_MSK 0xff
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING20_SH 0
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING20_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING40_SH 2
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING40_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING80_SH 4
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING80_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING160_SH 6
#define FWCMD_H2C_CCTRL_V1_NOMINAL_PKT_PADDING160_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_PAID_SH 8
#define FWCMD_H2C_CCTRL_V1_PAID_MSK 0x1ff
#define FWCMD_H2C_CCTRL_V1_ULDL BIT(17)
#define FWCMD_H2C_CCTRL_V1_DOPPLER_CTRL_SH 18
#define FWCMD_H2C_CCTRL_V1_DOPPLER_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_TXPWR_TOLERENCE_SH 24
#define FWCMD_H2C_CCTRL_V1_TXPWR_TOLERENCE_MSK 0x3f
#define FWCMD_H2C_CCTRL_V1_NC_SH 0
#define FWCMD_H2C_CCTRL_V1_NC_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_NR_SH 3
#define FWCMD_H2C_CCTRL_V1_NR_MSK 0x7
#define FWCMD_H2C_CCTRL_V1_NG_SH 6
#define FWCMD_H2C_CCTRL_V1_NG_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_CB_SH 8
#define FWCMD_H2C_CCTRL_V1_CB_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_CS_SH 10
#define FWCMD_H2C_CCTRL_V1_CS_MSK 0x3
#define FWCMD_H2C_CCTRL_V1_CSI_TXBF_EN BIT(12)
#define FWCMD_H2C_CCTRL_V1_CSI_STBC_EN BIT(13)
#define FWCMD_H2C_CCTRL_V1_CSI_LDPC_EN BIT(14)
#define FWCMD_H2C_CCTRL_V1_CSI_PARA_EN BIT(15)
#define FWCMD_H2C_CCTRL_V1_CSI_FIX_RATE_SH 16
#define FWCMD_H2C_CCTRL_V1_CSI_FIX_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_V1_CSI_BW_SH 25
#define FWCMD_H2C_CCTRL_V1_CSI_BW_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_QOS_FIELD_H_SH 0
#define FWCMD_H2C_DCTRL_V2_QOS_FIELD_H_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_HW_EXSEQ_MACID_SH 8
#define FWCMD_H2C_DCTRL_V2_HW_EXSEQ_MACID_MSK 0x7f
#define FWCMD_H2C_DCTRL_V2_QOS_DATA BIT(15)
#define FWCMD_H2C_DCTRL_V2_AES_IV_L_SH 16
#define FWCMD_H2C_DCTRL_V2_AES_IV_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_V2_AES_IV_H_SH 0
#define FWCMD_H2C_DCTRL_V2_AES_IV_H_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_V2_SEQ0_SH 0
#define FWCMD_H2C_DCTRL_V2_SEQ0_MSK 0xfff
#define FWCMD_H2C_DCTRL_V2_SEQ1_SH 12
#define FWCMD_H2C_DCTRL_V2_SEQ1_MSK 0xfff
#define FWCMD_H2C_DCTRL_V2_AMSDU_MAX_LEN_SH 24
#define FWCMD_H2C_DCTRL_V2_AMSDU_MAX_LEN_MSK 0x7
#define FWCMD_H2C_DCTRL_V2_STA_AMSDU_EN BIT(27)
#define FWCMD_H2C_DCTRL_V2_CHKSUM_OFLD_EN BIT(28)
#define FWCMD_H2C_DCTRL_V2_WITH_LLC BIT(29)
#define FWCMD_H2C_DCTRL_V2_NAT25_EN BIT(30)
#define FWCMD_H2C_DCTRL_V2_IS_MLD BIT(31)
#define FWCMD_H2C_DCTRL_V2_SEQ2_SH 0
#define FWCMD_H2C_DCTRL_V2_SEQ2_MSK 0xfff
#define FWCMD_H2C_DCTRL_V2_SEQ3_SH 12
#define FWCMD_H2C_DCTRL_V2_SEQ3_MSK 0xfff
#define FWCMD_H2C_DCTRL_V2_TGT_IND_SH 24
#define FWCMD_H2C_DCTRL_V2_TGT_IND_MSK 0xf
#define FWCMD_H2C_DCTRL_V2_TGT_IND_EN BIT(28)
#define FWCMD_H2C_DCTRL_V2_HTC_LB_SH 29
#define FWCMD_H2C_DCTRL_V2_HTC_LB_MSK 0x7
#define FWCMD_H2C_DCTRL_V2_VLAN_TAG_SEL_SH 5
#define FWCMD_H2C_DCTRL_V2_VLAN_TAG_SEL_MSK 0x7
#define FWCMD_H2C_DCTRL_V2_HTC_ORDER BIT(8)
#define FWCMD_H2C_DCTRL_V2_SEC_KEY_ID_SH 9
#define FWCMD_H2C_DCTRL_V2_SEC_KEY_ID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_VLAN_RX_DYNAMIC_PCP_EN BIT(11)
#define FWCMD_H2C_DCTRL_V2_VLAN_RX_PKT_DROP BIT(12)
#define FWCMD_H2C_DCTRL_V2_VLAN_RX_VALID BIT(13)
#define FWCMD_H2C_DCTRL_V2_VLAN_TX_VALID BIT(14)
#define FWCMD_H2C_DCTRL_V2_WAPI BIT(15)
#define FWCMD_H2C_DCTRL_V2_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_DCTRL_V2_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_DCTRL_V2_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_DCTRL_V2_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_DCTRL_V2_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_DCTRL_V2_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_DCTRL_V2_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_DCTRL_V2_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_DCTRL_V2_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_DCTRL_V2_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_DCTRL_V2_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT0_SH 8
#define FWCMD_H2C_DCTRL_V2_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT1_SH 16
#define FWCMD_H2C_DCTRL_V2_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT2_SH 24
#define FWCMD_H2C_DCTRL_V2_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT3_SH 0
#define FWCMD_H2C_DCTRL_V2_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT4_SH 8
#define FWCMD_H2C_DCTRL_V2_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT5_SH 16
#define FWCMD_H2C_DCTRL_V2_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_SEC_ENT6_SH 24
#define FWCMD_H2C_DCTRL_V2_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_DCTRL_V2_MLD_SMA_L_SH 0
#define FWCMD_H2C_DCTRL_V2_MLD_SMA_L_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_V2_MLD_SMA_H_SH 0
#define FWCMD_H2C_DCTRL_V2_MLD_SMA_H_MSK 0xffff
#define FWCMD_H2C_DCTRL_V2_MLD_TMA_L_SH 16
#define FWCMD_H2C_DCTRL_V2_MLD_TMA_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_V2_MLD_TMA_H_SH 0
#define FWCMD_H2C_DCTRL_V2_MLD_TMA_H_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_V2_MLD_BSSID_MAC_L_SH 0
#define FWCMD_H2C_DCTRL_V2_MLD_BSSID_MAC_L_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_V2_MLD_BSSID_MAC_H_SH 0
#define FWCMD_H2C_DCTRL_V2_MLD_BSSID_MAC_H_MSK 0xffff
#define FWCMD_H2C_CCTRL_V2_DATARATE_SH 0
#define FWCMD_H2C_CCTRL_V2_DATARATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_V2_DATA_GI_LTF_SH 12
#define FWCMD_H2C_CCTRL_V2_DATA_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_TRYRATE BIT(15)
#define FWCMD_H2C_CCTRL_V2_ARFR_CTRL_SH 16
#define FWCMD_H2C_CCTRL_V2_ARFR_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_DIS_HE1SS_STBC BIT(18)
#define FWCMD_H2C_CCTRL_V2_ACQ_RPT_EN BIT(20)
#define FWCMD_H2C_CCTRL_V2_MGQ_RPT_EN BIT(21)
#define FWCMD_H2C_CCTRL_V2_ULQ_RPT_EN BIT(22)
#define FWCMD_H2C_CCTRL_V2_TWTQ_RPT_EN BIT(23)
#define FWCMD_H2C_CCTRL_V2_FORCE_TXOP BIT(24)
#define FWCMD_H2C_CCTRL_V2_DISRTSFB BIT(25)
#define FWCMD_H2C_CCTRL_V2_DISDATAFB BIT(26)
#define FWCMD_H2C_CCTRL_V2_NSTR_EN BIT(27)
#define FWCMD_H2C_CCTRL_V2_AMPDU_DENSITY_SH 28
#define FWCMD_H2C_CCTRL_V2_AMPDU_DENSITY_MSK 0xf
#define FWCMD_H2C_CCTRL_V2_DATA_RTY_LOWEST_RATE_SH 0
#define FWCMD_H2C_CCTRL_V2_DATA_RTY_LOWEST_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_V2_RTS_TXCNT_LMT_SH 12
#define FWCMD_H2C_CCTRL_V2_RTS_TXCNT_LMT_MSK 0xf
#define FWCMD_H2C_CCTRL_V2_RTSRATE_SH 16
#define FWCMD_H2C_CCTRL_V2_RTSRATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_V2_RTS_RTY_LOWEST_RATE_SH 28
#define FWCMD_H2C_CCTRL_V2_RTS_RTY_LOWEST_RATE_MSK 0xf
#define FWCMD_H2C_CCTRL_V2_DATA_TX_CNT_LMT_SH 0
#define FWCMD_H2C_CCTRL_V2_DATA_TX_CNT_LMT_MSK 0x3f
#define FWCMD_H2C_CCTRL_V2_DATA_TXCNT_LMT_SEL BIT(6)
#define FWCMD_H2C_CCTRL_V2_MAX_AGG_NUM_SEL BIT(7)
#define FWCMD_H2C_CCTRL_V2_RTS_EN BIT(8)
#define FWCMD_H2C_CCTRL_V2_CTS2SELF_EN BIT(9)
#define FWCMD_H2C_CCTRL_V2_CCA_RTS_SH 10
#define FWCMD_H2C_CCTRL_V2_CCA_RTS_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_HW_RTS_EN BIT(12)
#define FWCMD_H2C_CCTRL_V2_RTS_DROP_DATA_MODE_SH 13
#define FWCMD_H2C_CCTRL_V2_RTS_DROP_DATA_MODE_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_PRELD_EN BIT(15)
#define FWCMD_H2C_CCTRL_V2_AMPDU_MAX_LEN_SH 16
#define FWCMD_H2C_CCTRL_V2_AMPDU_MAX_LEN_MSK 0x7ff
#define FWCMD_H2C_CCTRL_V2_UL_MU_DIS BIT(27)
#define FWCMD_H2C_CCTRL_V2_AMPDU_MAX_TIME_SH 28
#define FWCMD_H2C_CCTRL_V2_AMPDU_MAX_TIME_MSK 0xf
#define FWCMD_H2C_CCTRL_V2_MAX_AGG_NUM_SH 0
#define FWCMD_H2C_CCTRL_V2_MAX_AGG_NUM_MSK 0xff
#define FWCMD_H2C_CCTRL_V2_DATA_BW_SH 8
#define FWCMD_H2C_CCTRL_V2_DATA_BW_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_DATA_BW_ER BIT(11)
#define FWCMD_H2C_CCTRL_V2_BA_BMAP_SH 12
#define FWCMD_H2C_CCTRL_V2_BA_BMAP_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_VCS_STBC BIT(15)
#define FWCMD_H2C_CCTRL_V2_VO_LFTIME_SEL_SH 16
#define FWCMD_H2C_CCTRL_V2_VO_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_VI_LFTIME_SEL_SH 19
#define FWCMD_H2C_CCTRL_V2_VI_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_BE_LFTIME_SEL_SH 22
#define FWCMD_H2C_CCTRL_V2_BE_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_BK_LFTIME_SEL_SH 25
#define FWCMD_H2C_CCTRL_V2_BK_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_AMPDU_TIME_SEL BIT(28)
#define FWCMD_H2C_CCTRL_V2_AMPDU_LEN_SEL BIT(29)
#define FWCMD_H2C_CCTRL_V2_RTS_TXCNT_LMT_SEL BIT(30)
#define FWCMD_H2C_CCTRL_V2_LSIG_TXOP_EN BIT(31)
#define FWCMD_H2C_CCTRL_V2_MULTI_PORT_ID_SH 0
#define FWCMD_H2C_CCTRL_V2_MULTI_PORT_ID_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_BYPASS_PUNC BIT(3)
#define FWCMD_H2C_CCTRL_V2_MBSSID_SH 4
#define FWCMD_H2C_CCTRL_V2_MBSSID_MSK 0xf
#define FWCMD_H2C_CCTRL_V2_DATA_DCM BIT(8)
#define FWCMD_H2C_CCTRL_V2_DATA_ER BIT(9)
#define FWCMD_H2C_CCTRL_V2_DATA_LDPC BIT(10)
#define FWCMD_H2C_CCTRL_V2_DATA_STBC BIT(11)
#define FWCMD_H2C_CCTRL_V2_A_CTRL_BQR BIT(12)
#define FWCMD_H2C_CCTRL_V2_A_CTRL_BSR BIT(14)
#define FWCMD_H2C_CCTRL_V2_A_CTRL_CAS BIT(15)
#define FWCMD_H2C_CCTRL_V2_ACT_SUBCH_CBW_SH 16
#define FWCMD_H2C_CCTRL_V2_ACT_SUBCH_CBW_MSK 0xffff
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING0_SH 0
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING0_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING1_SH 2
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING1_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING2_SH 4
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING2_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING3_SH 6
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING3_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING4_SH 8
#define FWCMD_H2C_CCTRL_V2_NOMINAL_PKT_PADDING4_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_DOPPLER_CTRL_SH 10
#define FWCMD_H2C_CCTRL_V2_DOPPLER_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_ALL_ACK_SUPPORT BIT(12)
#define FWCMD_H2C_CCTRL_V2_BSR_QUEUE_SIZE_FORMAT BIT(13)
#define FWCMD_H2C_CCTRL_V2_BSR_OM_UPD_EN BIT(14)
#define FWCMD_H2C_CCTRL_V2_MACID_FWD_IDC BIT(15)
#define FWCMD_H2C_CCTRL_V2_FIX_UL_ADDRCAM_IDX BIT(18)
#define FWCMD_H2C_CCTRL_V2_CTRL_CNT_VLD BIT(19)
#define FWCMD_H2C_CCTRL_V2_CTRL_CNT_SH 20
#define FWCMD_H2C_CCTRL_V2_CTRL_CNT_MSK 0xf
#define FWCMD_H2C_CCTRL_V2_ADDR_CAM_INDEX_SH 24
#define FWCMD_H2C_CCTRL_V2_ADDR_CAM_INDEX_MSK 0xff
#define FWCMD_H2C_CCTRL_V2_AID12_PAID_SH 0
#define FWCMD_H2C_CCTRL_V2_AID12_PAID_MSK 0xfff
#define FWCMD_H2C_CCTRL_V2_RESP_REF_RATE_SH 12
#define FWCMD_H2C_CCTRL_V2_RESP_REF_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_V2_TXPWR_TOLERENCE_SH 24
#define FWCMD_H2C_CCTRL_V2_TXPWR_TOLERENCE_MSK 0x3f
#define FWCMD_H2C_CCTRL_V2_ULDL BIT(31)
#define FWCMD_H2C_CCTRL_V2_NC_SH 0
#define FWCMD_H2C_CCTRL_V2_NC_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_NR_SH 3
#define FWCMD_H2C_CCTRL_V2_NR_MSK 0x7
#define FWCMD_H2C_CCTRL_V2_NG_SH 6
#define FWCMD_H2C_CCTRL_V2_NG_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_CB_SH 8
#define FWCMD_H2C_CCTRL_V2_CB_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_CS_SH 10
#define FWCMD_H2C_CCTRL_V2_CS_MSK 0x3
#define FWCMD_H2C_CCTRL_V2_CSI_STBC_EN BIT(13)
#define FWCMD_H2C_CCTRL_V2_CSI_LDPC_EN BIT(14)
#define FWCMD_H2C_CCTRL_V2_CSI_PARA_EN BIT(15)
#define FWCMD_H2C_CCTRL_V2_CSI_FIX_RATE_SH 16
#define FWCMD_H2C_CCTRL_V2_CSI_FIX_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_V2_CSI_BW_SH 29
#define FWCMD_H2C_CCTRL_V2_CSI_BW_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_DATARATE_SH 0
#define FWCMD_H2C_CCTRL_G7_DATARATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_DATA_GI_LTF_SH 12
#define FWCMD_H2C_CCTRL_G7_DATA_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_TRYRATE BIT(15)
#define FWCMD_H2C_CCTRL_G7_ARFR_CTRL_SH 16
#define FWCMD_H2C_CCTRL_G7_ARFR_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_DIS_HE1SS_STBC BIT(18)
#define FWCMD_H2C_CCTRL_G7_ACQ_RPT_EN BIT(20)
#define FWCMD_H2C_CCTRL_G7_MGQ_RPT_EN BIT(21)
#define FWCMD_H2C_CCTRL_G7_ULQ_RPT_EN BIT(22)
#define FWCMD_H2C_CCTRL_G7_TWTQ_RPT_EN BIT(23)
#define FWCMD_H2C_CCTRL_G7_FORCE_TXOP BIT(24)
#define FWCMD_H2C_CCTRL_G7_DISRTSFB BIT(25)
#define FWCMD_H2C_CCTRL_G7_DISDATAFB BIT(26)
#define FWCMD_H2C_CCTRL_G7_NSTR_EN BIT(27)
#define FWCMD_H2C_CCTRL_G7_AMPDU_DENSITY_SH 28
#define FWCMD_H2C_CCTRL_G7_AMPDU_DENSITY_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_DATA_RTY_LOWEST_RATE_SH 0
#define FWCMD_H2C_CCTRL_G7_DATA_RTY_LOWEST_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_RTS_TXCNT_LMT_SH 12
#define FWCMD_H2C_CCTRL_G7_RTS_TXCNT_LMT_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_RTSRATE_SH 16
#define FWCMD_H2C_CCTRL_G7_RTSRATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_RTS_RTY_LOWEST_RATE_SH 28
#define FWCMD_H2C_CCTRL_G7_RTS_RTY_LOWEST_RATE_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_DATA_TX_CNT_LMT_SH 0
#define FWCMD_H2C_CCTRL_G7_DATA_TX_CNT_LMT_MSK 0x3f
#define FWCMD_H2C_CCTRL_G7_DATA_TXCNT_LMT_SEL BIT(6)
#define FWCMD_H2C_CCTRL_G7_MAX_AGG_NUM_SEL BIT(7)
#define FWCMD_H2C_CCTRL_G7_RTS_EN BIT(8)
#define FWCMD_H2C_CCTRL_G7_CTS2SELF_EN BIT(9)
#define FWCMD_H2C_CCTRL_G7_CCA_RTS_SH 10
#define FWCMD_H2C_CCTRL_G7_CCA_RTS_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_HW_RTS_EN BIT(12)
#define FWCMD_H2C_CCTRL_G7_RTS_DROP_DATA_MODE_SH 13
#define FWCMD_H2C_CCTRL_G7_RTS_DROP_DATA_MODE_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_PRELD_EN BIT(15)
#define FWCMD_H2C_CCTRL_G7_AMPDU_MAX_LEN_SH 16
#define FWCMD_H2C_CCTRL_G7_AMPDU_MAX_LEN_MSK 0x7ff
#define FWCMD_H2C_CCTRL_G7_UL_MU_DIS BIT(27)
#define FWCMD_H2C_CCTRL_G7_AMPDU_MAX_TIME_SH 28
#define FWCMD_H2C_CCTRL_G7_AMPDU_MAX_TIME_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_MAX_AGG_NUM_SH 0
#define FWCMD_H2C_CCTRL_G7_MAX_AGG_NUM_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_DATA_BW_SH 8
#define FWCMD_H2C_CCTRL_G7_DATA_BW_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_DATA_BW_ER BIT(11)
#define FWCMD_H2C_CCTRL_G7_BA_BMAP_SH 12
#define FWCMD_H2C_CCTRL_G7_BA_BMAP_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_VCS_STBC BIT(15)
#define FWCMD_H2C_CCTRL_G7_VO_LFTIME_SEL_SH 16
#define FWCMD_H2C_CCTRL_G7_VO_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_VI_LFTIME_SEL_SH 19
#define FWCMD_H2C_CCTRL_G7_VI_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_BE_LFTIME_SEL_SH 22
#define FWCMD_H2C_CCTRL_G7_BE_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_BK_LFTIME_SEL_SH 25
#define FWCMD_H2C_CCTRL_G7_BK_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_AMPDU_TIME_SEL BIT(28)
#define FWCMD_H2C_CCTRL_G7_AMPDU_LEN_SEL BIT(29)
#define FWCMD_H2C_CCTRL_G7_RTS_TXCNT_LMT_SEL BIT(30)
#define FWCMD_H2C_CCTRL_G7_LSIG_TXOP_EN BIT(31)
#define FWCMD_H2C_CCTRL_G7_MULTI_PORT_ID_SH 0
#define FWCMD_H2C_CCTRL_G7_MULTI_PORT_ID_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_BYPASS_PUNC BIT(3)
#define FWCMD_H2C_CCTRL_G7_MBSSID_SH 4
#define FWCMD_H2C_CCTRL_G7_MBSSID_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_DATA_DCM BIT(8)
#define FWCMD_H2C_CCTRL_G7_DATA_ER BIT(9)
#define FWCMD_H2C_CCTRL_G7_DATA_LDPC BIT(10)
#define FWCMD_H2C_CCTRL_G7_DATA_STBC BIT(11)
#define FWCMD_H2C_CCTRL_G7_A_CTRL_BQR BIT(12)
#define FWCMD_H2C_CCTRL_G7_A_CTRL_BSR BIT(14)
#define FWCMD_H2C_CCTRL_G7_A_CTRL_CAS BIT(15)
#define FWCMD_H2C_CCTRL_G7_ACT_SUBCH_CBW_SH 16
#define FWCMD_H2C_CCTRL_G7_ACT_SUBCH_CBW_MSK 0xffff
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING0_SH 0
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING0_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING1_SH 2
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING1_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING2_SH 4
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING2_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING3_SH 6
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING3_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING4_SH 8
#define FWCMD_H2C_CCTRL_G7_NOMINAL_PKT_PADDING4_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_SR_RATE_SH 10
#define FWCMD_H2C_CCTRL_G7_SR_RATE_MSK 0x1f
#define FWCMD_H2C_CCTRL_G7_TID_DISABLE_SH 16
#define FWCMD_H2C_CCTRL_G7_TID_DISABLE_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_ADDR_CAM_INDEX_SH 24
#define FWCMD_H2C_CCTRL_G7_ADDR_CAM_INDEX_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_AID12_PAID_SH 0
#define FWCMD_H2C_CCTRL_G7_AID12_PAID_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_RESP_REF_RATE_SH 12
#define FWCMD_H2C_CCTRL_G7_RESP_REF_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_ULDL BIT(31)
#define FWCMD_H2C_CCTRL_G7_NC_SH 0
#define FWCMD_H2C_CCTRL_G7_NC_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_NR_SH 3
#define FWCMD_H2C_CCTRL_G7_NR_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_NG_SH 6
#define FWCMD_H2C_CCTRL_G7_NG_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_CB_SH 8
#define FWCMD_H2C_CCTRL_G7_CB_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_CS_SH 10
#define FWCMD_H2C_CCTRL_G7_CS_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_CSI_STBC_EN BIT(13)
#define FWCMD_H2C_CCTRL_G7_CSI_LDPC_EN BIT(14)
#define FWCMD_H2C_CCTRL_G7_CSI_PARA_EN BIT(15)
#define FWCMD_H2C_CCTRL_G7_CSI_FIX_RATE_SH 16
#define FWCMD_H2C_CCTRL_G7_CSI_FIX_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_CSI_BW_SH 29
#define FWCMD_H2C_CCTRL_G7_CSI_BW_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_ALL_ACK_SUPPORT BIT(0)
#define FWCMD_H2C_CCTRL_G7_BSR_QUEUE_SIZE_FORMAT BIT(1)
#define FWCMD_H2C_CCTRL_G7_BSR_OM_UPD_EN BIT(2)
#define FWCMD_H2C_CCTRL_G7_MACID_FWD_IDC BIT(3)
#define FWCMD_H2C_CCTRL_G7_AZ_SEC_EN BIT(4)
#define FWCMD_H2C_CCTRL_G7_CSI_SEC_EN BIT(5)
#define FWCMD_H2C_CCTRL_G7_FIX_UL_ADDRCAM_IDX BIT(6)
#define FWCMD_H2C_CCTRL_G7_CTRL_CNT_VLD BIT(7)
#define FWCMD_H2C_CCTRL_G7_CTRL_CNT_SH 8
#define FWCMD_H2C_CCTRL_G7_CTRL_CNT_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_RESP_SEC_TYPE_SH 12
#define FWCMD_H2C_CCTRL_G7_RESP_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_VO_CURR_RATE_SH 0
#define FWCMD_H2C_CCTRL_G7_VO_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_VI_CURR_RATE_SH 12
#define FWCMD_H2C_CCTRL_G7_VI_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_BE_CURR_RATE_L_SH 24
#define FWCMD_H2C_CCTRL_G7_BE_CURR_RATE_L_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_BE_CURR_RATE_H_SH 0
#define FWCMD_H2C_CCTRL_G7_BE_CURR_RATE_H_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_BK_CURR_RATE_SH 4
#define FWCMD_H2C_CCTRL_G7_BK_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_MGNT_CURR_RATE_SH 16
#define FWCMD_H2C_CCTRL_G7_MGNT_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_MACID_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_MACID_MSK 0x3ff
#define FWCMD_H2C_CCTRL_G7_V1_OP BIT(10)
#define FWCMD_H2C_CCTRL_G7_V1_DATARATE_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_DATARATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_DATA_GI_LTF_SH 12
#define FWCMD_H2C_CCTRL_G7_V1_DATA_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_TRYRATE BIT(15)
#define FWCMD_H2C_CCTRL_G7_V1_ARFR_CTRL_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_ARFR_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_DIS_HE1SS_STBC BIT(18)
#define FWCMD_H2C_CCTRL_G7_V1_ACQ_RPT_EN BIT(20)
#define FWCMD_H2C_CCTRL_G7_V1_MGQ_RPT_EN BIT(21)
#define FWCMD_H2C_CCTRL_G7_V1_ULQ_RPT_EN BIT(22)
#define FWCMD_H2C_CCTRL_G7_V1_TWTQ_RPT_EN BIT(23)
#define FWCMD_H2C_CCTRL_G7_V1_FORCE_TXOP BIT(24)
#define FWCMD_H2C_CCTRL_G7_V1_DISRTSFB BIT(25)
#define FWCMD_H2C_CCTRL_G7_V1_DISDATAFB BIT(26)
#define FWCMD_H2C_CCTRL_G7_V1_NSTR_EN BIT(27)
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_DENSITY_SH 28
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_DENSITY_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_DATA_RTY_LOWEST_RATE_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_DATA_RTY_LOWEST_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_RTS_TXCNT_LMT_SH 12
#define FWCMD_H2C_CCTRL_G7_V1_RTS_TXCNT_LMT_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_RTSRATE_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_RTSRATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_RTS_RTY_LOWEST_RATE_SH 28
#define FWCMD_H2C_CCTRL_G7_V1_RTS_RTY_LOWEST_RATE_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_DATA_TX_CNT_LMT_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_DATA_TX_CNT_LMT_MSK 0x3f
#define FWCMD_H2C_CCTRL_G7_V1_DATA_TXCNT_LMT_SEL BIT(6)
#define FWCMD_H2C_CCTRL_G7_V1_MAX_AGG_NUM_SEL BIT(7)
#define FWCMD_H2C_CCTRL_G7_V1_RTS_EN BIT(8)
#define FWCMD_H2C_CCTRL_G7_V1_CTS2SELF_EN BIT(9)
#define FWCMD_H2C_CCTRL_G7_V1_CCA_RTS_SH 10
#define FWCMD_H2C_CCTRL_G7_V1_CCA_RTS_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_HW_RTS_EN BIT(12)
#define FWCMD_H2C_CCTRL_G7_V1_RTS_DROP_DATA_MODE_SH 13
#define FWCMD_H2C_CCTRL_G7_V1_RTS_DROP_DATA_MODE_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_PRELD_EN BIT(15)
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_MAX_LEN_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_MAX_LEN_MSK 0x7ff
#define FWCMD_H2C_CCTRL_G7_V1_UL_MU_DIS BIT(27)
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_MAX_TIME_SH 28
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_MAX_TIME_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_MAX_AGG_NUM_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_MAX_AGG_NUM_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_V1_DATA_BW_SH 8
#define FWCMD_H2C_CCTRL_G7_V1_DATA_BW_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_DATA_BW_ER BIT(11)
#define FWCMD_H2C_CCTRL_G7_V1_BA_BMAP_SH 12
#define FWCMD_H2C_CCTRL_G7_V1_BA_BMAP_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_VCS_STBC BIT(15)
#define FWCMD_H2C_CCTRL_G7_V1_VO_LFTIME_SEL_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_VO_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_VI_LFTIME_SEL_SH 19
#define FWCMD_H2C_CCTRL_G7_V1_VI_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_BE_LFTIME_SEL_SH 22
#define FWCMD_H2C_CCTRL_G7_V1_BE_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_BK_LFTIME_SEL_SH 25
#define FWCMD_H2C_CCTRL_G7_V1_BK_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_TIME_SEL BIT(28)
#define FWCMD_H2C_CCTRL_G7_V1_AMPDU_LEN_SEL BIT(29)
#define FWCMD_H2C_CCTRL_G7_V1_RTS_TXCNT_LMT_SEL BIT(30)
#define FWCMD_H2C_CCTRL_G7_V1_LSIG_TXOP_EN BIT(31)
#define FWCMD_H2C_CCTRL_G7_V1_MULTI_PORT_ID_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_MULTI_PORT_ID_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_BYPASS_PUNC BIT(3)
#define FWCMD_H2C_CCTRL_G7_V1_MBSSID_SH 4
#define FWCMD_H2C_CCTRL_G7_V1_MBSSID_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_TID_DISABLE_SH 8
#define FWCMD_H2C_CCTRL_G7_V1_TID_DISABLE_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_V1_ACT_SUBCH_CBW_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_ACT_SUBCH_CBW_MSK 0xffff
#define FWCMD_H2C_CCTRL_G7_V1_ADDR_CAM_INDEX_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_ADDR_CAM_INDEX_MSK 0x3ff
#define FWCMD_H2C_CCTRL_G7_V1_A_CTRL_BQR BIT(15)
#define FWCMD_H2C_CCTRL_G7_V1_A_CTRL_BSR BIT(16)
#define FWCMD_H2C_CCTRL_G7_V1_A_CTRL_CAS BIT(17)
#define FWCMD_H2C_CCTRL_G7_V1_DATA_ER BIT(18)
#define FWCMD_H2C_CCTRL_G7_V1_DATA_DCM BIT(19)
#define FWCMD_H2C_CCTRL_G7_V1_DATA_LDPC BIT(20)
#define FWCMD_H2C_CCTRL_G7_V1_DATA_STBC BIT(21)
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING0_SH 22
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING0_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING1_SH 24
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING1_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING2_SH 26
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING2_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING3_SH 28
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING3_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING4_SH 30
#define FWCMD_H2C_CCTRL_G7_V1_NOMINAL_PKT_PADDING4_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_AID12_PAID_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_AID12_PAID_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_RESP_REF_RATE_SH 12
#define FWCMD_H2C_CCTRL_G7_V1_RESP_REF_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_ULDL BIT(31)
#define FWCMD_H2C_CCTRL_G7_V1_NC_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_NC_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_NR_SH 3
#define FWCMD_H2C_CCTRL_G7_V1_NR_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_NG_SH 6
#define FWCMD_H2C_CCTRL_G7_V1_NG_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_CB_SH 8
#define FWCMD_H2C_CCTRL_G7_V1_CB_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_CS_SH 10
#define FWCMD_H2C_CCTRL_G7_V1_CS_MSK 0x3
#define FWCMD_H2C_CCTRL_G7_V1_CSI_STBC_EN BIT(13)
#define FWCMD_H2C_CCTRL_G7_V1_CSI_LDPC_EN BIT(14)
#define FWCMD_H2C_CCTRL_G7_V1_CSI_PARA_EN BIT(15)
#define FWCMD_H2C_CCTRL_G7_V1_CSI_FIX_RATE_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_CSI_FIX_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_CSI_BW_SH 29
#define FWCMD_H2C_CCTRL_G7_V1_CSI_BW_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_ALL_ACK_SUPPORT BIT(0)
#define FWCMD_H2C_CCTRL_G7_V1_BSR_QUEUE_SIZE_FORMAT BIT(1)
#define FWCMD_H2C_CCTRL_G7_V1_BSR_OM_UPD_EN BIT(2)
#define FWCMD_H2C_CCTRL_G7_V1_MACID_FWD_IDC BIT(3)
#define FWCMD_H2C_CCTRL_G7_V1_AZ_SEC_EN BIT(4)
#define FWCMD_H2C_CCTRL_G7_V1_BF_SEC_EN BIT(5)
#define FWCMD_H2C_CCTRL_G7_V1_FIX_UL_ADDRCAM_IDX BIT(6)
#define FWCMD_H2C_CCTRL_G7_V1_CTRL_CNT_VLD BIT(7)
#define FWCMD_H2C_CCTRL_G7_V1_CTRL_CNT_SH 8
#define FWCMD_H2C_CCTRL_G7_V1_CTRL_CNT_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_RESP_SEC_TYPE_SH 12
#define FWCMD_H2C_CCTRL_G7_V1_RESP_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_EMLSR_TRANS_DLY_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_EMLSR_TRANS_DLY_MSK 0x7
#define FWCMD_H2C_CCTRL_G7_V1_SR_MCS_SU_SH 3
#define FWCMD_H2C_CCTRL_G7_V1_SR_MCS_SU_MSK 0x1f
#define FWCMD_H2C_CCTRL_G7_V1_SR_MCS_RU_SH 8
#define FWCMD_H2C_CCTRL_G7_V1_SR_MCS_RU_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_VO_CURR_RATE_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_VO_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_VI_CURR_RATE_SH 12
#define FWCMD_H2C_CCTRL_G7_V1_VI_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_BE_CURR_RATE_L_SH 24
#define FWCMD_H2C_CCTRL_G7_V1_BE_CURR_RATE_L_MSK 0xff
#define FWCMD_H2C_CCTRL_G7_V1_BE_CURR_RATE_H_SH 0
#define FWCMD_H2C_CCTRL_G7_V1_BE_CURR_RATE_H_MSK 0xf
#define FWCMD_H2C_CCTRL_G7_V1_BK_CURR_RATE_SH 4
#define FWCMD_H2C_CCTRL_G7_V1_BK_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_CCTRL_G7_V1_MGNT_CURR_RATE_SH 16
#define FWCMD_H2C_CCTRL_G7_V1_MGNT_CURR_RATE_MSK 0xfff
#define FWCMD_H2C_IE_CAM_INFO_TYPE_SH 0
#define FWCMD_H2C_IE_CAM_INFO_TYPE_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA0_SH 8
#define FWCMD_H2C_IE_CAM_INFO_DATA0_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA1_SH 16
#define FWCMD_H2C_IE_CAM_INFO_DATA1_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA2_SH 24
#define FWCMD_H2C_IE_CAM_INFO_DATA2_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA3_SH 0
#define FWCMD_H2C_IE_CAM_INFO_DATA3_MSK 0xff
#define FWCMD_H2C_PLAT_AUTO_TEST_D0_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D0_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D1_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D1_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D2_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D2_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D3_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D3_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D4_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D4_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D5_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D5_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D6_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D6_MSK 0xffffffff
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_FUNC_SH 0
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_FUNC_MSK 0x7f
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_ACK BIT(7)
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TOTAL_LEN_SH 8
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TOTAL_LEN_MSK 0xf
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_SEQ_NUM_SH 12
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_SEQ_NUM_MSK 0xf
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TX_EN_SH 16
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TX_EN_MSK 0xffff
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_MASK_SH 0
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_MASK_MSK 0xffff
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_BAND BIT(16)
#define FWCMD_H2C_CMD_OFLD_SRC_SH 0
#define FWCMD_H2C_CMD_OFLD_SRC_MSK 0x3
#define FWCMD_H2C_CMD_OFLD_TYPE_SH 2
#define FWCMD_H2C_CMD_OFLD_TYPE_MSK 0x3
#define FWCMD_H2C_CMD_OFLD_LC BIT(4)
#define FWCMD_H2C_CMD_OFLD_PATH_SH 5
#define FWCMD_H2C_CMD_OFLD_PATH_MSK 0x3
#define FWCMD_H2C_CMD_OFLD_CMD_NUM_SH 8
#define FWCMD_H2C_CMD_OFLD_CMD_NUM_MSK 0x7f
#define FWCMD_H2C_CMD_OFLD_OFFSET_SH 16
#define FWCMD_H2C_CMD_OFLD_OFFSET_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_ID_SH 0
#define FWCMD_H2C_CMD_OFLD_ID_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_BASE_OFFSET_SH 16
#define FWCMD_H2C_CMD_OFLD_BASE_OFFSET_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_VALUE_SH 0
#define FWCMD_H2C_CMD_OFLD_VALUE_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_MASK_SH 0
#define FWCMD_H2C_CMD_OFLD_MASK_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_TYPE_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_TYPE_MSK 0x7
#define FWCMD_H2C_CMD_OFLD_V1_LC BIT(3)
#define FWCMD_H2C_CMD_OFLD_V1_OFFSET0_SH 8
#define FWCMD_H2C_CMD_OFLD_V1_OFFSET0_MSK 0xffffff
#define FWCMD_H2C_CMD_OFLD_V1_OFFSET1_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_OFFSET1_MSK 0xffffff
#define FWCMD_H2C_CMD_OFLD_V1_CMD_NUM_SH 24
#define FWCMD_H2C_CMD_OFLD_V1_CMD_NUM_MSK 0xff
#define FWCMD_H2C_CMD_OFLD_V1_MASK0_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_MASK0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_V1_VALUE_SH 0
#define FWCMD_H2C_CMD_OFLD_V1_VALUE_MSK 0xffffffff
#define FWCMD_H2C_H2CPKT_SCH_TX_PAUSE_TX_EN_SH 0
#define FWCMD_H2C_H2CPKT_SCH_TX_PAUSE_TX_EN_MSK 0xffff
#define FWCMD_H2C_H2CPKT_SCH_TX_PAUSE_MASK_SH 0
#define FWCMD_H2C_H2CPKT_SCH_TX_PAUSE_MASK_MSK 0xffff
#define FWCMD_H2C_H2CPKT_SCH_TX_PAUSE_BAND BIT(16)
#define FWCMD_H2C_WOW_CSA_CHINFO_PRI_CH_SH 0
#define FWCMD_H2C_WOW_CSA_CHINFO_PRI_CH_MSK 0xff
#define FWCMD_H2C_WOW_CSA_CHINFO_SUPPORTED_BW_SH 8
#define FWCMD_H2C_WOW_CSA_CHINFO_SUPPORTED_BW_MSK 0xff
#define FWCMD_H2C_WOW_CSA_CHINFO_CH_BAND_SH 16
#define FWCMD_H2C_WOW_CSA_CHINFO_CH_BAND_MSK 0x3
#define FWCMD_H2C_WOW_CSA_CHINFO_RF0_SH 0
#define FWCMD_H2C_WOW_CSA_CHINFO_RF0_MSK 0xffffffff
#define FWCMD_H2C_WOW_CSA_CHINFO_RF1_SH 0
#define FWCMD_H2C_WOW_CSA_CHINFO_RF1_MSK 0xffffffff
#define FWCMD_H2C_WOW_CSA_CHINFO_RF2_SH 0
#define FWCMD_H2C_WOW_CSA_CHINFO_RF2_MSK 0xffffffff
#define FWCMD_H2C_WOW_CSA_CHINFO_RF3_SH 0
#define FWCMD_H2C_WOW_CSA_CHINFO_RF3_MSK 0xffffffff
#define FWCMD_H2C_BA_CAM_G7_VALID BIT(0)
#define FWCMD_H2C_BA_CAM_G7_INIT_REQ BIT(1)
#define FWCMD_H2C_BA_CAM_G7_TID_SH 4
#define FWCMD_H2C_BA_CAM_G7_TID_MSK 0xf
#define FWCMD_H2C_BA_CAM_G7_STD_ENTRY_EN BIT(8)
#define FWCMD_H2C_BA_CAM_G7_BAND_SEL BIT(9)
#define FWCMD_H2C_BA_CAM_G7_MLD_EN BIT(10)
#define FWCMD_H2C_BA_CAM_G7_BMAP_SIZE_SH 16
#define FWCMD_H2C_BA_CAM_G7_BMAP_SIZE_MSK 0xf
#define FWCMD_H2C_BA_CAM_G7_SSN_SH 20
#define FWCMD_H2C_BA_CAM_G7_SSN_MSK 0xfff
#define FWCMD_H2C_BA_CAM_G7_UID_VALUE_SH 0
#define FWCMD_H2C_BA_CAM_G7_UID_VALUE_MSK 0xff
#define FWCMD_H2C_BA_CAM_G7_MACID_SH 8
#define FWCMD_H2C_BA_CAM_G7_MACID_MSK 0x3ff
#define FWCMD_H2C_BA_CAM_G7_ENTRY_IDX_SH 24
#define FWCMD_H2C_BA_CAM_G7_ENTRY_IDX_MSK 0xff
#define FWCMD_H2C_STA_CSA_CHINFO_PRI_CH_SH 0
#define FWCMD_H2C_STA_CSA_CHINFO_PRI_CH_MSK 0xff
#define FWCMD_H2C_STA_CSA_CHINFO_SUPPORTED_BW_SH 8
#define FWCMD_H2C_STA_CSA_CHINFO_SUPPORTED_BW_MSK 0xff
#define FWCMD_H2C_STA_CSA_CHINFO_CH_BAND_SH 16
#define FWCMD_H2C_STA_CSA_CHINFO_CH_BAND_MSK 0x3
#define FWCMD_H2C_STA_CSA_CHINFO_RF0_SH 0
#define FWCMD_H2C_STA_CSA_CHINFO_RF0_MSK 0xffffffff
#define FWCMD_H2C_STA_CSA_CHINFO_RF1_SH 0
#define FWCMD_H2C_STA_CSA_CHINFO_RF1_MSK 0xffffffff
#define FWCMD_H2C_STA_CSA_CHINFO_RF2_SH 0
#define FWCMD_H2C_STA_CSA_CHINFO_RF2_MSK 0xffffffff
#define FWCMD_H2C_STA_CSA_CHINFO_RF3_SH 0
#define FWCMD_H2C_STA_CSA_CHINFO_RF3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID_LEN_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID_LEN_MSK 0xff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP_TYPE_SH 8
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP_TYPE_MSK 0xff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP_LEN_SH 16
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP_LEN_MSK 0xff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID0_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID1_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID2_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID3_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_OID3_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP0_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP0_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP1_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP1_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP2_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP2_MSK 0xffffffff
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP3_SH 0
#define FWCMD_H2C_PROXY_SNMP_ENTERPRISE_RSP3_MSK 0xffffffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PERIOD_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PERIOD_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_DWELL_TIME_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_DWELL_TIME_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CENTRAL_CH_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PRI_CH_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PRI_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_BW_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_BW_MSK 0x7
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NOTIFY_DWELL BIT(3)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NOTIFY_PRETX BIT(4)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NOTIFY_POSTTX BIT(5)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NOTIFY_ENTERCH BIT(6)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NOTIFY_LEAVECH BIT(7)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NUM_TX_PKT_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_NUM_TX_PKT_MSK 0xf
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT BIT(12)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PAUSE_TX_DATA BIT(13)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CH_BAND_SH 14
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PROBE_REQ_PKT_ID_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_PROBE_REQ_PKT_ID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_DFS_CH BIT(24)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_NULL BIT(25)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_RAND_SEQ_NUM BIT(26)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CFG_TX_PWR BIT(27)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PROBE_REQ BIT(28)
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID0_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID0_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID1_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID1_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID2_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID2_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID3_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID3_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID4_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID4_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID5_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID5_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID6_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID6_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID7_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ID7_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PWR_IDX_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PWR_IDX_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CHKPT_TIMER_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_CHKPT_TIMER_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ACKING_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_TX_PKT_ACKING_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_SSIDS_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_SSIDS_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_TPLT_ID_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_TPLT_ID_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_DRIVER_DEF_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_DRIVER_DEF_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_SHORTSSIDS_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_SHORTSSIDS_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_BSSIDS_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V1_FW_PROBE0_BSSIDS_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PERIOD_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PERIOD_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_DWELL_TIME_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_DWELL_TIME_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CENTRAL_CH_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PRI_CH_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PRI_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_BW_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_BW_MSK 0x7
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CH_BAND_SH 3
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_DFS_CH BIT(5)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PAUSE_TX_DATA BIT(6)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_NULL BIT(7)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_RAND_SEQ_NUM BIT(8)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_NOTIFY_DWELL BIT(9)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_NOTIFY_PRETX BIT(10)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_NOTIFY_POSTTX BIT(11)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_NOTIFY_ENTERCH BIT(12)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_NOTIFY_LEAVECH BIT(13)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PROBE BIT(14)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_EARLY_LEAVE_CRIT_SH 15
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_EARLY_LEAVE_CRIT_MSK 0x7
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CHKPT_REPEAT_PROBE BIT(18)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PREFERRED BIT(19)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PARAM_FOR_LEARNED_CH BIT(20)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TYPE_SH 21
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TYPE_MSK 0x3
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_NOTIFY_CHKPT BIT(23)
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CHKPT_TIMER_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_CHKPT_TIMER_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_EARLY_LEAVE_TIME_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_EARLY_LEAVE_TIME_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_EARLY_LEAVE_TH_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_EARLY_LEAVE_TH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_CTRL_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_CTRL_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID0_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID0_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID1_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID1_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID2_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID2_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID3_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID3_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID4_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID4_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID5_SH 8
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID5_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID6_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID6_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID7_SH 24
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_TX_PKT_ID7_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_DRIVER_DEF_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_DRIVER_DEF_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_FW_PROBE0_SSIDS_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_FW_PROBE0_SSIDS_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_FW_PROBE0_SHORTSSIDS_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_FW_PROBE0_SHORTSSIDS_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_FW_PROBE0_BSSIDS_SH 16
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_FW_PROBE0_BSSIDS_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PERIOD_V2_SH 0
#define FWCMD_H2C_SCANOFLD_CHINFO_V2_PERIOD_V2_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_BAND_SH 0
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_PORT_ID_SH 2
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_PORT_ID_MSK 0x7
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_MACID_SH 8
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_MACID_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_OPCH_END_SH 24
#define FWCMD_H2C_SCANOFLD_MACC_ROLE_OPCH_END_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_MACID_SH 0
#define FWCMD_H2C_SCANOFLD_OPCH_MACID_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_OPCH_BAND_SH 16
#define FWCMD_H2C_SCANOFLD_OPCH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_OPCH_PORT_ID_SH 18
#define FWCMD_H2C_SCANOFLD_OPCH_PORT_ID_MSK 0x7
#define FWCMD_H2C_SCANOFLD_OPCH_POLICY_SH 21
#define FWCMD_H2C_SCANOFLD_OPCH_POLICY_MSK 0x3
#define FWCMD_H2C_SCANOFLD_OPCH_TXNULL BIT(23)
#define FWCMD_H2C_SCANOFLD_OPCH_POLICY_VAL_SH 24
#define FWCMD_H2C_SCANOFLD_OPCH_POLICY_VAL_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_DURATION_SH 0
#define FWCMD_H2C_SCANOFLD_OPCH_DURATION_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_CH_BAND_SH 8
#define FWCMD_H2C_SCANOFLD_OPCH_CH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_OPCH_BW_SH 10
#define FWCMD_H2C_SCANOFLD_OPCH_BW_MSK 0x7
#define FWCMD_H2C_SCANOFLD_OPCH_NOTIFY_ENTER BIT(13)
#define FWCMD_H2C_SCANOFLD_OPCH_NOTIFY_LEAVE BIT(14)
#define FWCMD_H2C_SCANOFLD_OPCH_NULL_TYPE BIT(15)
#define FWCMD_H2C_SCANOFLD_OPCH_PRI_CH_SH 16
#define FWCMD_H2C_SCANOFLD_OPCH_PRI_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_CENTRAL_CH_SH 24
#define FWCMD_H2C_SCANOFLD_OPCH_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_PKTS_CTRL_SH 0
#define FWCMD_H2C_SCANOFLD_OPCH_PKTS_CTRL_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_DRIVER_DEF_SH 8
#define FWCMD_H2C_SCANOFLD_OPCH_DRIVER_DEF_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_SS_SH 16
#define FWCMD_H2C_SCANOFLD_OPCH_SS_MSK 0x7
#define FWCMD_H2C_SCANOFLD_OPCH_TXBCN BIT(19)
#define FWCMD_H2C_SCANOFLD_OPCH_PKT0_SH 0
#define FWCMD_H2C_SCANOFLD_OPCH_PKT0_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_PKT1_SH 8
#define FWCMD_H2C_SCANOFLD_OPCH_PKT1_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_PKT2_SH 16
#define FWCMD_H2C_SCANOFLD_OPCH_PKT2_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_PKT3_SH 24
#define FWCMD_H2C_SCANOFLD_OPCH_PKT3_MSK 0xff
#define FWCMD_H2C_SCANOFLD_OPCH_DURATION_V2_SH 0
#define FWCMD_H2C_SCANOFLD_OPCH_DURATION_V2_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHRPT_PRI_CH_SH 0
#define FWCMD_H2C_SCANOFLD_CHRPT_PRI_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHRPT_RX_CNT_SH 8
#define FWCMD_H2C_SCANOFLD_CHRPT_RX_CNT_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHRPT_TX_FAIL_SH 16
#define FWCMD_H2C_SCANOFLD_CHRPT_TX_FAIL_MSK 0x7f
#define FWCMD_H2C_SCANOFLD_CHRPT_PARSED BIT(23)
#define FWCMD_H2C_SCANOFLD_CHRPT_CH_BAND_SH 24
#define FWCMD_H2C_SCANOFLD_CHRPT_CH_BAND_MSK 0x3
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_RTY_DROP_SH 26
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_RTY_DROP_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL0_TX_SH 0
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL0_TX_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL1_TX_SH 5
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL1_TX_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL0_TX_FAIL_SH 10
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL0_TX_FAIL_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL1_TX_FAIL_SH 15
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL1_TX_FAIL_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_BW_SH 20
#define FWCMD_H2C_SCANOFLD_CHRPT_BW_MSK 0x7
#define FWCMD_H2C_SCANOFLD_CHRPT_CENTRAL_CH_SH 24
#define FWCMD_H2C_SCANOFLD_CHRPT_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_SCANOFLD_CHRPT_MACID_SH 0
#define FWCMD_H2C_SCANOFLD_CHRPT_MACID_MSK 0xffff
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_LIFE_DROP_SH 16
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_LIFE_DROP_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_MACID_DROP_SH 21
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_MACID_DROP_MSK 0x1f
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_OTHER_SH 26
#define FWCMD_H2C_SCANOFLD_CHRPT_NULL_FAIL_OTHER_MSK 0x1f
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_TSF_SHIFT_MS_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_TSF_SHIFT_MS_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_DURATION_MS_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_DURATION_MS_MSK 0xff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_GNRL_CRC_ERR_CNT_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_GNRL_CRC_ERR_CNT_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_HOST_FAIL_CNT_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_HOST_FAIL_CNT_MSK 0xff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_HOST_FAIL_CNT_SH 24
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_HOST_FAIL_CNT_MSK 0xff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_NAK_NRDY_CNT_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_NAK_NRDY_CNT_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_DMA_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_DMA_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_N2E_MAX_INTV_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_N2E_MAX_INTV_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_N2E_EXC_CNT_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_N2E_EXC_CNT_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_E2H_MAX_INTV_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_E2H_MAX_INTV_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_E2H_EXC_CNT_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON0_E2H_EXC_CNT_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_NAK_NRDY_CNT_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_NAK_NRDY_CNT_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_DMA_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_DMA_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_N2E_MAX_INTV_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_N2E_MAX_INTV_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_N2E_EXC_CNT_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_N2E_EXC_CNT_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_E2H_MAX_INTV_SH 0
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_E2H_MAX_INTV_MSK 0xffff
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_E2H_EXC_CNT_SH 16
#define FWCMD_H2C_USB_TP_DBG_MON_RPT_EPMON1_E2H_EXC_CNT_MSK 0xffff
#define FWCMD_H2C_SCAN_DBG_DUMP_HDR_ID_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_HDR_ID_MSK 0x1f
#define FWCMD_H2C_SCAN_DBG_DUMP_HDR_SZ_SH 8
#define FWCMD_H2C_SCAN_DBG_DUMP_HDR_SZ_MSK 0xf
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_OK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_OK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_FAIL_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_FAIL_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_PPDU_OK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_PPDU_OK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_FA_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_OFDM_FA_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_OK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_OK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_FAIL_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_FAIL_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_PPDU_OK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_PPDU_OK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_FA_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_RX_CCK_FA_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_TX_OFDM_PPDU_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_TX_OFDM_PPDU_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_TX_LCCK_PPDU_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_TX_LCCK_PPDU_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_TX_SCCK_PPDU_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_TX_SCCK_PPDU_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_OFDM_CCA_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_OFDM_CCA_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_CCK_CCA_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_CCK_CCA_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_LEGACY_CRC_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_LEGACY_CRC_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_CCK_CRC_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_CCK_CRC_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_BLOCK_RX_BLOCK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_RX_BLOCK_RX_BLOCK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_TX_OFDM_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_TX_OFDM_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_TX_CCK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_TX_CCK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_TX_CCK_FROM_MAC_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_TX_CCK_FROM_MAC_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR0_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR0_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR1_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR1_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR2_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR2_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR3_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR3_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR4_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR4_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR5_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S0_CR5_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR0_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR0_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR1_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR1_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR2_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR2_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR3_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR3_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR4_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR4_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR5_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_RF_S1_CR5_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_CCK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_CCK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_SEARCH_FAIL_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_SEARCH_FAIL_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_LSIG_BRK_S_TH_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_LSIG_BRK_S_TH_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_LSIG_BRK_L_TH_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_LSIG_BRK_L_TH_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_RXL_ERR_PARITY_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_RXL_ERR_PARITY_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_RXL_ERR_RATE_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_BRK_OFDM_RXL_ERR_RATE_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_FA_OFDM_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_FA_OFDM_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_FA_CCK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_FA_CCK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_PD_THRD_OFDM_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_PD_THRD_OFDM_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_PD_THRD_CCK_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_BB_PD_THRD_CCK_MSK 0xffffffff
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_PTCL_PHY_SH 0
#define FWCMD_H2C_SCAN_DBG_DUMP_MAC_PTCL_PHY_MSK 0xffffffff

/*----------------------------------- H2CPKT - CAT(OutSrc,Phydm) -------------------*/
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_MACID_CFG_IS_DISRA BIT(0)
#define FWCMD_H2C_MACID_CFG_MODE_CTRL_SH 1
#define FWCMD_H2C_MACID_CFG_MODE_CTRL_MSK 0x1f
#define FWCMD_H2C_MACID_CFG_BW_CAP_SH 6
#define FWCMD_H2C_MACID_CFG_BW_CAP_MSK 0x3
#define FWCMD_H2C_MACID_CFG_MACID_SH 8
#define FWCMD_H2C_MACID_CFG_MACID_MSK 0xff
#define FWCMD_H2C_MACID_CFG_DCM_CAP BIT(16)
#define FWCMD_H2C_MACID_CFG_ER_CAP BIT(17)
#define FWCMD_H2C_MACID_CFG_INIT_RATE_LV_SH 18
#define FWCMD_H2C_MACID_CFG_INIT_RATE_LV_MSK 0x3
#define FWCMD_H2C_MACID_CFG_BW_NOUPDATE BIT(20)
#define FWCMD_H2C_MACID_CFG_EN_SGI BIT(21)
#define FWCMD_H2C_MACID_CFG_LDPC_CAP BIT(22)
#define FWCMD_H2C_MACID_CFG_STBC_CAP BIT(23)
#define FWCMD_H2C_MACID_CFG_SS_NUM_SH 24
#define FWCMD_H2C_MACID_CFG_SS_NUM_MSK 0x7
#define FWCMD_H2C_MACID_CFG_GI_LTF_SH 27
#define FWCMD_H2C_MACID_CFG_GI_LTF_MSK 0x7
#define FWCMD_H2C_MACID_CFG_RA_MASK_LOW_SH 0
#define FWCMD_H2C_MACID_CFG_RA_MASK_LOW_MSK 0xffffffff
#define FWCMD_H2C_MACID_CFG_RA_MASK_HI_SH 0
#define FWCMD_H2C_MACID_CFG_RA_MASK_HI_MSK 0xfffffff
#define FWCMD_H2C_RSSI_RA_CONFIG_IS_DISRA BIT(0)
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_LOW_SH 0
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_LOW_MSK 0xffffffff
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_HI_SH 0
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_HI_MSK 0xffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

/*----------------------------------- H2CPKT - CAT(OutSrc, RF) ---------------------*/
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

/*----------------------------------- H2CPKT - CAT(OutSrc, BTC) --------------------*/
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_TDMA_EN BIT(0)
#define FWCMD_H2C_TDMA_PRO_PS BIT(1)
#define FWCMD_H2C_TDMA_NULL BIT(2)
#define FWCMD_H2C_TDMA_QOS_NULL BIT(3)
#define FWCMD_H2C_TDMA_WL_SLOT_SH 8
#define FWCMD_H2C_TDMA_WL_SLOT_MSK 0xff

/*----------------------------------- C2HPKT - CAT(TEST) ---------------------------*/
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_C2H_LB_PAYLOAD_SH 0
#define FWCMD_C2H_C2H_LB_PAYLOAD_MSK 0xffffffff
#define FWCMD_C2H_TEST_PHY_RPT_PAYLOAD_SH 0
#define FWCMD_C2H_TEST_PHY_RPT_PAYLOAD_MSK 0xffffffff
#define FWCMD_C2H_C2H_LOG_TEST_PAYLOAD0_SH 0
#define FWCMD_C2H_C2H_LOG_TEST_PAYLOAD0_MSK 0xffffffff
#define FWCMD_C2H_SEND_NULL_TEST_SEND_NUM_SH 0
#define FWCMD_C2H_SEND_NULL_TEST_SEND_NUM_MSK 0xffff
#define FWCMD_C2H_SEND_NULL_TEST_RPT_NUM_SH 16
#define FWCMD_C2H_SEND_NULL_TEST_RPT_NUM_MSK 0xffff
#define FWCMD_C2H_C2H_L1_2_TEST_RESULT_SH 0
#define FWCMD_C2H_C2H_L1_2_TEST_RESULT_MSK 0xffffffff
#define FWCMD_C2H_SPIC_PAYLOAD0_SH 0
#define FWCMD_C2H_SPIC_PAYLOAD0_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD1_SH 8
#define FWCMD_C2H_SPIC_PAYLOAD1_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD2_SH 16
#define FWCMD_C2H_SPIC_PAYLOAD2_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD3_SH 24
#define FWCMD_C2H_SPIC_PAYLOAD3_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD4_SH 0
#define FWCMD_C2H_SPIC_PAYLOAD4_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD5_SH 8
#define FWCMD_C2H_SPIC_PAYLOAD5_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD6_SH 16
#define FWCMD_C2H_SPIC_PAYLOAD6_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD7_SH 24
#define FWCMD_C2H_SPIC_PAYLOAD7_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD0_SH 0
#define FWCMD_C2H_SPIC2_PAYLOAD0_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD1_SH 8
#define FWCMD_C2H_SPIC2_PAYLOAD1_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD2_SH 16
#define FWCMD_C2H_SPIC2_PAYLOAD2_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD3_SH 24
#define FWCMD_C2H_SPIC2_PAYLOAD3_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD4_SH 0
#define FWCMD_C2H_SPIC2_PAYLOAD4_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD5_SH 8
#define FWCMD_C2H_SPIC2_PAYLOAD5_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD6_SH 16
#define FWCMD_C2H_SPIC2_PAYLOAD6_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD7_SH 24
#define FWCMD_C2H_SPIC2_PAYLOAD7_MSK 0xff
#define FWCMD_C2H_LPS_ONOFF_TEST_TYPE_SH 0
#define FWCMD_C2H_LPS_ONOFF_TEST_TYPE_MSK 0xffffffff
#define FWCMD_C2H_LPS_ONOFF_TEST_RESULT_SH 0
#define FWCMD_C2H_LPS_ONOFF_TEST_RESULT_MSK 0xffffffff
#define FWCMD_C2H_MPIO_TEST_TYPE_SH 0
#define FWCMD_C2H_MPIO_TEST_TYPE_MSK 0xffffffff
#define FWCMD_C2H_MPIO_TEST_RESULT_SH 0
#define FWCMD_C2H_MPIO_TEST_RESULT_MSK 0xffffffff
#define FWCMD_C2H_SENDNULL_TEST_SEND_NUM_SH 0
#define FWCMD_C2H_SENDNULL_TEST_SEND_NUM_MSK 0xffff
#define FWCMD_C2H_SENDNULL_TEST_RPT_NUM_SH 16
#define FWCMD_C2H_SENDNULL_TEST_RPT_NUM_MSK 0xffff
#define FWCMD_C2H_MPIOV2_TEST_TYPE_SH 0
#define FWCMD_C2H_MPIOV2_TEST_TYPE_MSK 0xffffffff
#define FWCMD_C2H_MPIOV2_TEST_RESULT_SH 0
#define FWCMD_C2H_MPIOV2_TEST_RESULT_MSK 0xffffffff
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD0_SH 0
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD0_MSK 0xffffffff
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD1_SH 0
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD1_MSK 0xffffffff
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD2_SH 0
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD2_MSK 0xffffffff
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD3_SH 0
#define FWCMD_C2H_MPIOV2_TEST_PAYLOAD3_MSK 0xffffffff
#define FWCMD_C2H_MIO_TEST_RESULT_SH 0
#define FWCMD_C2H_MIO_TEST_RESULT_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_SEQNUM_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_SEQNUM_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_TEST_FUNC_MODE_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_TEST_FUNC_MODE_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_TEST_CNT_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_TEST_CNT_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_BUFFERSIZE_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_BUFFERSIZE_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT_NUM_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT_NUM_MSK 0xffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT_BUFFER_MODE_SH 16
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT_BUFFER_MODE_MSK 0xffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT0_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT0_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT1_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT1_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT2_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT2_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT3_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT3_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT4_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT4_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT5_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT5_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT6_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT6_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT7_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INPUT7_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_RETURN_VALUE_EXPECT_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_RETURN_VALUE_EXPECT_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_RETURN_VALUE_MASK_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_RETURN_VALUE_MASK_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_RETURN_VAL_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_RETURN_VAL_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_CPU_CYCLE_START_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_CPU_CYCLE_START_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_CPU_CYCLE_END_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_CPU_CYCLE_END_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INST_CNT_START_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INST_CNT_START_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INST_CNT_END_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_INST_CNT_END_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_FREERUN_CNT_START_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_FREERUN_CNT_START_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_FREERUN_CNT_END_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_FREERUN_CNT_END_MSK 0xffffffff
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_BUFFER_SH 0
#define FWCMD_C2H_ANYTESTBUSYCALL_TEST_BUFFER_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_SEQNUM_SH 0
#define FWCMD_C2H_ANYRW_TEST_SEQNUM_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_OP_MODE_SH 0
#define FWCMD_C2H_ANYRW_TEST_OP_MODE_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_BUFFERSIZE_SH 0
#define FWCMD_C2H_ANYRW_TEST_BUFFERSIZE_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_INPUT0_SH 0
#define FWCMD_C2H_ANYRW_TEST_INPUT0_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_INPUT1_SH 0
#define FWCMD_C2H_ANYRW_TEST_INPUT1_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_INPUT2_SH 0
#define FWCMD_C2H_ANYRW_TEST_INPUT2_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_INPUT3_SH 0
#define FWCMD_C2H_ANYRW_TEST_INPUT3_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_INPUT4_SH 0
#define FWCMD_C2H_ANYRW_TEST_INPUT4_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_INPUT5_SH 0
#define FWCMD_C2H_ANYRW_TEST_INPUT5_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_RETURN_VAL_SH 0
#define FWCMD_C2H_ANYRW_TEST_RETURN_VAL_MSK 0xffffffff
#define FWCMD_C2H_ANYRW_TEST_BUFFER_SH 0
#define FWCMD_C2H_ANYRW_TEST_BUFFER_MSK 0xffffffff
#define FWCMD_C2H_CPUIO_TEST_RESULT_SH 0
#define FWCMD_C2H_CPUIO_TEST_RESULT_MSK 0xffffffff

/*----------------------------------- C2HPKT - CAT(MAC) ----------------------------*/
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_REC_ACK_CAT_SH 0
#define FWCMD_C2H_REC_ACK_CAT_MSK 0x3
#define FWCMD_C2H_REC_ACK_CLASS_SH 2
#define FWCMD_C2H_REC_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_REC_ACK_FUNC_SH 8
#define FWCMD_C2H_REC_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_REC_ACK_H2C_SEQ_SH 16
#define FWCMD_C2H_REC_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_DONE_ACK_CAT_SH 0
#define FWCMD_C2H_DONE_ACK_CAT_MSK 0x3
#define FWCMD_C2H_DONE_ACK_CLASS_SH 2
#define FWCMD_C2H_DONE_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_DONE_ACK_FUNC_SH 8
#define FWCMD_C2H_DONE_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_DONE_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_DONE_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_DONE_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_DONE_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_C2H_LOG_LOG_MSG_SH 0
#define FWCMD_C2H_C2H_LOG_LOG_MSG_MSK 0xffffffff
#define FWCMD_C2H_BCN_CNT_PORT_MBSSID_IDX_SH 0
#define FWCMD_C2H_BCN_CNT_PORT_MBSSID_IDX_MSK 0x7f
#define FWCMD_C2H_BCN_CNT_BAND_IDX BIT(7)
#define FWCMD_C2H_BCN_CNT_CCA_FAIL_CNT_SH 8
#define FWCMD_C2H_BCN_CNT_CCA_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_EDCCA_FAIL_CNT_SH 12
#define FWCMD_C2H_BCN_CNT_EDCCA_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_NAV_FAIL_CNT_SH 16
#define FWCMD_C2H_BCN_CNT_NAV_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_TXON_FAIL_CNT_SH 20
#define FWCMD_C2H_BCN_CNT_TXON_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_MAC_FAIL_CNT_SH 24
#define FWCMD_C2H_BCN_CNT_MAC_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_OTHERS_FAIL_CNT_SH 28
#define FWCMD_C2H_BCN_CNT_OTHERS_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_LOCK_FAIL_CNT_SH 0
#define FWCMD_C2H_BCN_CNT_LOCK_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_CMP_FAIL_CNT_SH 4
#define FWCMD_C2H_BCN_CNT_CMP_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_INVALID_FAIL_CNT_SH 8
#define FWCMD_C2H_BCN_CNT_INVALID_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_SRCHEND_FAIL_CNT_SH 12
#define FWCMD_C2H_BCN_CNT_SRCHEND_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_OK_CNT_SH 16
#define FWCMD_C2H_BCN_CNT_OK_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CSAZERO_PORT_MBSSID_IDX_SH 0
#define FWCMD_C2H_BCN_CSAZERO_PORT_MBSSID_IDX_MSK 0x7f
#define FWCMD_C2H_BCN_CSAZERO_BAND_IDX BIT(7)
#define FWCMD_C2H_BCN_CRITICAL_RST_PORT_MBSSID_IDX_SH 0
#define FWCMD_C2H_BCN_CRITICAL_RST_PORT_MBSSID_IDX_MSK 0x7f
#define FWCMD_C2H_BCN_CRITICAL_RST_BAND_IDX BIT(7)
#define FWCMD_C2H_BCN_UPD_DONE_PORT_SH 0
#define FWCMD_C2H_BCN_UPD_DONE_PORT_MSK 0x7
#define FWCMD_C2H_BCN_UPD_DONE_MBSSID_SH 3
#define FWCMD_C2H_BCN_UPD_DONE_MBSSID_MSK 0xf
#define FWCMD_C2H_BCN_UPD_DONE_BAND_IDX BIT(7)
#define FWCMD_C2H_BCN_BC_CHG_ZERO_PORT_MBSSID_IDX_SH 0
#define FWCMD_C2H_BCN_BC_CHG_ZERO_PORT_MBSSID_IDX_MSK 0x7f
#define FWCMD_C2H_BCN_BC_CHG_ZERO_BAND_IDX BIT(7)
#define FWCMD_C2H_FW_SELF_DX_INFO_FWDX_TIME_INTERVAL_SH 0
#define FWCMD_C2H_FW_SELF_DX_INFO_FWDX_TIME_INTERVAL_MSK 0xffff
#define FWCMD_C2H_FW_SELF_DX_INFO_FWDX_HEAP_REMAIN BIT(0)
#define FWCMD_C2H_FW_SELF_DX_INFO_FWDX_IRQ_CNT BIT(1)
#define FWCMD_C2H_FW_SELF_DX_INFO_FWDX_AXIDMA_DEBUG_INFO BIT(2)
#define FWCMD_C2H_FW_SELF_DX_INFO_FWDX_CPUIO_DEBUG_INFO BIT(3)
#define FWCMD_C2H_EFUSE_DUMP_UUID0_SH 16
#define FWCMD_C2H_EFUSE_DUMP_UUID0_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_UUID2_SH 24
#define FWCMD_C2H_EFUSE_DUMP_UUID2_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_REMARK_SH 24
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_SH 28
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_HCI_TYPE_SH 0
#define FWCMD_C2H_EFUSE_DUMP_HCI_TYPE_MSK 0xf
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_SH 8
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_SH 12
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_SH 16
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_SH 20
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN0_SH 24
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN0_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN1_SH 0
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN1_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_REMARK_80211_SH 8
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_REMARK_80211_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_80211_SH 10
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_80211_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_REMARK_SH 12
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_REMARK_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_SH 14
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_REMARK_SH 16
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_REMARK_SH 20
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_REMARK_SH 24
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_REMARK_SH 28
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_WL_FUNCTION_SUPPORT_SH 0
#define FWCMD_C2H_EFUSE_DUMP_WL_FUNCTION_SUPPORT_MSK 0xf
#define FWCMD_C2H_EFUSE_DUMP_HW_SPECIAL_TYPE_SH 4
#define FWCMD_C2H_EFUSE_DUMP_HW_SPECIAL_TYPE_MSK 0xf
#define FWCMD_C2H_EFUSE_DUMP_UUID3_SH 0
#define FWCMD_C2H_EFUSE_DUMP_UUID3_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_UUID1_SH 8
#define FWCMD_C2H_EFUSE_DUMP_UUID1_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_PFID_SH 16
#define FWCMD_C2H_EFUSE_DUMP_PFID_MSK 0xff
#define FWCMD_C2H_READ_RSP_VALUE_LEN_SH 0
#define FWCMD_C2H_READ_RSP_VALUE_LEN_MSK 0x7ff
#define FWCMD_C2H_READ_RSP_LS BIT(15)
#define FWCMD_C2H_READ_RSP_OFLD_ID_SH 16
#define FWCMD_C2H_READ_RSP_OFLD_ID_MSK 0xff
#define FWCMD_C2H_READ_RSP_ENTRY_NUM_SH 24
#define FWCMD_C2H_READ_RSP_ENTRY_NUM_MSK 0xff
#define FWCMD_C2H_READ_RSP_OFFSET_SH 0
#define FWCMD_C2H_READ_RSP_OFFSET_MSK 0xffff
#define FWCMD_C2H_READ_RSP_START_SH 0
#define FWCMD_C2H_READ_RSP_START_MSK 0xffffffff
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_ID_SH 0
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_ID_MSK 0xff
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_OP_SH 8
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_OP_MSK 0x7
#define FWCMD_C2H_PKT_OFLD_RSP_NUM_TIMING_SH 11
#define FWCMD_C2H_PKT_OFLD_RSP_NUM_TIMING_MSK 0x3
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_LENGTH_SH 16
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_LENGTH_MSK 0xffff
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_CONTENT_SH 0
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_1_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_1_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_2_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_2_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_3_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_3_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_4_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_4_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_5_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_5_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_6_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_6_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_7_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_7_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_8_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_8_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_9_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_9_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_10_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_10_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_11_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_11_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_12_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_12_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_13_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_13_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_14_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_14_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_15_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_15_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_16_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_16_MSK 0xffffffff
#define FWCMD_C2H_FW_GETPKT_RPT_MACID_SH 0
#define FWCMD_C2H_FW_GETPKT_RPT_MACID_MSK 0xff
#define FWCMD_C2H_FW_GETPKT_RPT_PKT_TYPE_SH 8
#define FWCMD_C2H_FW_GETPKT_RPT_PKT_TYPE_MSK 0xf
#define FWCMD_C2H_FW_GETPKT_RPT_MACID_EXT_SH 16
#define FWCMD_C2H_FW_GETPKT_RPT_MACID_EXT_MSK 0xff
#define FWCMD_C2H_TSF32_TOGL_RPT_BAND BIT(0)
#define FWCMD_C2H_TSF32_TOGL_RPT_PORT_SH 1
#define FWCMD_C2H_TSF32_TOGL_RPT_PORT_MSK 0x7
#define FWCMD_C2H_TSF32_TOGL_RPT_STATUS_SH 4
#define FWCMD_C2H_TSF32_TOGL_RPT_STATUS_MSK 0xfff
#define FWCMD_C2H_TSF32_TOGL_RPT_EARLY_SH 16
#define FWCMD_C2H_TSF32_TOGL_RPT_EARLY_MSK 0xffff
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_L_SH 0
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_H_SH 0
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_RPT_MODE_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_RPT_MODE_MSK 0x7
#define FWCMD_C2H_USR_TX_RPT_INFO_MACID_SH 8
#define FWCMD_C2H_USR_TX_RPT_INFO_MACID_MSK 0xff
#define FWCMD_C2H_USR_TX_RPT_INFO_AC_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_AC_MSK 0x3
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BE_1K_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BE_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BK_1K_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BK_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VI_1K_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VI_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VO_1K_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VO_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_IN_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_IN_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_OUT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_OUT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_LAST_OUT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_LAST_OUT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BE_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BE_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BK_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BK_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VI_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VI_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VO_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VO_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BE_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BE_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BK_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BK_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VI_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VI_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VO_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VO_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_RX_CLEAR_US_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_RX_CLEAR_US_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_BUSY_US_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_BUSY_US_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_LAST_IN_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_LAST_IN_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_PPDU_CNT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_PPDU_CNT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_PPDU_CNT_WO_LAST_PKT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_PPDU_CNT_WO_LAST_PKT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_MPDU_CNT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_MPDU_CNT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_MPDU_CNT_WO_LAST_PKT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_MPDU_CNT_WO_LAST_PKT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_RTS_CNT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_RTS_CNT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_RTS_RETRY_CNT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_RTS_RETRY_CNT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_MPDU_OK_CNT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_MPDU_OK_CNT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_RA_RATIO_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_RA_RATIO_MSK 0xff
#define FWCMD_C2H_USR_TX_RPT_INFO_MAX_RTS_CNT_SH 8
#define FWCMD_C2H_USR_TX_RPT_INFO_MAX_RTS_CNT_MSK 0xff
#define FWCMD_C2H_USR_TX_RPT_INFO_MAX_AMPDU_NUM_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_MAX_AMPDU_NUM_MSK 0xff
#define FWCMD_C2H_USR_TX_RPT_INFO_MACID_EXT_SH 24
#define FWCMD_C2H_USR_TX_RPT_INFO_MACID_EXT_MSK 0xff
#define FWCMD_C2H_USR_TX_RPT_INFO_RX_ERR_CNT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_RX_ERR_CNT_MSK 0xffffffff
#define FWCMD_C2H_CMD_OFLD_RSP_RESULT BIT(0)
#define FWCMD_C2H_CMD_OFLD_RSP_CMD_NUM_SH 8
#define FWCMD_C2H_CMD_OFLD_RSP_CMD_NUM_MSK 0xff
#define FWCMD_C2H_CMD_OFLD_RSP_OFFSET_SH 0
#define FWCMD_C2H_CMD_OFLD_RSP_OFFSET_MSK 0xffffffff
#define FWCMD_C2H_CMD_OFLD_RSP_EXP_VAL_SH 0
#define FWCMD_C2H_CMD_OFLD_RSP_EXP_VAL_MSK 0xffffffff
#define FWCMD_C2H_CMD_OFLD_RSP_R_VAL_SH 0
#define FWCMD_C2H_CMD_OFLD_RSP_R_VAL_MSK 0xffffffff
#define FWCMD_C2H_SCANOFLD_RSP_PRI_CH_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_PRI_CH_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_SCANNED_ROUND_SH 8
#define FWCMD_C2H_SCANOFLD_RSP_SCANNED_ROUND_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_NOTIFY_REASON_SH 16
#define FWCMD_C2H_SCANOFLD_RSP_NOTIFY_REASON_MSK 0xf
#define FWCMD_C2H_SCANOFLD_RSP_STATUS_SH 20
#define FWCMD_C2H_SCANOFLD_RSP_STATUS_MSK 0xf
#define FWCMD_C2H_SCANOFLD_RSP_ACTUAL_PERIOD_SH 24
#define FWCMD_C2H_SCANOFLD_RSP_ACTUAL_PERIOD_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_SPENT_LOW_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_SPENT_LOW_MSK 0xffffffff
#define FWCMD_C2H_SCANOFLD_RSP_SPENT_HIGH_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_SPENT_HIGH_MSK 0xffffffff
#define FWCMD_C2H_SCANOFLD_RSP_TX_FAIL_CNT_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_TX_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_SCANOFLD_RSP_AIR_DENSITY_SH 4
#define FWCMD_C2H_SCANOFLD_RSP_AIR_DENSITY_MSK 0xf
#define FWCMD_C2H_SCANOFLD_RSP_NUM_CH_RPT_SH 8
#define FWCMD_C2H_SCANOFLD_RSP_NUM_CH_RPT_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_CH_RPT_SIZE_SH 16
#define FWCMD_C2H_SCANOFLD_RSP_CH_RPT_SIZE_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_CH_BAND_SH 24
#define FWCMD_C2H_SCANOFLD_RSP_CH_BAND_MSK 0x3
#define FWCMD_C2H_SCANOFLD_RSP_BAND BIT(26)
#define FWCMD_C2H_SCANOFLD_RSP_BW_SH 27
#define FWCMD_C2H_SCANOFLD_RSP_BW_MSK 0x3
#define FWCMD_C2H_SCANOFLD_RSP_ACTIVE_CH BIT(29)
#define FWCMD_C2H_SCANOFLD_RSP_DRIVER_DEF_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_DRIVER_DEF_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_EXPECT_PERIOD_SH 8
#define FWCMD_C2H_SCANOFLD_RSP_EXPECT_PERIOD_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_FW_DEF_SH 16
#define FWCMD_C2H_SCANOFLD_RSP_FW_DEF_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_CENTRAL_CH_SH 24
#define FWCMD_C2H_SCANOFLD_RSP_CENTRAL_CH_MSK 0xff
#define FWCMD_C2H_SCANOFLD_RSP_REPORTING_TSF_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_REPORTING_TSF_MSK 0xffffffff
#define FWCMD_C2H_SCANOFLD_RSP_ACTUAL_PERIOD_V2_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_ACTUAL_PERIOD_V2_MSK 0xffff
#define FWCMD_C2H_SCANOFLD_RSP_EXPECT_PERIOD_V2_SH 16
#define FWCMD_C2H_SCANOFLD_RSP_EXPECT_PERIOD_V2_MSK 0xffff
#define FWCMD_C2H_SCANOFLD_RSP_RSP_SIZE_SH 0
#define FWCMD_C2H_SCANOFLD_RSP_RSP_SIZE_MSK 0x1f
#define FWCMD_C2H_SCANOFLD_RSP_DBG_DUMP_SIZE_SH 8
#define FWCMD_C2H_SCANOFLD_RSP_DBG_DUMP_SIZE_MSK 0x7f
#define FWCMD_C2H_TX_DUTY_RPT_TIMER_ERR_SH 0
#define FWCMD_C2H_TX_DUTY_RPT_TIMER_ERR_MSK 0x7
#define FWCMD_C2H_CH_SWITCH_RPT_RESULT_SH 0
#define FWCMD_C2H_CH_SWITCH_RPT_RESULT_MSK 0xffffffff
#define FWCMD_C2H_BCNERLYNTFY_BAND BIT(0)
#define FWCMD_C2H_BCNERLYNTFY_PORT_SH 1
#define FWCMD_C2H_BCNERLYNTFY_PORT_MSK 0x7
#define FWCMD_C2H_BCNERLYNTFY_FREERUN_CNT_LOW_SH 0
#define FWCMD_C2H_BCNERLYNTFY_FREERUN_CNT_LOW_MSK 0xffffffff
#define FWCMD_C2H_BCNERLYNTFY_FREERUN_CNT_HIGH_SH 0
#define FWCMD_C2H_BCNERLYNTFY_FREERUN_CNT_HIGH_MSK 0xffffffff
#define FWCMD_C2H_BCNERLYNTFY_TSF_LOW_SH 0
#define FWCMD_C2H_BCNERLYNTFY_TSF_LOW_MSK 0xffffffff
#define FWCMD_C2H_BCNERLYNTFY_TSF_HIGH_SH 0
#define FWCMD_C2H_BCNERLYNTFY_TSF_HIGH_MSK 0xffffffff
#define FWCMD_C2H_BCNFLTR_RPT_MACID_SH 0
#define FWCMD_C2H_BCNFLTR_RPT_MACID_MSK 0xff
#define FWCMD_C2H_BCNFLTR_RPT_TYPE_SH 8
#define FWCMD_C2H_BCNFLTR_RPT_TYPE_MSK 0x3
#define FWCMD_C2H_BCNFLTR_RPT_RSSI_EVT_SH 10
#define FWCMD_C2H_BCNFLTR_RPT_RSSI_EVT_MSK 0x3
#define FWCMD_C2H_BCNFLTR_RPT_RSSI_MA_SH 16
#define FWCMD_C2H_BCNFLTR_RPT_RSSI_MA_MSK 0xff
#define FWCMD_C2H_BCNFLTR_RPT_MACID_EXT_SH 24
#define FWCMD_C2H_BCNFLTR_RPT_MACID_EXT_MSK 0xff
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_MACID_SH 0
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_MACID_MSK 0xff
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_NUM_SH 8
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_NUM_MSK 0xff
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_SEQ_NUM_SH 16
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_SEQ_NUM_MSK 0xff
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_MACID_EXT_SH 24
#define FWCMD_C2H_WIFI_SENSING_CSI_TX_RESULT_MACID_EXT_MSK 0xff
#define FWCMD_C2H_TBTT_SH_STAT_RPT_BAND_SH 0
#define FWCMD_C2H_TBTT_SH_STAT_RPT_BAND_MSK 0xff
#define FWCMD_C2H_TBTT_SH_STAT_RPT_PORT_SH 8
#define FWCMD_C2H_TBTT_SH_STAT_RPT_PORT_MSK 0xff
#define FWCMD_C2H_TBTT_SH_STAT_RPT_NUM_TSF_SH 16
#define FWCMD_C2H_TBTT_SH_STAT_RPT_NUM_TSF_MSK 0xff
#define FWCMD_C2H_BCN_OFLD_RPT_BAND BIT(0)
#define FWCMD_C2H_BCN_OFLD_RPT_PORT_SH 1
#define FWCMD_C2H_BCN_OFLD_RPT_PORT_MSK 0x7
#define FWCMD_C2H_BCN_OFLD_RPT_RSSI_NUM_SH 4
#define FWCMD_C2H_BCN_OFLD_RPT_RSSI_NUM_MSK 0xff
#define FWCMD_C2H_BCN_OFLD_RPT_TIMESTAMP_NUM_SH 12
#define FWCMD_C2H_BCN_OFLD_RPT_TIMESTAMP_NUM_MSK 0xff
#define FWCMD_C2H_BCN_OFLD_RPT_RSSI_DETECTED BIT(20)
#define FWCMD_C2H_BCN_OFLD_RPT_TBTT_NUM_SH 0
#define FWCMD_C2H_BCN_OFLD_RPT_TBTT_NUM_MSK 0xff
#define FWCMD_C2H_BCN_OFLD_RPT_RXBCNOK_NUM_SH 8
#define FWCMD_C2H_BCN_OFLD_RPT_RXBCNOK_NUM_MSK 0xff
#define FWCMD_C2H_BCN_OFLD_RPT_IEHIT_NUM_SH 16
#define FWCMD_C2H_BCN_OFLD_RPT_IEHIT_NUM_MSK 0xff
#define FWCMD_C2H_BCN_OFLD_RPT_IEMISS_NUM_SH 24
#define FWCMD_C2H_BCN_OFLD_RPT_IEMISS_NUM_MSK 0xff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_MODE_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_MODE_MSK 0xf
#define FWCMD_C2H_FRAME_TO_ACT_RPT_TRIGGER_CNT_SH 8
#define FWCMD_C2H_FRAME_TO_ACT_RPT_TRIGGER_CNT_MSK 0xff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_SW_DEF_SH 16
#define FWCMD_C2H_FRAME_TO_ACT_RPT_SW_DEF_MSK 0xffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_TO_THR_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_TO_THR_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_CONT_FAIL_CNT_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_CONT_FAIL_CNT_MSK 0xffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_RESET BIT(16)
#define FWCMD_C2H_FRAME_TO_ACT_RPT_FRAME_FAIL_FLG BIT(17)
#define FWCMD_C2H_FRAME_TO_ACT_RPT_START_PKT_TIME_US_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_START_PKT_TIME_US_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_FREERUN_NOW_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_FREERUN_NOW_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_PKT_IN_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_PKT_IN_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_QUEUE_TIME_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_QUEUE_TIME_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_DURATION_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_DURATION_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_C2H_ENQUEUE_FAIL_CNT_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_C2H_ENQUEUE_FAIL_CNT_MSK 0xffffffff
#define FWCMD_C2H_FRAME_TO_ACT_RPT_FW_ACTION_SH 0
#define FWCMD_C2H_FRAME_TO_ACT_RPT_FW_ACTION_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_V2_CONTENT_SIZE_SH 0
#define FWCMD_C2H_EFUSE_DUMP_V2_CONTENT_SIZE_MSK 0xfff
#define FWCMD_C2H_EFUSE_DUMP_V2_END_BREAK_STATUS BIT(31)
#define FWCMD_C2H_EFUSE_DUMP_V2_CONTENT_SH 0
#define FWCMD_C2H_EFUSE_DUMP_V2_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_TXRPT_STATS_MACID_NUM_SH 0
#define FWCMD_C2H_TXRPT_STATS_MACID_NUM_MSK 0xff
#define FWCMD_C2H_TXRPT_STATS_C2H_MODE BIT(8)
#define FWCMD_C2H_TXRPT_STATS_STATUS_SH 9
#define FWCMD_C2H_TXRPT_STATS_STATUS_MSK 0xf
#define FWCMD_C2H_TXRPT_STATS_MACID_SH 0
#define FWCMD_C2H_TXRPT_STATS_MACID_MSK 0xffff
#define FWCMD_C2H_TXRPT_STATS_TP_SH 16
#define FWCMD_C2H_TXRPT_STATS_TP_MSK 0xffff
#define FWCMD_C2H_TXRPT_STATS_TXRPT_NUM_SH 0
#define FWCMD_C2H_TXRPT_STATS_TXRPT_NUM_MSK 0xffffffff
#define FWCMD_C2H_TXRPT_STATS_TOTAL_PKT_SUM_SH 0
#define FWCMD_C2H_TXRPT_STATS_TOTAL_PKT_SUM_MSK 0xffffffff
#define FWCMD_C2H_TXRPT_STATS_PKT_OK_SUM_SH 0
#define FWCMD_C2H_TXRPT_STATS_PKT_OK_SUM_MSK 0xffffffff
#define FWCMD_C2H_BCN_SYNC_RPT_BAND BIT(0)
#define FWCMD_C2H_BCN_SYNC_RPT_PORT_SH 1
#define FWCMD_C2H_BCN_SYNC_RPT_PORT_MSK 0x7
#define FWCMD_C2H_BCN_SYNC_RPT_RPT_ID_SH 4
#define FWCMD_C2H_BCN_SYNC_RPT_RPT_ID_MSK 0xf
#define FWCMD_C2H_BCN_SYNC_RPT_SEQ_NUM_SH 8
#define FWCMD_C2H_BCN_SYNC_RPT_SEQ_NUM_MSK 0xfff
#define FWCMD_C2H_BCN_SYNC_RPT_TSF_L_SH 0
#define FWCMD_C2H_BCN_SYNC_RPT_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_BCN_SYNC_RPT_TSF_H_SH 0
#define FWCMD_C2H_BCN_SYNC_RPT_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_TRX_TIME_STATS_BAND_0_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_BAND_0_MSK 0xf
#define FWCMD_C2H_TRX_TIME_STATS_STATUS_0_SH 4
#define FWCMD_C2H_TRX_TIME_STATS_STATUS_0_MSK 0xf
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME0_0_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME0_0_MSK 0xffffffff
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME1_0_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME1_0_MSK 0xffffffff
#define FWCMD_C2H_TRX_TIME_STATS_IDLE_TIME1_0_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_IDLE_TIME1_0_MSK 0xffffffff
#define FWCMD_C2H_TRX_TIME_STATS_BAND_1_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_BAND_1_MSK 0xf
#define FWCMD_C2H_TRX_TIME_STATS_STATUS_1_SH 4
#define FWCMD_C2H_TRX_TIME_STATS_STATUS_1_MSK 0xf
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME0_1_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME0_1_MSK 0xffffffff
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME1_1_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_BUSY_TIME1_1_MSK 0xffffffff
#define FWCMD_C2H_TRX_TIME_STATS_IDLE_TIME1_1_SH 0
#define FWCMD_C2H_TRX_TIME_STATS_IDLE_TIME1_1_MSK 0xffffffff
#define FWCMD_C2H_WAIT_ANNOUNCE_WAIT_CASE_SH 0
#define FWCMD_C2H_WAIT_ANNOUNCE_WAIT_CASE_MSK 0xf
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID0_SH 8
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID0_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID1_SH 16
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID1_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID2_SH 24
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID2_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID0_EXT_SH 0
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID0_EXT_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID1_EXT_SH 8
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID1_EXT_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID2_EXT_SH 16
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID2_EXT_MSK 0xff
#define FWCMD_C2H_STAT_RPT_TWT_ERR_REC_SH 0
#define FWCMD_C2H_STAT_RPT_TWT_ERR_REC_MSK 0xffffffff
#define FWCMD_C2H_STAT_RPT_TWT_INFO_SH 0
#define FWCMD_C2H_STAT_RPT_TWT_INFO_MSK 0xffffffff
#define FWCMD_C2H_AOAC_REPORT_AOAC_REPORT_SH 0
#define FWCMD_C2H_AOAC_REPORT_AOAC_REPORT_MSK 0xffffffff
#define FWCMD_C2H_READ_WOW_CAM_VALUE_LEN_SH 0
#define FWCMD_C2H_READ_WOW_CAM_VALUE_LEN_MSK 0x7ff
#define FWCMD_C2H_READ_WOW_CAM_IDX_SH 24
#define FWCMD_C2H_READ_WOW_CAM_IDX_MSK 0xff
#define FWCMD_C2H_READ_WOW_CAM_WOW_CAM_SH 0
#define FWCMD_C2H_READ_WOW_CAM_WOW_CAM_MSK 0xffffffff
#define FWCMD_C2H_APF_RPT_PROGRAM_NUMBER_SH 0
#define FWCMD_C2H_APF_RPT_PROGRAM_NUMBER_MSK 0xff
#define FWCMD_C2H_APF_RPT_PROGRAM_LEN_SH 0
#define FWCMD_C2H_APF_RPT_PROGRAM_LEN_MSK 0xffff
#define FWCMD_C2H_APF_RPT_DATA_LEN_SH 16
#define FWCMD_C2H_APF_RPT_DATA_LEN_MSK 0xffff
#define FWCMD_C2H_APF_RPT_PROGRAM_PTR_SH 0
#define FWCMD_C2H_APF_RPT_PROGRAM_PTR_MSK 0xffffffff
#define FWCMD_C2H_MCC_RCV_ACK_GROUP_SH 0
#define FWCMD_C2H_MCC_RCV_ACK_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_RCV_ACK_H2C_FUNC_SH 8
#define FWCMD_C2H_MCC_RCV_ACK_H2C_FUNC_MSK 0xff
#define FWCMD_C2H_MCC_REQ_ACK_GROUP_SH 0
#define FWCMD_C2H_MCC_REQ_ACK_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_REQ_ACK_H2C_RETURN_SH 2
#define FWCMD_C2H_MCC_REQ_ACK_H2C_RETURN_MSK 0x3f
#define FWCMD_C2H_MCC_REQ_ACK_H2C_FUNC_SH 8
#define FWCMD_C2H_MCC_REQ_ACK_H2C_FUNC_MSK 0xff
#define FWCMD_C2H_MCC_TSF_RPT_MACID_X_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_MACID_X_MSK 0xff
#define FWCMD_C2H_MCC_TSF_RPT_MACID_Y_SH 8
#define FWCMD_C2H_MCC_TSF_RPT_MACID_Y_MSK 0xff
#define FWCMD_C2H_MCC_TSF_RPT_GROUP_SH 16
#define FWCMD_C2H_MCC_TSF_RPT_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_X_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_X_MSK 0xffffffff
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_X_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_X_MSK 0xffffffff
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_Y_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_Y_MSK 0xffffffff
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_Y_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_Y_MSK 0xffffffff
#define FWCMD_C2H_MCC_STATUS_RPT_STATUS_SH 0
#define FWCMD_C2H_MCC_STATUS_RPT_STATUS_MSK 0x3f
#define FWCMD_C2H_MCC_STATUS_RPT_GROUP_SH 6
#define FWCMD_C2H_MCC_STATUS_RPT_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_STATUS_RPT_MACID_SH 8
#define FWCMD_C2H_MCC_STATUS_RPT_MACID_MSK 0xff
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_LOW_SH 0
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_LOW_MSK 0xffffffff
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_HIGH_SH 0
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_HIGH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_WRITE_ADDR_SH 0
#define FWCMD_C2H_PLAT_FLASH_WRITE_ADDR_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_WRITE_LENGTH_SH 0
#define FWCMD_C2H_PLAT_FLASH_WRITE_LENGTH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_ERASE_ADDR_SH 0
#define FWCMD_C2H_PLAT_FLASH_ERASE_ADDR_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_ERASE_LENGTH_SH 0
#define FWCMD_C2H_PLAT_FLASH_ERASE_LENGTH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_READ_ADDR_SH 0
#define FWCMD_C2H_PLAT_FLASH_READ_ADDR_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_READ_LENGTH_SH 0
#define FWCMD_C2H_PLAT_FLASH_READ_LENGTH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_READ_PAYLOAD_SH 0
#define FWCMD_C2H_PLAT_FLASH_READ_PAYLOAD_MSK 0xffffffff
#define FWCMD_C2H_FCS_RPT_STATUS_SH 0
#define FWCMD_C2H_FCS_RPT_STATUS_MSK 0xffffffff
#define FWCMD_C2H_WPS_RPT_STATE_SH 0
#define FWCMD_C2H_WPS_RPT_STATE_MSK 0xff
#define FWCMD_C2H_CCXRPT_DWORD0_SH 0
#define FWCMD_C2H_CCXRPT_DWORD0_MSK 0xffffffff
#define FWCMD_C2H_CCXRPT_DWORD1_SH 0
#define FWCMD_C2H_CCXRPT_DWORD1_MSK 0xffffffff
#define FWCMD_C2H_CCXRPT_DWORD2_SH 0
#define FWCMD_C2H_CCXRPT_DWORD2_MSK 0xffffffff
#define FWCMD_C2H_CCXRPT_DWORD3_SH 0
#define FWCMD_C2H_CCXRPT_DWORD3_MSK 0xffffffff
#define FWCMD_C2H_CCXRPT_DWORD4_SH 0
#define FWCMD_C2H_CCXRPT_DWORD4_MSK 0xffffffff
#define FWCMD_C2H_CCXRPT_DWORD5_SH 0
#define FWCMD_C2H_CCXRPT_DWORD5_MSK 0xffffffff
#define FWCMD_C2H_BF_SENS_FEEDBACK_MACID_SH 0
#define FWCMD_C2H_BF_SENS_FEEDBACK_MACID_MSK 0xfff
#define FWCMD_C2H_BF_SENS_FEEDBACK_MSR_SETUP_ID_SH 12
#define FWCMD_C2H_BF_SENS_FEEDBACK_MSR_SETUP_ID_MSK 0x7
#define FWCMD_C2H_BF_SENS_FEEDBACK_TERMINATE BIT(15)
#define FWCMD_C2H_BF_SENS_FEEDBACK_MSR_INST_ID_SH 16
#define FWCMD_C2H_BF_SENS_FEEDBACK_MSR_INST_ID_MSK 0x3f
#define FWCMD_C2H_BF_SENS_FEEDBACK_TB_MORE_TF BIT(22)
#define FWCMD_C2H_BF_SENS_FEEDBACK_TB_COMEBACK BIT(23)
#define FWCMD_C2H_BF_SENS_FEEDBACK_STATUS_BITMAP_SH 0
#define FWCMD_C2H_BF_SENS_FEEDBACK_STATUS_BITMAP_MSK 0xffffffff
#define FWCMD_C2H_GET_PUNC_REF_SEL_SH 0
#define FWCMD_C2H_GET_PUNC_REF_SEL_MSK 0xf
#define FWCMD_C2H_GET_PUNC_BW_SH 4
#define FWCMD_C2H_GET_PUNC_BW_MSK 0xf
#define FWCMD_C2H_GET_PUNC_BAND BIT(8)
#define FWCMD_C2H_GET_PUNC_BITMAP_SH 16
#define FWCMD_C2H_GET_PUNC_BITMAP_MSK 0xffff
#define FWCMD_C2H_PORT_INIT_STAT_BAND BIT(0)
#define FWCMD_C2H_PORT_INIT_STAT_PORT_SH 1
#define FWCMD_C2H_PORT_INIT_STAT_PORT_MSK 0x7
#define FWCMD_C2H_PORT_INIT_STAT_CFG_MBID_IDX_SH 8
#define FWCMD_C2H_PORT_INIT_STAT_CFG_MBID_IDX_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_CFG_TYPE_SH 16
#define FWCMD_C2H_PORT_INIT_STAT_CFG_TYPE_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_STEP_SH 24
#define FWCMD_C2H_PORT_INIT_STAT_STEP_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_CFG_VAL_SH 0
#define FWCMD_C2H_PORT_INIT_STAT_CFG_VAL_MSK 0xffffffff
#define FWCMD_C2H_PORT_INIT_STAT_RET_SH 0
#define FWCMD_C2H_PORT_INIT_STAT_RET_MSK 0xffffffff
#define FWCMD_C2H_PORT_CFG_STAT_BAND BIT(0)
#define FWCMD_C2H_PORT_CFG_STAT_PORT_SH 1
#define FWCMD_C2H_PORT_CFG_STAT_PORT_MSK 0x7
#define FWCMD_C2H_PORT_CFG_STAT_MBSSID_IDX_SH 8
#define FWCMD_C2H_PORT_CFG_STAT_MBSSID_IDX_MSK 0xff
#define FWCMD_C2H_PORT_CFG_STAT_TYPE_SH 16
#define FWCMD_C2H_PORT_CFG_STAT_TYPE_MSK 0xff
#define FWCMD_C2H_PORT_CFG_STAT_VAL_SH 0
#define FWCMD_C2H_PORT_CFG_STAT_VAL_MSK 0xffffffff
#define FWCMD_C2H_PORT_CFG_STAT_RET_SH 0
#define FWCMD_C2H_PORT_CFG_STAT_RET_MSK 0xffffffff
#define FWCMD_C2H_OFDMA_STS_TFSTS_USER_NUM_SH 0
#define FWCMD_C2H_OFDMA_STS_TFSTS_USER_NUM_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_RU_SU_PER_SH 8
#define FWCMD_C2H_OFDMA_STS_TFSTS_RU_SU_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_MACID_SH 0
#define FWCMD_C2H_OFDMA_STS_TFSTS_MACID_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_TB_RATE_SH 8
#define FWCMD_C2H_OFDMA_STS_TFSTS_TB_RATE_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_TB_FAIL_PER_SH 16
#define FWCMD_C2H_OFDMA_STS_TFSTS_TB_FAIL_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_AVG_TB_RSSI_SH 24
#define FWCMD_C2H_OFDMA_STS_TFSTS_AVG_TB_RSSI_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_CCA_MISS_PER_SH 0
#define FWCMD_C2H_OFDMA_STS_TFSTS_CCA_MISS_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_AVG_UPH_SH 8
#define FWCMD_C2H_OFDMA_STS_TFSTS_AVG_UPH_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_MINFLAG_PER_SH 16
#define FWCMD_C2H_OFDMA_STS_TFSTS_MINFLAG_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_AVG_TB_EVM_SH 24
#define FWCMD_C2H_OFDMA_STS_TFSTS_AVG_TB_EVM_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_TFSTS_TF_NUM_SH 0
#define FWCMD_C2H_OFDMA_STS_TFSTS_TF_NUM_MSK 0xffffffff
#define FWCMD_C2H_OFDMA_STS_TFSTS_BSR_LEN_SH 0
#define FWCMD_C2H_OFDMA_STS_TFSTS_BSR_LEN_MSK 0xffff
#define FWCMD_C2H_OFDMA_STS_TFSTS_MACID_EXT_SH 16
#define FWCMD_C2H_OFDMA_STS_TFSTS_MACID_EXT_MSK 0xffff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_USER_NUM_SH 0
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_USER_NUM_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_TOTAL_SU_RU_RATIO_SH 8
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_TOTAL_SU_RU_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_TOTAL_RU_FAIL_RATIO_SH 16
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_TOTAL_RU_FAIL_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_TOTAL_SU_FAIL_RATIO_SH 24
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_TOTAL_SU_FAIL_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_MACID_SH 0
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_MACID_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_SU_RU_RATIO_SH 8
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_SU_RU_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_SU_FAIL_SH 16
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_SU_FAIL_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_RU_FAIL_SH 24
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_RU_FAIL_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_AVG_AGG_SH 0
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_AVG_AGG_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_RU_RATE_MCS_SH 8
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_RU_RATE_MCS_MSK 0xf
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_RU_RATE_NSS_SH 12
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_RU_RATE_NSS_MSK 0xf
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_MACID_EXT_SH 16
#define FWCMD_C2H_OFDMA_STS_DLRUSTS_MACID_EXT_MSK 0xffff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_USER_NUM_SH 0
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_USER_NUM_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_RU_SU_PER_SH 8
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_RU_SU_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_MACID_SH 16
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_MACID_MSK 0x3ff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_TB_RATE_SH 8
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_TB_RATE_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_TB_FAIL_PER_SH 16
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_TB_FAIL_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_AVG_TB_RSSI_SH 24
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_AVG_TB_RSSI_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_CCA_MISS_PER_SH 0
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_CCA_MISS_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_AVG_UPH_SH 8
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_AVG_UPH_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_MINFLAG_PER_SH 16
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_MINFLAG_PER_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_AVG_TB_EVM_SH 24
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_AVG_TB_EVM_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_TF_NUM_SH 0
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_TF_NUM_MSK 0xffffffff
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_BSR_LEN_SH 0
#define FWCMD_C2H_OFDMA_STS_V1_TFSTS_BSR_LEN_MSK 0xffff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_MACID_SH 16
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_MACID_MSK 0x3ff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_USER_NUM_SH 0
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_USER_NUM_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_TOTAL_SU_RU_RATIO_SH 8
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_TOTAL_SU_RU_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_TOTAL_RU_FAIL_RATIO_SH 16
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_TOTAL_RU_FAIL_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_TOTAL_SU_FAIL_RATIO_SH 24
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_TOTAL_SU_FAIL_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_SU_RU_RATIO_SH 8
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_SU_RU_RATIO_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_SU_FAIL_SH 16
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_SU_FAIL_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_RU_FAIL_SH 24
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_RU_FAIL_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_AVG_AGG_SH 0
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_AVG_AGG_MSK 0xff
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_RU_RATE_MCS_SH 8
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_RU_RATE_MCS_MSK 0xf
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_RU_RATE_NSS_SH 12
#define FWCMD_C2H_OFDMA_STS_V1_DLRUSTS_RU_RATE_NSS_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_MACID_SH 0
#define FWCMD_C2H_MLO_GET_TBL_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_GET_TBL_IS_DEF_VAL BIT(16)
#define FWCMD_C2H_MLO_GET_TBL_BE_MIN_B0_SH 0
#define FWCMD_C2H_MLO_GET_TBL_BE_MIN_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BE_MAX_B0_SH 4
#define FWCMD_C2H_MLO_GET_TBL_BE_MAX_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BE_MIN_B1_SH 8
#define FWCMD_C2H_MLO_GET_TBL_BE_MIN_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BE_MAX_B1_SH 12
#define FWCMD_C2H_MLO_GET_TBL_BE_MAX_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BK_MIN_B0_SH 16
#define FWCMD_C2H_MLO_GET_TBL_BK_MIN_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BK_MAX_B0_SH 20
#define FWCMD_C2H_MLO_GET_TBL_BK_MAX_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BK_MIN_B1_SH 24
#define FWCMD_C2H_MLO_GET_TBL_BK_MIN_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BK_MAX_B1_SH 28
#define FWCMD_C2H_MLO_GET_TBL_BK_MAX_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VI_MIN_B0_SH 0
#define FWCMD_C2H_MLO_GET_TBL_VI_MIN_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VI_MAX_B0_SH 4
#define FWCMD_C2H_MLO_GET_TBL_VI_MAX_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VI_MIN_B1_SH 8
#define FWCMD_C2H_MLO_GET_TBL_VI_MIN_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VI_MAX_B1_SH 12
#define FWCMD_C2H_MLO_GET_TBL_VI_MAX_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VO_MIN_B0_SH 16
#define FWCMD_C2H_MLO_GET_TBL_VO_MIN_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VO_MAX_B0_SH 20
#define FWCMD_C2H_MLO_GET_TBL_VO_MAX_B0_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VO_MIN_B1_SH 24
#define FWCMD_C2H_MLO_GET_TBL_VO_MIN_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VO_MAX_B1_SH 28
#define FWCMD_C2H_MLO_GET_TBL_VO_MAX_B1_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BE_BA_LIMIT_SH 0
#define FWCMD_C2H_MLO_GET_TBL_BE_BA_LIMIT_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_BK_BA_LIMIT_SH 4
#define FWCMD_C2H_MLO_GET_TBL_BK_BA_LIMIT_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VI_BA_LIMIT_SH 8
#define FWCMD_C2H_MLO_GET_TBL_VI_BA_LIMIT_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_VO_BA_LIMIT_SH 12
#define FWCMD_C2H_MLO_GET_TBL_VO_BA_LIMIT_MSK 0xf
#define FWCMD_C2H_MLO_GET_TBL_FIX_TO_B0 BIT(16)
#define FWCMD_C2H_MLO_GET_TBL_FIX_TO_B1 BIT(17)
#define FWCMD_C2H_MLO_GET_TBL_WAIT2C_EMPTY BIT(18)
#define FWCMD_C2H_MLO_GET_TBL_CUR_BAND BIT(19)
#define FWCMD_C2H_MLO_GET_TBL_B0_CHK BIT(20)
#define FWCMD_C2H_MLO_GET_TBL_B1_CHK BIT(21)
#define FWCMD_C2H_MLO_GET_TBL_EXT0_CHK BIT(22)
#define FWCMD_C2H_MLO_GET_TBL_EXT1_CHK BIT(23)
#define FWCMD_C2H_MLO_GET_TBL_WD_DROP_BE BIT(24)
#define FWCMD_C2H_MLO_GET_TBL_WD_DROP_BK BIT(25)
#define FWCMD_C2H_MLO_GET_TBL_WD_DROP_VI BIT(26)
#define FWCMD_C2H_MLO_GET_TBL_WD_DROP_VO BIT(27)
#define FWCMD_C2H_MLO_GET_TBL_PRI_BAND BIT(28)
#define FWCMD_C2H_EMLSR_TRANS_DONE_MACID_SH 0
#define FWCMD_C2H_EMLSR_TRANS_DONE_MACID_MSK 0xff
#define FWCMD_C2H_EMLSR_TRANS_DONE_EXT_MACID_SH 8
#define FWCMD_C2H_EMLSR_TRANS_DONE_EXT_MACID_MSK 0xff
#define FWCMD_C2H_EMLSR_STA_CFG_DONE_MACID_SH 0
#define FWCMD_C2H_EMLSR_STA_CFG_DONE_MACID_MSK 0xffff
#define FWCMD_C2H_EMLSR_STA_CFG_DONE_ENABLE BIT(16)
#define FWCMD_C2H_EMLSR_STA_CFG_DONE_STATUS_SH 24
#define FWCMD_C2H_EMLSR_STA_CFG_DONE_STATUS_MSK 0xf
#define FWCMD_C2H_MCMLO_RELINK_RPT_MACID_SH 0
#define FWCMD_C2H_MCMLO_RELINK_RPT_MACID_MSK 0xffff
#define FWCMD_C2H_MCMLO_RELINK_RPT_AC_BMP_SH 16
#define FWCMD_C2H_MCMLO_RELINK_RPT_AC_BMP_MSK 0xf
#define FWCMD_C2H_MCMLO_RELINK_RPT_OPERATION_SH 20
#define FWCMD_C2H_MCMLO_RELINK_RPT_OPERATION_MSK 0x3
#define FWCMD_C2H_MCMLO_RELINK_RPT_BAND BIT(22)
#define FWCMD_C2H_MCMLO_RELINK_RPT_STATUS_SH 24
#define FWCMD_C2H_MCMLO_RELINK_RPT_STATUS_MSK 0xff
#define FWCMD_C2H_MCMLO_SN_SYNC_RPT_SRC_LINK_IDX_SH 0
#define FWCMD_C2H_MCMLO_SN_SYNC_RPT_SRC_LINK_IDX_MSK 0x3
#define FWCMD_C2H_MCMLO_SN_SYNC_RPT_MACID_START_SH 0
#define FWCMD_C2H_MCMLO_SN_SYNC_RPT_MACID_START_MSK 0xffff
#define FWCMD_C2H_MCMLO_SN_SYNC_RPT_MACID_NUM_SH 16
#define FWCMD_C2H_MCMLO_SN_SYNC_RPT_MACID_NUM_MSK 0xffff
#define FWCMD_C2H_MLO_LINK_CFG_STAT_MACID_SH 0
#define FWCMD_C2H_MLO_LINK_CFG_STAT_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_LINK_CFG_STAT_STATUS_SH 16
#define FWCMD_C2H_MLO_LINK_CFG_STAT_STATUS_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_MAIN_MACID_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_MAIN_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_ID_SH 16
#define FWCMD_C2H_MLO_DM_DBG_DUMP_ID_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_CUR_INDEX_SH 20
#define FWCMD_C2H_MLO_DM_DBG_DUMP_CUR_INDEX_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_DECISION_SH 24
#define FWCMD_C2H_MLO_DM_DBG_DUMP_DECISION_MSK 0xff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_CUR_MLO_MIN_LVL_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_CUR_MLO_MIN_LVL_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_CUR_MLO_MAX_LVL_SH 4
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_CUR_MLO_MAX_LVL_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_CUR_MLO_MIN_LVL_SH 8
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_CUR_MLO_MIN_LVL_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_CUR_MLO_MAX_LVL_SH 12
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_CUR_MLO_MAX_LVL_MSK 0xf
#define FWCMD_C2H_MLO_DM_DBG_DUMP_CUR_TX_LINK_SH 16
#define FWCMD_C2H_MLO_DM_DBG_DUMP_CUR_TX_LINK_MSK 0x3
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_TOTAL_PKT_SUM_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_TOTAL_PKT_SUM_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_TOTAL_PKT_SUM_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_TOTAL_PKT_SUM_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_PKT_OK_SUM_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_PKT_OK_SUM_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_PKT_OK_SUM_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_PKT_OK_SUM_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_TX_LEN_SUM_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_TX_LEN_SUM_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_TX_LEN_SUM_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_TX_LEN_SUM_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_EST_TP_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_EST_TP_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_EST_TP_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_EST_TP_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_TP_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_TP_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_TP_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_TP_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_Q_EMPTY_SH 0
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_Q_EMPTY_MSK 0xff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_Q_EMPTY_SH 8
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_Q_EMPTY_MSK 0xff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_UTIL_SH 16
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B0_UTIL_MSK 0xff
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_UTIL_SH 24
#define FWCMD_C2H_MLO_DM_DBG_DUMP_B1_UTIL_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_ENABLE BIT(0)
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_RELINK_SH 1
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_RELINK_MSK 0x3
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_INTERVAL_SH 3
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_INTERVAL_MSK 0x1f
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_0_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_0_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_1_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_1_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_2_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_2_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_3_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_3_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_4_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_4_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_5_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_5_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_6_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_6_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_7_EXIST_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_7_EXIST_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_0_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_0_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_1_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_1_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_2_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_2_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_3_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_3_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_4_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_4_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_5_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_5_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_6_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_6_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_7_VALID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_STA_LST_7_VALID_MSK 0xffffffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_LST_EN_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_LST_EN_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_LST_VALID_SH 8
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_LST_VALID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_0_MLD_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_0_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_1_MLD_SH 8
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_1_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_2_MLD_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_2_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_3_MLD_SH 24
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_3_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_4_MLD_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_4_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_5_MLD_SH 8
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_5_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_6_MLD_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_6_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_7_MLD_SH 24
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_DBG_7_MLD_MSK 0xff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_0_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_0_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_1_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_1_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_2_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_2_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_3_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_3_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_4_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_4_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_5_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_5_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_6_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_6_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_7_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_7_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_8_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_8_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_9_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_9_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_10_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_10_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_11_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_11_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_12_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_12_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_13_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_13_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_14_MACID_SH 0
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_14_MACID_MSK 0xffff
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_15_MACID_SH 16
#define FWCMD_C2H_MLO_DM_STATUS_DUMP_SND_15_MACID_MSK 0xffff
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_MACID_SH 0
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_MACID_MSK 0x3ff
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_AC_SH 16
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_AC_MSK 0x3
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_TBL_SEL_SH 28
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_TBL_SEL_MSK 0x7
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_READ_DATA_SH 0
#define FWCMD_C2H_MCMLO_TABLE_ACC_RPT_READ_DATA_MSK 0xffffffff
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_CAT_SH 0
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_CAT_MSK 0x3
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_CLASS_SH 2
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_FUNC_SH 8
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_SCHEDULE_ID_SH 0
#define FWCMD_C2H_ACT_SCHEDULE_REQ_ACK_SCHEDULE_ID_MSK 0xffffffff
#define FWCMD_C2H_BCN_REQ_ACK_CAT_SH 0
#define FWCMD_C2H_BCN_REQ_ACK_CAT_MSK 0x3
#define FWCMD_C2H_BCN_REQ_ACK_CLASS_SH 2
#define FWCMD_C2H_BCN_REQ_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_BCN_REQ_ACK_FUNC_SH 8
#define FWCMD_C2H_BCN_REQ_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_BCN_REQ_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_BCN_REQ_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_BCN_REQ_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_BCN_REQ_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_CAT_SH 0
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_CAT_MSK 0x3
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_CLASS_SH 2
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_FUNC_SH 8
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_NAN_FUNC_CTRL_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_NAN_DE_INFO_ACK_CAT_SH 0
#define FWCMD_C2H_NAN_DE_INFO_ACK_CAT_MSK 0x3
#define FWCMD_C2H_NAN_DE_INFO_ACK_CLASS_SH 2
#define FWCMD_C2H_NAN_DE_INFO_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_NAN_DE_INFO_ACK_FUNC_SH 8
#define FWCMD_C2H_NAN_DE_INFO_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_NAN_DE_INFO_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_NAN_DE_INFO_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_NAN_DE_INFO_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_NAN_DE_INFO_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_CAT_SH 0
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_CAT_MSK 0x3
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_CLASS_SH 2
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_FUNC_SH 8
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_NAN_JOIN_CLUSTER_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_CAT_SH 0
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_CAT_MSK 0x3
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_CLASS_SH 2
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_FUNC_SH 8
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_NAN_PAUSE_FAW_TX_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_INFO1_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_INFO1_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID0_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID0_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID1_SH 8
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID1_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID2_SH 16
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID2_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID3_SH 24
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID3_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID4_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID4_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID5_SH 8
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_CLUSTER_ID5_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_MASTERPREF_SH 16
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_MASTERPREF_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_RANDOMFACTOR_SH 24
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_RANDOMFACTOR_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_AMR_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_AMR_MSK 0xffffffff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_AMBTT_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_AMBTT_MSK 0xffffffff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_HOPCOUNT_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_HOPCOUNT_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_AMR_HIGH_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_INFO_AMR_HIGH_MSK 0xffffffff
#define FWCMD_C2H_NAN_INFO_NOTIFY_TSF_INFO_INFO2_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_TSF_INFO_INFO2_MSK 0xff
#define FWCMD_C2H_NAN_INFO_NOTIFY_TSF_INFO_PORT_DWST_LOW_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_TSF_INFO_PORT_DWST_LOW_MSK 0xffffffff
#define FWCMD_C2H_NAN_INFO_NOTIFY_TSF_INFO_FR_DWST_LOW_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_TSF_INFO_FR_DWST_LOW_MSK 0xffffffff
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_JOIN_INFO3_SH 0
#define FWCMD_C2H_NAN_INFO_NOTIFY_CLUSTER_JOIN_INFO3_MSK 0xff
#define FWCMD_C2H_NAN_DEINIT_RPT_STATUS_SH 0
#define FWCMD_C2H_NAN_DEINIT_RPT_STATUS_MSK 0xff
#define FWCMD_C2H_MRC_TSF_RPT_REQ_TSF_NUM_SH 0
#define FWCMD_C2H_MRC_TSF_RPT_REQ_TSF_NUM_MSK 0xff
#define FWCMD_C2H_MRC_TSF_RPT_TSF_LOW_SH 0
#define FWCMD_C2H_MRC_TSF_RPT_TSF_LOW_MSK 0xffffffff
#define FWCMD_C2H_MRC_TSF_RPT_TSF_HIGH_SH 0
#define FWCMD_C2H_MRC_TSF_RPT_TSF_HIGH_MSK 0xffffffff
#define FWCMD_C2H_MRC_STATUS_RPT_STATUS_SH 0
#define FWCMD_C2H_MRC_STATUS_RPT_STATUS_MSK 0x3f
#define FWCMD_C2H_MRC_STATUS_RPT_SCH_IDX_SH 6
#define FWCMD_C2H_MRC_STATUS_RPT_SCH_IDX_MSK 0x3
#define FWCMD_C2H_MRC_STATUS_RPT_TSF_LOW_SH 0
#define FWCMD_C2H_MRC_STATUS_RPT_TSF_LOW_MSK 0xffffffff
#define FWCMD_C2H_MRC_STATUS_RPT_TSF_HIGH_SH 0
#define FWCMD_C2H_MRC_STATUS_RPT_TSF_HIGH_MSK 0xffffffff
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID_CNT_SH 0
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID_CNT_MSK 0x7
#define FWCMD_C2H_MRC_STATUS_RPT_MASTER_MACID_SH 16
#define FWCMD_C2H_MRC_STATUS_RPT_MASTER_MACID_MSK 0xffff
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID0_SH 0
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID0_MSK 0xffff
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID1_SH 16
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID1_MSK 0xffff
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID2_SH 0
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID2_MSK 0xffff
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID3_SH 16
#define FWCMD_C2H_MRC_STATUS_RPT_CUR_MACID3_MSK 0xffff
#define FWCMD_C2H_MRC_NOTIFY_EVT_STATUS_SH 0
#define FWCMD_C2H_MRC_NOTIFY_EVT_STATUS_MSK 0xff
#define FWCMD_C2H_MRC_NOTIFY_EVT_BAND_SH 8
#define FWCMD_C2H_MRC_NOTIFY_EVT_BAND_MSK 0xf
#define FWCMD_C2H_MRC_NOTIFY_EVT_PORT_SH 12
#define FWCMD_C2H_MRC_NOTIFY_EVT_PORT_MSK 0xf
#define FWCMD_C2H_DOZE_TIME_RPT_MACID_SH 0
#define FWCMD_C2H_DOZE_TIME_RPT_MACID_MSK 0xff
#define FWCMD_C2H_DOZE_TIME_RPT_DOZE_TIME_SH 0
#define FWCMD_C2H_DOZE_TIME_RPT_DOZE_TIME_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD0_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD0_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD1_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD1_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD2_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD2_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD3_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD3_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD4_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD4_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD5_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD5_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD6_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD6_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD7_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD7_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD8_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD8_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD9_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD9_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD10_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD10_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD11_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD11_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD12_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD12_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD13_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD13_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD14_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD14_MSK 0xffffffff
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD15_SH 0
#define FWCMD_C2H_DCTL_INFO_DWORD_DWORD15_MSK 0xffffffff
#define FWCMD_C2H_OM_ADV_RPT_MACID_SH 0
#define FWCMD_C2H_OM_ADV_RPT_MACID_MSK 0xffff
#define FWCMD_C2H_OM_ADV_RPT_TYPE_SH 16
#define FWCMD_C2H_OM_ADV_RPT_TYPE_MSK 0xf
#define FWCMD_C2H_WOW_DIAG_RPT_TSF_H_SH 0
#define FWCMD_C2H_WOW_DIAG_RPT_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_RPT_TSF_L_SH 0
#define FWCMD_C2H_WOW_DIAG_RPT_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_RPT_ERR_CODE_SH 0
#define FWCMD_C2H_WOW_DIAG_RPT_ERR_CODE_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_GTK_M1_RCV_SH 0
#define FWCMD_C2H_WOW_DIAG_GTK_M1_RCV_MSK 0xffff
#define FWCMD_C2H_WOW_DIAG_GTK_M2_ENQ_SH 16
#define FWCMD_C2H_WOW_DIAG_GTK_M2_ENQ_MSK 0xffff
#define FWCMD_C2H_WOW_DIAG_GTK_M2_SUC_SH 0
#define FWCMD_C2H_WOW_DIAG_GTK_M2_SUC_MSK 0xffff
#define FWCMD_C2H_WOW_DIAG_GTK_MAC_DROP_SH 16
#define FWCMD_C2H_WOW_DIAG_GTK_MAC_DROP_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_LIFE_DROP_SH 24
#define FWCMD_C2H_WOW_DIAG_GTK_LIFE_DROP_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_RETRY_DROP_SH 0
#define FWCMD_C2H_WOW_DIAG_GTK_RETRY_DROP_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_OTHER_ERR_SH 8
#define FWCMD_C2H_WOW_DIAG_GTK_OTHER_ERR_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_M1_RCV_LAST_SH 16
#define FWCMD_C2H_WOW_DIAG_GTK_M1_RCV_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_M2_ENQ_LAST_SH 24
#define FWCMD_C2H_WOW_DIAG_GTK_M2_ENQ_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_MAC_DROP_LAST_SH 0
#define FWCMD_C2H_WOW_DIAG_GTK_MAC_DROP_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_LIFE_DROP_LAST_SH 8
#define FWCMD_C2H_WOW_DIAG_GTK_LIFE_DROP_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_RETRY_DROP_LAST_SH 16
#define FWCMD_C2H_WOW_DIAG_GTK_RETRY_DROP_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_GTK_OTHER_ERR_LAST_SH 24
#define FWCMD_C2H_WOW_DIAG_GTK_OTHER_ERR_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_BCN_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_AP_LOST_BCN_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_TX_SUCCESS_CNT_SH 8
#define FWCMD_C2H_WOW_DIAG_AP_LOST_TX_SUCCESS_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_TX_FAIL_CNT_SH 16
#define FWCMD_C2H_WOW_DIAG_AP_LOST_TX_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_TX_FAIL_RSN_SH 24
#define FWCMD_C2H_WOW_DIAG_AP_LOST_TX_FAIL_RSN_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_DISCONNECT_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_AP_LOST_DISCONNECT_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_DISCONNECT_LIMIT_SH 8
#define FWCMD_C2H_WOW_DIAG_AP_LOST_DISCONNECT_LIMIT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_RETRY_CNT_SH 16
#define FWCMD_C2H_WOW_DIAG_AP_LOST_RETRY_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_AP_LOST_RETRY_LIMIT_SH 24
#define FWCMD_C2H_WOW_DIAG_AP_LOST_RETRY_LIMIT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_SER_L0_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_SER_L0_CNT_MSK 0xffff
#define FWCMD_C2H_WOW_DIAG_SER_L1_CNT_SH 16
#define FWCMD_C2H_WOW_DIAG_SER_L1_CNT_MSK 0xffff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_RX_EVT_MASK_SH 0
#define FWCMD_C2H_WOW_DIAG_RX_EVT_RX_EVT_MASK_MSK 0xffffff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_RX_EVT_CNT_SH 24
#define FWCMD_C2H_WOW_DIAG_RX_EVT_RX_EVT_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_EARLY_SH 0
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_EARLY_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_OK_SH 0
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_OK_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_NO_HIT_SH 0
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_NO_HIT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_LOST_RATE_SH 0
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_LOST_RATE_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_ROLE_IDX_SH 8
#define FWCMD_C2H_WOW_DIAG_RX_EVT_BCN_ROLE_IDX_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_LAST_TSF_H_SH 0
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_LAST_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_LAST_TSF_L_SH 0
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_LAST_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_ENQ_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_ENQ_CNT_MSK 0xffff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_ENQ_FAIL_CNT_SH 16
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_ENQ_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_FAIL_CNT_SH 24
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_RESULT_LAST_SH 0
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_RESULT_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_RET_TYPE_LAST_SH 8
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_TX_RET_TYPE_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_DISABLED BIT(16)
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_INVALID_BANDPORT BIT(17)
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_DISCONNECT BIT(18)
#define FWCMD_C2H_WOW_DIAG_KEEPALIVE_PKT_OFLD_FAIL BIT(19)
#define FWCMD_C2H_WOW_DIAG_ARP_ARP_REQ_LAST_TSF_H_SH 0
#define FWCMD_C2H_WOW_DIAG_ARP_ARP_REQ_LAST_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_ARP_ARP_REQ_LAST_TSF_L_SH 0
#define FWCMD_C2H_WOW_DIAG_ARP_ARP_REQ_LAST_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_ARP_TX_RESULT_LAST_SH 0
#define FWCMD_C2H_WOW_DIAG_ARP_TX_RESULT_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_ARP_TX_RET_TYPE_LAST_SH 8
#define FWCMD_C2H_WOW_DIAG_ARP_TX_RET_TYPE_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_ARP_BSSID_MATCH_LAST BIT(16)
#define FWCMD_C2H_WOW_DIAG_ARP_IP_MATCH_LAST BIT(17)
#define FWCMD_C2H_WOW_DIAG_ARP_ACT_WAKEUP BIT(18)
#define FWCMD_C2H_WOW_DIAG_ARP_TKIP_WAKEUP BIT(19)
#define FWCMD_C2H_WOW_DIAG_ARP_PKT_OFLD_FAIL BIT(20)
#define FWCMD_C2H_WOW_DIAG_ARP_ENQ_FAIL_LAST BIT(21)
#define FWCMD_C2H_WOW_DIAG_PMF_ACT_LAST_TSF_H_SH 0
#define FWCMD_C2H_WOW_DIAG_PMF_ACT_LAST_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PMF_ACT_LAST_TSF_L_SH 0
#define FWCMD_C2H_WOW_DIAG_PMF_ACT_LAST_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PMF_DEAUTH_LAST_TSF_H_SH 0
#define FWCMD_C2H_WOW_DIAG_PMF_DEAUTH_LAST_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PMF_DEAUTH_LAST_TSF_L_SH 0
#define FWCMD_C2H_WOW_DIAG_PMF_DEAUTH_LAST_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PMF_TX_RESULT_LAST_SH 0
#define FWCMD_C2H_WOW_DIAG_PMF_TX_RESULT_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_PMF_TX_RET_TYPE_LAST_SH 8
#define FWCMD_C2H_WOW_DIAG_PMF_TX_RET_TYPE_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_PMF_NO_FCS_LAST BIT(16)
#define FWCMD_C2H_WOW_DIAG_PMF_SA_QUERY_REQ_LAST BIT(17)
#define FWCMD_C2H_WOW_DIAG_PMF_PKT_OFLOD_FAIL_LAST BIT(18)
#define FWCMD_C2H_WOW_DIAG_PMF_ENQ_LAST BIT(19)
#define FWCMD_C2H_WOW_DIAG_PMF_ENQ_FAIL_LAST BIT(20)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_NULL_PARM BIT(0)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_DISABLED BIT(1)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_WRONG_ROLE BIT(2)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_TX_TIMER_FAIL BIT(3)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_TM_TIMER_FAIL BIT(4)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_RD_PKT_OFLD_FAIL BIT(5)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_ENQ_FAIL BIT(6)
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_RETRY_CNT_SH 8
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_RETRY_CNT_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_TX_RESULT_LAST_SH 16
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_TX_RESULT_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_TX_RET_TYPE_LAST_SH 24
#define FWCMD_C2H_WOW_DIAG_TCP_KEEPALIVE_TX_RET_TYPE_LAST_MSK 0xff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_RECV_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_RECV_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_RSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_RSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_NO_CORRSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_NO_CORRSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_NO_MEM_DROP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_MDNS_NO_MEM_DROP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_RECV_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_RECV_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_RSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_RSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_NO_CORRSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_NO_CORRSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_NO_MEM_DROP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_SNMP_NO_MEM_DROP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_RECV_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_RECV_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_RSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_RSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_NO_CORRSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_NO_CORRSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_NO_MEM_DROP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_LLMNR_NO_MEM_DROP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_RECV_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_RECV_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_RSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_RSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_NO_CORRSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_NO_CORRSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_NO_MEM_DROP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_NETBIOS_NO_MEM_DROP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_RECV_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_RECV_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_RSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_RSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_NO_CORRSP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_NO_CORRSP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_NO_MEM_DROP_CNT_SH 0
#define FWCMD_C2H_WOW_DIAG_PROXY_OFLD_PATTERN_NO_MEM_DROP_CNT_MSK 0xffffffff
#define FWCMD_C2H_WOW_DUMP_RX_BUF_LEN_SH 0
#define FWCMD_C2H_WOW_DUMP_RX_BUF_LEN_MSK 0xffff
#define FWCMD_C2H_WOW_DUMP_MEM_BUF_LEN_SH 0
#define FWCMD_C2H_WOW_DUMP_MEM_BUF_LEN_MSK 0xffff
#define FWCMD_C2H_WOW_DUMP_ROLE_ROLE_NUM_SH 0
#define FWCMD_C2H_WOW_DUMP_ROLE_ROLE_NUM_MSK 0xff
#define FWCMD_C2H_WOW_DUMP_BB_RF_REG_BUF_LEN_SH 0
#define FWCMD_C2H_WOW_DUMP_BB_RF_REG_BUF_LEN_MSK 0xffff
#define FWCMD_C2H_FTM_AZ_PKTID_CONTENT_FTM_AZ_PARA_TYPE_LEN_SH 0
#define FWCMD_C2H_FTM_AZ_PKTID_CONTENT_FTM_AZ_PARA_TYPE_LEN_MSK 0xff
#define FWCMD_C2H_FTM_AZ_PARA_DUMP_FTM_AZ_PARA_TYPE_LEN_SH 0
#define FWCMD_C2H_FTM_AZ_PARA_DUMP_FTM_AZ_PARA_TYPE_LEN_MSK 0xff
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_FTM_AZ_PARA_TYPE_LEN_SH 0
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_FTM_AZ_PARA_TYPE_LEN_MSK 0xff
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_FUNC_NO_SH 8
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_FUNC_NO_MSK 0xff
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_STAT_CODE_SH 16
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_STAT_CODE_MSK 0xff
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_ERROR_CODE_SH 24
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_ERROR_CODE_MSK 0xff
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_FW_DEFINE_SH 0
#define FWCMD_C2H_FTM_AZ_DBG_DUMP_FW_DEFINE_MSK 0xff
#define FWCMD_C2H_FTM_AZ_RPT_HDL_FTM_AZ_PARA_TYPE_LEN_SH 0
#define FWCMD_C2H_FTM_AZ_RPT_HDL_FTM_AZ_PARA_TYPE_LEN_MSK 0xff
#define FWCMD_C2H_FTM_MC_PKTID_CONTENT_FTM_MC_PARA_TYPE_LEN_SH 0
#define FWCMD_C2H_FTM_MC_PKTID_CONTENT_FTM_MC_PARA_TYPE_LEN_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_0_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_0_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_0 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_0 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_0_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_0_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_0_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_0_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_1_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_1_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_1 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_1 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_1_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_1_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_1_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_1_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_2_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_2_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_2 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_2 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_2_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_2_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_2_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_2_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_3_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_3_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_3 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_3 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_3_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_3_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_3_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_3_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_4_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_4_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_4 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_4 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_4_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_4_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_4_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_4_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_5_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_5_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_5 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_5 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_5_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_5_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_5_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_5_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_6_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_6_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_6 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_6 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_6_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_6_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_6_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_6_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_7_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_7_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_7 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_7 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_7_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_7_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_7_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_7_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_8_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_8_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_8 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_8 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_8_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_8_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_8_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_8_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_9_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_9_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_9 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_9 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_9_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_9_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_9_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_9_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_10_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_10_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_10 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_10 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_10_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_10_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_10_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_10_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_11_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_11_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_11 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_11 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_11_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_11_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_11_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_11_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_12_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_12_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_12 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_12 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_12_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_12_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_12_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_12_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_13_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_13_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_13 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_13 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_13_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_13_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_13_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_13_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_14_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_14_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_14 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_14 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_14_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_14_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_14_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_14_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_15_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_FEATURE_15_MSK 0xff
#define FWCMD_C2H_AP_SELF_DIAG_RST_LAST_15 BIT(8)
#define FWCMD_C2H_AP_SELF_DIAG_RST_BADN_15 BIT(9)
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_15_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_WARN_BITMAP_15_MSK 0xffffffff
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_15_SH 0
#define FWCMD_C2H_AP_SELF_DIAG_RST_ERR_BITMAP_15_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_CHK_NUM_NORMAL_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_CHK_NUM_NORMAL_MSK 0xff
#define FWCMD_C2H_STA_DIAG_RPT_CHK_NUM_WOW_SH 8
#define FWCMD_C2H_STA_DIAG_RPT_CHK_NUM_WOW_MSK 0xff
#define FWCMD_C2H_STA_DIAG_RPT_ERR_CODE_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_ERR_CODE_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_ERR_CODE_WOW_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_ERR_CODE_WOW_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_BCN_EARLY_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_BCN_EARLY_CNT_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_BCN_OK_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_BCN_OK_CNT_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_BCN_RCV_MASK_LAST_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_BCN_RCV_MASK_LAST_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_WOW_ENTER_TSF_H_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_WOW_ENTER_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_WOW_ENTER_TSF_L_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_WOW_ENTER_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_RPT_WOW_TOGGLE_WAKE_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_WOW_TOGGLE_WAKE_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_RPT_CHK_FEATURE_BITMAP_SH 0
#define FWCMD_C2H_STA_DIAG_RPT_CHK_FEATURE_BITMAP_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_CB_FAIL_RTY_DROP_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_CB_FAIL_RTY_DROP_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_CB_FAIL_LIFE_DROP_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_CB_FAIL_LIFE_DROP_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_CB_FAIL_MACID_DROP_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_CB_FAIL_MACID_DROP_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_API_FAIL_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_SCAN_NULL_API_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_TX_CB_FAIL_RTY_DROP_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_TX_CB_FAIL_RTY_DROP_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_TX_CB_FAIL_LIFE_DROP_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_SCAN_TX_CB_FAIL_LIFE_DROP_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_TX_CB_FAIL_MACID_DROP_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_SCAN_TX_CB_FAIL_MACID_DROP_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_READ_PKTOFLD_FAIL_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_SCAN_READ_PKTOFLD_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_MALFORMED_PROBE_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_MALFORMED_PROBE_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_TXAPI_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_SCAN_TXAPI_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_TXAPI_LAST_FAIL_RETTYPE_SH 16
#define FWCMD_C2H_STA_DIAG_SCAN_TXAPI_LAST_FAIL_RETTYPE_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_TXAPI_LAST_FAIL_RESULT_SH 24
#define FWCMD_C2H_STA_DIAG_SCAN_TXAPI_LAST_FAIL_RESULT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_CHSWITCH_FAIL_RET_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_CHSWITCH_FAIL_RET_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_SCAN_BB_CTRL_MLO_FAIL_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_BB_CTRL_MLO_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_RF_CTRL_MLO_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_SCAN_RF_CTRL_MLO_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_RF_RELOAD_FAIL BIT(16)
#define FWCMD_C2H_STA_DIAG_SCAN_NUM_MACID_PAUSE_SLEEP_MISMATCH_SH 17
#define FWCMD_C2H_STA_DIAG_SCAN_NUM_MACID_PAUSE_SLEEP_MISMATCH_MSK 0x7
#define FWCMD_C2H_STA_DIAG_SCAN_C2H_NOTIFY_FAIL_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_SCAN_C2H_NOTIFY_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_0_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_0_MSK 0xffff
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_1_SH 16
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_1_MSK 0xffff
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_2_SH 0
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_2_MSK 0xffff
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_3_SH 16
#define FWCMD_C2H_STA_DIAG_SCAN_MACID_PAUSE_SLEEP_MISMATCH_3_MSK 0xffff
#define FWCMD_C2H_STA_DIAG_CSA_PRI_NOT_VALID_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_CSA_PRI_NOT_VALID_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_BW_NOT_VALID_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_CSA_BW_NOT_VALID_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_NOT_VALID_PRI_SH 16
#define FWCMD_C2H_STA_DIAG_CSA_NOT_VALID_PRI_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_NOT_VALID_BW_SH 24
#define FWCMD_C2H_STA_DIAG_CSA_NOT_VALID_BW_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_NEWBCN_TIMEOUT_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_CSA_NEWBCN_TIMEOUT_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_CHSW_FAILED_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_CSA_CHSW_FAILED_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_NULL_FAILED_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_CSA_NULL_FAILED_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_CSA_CHSW_FAILED_RET_SH 0
#define FWCMD_C2H_STA_DIAG_CSA_CHSW_FAILED_RET_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_PS_TOTAL_MACID_NUM_SH 0
#define FWCMD_C2H_STA_DIAG_PS_TOTAL_MACID_NUM_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RPWM_NTFY_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_PS_RPWM_NTFY_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RPWM_REQ_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_PS_RPWM_REQ_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RPWM_ACT_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_PS_RPWM_ACT_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RPWM_CG_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_PS_RPWM_CG_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RPWM_PG_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_PS_RPWM_PG_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_ENTER_CG_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_PS_ENTER_CG_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_ENTER_PG_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_PS_ENTER_PG_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_MSTATUS_VAL_SH 0
#define FWCMD_C2H_STA_DIAG_PS_MSTATUS_VAL_MSK 0xffffffff
#define FWCMD_C2H_STA_DIAG_PS_B0_NOR_MODE_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_PS_B0_NOR_MODE_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_B0_CLS_RF_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_PS_B0_CLS_RF_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_B0_OPEN_RF_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_PS_B0_OPEN_RF_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_B1_NOR_MODE_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_PS_B1_NOR_MODE_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_B1_CLS_RF_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_PS_B1_CLS_RF_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_B1_OPEN_RF_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_PS_B1_OPEN_RF_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_MACID_SH 0
#define FWCMD_C2H_STA_DIAG_PS_MACID_MSK 0xffff
#define FWCMD_C2H_STA_DIAG_PS_BCN_UC_HIT_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_PS_BCN_UC_HIT_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_BCN_BC_HIT_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_PS_BCN_BC_HIT_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RX_BCN_RATE_SH 0
#define FWCMD_C2H_STA_DIAG_PS_RX_BCN_RATE_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RX_BCN_MODE_RATE_SH 8
#define FWCMD_C2H_STA_DIAG_PS_RX_BCN_MODE_RATE_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RX_NOR_MODE_RATE_SH 16
#define FWCMD_C2H_STA_DIAG_PS_RX_NOR_MODE_RATE_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_RX_KEEP_ON_RATE_SH 24
#define FWCMD_C2H_STA_DIAG_PS_RX_KEEP_ON_RATE_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_BCN_ERLY_TIME_SH 0
#define FWCMD_C2H_STA_DIAG_PS_BCN_ERLY_TIME_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_BCN_TO_TIME_SH 8
#define FWCMD_C2H_STA_DIAG_PS_BCN_TO_TIME_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_TBTT_SHIFT_TIME_SH 16
#define FWCMD_C2H_STA_DIAG_PS_TBTT_SHIFT_TIME_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_TX_NULL1_FAIL_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_PS_TX_NULL1_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_TX_NULL0_FAIL_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_PS_TX_NULL0_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_NULL_TX_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_PS_NULL_TX_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_TXPKTIN_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_PS_TXPKTIN_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_PS_SW_TX_OK_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_PS_SW_TX_OK_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_H2C_ADD_MCC_FAIL_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_MCC_H2C_ADD_MCC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_H2C_START_MCC_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_MCC_H2C_START_MCC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_H2C_STOP_MCC_FAIL_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_MCC_H2C_STOP_MCC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_H2C_DEL_MCC_FAIL_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_MCC_H2C_DEL_MCC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_H2C_MCC_SET_DUR_FAIL_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_MCC_H2C_MCC_SET_DUR_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_CHANGE_ROLE_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_MCC_CHANGE_ROLE_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MCC_SW_CH_FAIL_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_MCC_SW_CH_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_EFUSE_H2C_EFUSE_ERR_CODE_SH 0
#define FWCMD_C2H_STA_DIAG_EFUSE_H2C_EFUSE_ERR_CODE_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MRC_H2C_ADD_MRC_FAIL_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_MRC_H2C_ADD_MRC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MRC_H2C_START_MRC_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_MRC_H2C_START_MRC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MRC_H2C_DEL_MRC_FAIL_CNT_SH 16
#define FWCMD_C2H_STA_DIAG_MRC_H2C_DEL_MRC_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MRC_H2C_MRC_UPD_DUR_FAIL_CNT_SH 24
#define FWCMD_C2H_STA_DIAG_MRC_H2C_MRC_UPD_DUR_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MRC_CHANGE_SLOT_FAIL_CNT_SH 0
#define FWCMD_C2H_STA_DIAG_MRC_CHANGE_SLOT_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_STA_DIAG_MRC_SW_CH_FAIL_CNT_SH 8
#define FWCMD_C2H_STA_DIAG_MRC_SW_CH_FAIL_CNT_MSK 0xff
#define FWCMD_C2H_PWR_INT_NOTIFY_MACID_NUM_SH 0
#define FWCMD_C2H_PWR_INT_NOTIFY_MACID_NUM_MSK 0xffff
#define FWCMD_C2H_PWR_INT_NOTIFY_CURR_PWR_STATUS BIT(16)
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_NO_TAG_SH 0
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_NO_TAG_MSK 0xffff
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_WD_TAG_SH 16
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_WD_TAG_MSK 0xffff
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_CHK_TIME_SH 0
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_CHK_TIME_MSK 0xffff
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_CHK_INTERVAL_SH 16
#define FWCMD_C2H_PCIE_WP_TO_CNTER_INFO_CHK_INTERVAL_MSK 0xffff
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_TSF_L32_SH 0
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_TSF_L32_MSK 0xffffffff
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_TBL_SZ_SH 0
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_TBL_SZ_MSK 0xf
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_LAST BIT(4)
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_TBL_NUM_SH 8
#define FWCMD_C2H_USB_TP_DBG_MON_RPT_INFO_TBL_NUM_MSK 0xff

/*----------------------------------- C2HPKT - CAT(OutSrc, Phydm) ------------------*/
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

/*----------------------------------- C2HPKT - CAT(OutSrc, RF) ---------------------*/
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_RF_REPORT_RF_REPORT_CONTENT_SH 0
#define FWCMD_C2H_RF_REPORT_RF_REPORT_CONTENT_MSK 0xff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

/*----------------------------------- C2HPKT - CAT(OutSrc, BTC) --------------------*/
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

// struct for halmac//
struct fwcmd_hdr {
	u32 hdr0;
	u32 hdr1;
};
/*----------------------------------- H2CREG ---------------------------------------*/
struct fwcmd_h2creg_hdr {
	u32 dword0;
};

struct fwcmd_h2creg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_h2creg_lb {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_cnsl_cmd {
	u32 dword0;
};

struct fwcmd_fwerr {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_hidden_get {
	u32 dword0;
};

struct fwcmd_getpkt_inform {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sch_tx_en {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_trx_stop {
	u32 dword0;
};

struct fwcmd_aoac_rpt_1 {
	u32 dword0;
};

struct fwcmd_aoac_rpt_2 {
	u32 dword0;
};

struct fwcmd_aoac_rpt_3_req {
	u32 dword0;
};

struct fwcmd_wow_cpuio_rx_ctrl {
	u32 dword0;
};

struct fwcmd_set_gpio {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_fwdbg_addr_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

/*----------------------------------- C2HREG ---------------------------------------*/
struct fwcmd_c2hreg_hdr {
	u32 dword0;
};

struct fwcmd_c2hreg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_c2hreg_lb {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_err_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_err_msg {
	u32 dword0;
};

struct fwcmd_efuse_hidden {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_tx_pause_rpt {
	u32 dword0;
};

struct fwcmd_aoac_rpt_3 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_io_ofld_result {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_wow_cpuio_rx_ack {
	u32 dword0;
};

struct fwcmd_fwdbg_addr_sts {
	u32 dword0;
};

struct fwcmd_efuse_hidden_part1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

/*----------------------------------- H2CPKT - CAT(TEST) ---------------------------*/
struct fwcmd_h2c_lb {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_log_test {
	u32 dword0;
};

struct fwcmd_plat_spic_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_plat_fl_write {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_fl_erase {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_pl_flash_read {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_long_run {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_lps_test {
	u32 dword0;
};

struct fwcmd_lps_onoff_test {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_cpumgenq_test {
	u32 dword0;
};

struct fwcmd_mpio_test {
	u32 dword0;
};

struct fwcmd_mpiov2_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_anytestbusycall_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
};

struct fwcmd_anyrw_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_fw_status {
	u32 dword0;
};

struct fwcmd_trigger_cpu_exception {
	u32 dword0;
};

struct fwcmd_fw_profiling {
	u32 dword0;
};

struct fwcmd_wow_auto_test {
	u32 dword0;
};

/*----------------------------------- H2CPKT - CAT(MAC) ----------------------------*/
struct fwcmd_log_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_general_pkt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_c2h_rpt_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fw_dbgreg_cfg {
	u32 dword0;
};

struct fwcmd_fw_redl_cfg {
	u32 dword0;
};

struct fwcmd_fw_self_dx {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_fw_dbg_addr_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_keep_alive {
	u32 dword0;
};

struct fwcmd_disconnect_detect {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_global {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_gtk_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_arp_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ndp_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_realwow {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_nlo {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wakeup_ctrl {
	u32 dword0;
};

struct fwcmd_negative_pattern {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_dev2hst_gpio {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_hst2dev_ctrl {
	u32 dword0;
};

struct fwcmd_wow_cam_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_aoac_report_req {
	u32 dword0;
};

struct fwcmd_wow_stop_fw_trx {
	u32 dword0;
};

struct fwcmd_wow_csa {
	u32 dword0;
};

struct fwcmd_magic_waker_filter {
	u32 dword0;
};

struct fwcmd_tcp_keepalive {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_wow_payload_cam_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_lps_parm {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_p2p_act {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_p2p_macid_ctrl {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ips_cfg {
	u32 dword0;
};

struct fwcmd_ps_advance_parm {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_periodic_wake {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_bb_rf_pwr_st {
	u32 dword0;
};

struct fwcmd_ps_power_level {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_lps_option_cfg {
	u32 dword0;
};

struct fwcmd_doze_time_stats {
	u32 dword0;
};

struct fwcmd_tbtt_tuning {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_bkp_cam_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_smps_cfg {
	u32 dword0;
};

struct fwcmd_rtd3_cfg {
	u32 dword0;
};

struct fwcmd_lps_dbg_cfg {
	u32 dword0;
};

struct fwcmd_fwhdr_dl {
	u32 dword0;
};

struct fwcmd_fwhdr_redl {
	u32 dword0;
};

struct fwcmd_twt_announce_upd {
	u32 dword0;
};

struct fwcmd_twtinfo_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_twt_stansp_upd {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_tblud {
	u32 dword0;
};

struct fwcmd_dctlinfo_ud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_cctlinfo_ud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_shcut_update {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
};

struct fwcmd_bcn_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_ss_ulsta_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_f2pdbg_set {
	u32 dword0;
};

struct fwcmd_wlaninfo_get {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_dctlinfo_ud_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_cctlinfo_ud_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_fw_sts_para {
	u32 dword0;
};

struct fwcmd_dctlinfo_ud_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
};

struct fwcmd_bcn_upd_be {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
};

struct fwcmd_bcn_ignore_edcca {
	u32 dword0;
};

struct fwcmd_bcn_upd_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_dctlinfo_ud_v3 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
};

struct fwcmd_cctlinfo_ud_g7 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
};

struct fwcmd_swtx_stacfg {
	u32 dword0;
};

struct fwcmd_txmode_switch {
	u32 dword0;
};

struct fwcmd_bcn_dynamic_mech {
	u32 dword0;
};

struct fwcmd_addrcam_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
};

struct fwcmd_addrcam_info_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
};

struct fwcmd_joininfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_dl_grp_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_ul_grp_upd {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mu_sta_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_fwrole_maintain {
	u32 dword0;
};

struct fwcmd_notify_dbcc {
	u32 dword0;
};

struct fwcmd_dl_grp_upd_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
};

struct fwcmd_fw_flow_ctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_txrpt_forward {
	u32 dword0;
};

struct fwcmd_mru_grp_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
};

struct fwcmd_dump_efuse {
	u32 dword0;
};

struct fwcmd_packet_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_read_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_write_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_conf_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sys_init {
	u32 dword0;
};

struct fwcmd_trx_init {
	u32 dword0;
};

struct fwcmd_intf_init {
	u32 dword0;
};

struct fwcmd_macid_pause {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_rx_fwd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_en_mac_hdr_conv {
	u32 dword0;
};

struct fwcmd_set_hwseq_reg {
	u32 dword0;
};

struct fwcmd_hwamsdu_reg {
	u32 dword0;
};

struct fwcmd_amsdu_cut_reg {
	u32 dword0;
};

struct fwcmd_tcpip_chksum_offload_reg {
	u32 dword0;
};

struct fwcmd_usr_edca {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_tsf32_togl {
	u32 dword0;
};

struct fwcmd_cmd_ofld_reg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_usr_tx_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_cmd_ofld_pkt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_ofld_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_h2c_agg {
	u32 dword0;
};

struct fwcmd_add_scanofld_ch {
	u32 dword0;
};

struct fwcmd_scanofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_tx_duty {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_disable_rf {
	u32 dword0;
};

struct fwcmd_tx_addba_pkt {
	u32 dword0;
};

struct fwcmd_pkt_drop {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
};

struct fwcmd_ch_switch {
	u32 dword0;
};

struct fwcmd_bcnerlyrpt {
	u32 dword0;
};

struct fwcmd_cfg_bcnfltr {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ofld_rssi {
	u32 dword0;
};

struct fwcmd_ofld_tp {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_host_efuse_rec {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_scanofld_drv_ctrl {
	u32 dword0;
};

struct fwcmd_wifi_sensing_csi {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_cmd_ofld_v1_reg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_cmd_ofld_v1_pkt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_sch_tx_en_pkt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_macid_pause_sleep {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
};

struct fwcmd_bcn_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_tbtt_sh_stat_ofld {
	u32 dword0;
};

struct fwcmd_sta_csa {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_scanofld_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
};

struct fwcmd_frame_to_act {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_dump_efuse_v2 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_txrpt_stats_en {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_cpumgpkt_tx {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_bcn_cnt_gpio {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_rx_fwd_be {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_trx_time_stats_en {
	u32 dword0;
};

struct fwcmd_trx_protect_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_tb_ppdu_ctrl {
	u32 dword0;
};

struct fwcmd_apf_ofld_ctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_seccam_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
};

struct fwcmd_seccam_info_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
};

struct fwcmd_set_snd_para {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
	u32 dword64;
	u32 dword65;
	u32 dword66;
	u32 dword67;
	u32 dword68;
	u32 dword69;
	u32 dword70;
	u32 dword71;
};

struct fwcmd_get_csi_buf {
	u32 dword0;
};

struct fwcmd_set_csi_buf {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_get_snd_sts {
	u32 dword0;
};

struct fwcmd_set_snd_sts {
	u32 dword0;
};

struct fwcmd_init_snd_mer {
	u32 dword0;
};

struct fwcmd_init_snd_mee {
	u32 dword0;
};

struct fwcmd_csi_fix_rate {
	u32 dword0;
};

struct fwcmd_csi_rrsc {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_set_mu_table {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_set_csi_para_reg {
	u32 dword0;
};

struct fwcmd_hw_snd_pr {
	u32 dword0;
};

struct fwcmd_set_snd_para_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
	u32 dword64;
	u32 dword65;
	u32 dword66;
	u32 dword67;
	u32 dword68;
	u32 dword69;
	u32 dword70;
	u32 dword71;
	u32 dword72;
	u32 dword73;
	u32 dword74;
	u32 dword75;
	u32 dword76;
	u32 dword77;
	u32 dword78;
	u32 dword79;
	u32 dword80;
	u32 dword81;
	u32 dword82;
	u32 dword83;
	u32 dword84;
	u32 dword85;
	u32 dword86;
	u32 dword87;
	u32 dword88;
	u32 dword89;
	u32 dword90;
	u32 dword91;
	u32 dword92;
	u32 dword93;
	u32 dword94;
	u32 dword95;
	u32 dword96;
	u32 dword97;
};

struct fwcmd_set_snd_para_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
	u32 dword64;
	u32 dword65;
	u32 dword66;
	u32 dword67;
	u32 dword68;
	u32 dword69;
	u32 dword70;
	u32 dword71;
	u32 dword72;
	u32 dword73;
	u32 dword74;
	u32 dword75;
	u32 dword76;
	u32 dword77;
	u32 dword78;
	u32 dword79;
	u32 dword80;
	u32 dword81;
	u32 dword82;
	u32 dword83;
	u32 dword84;
	u32 dword85;
	u32 dword86;
	u32 dword87;
	u32 dword88;
	u32 dword89;
	u32 dword90;
	u32 dword91;
	u32 dword92;
	u32 dword93;
	u32 dword94;
	u32 dword95;
	u32 dword96;
	u32 dword97;
	u32 dword98;
	u32 dword99;
	u32 dword100;
	u32 dword101;
	u32 dword102;
	u32 dword103;
	u32 dword104;
	u32 dword105;
	u32 dword106;
	u32 dword107;
	u32 dword108;
	u32 dword109;
	u32 dword110;
	u32 dword111;
	u32 dword112;
	u32 dword113;
	u32 dword114;
	u32 dword115;
	u32 dword116;
	u32 dword117;
	u32 dword118;
	u32 dword119;
	u32 dword120;
	u32 dword121;
	u32 dword122;
	u32 dword123;
	u32 dword124;
	u32 dword125;
	u32 dword126;
	u32 dword127;
	u32 dword128;
	u32 dword129;
	u32 dword130;
	u32 dword131;
	u32 dword132;
	u32 dword133;
	u32 dword134;
	u32 dword135;
	u32 dword136;
	u32 dword137;
	u32 dword138;
	u32 dword139;
	u32 dword140;
	u32 dword141;
	u32 dword142;
	u32 dword143;
	u32 dword144;
	u32 dword145;
	u32 dword146;
	u32 dword147;
	u32 dword148;
	u32 dword149;
	u32 dword150;
	u32 dword151;
	u32 dword152;
	u32 dword153;
	u32 dword154;
	u32 dword155;
	u32 dword156;
	u32 dword157;
	u32 dword158;
	u32 dword159;
	u32 dword160;
	u32 dword161;
	u32 dword162;
	u32 dword163;
	u32 dword164;
	u32 dword165;
	u32 dword166;
	u32 dword167;
	u32 dword168;
	u32 dword169;
	u32 dword170;
	u32 dword171;
	u32 dword172;
	u32 dword173;
};

struct fwcmd_ba_cam {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ba_cam_v1 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ba_cam_init {
	u32 dword0;
};

struct fwcmd_ie_cam {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_add_mcc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_start_mcc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_stop_mcc {
	u32 dword0;
};

struct fwcmd_del_mcc_group {
	u32 dword0;
};

struct fwcmd_reset_mcc_group {
	u32 dword0;
};

struct fwcmd_mcc_req_tsf {
	u32 dword0;
};

struct fwcmd_mcc_macid_bitmap {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mcc_sync {
	u32 dword0;
};

struct fwcmd_mcc_set_duration {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_mcc_dbg_notify {
	u32 dword0;
};

struct fwcmd_scsi_tx {
	u32 dword0;
};

struct fwcmd_usb_switch {
	u32 dword0;
};

struct fwcmd_plat_flash_write {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_plat_flash_erase {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_flash_read {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fcs {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_cfg_wps {
	u32 dword0;
};

struct fwcmd_punc_upd {
	u32 dword0;
};

struct fwcmd_port_init {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_port_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mlotbl_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_mlo_stafunc_cfg {
	u32 dword0;
};

struct fwcmd_mlo_tid_to_link_map {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_mlo_dm_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_emlsr_sta_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_mcmlo_relink_drop {
	u32 dword0;
};

struct fwcmd_mcmlo_sn_sync {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mlo_relink {
	u32 dword0;
};

struct fwcmd_mlo_link_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mlo_dm_dbg {
	u32 dword0;
};

struct fwcmd_mcmlo_table_acc {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mcmlo_open_qsts {
	u32 dword0;
};

struct fwcmd_mcmlo_init {
	u32 dword0;
};

struct fwcmd_proxy {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
};

struct fwcmd_mdns {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
	u32 dword64;
	u32 dword65;
	u32 dword66;
	u32 dword67;
	u32 dword68;
	u32 dword69;
	u32 dword70;
	u32 dword71;
	u32 dword72;
	u32 dword73;
	u32 dword74;
	u32 dword75;
	u32 dword76;
	u32 dword77;
	u32 dword78;
	u32 dword79;
	u32 dword80;
	u32 dword81;
	u32 dword82;
	u32 dword83;
};

struct fwcmd_ptcl_pattern {
	u32 dword0;
};

struct fwcmd_snmp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
};

struct fwcmd_llmnr {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
};

struct fwcmd_mdns_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_apf_set {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
};

struct fwcmd_apf_get {
	u32 dword0;
};

struct fwcmd_act_schedule_req {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_bcn_req {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_nan_func_ctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_nan_de_info {
	u32 dword0;
};

struct fwcmd_nan_join_cluster {
	u32 dword0;
};

struct fwcmd_pause_faw_tx {
	u32 dword0;
};

struct fwcmd_nan_get_cluster_info {
	u32 dword0;
};

struct fwcmd_nan_avail_t_bitmap {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_fw_cmdreq {
	u32 dword0;
};

struct fwcmd_mrc_req_tsf {
	u32 dword0;
};

struct fwcmd_add_mrc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_start_mrc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_del_mrc {
	u32 dword0;
};

struct fwcmd_mrc_sync {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mrc_upd_duration {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_mrc_upd_bitmap {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mrc_dbg_dump_cfg {
	u32 dword0;
};

struct fwcmd_sens_tbl_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_sens_ntb_tx_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_sens_invld_smr {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_sub_offload_agg {
	u32 dword0;
};

struct fwcmd_sub_offload_agg_dctl_info_byte {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sub_offload_agg_with_num {
	u32 dword0;
};

struct fwcmd_om_adv_rpt {
	u32 dword0;
};

struct fwcmd_ser_dbg_case_set {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_nat2p5_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_az_en {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_az_proc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_az_update {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_az_cancel {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_diag_ctrl {
	u32 dword0;
};

struct fwcmd_wow_req_rx_pkt {
	u32 dword0;
};

struct fwcmd_wow_req_mem {
	u32 dword0;
};

struct fwcmd_wow_req_bb_rf_reg {
	u32 dword0;
};

struct fwcmd_ap_self_diag {
	u32 dword0;
};

struct fwcmd_req_sta_diag_rpt {
	u32 dword0;
};

struct fwcmd_addba_ofld_req {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_sap_info {
	u32 dword0;
};

struct fwcmd_pcie_wp_to_ctrl {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_pcie_wp_to_get {
	u32 dword0;
};

struct fwcmd_pcie_wp_to_reset {
	u32 dword0;
};

struct fwcmd_usb_tp_dbg_mon {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

/*----------------------------------- H2CPKT - CAT(Table) --------------------------*/
struct fwcmd_mude_para_tblud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_mudecision_para {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mu_fixinfo {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ul_fixinfo_tblud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_ul_fixinfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_ul_fixinfo_sta_info {
	u32 dword0;
};

struct fwcmd_ul_fixinfo_ul_rua_sta_ent {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ul_fixinfo_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
};

struct fwcmd_ul_fixinfo_sta_info_v2 {
	u32 dword0;
};

struct fwcmd_ul_fixinfo_ul_rua_sta_ent_v2 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_addr_cam {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_bssid_cam {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sec_cam {
	u32 dword0;
};

struct fwcmd_fixmode_para_tblud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_fixmode_para {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_write_ofld_req {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_read_ofld_req {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_conf_ofld_req_cmd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_dctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_cctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_dctrl_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_cctrl_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_dctrl_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_cctrl_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_cctrl_g7 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_cctrl_g7_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_ie_cam_info {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_auto_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_h2creg_sch_tx_pause {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_cmd_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_cmd_ofld_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_h2cpkt_sch_tx_pause {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_csa_chinfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_ba_cam_g7 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sta_csa_chinfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_proxy_snmp_enterprise {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_scanofld_chinfo_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_scanofld_chinfo_v2 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_scanofld_macc_role {
	u32 dword0;
};

struct fwcmd_scanofld_opch {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_scanofld_chrpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_usb_tp_dbg_mon_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_scan_dbg_dump_hdr {
	u32 dword0;
};

struct fwcmd_scan_dbg_dump_mac_rx {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_scan_dbg_dump_mac_tx {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_scan_dbg_dump_bb_rx {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_scan_dbg_dump_bb_rx_block {
	u32 dword0;
};

struct fwcmd_scan_dbg_dump_bb_tx {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_scan_dbg_dump_rf_s0 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_scan_dbg_dump_rf_s1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_scan_dbg_dump_bb_brk {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_scan_dbg_dump_bb_fa {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_scan_dbg_dump_bb_pd_thrd {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_scan_dbg_dump_mac_ptcl {
	u32 dword0;
};

/*----------------------------------- H2CPKT - CAT(OutSrc,Phydm) -------------------*/
struct fwcmd_example {
	u32 dword0;
};

struct fwcmd_macid_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_rssi_ra_config {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

/*----------------------------------- H2CPKT - CAT(OutSrc, RF) ---------------------*/
/*----------------------------------- H2CPKT - CAT(OutSrc, BTC) --------------------*/
struct fwcmd_tdma {
	u32 dword0;
};

/*----------------------------------- C2HPKT - CAT(TEST) ---------------------------*/
struct fwcmd_c2h_lb {
	u32 dword0;
};

struct fwcmd_test_phy_rpt {
	u32 dword0;
};

struct fwcmd_c2h_log_test {
	u32 dword0;
};

struct fwcmd_send_null_test {
	u32 dword0;
};

struct fwcmd_c2h_l1_2_test {
	u32 dword0;
};

struct fwcmd_spic {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_spic2 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sendnull_test {
	u32 dword0;
};

struct fwcmd_mio_test {
	u32 dword0;
};

struct fwcmd_cpuio_test {
	u32 dword0;
};

/*----------------------------------- C2HPKT - CAT(MAC) ----------------------------*/
struct fwcmd_rec_ack {
	u32 dword0;
};

struct fwcmd_done_ack {
	u32 dword0;
};

struct fwcmd_c2h_log {
	u32 dword0;
};

struct fwcmd_bcn_cnt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_bcn_csazero {
	u32 dword0;
};

struct fwcmd_bcn_critical_rst {
	u32 dword0;
};

struct fwcmd_bcn_upd_done {
	u32 dword0;
};

struct fwcmd_bcn_bc_chg_zero {
	u32 dword0;
};

struct fwcmd_fw_self_dx_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_efuse_dump {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_read_rsp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_pkt_ofld_rsp {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fw_getpkt_rpt {
	u32 dword0;
};

struct fwcmd_tsf32_togl_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_usr_tx_rpt_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
};

struct fwcmd_cmd_ofld_rsp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_scanofld_rsp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_tx_duty_rpt {
	u32 dword0;
};

struct fwcmd_ch_switch_rpt {
	u32 dword0;
};

struct fwcmd_bcnerlyntfy {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_bcnfltr_rpt {
	u32 dword0;
};

struct fwcmd_wifi_sensing_csi_tx_result {
	u32 dword0;
};

struct fwcmd_tbtt_sh_stat_rpt {
	u32 dword0;
};

struct fwcmd_bcn_ofld_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_frame_to_act_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
};

struct fwcmd_efuse_dump_v2 {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_txrpt_stats {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_bcn_sync_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_trx_time_stats {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_wait_announce {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_stat_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_aoac_report {
	u32 dword0;
};

struct fwcmd_read_wow_cam {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_apf_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_mcc_rcv_ack {
	u32 dword0;
};

struct fwcmd_mcc_req_ack {
	u32 dword0;
};

struct fwcmd_mcc_tsf_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_mcc_status_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_rx_dbg {
	u32 dword0;
};

struct fwcmd_scsi_rx {
	u32 dword0;
};

struct fwcmd_fcs_rpt {
	u32 dword0;
};

struct fwcmd_wps_rpt {
	u32 dword0;
};

struct fwcmd_ccxrpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_bf_sens_feedback {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_get_punc {
	u32 dword0;
};

struct fwcmd_port_init_stat {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_port_cfg_stat {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_ofdma_sts {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_ofdma_sts_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_mlo_get_tbl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_emlsr_trans_done {
	u32 dword0;
};

struct fwcmd_emlsr_sta_cfg_done {
	u32 dword0;
};

struct fwcmd_mcmlo_relink_rpt {
	u32 dword0;
};

struct fwcmd_mcmlo_sn_sync_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mlo_link_cfg_stat {
	u32 dword0;
};

struct fwcmd_mlo_dm_dbg_dump {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
};

struct fwcmd_mlo_dm_status_dump {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
};

struct fwcmd_mcmlo_table_acc_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_act_schedule_req_ack {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_bcn_req_ack {
	u32 dword0;
};

struct fwcmd_nan_func_ctrl_ack {
	u32 dword0;
};

struct fwcmd_nan_de_info_ack {
	u32 dword0;
};

struct fwcmd_nan_join_cluster_ack {
	u32 dword0;
};

struct fwcmd_nan_pause_faw_tx_ack {
	u32 dword0;
};

struct fwcmd_nan_info_notify_cluster_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_nan_info_notify_tsf_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_nan_info_notify_cluster_join {
	u32 dword0;
};

struct fwcmd_nan_deinit_rpt {
	u32 dword0;
};

struct fwcmd_mrc_tsf_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_mrc_status_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_mrc_notify_evt {
	u32 dword0;
};

struct fwcmd_doze_time_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_dctl_info_dword {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_wow_diag_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_wow_diag_gtk {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_wow_diag_ap_lost {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_diag_ser {
	u32 dword0;
};

struct fwcmd_wow_diag_rx_evt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_wow_diag_keepalive {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_wow_diag_arp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_wow_diag_ns {
	u32 dword0;
};

struct fwcmd_wow_diag_pmf {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_wow_diag_per_wake {
	u32 dword0;
};

struct fwcmd_wow_diag_nlo {
	u32 dword0;
};

struct fwcmd_wow_diag_sta_csa {
	u32 dword0;
};

struct fwcmd_wow_diag_tcp_keepalive {
	u32 dword0;
};

struct fwcmd_wow_diag_proxy_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
};

struct fwcmd_wow_dump_rx {
	u32 dword0;
};

struct fwcmd_wow_dump_mem {
	u32 dword0;
};

struct fwcmd_wow_dump_role {
	u32 dword0;
};

struct fwcmd_wow_dump_bb_rf_reg {
	u32 dword0;
};

struct fwcmd_ftm_az_pktid_content {
	u32 dword0;
};

struct fwcmd_ftm_az_para_dump {
	u32 dword0;
};

struct fwcmd_ftm_az_dbg_dump {
	u32 dword0;
};

struct fwcmd_ftm_az_rpt_hdl {
	u32 dword0;
};

struct fwcmd_ftm_mc_pktid_content {
	u32 dword0;
};

struct fwcmd_ap_self_diag_rst {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
};

struct fwcmd_sta_diag_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
};

struct fwcmd_sta_diag_scan {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_sta_diag_csa {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_sta_diag_ps {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_sta_diag_mcc {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sta_diag_efuse {
	u32 dword0;
};

struct fwcmd_sta_diag_mrc {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_pwr_int_notify {
	u32 dword0;
};

struct fwcmd_pcie_wp_to_cnter_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_usb_tp_dbg_mon_rpt_info {
	u32 dword0;
	u32 dword1;
};

/*----------------------------------- C2HPKT - CAT(OutSrc, Phydm) ------------------*/
/*----------------------------------- C2HPKT - CAT(OutSrc, RF) ---------------------*/
struct fwcmd_rf_report {
	u32 dword0;
};

/*----------------------------------- C2HPKT - CAT(OutSrc, BTC) --------------------*/

#endif
