/******************************************************************************
 *
 * Copyright(c) 2012 - 2020 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/
#include "./hal8852b_fw_log.h"

struct mac_fw_msg fw_log_8852b[] = {
	{(u32)MSG_8852B_FIRST, "RESERVED"},
	{(u32)MSG_8852B_SAMPLE_NO_PARAMETER, "Sample without parameter.\n"},
	{(u32)MSG_8852B_SAMPLE_PARAMETER, "Sample string:%s.\n"},
	{(u32)MSG_8852B_SAMPLE_INTEGER, "Sample integer:%d.\n"},
	{(u32)MSG_8852B_SAMPLE_INTEGER_X, "Sample integer:0x%x.\n"},
	{(u32)MSG_8852B_SAMPLE_INTEGER_2, "Sample integer1:%d, integer2:%d.\n"},
	{(u32)MSG_8852B_FCUN_NAME, "%s()\n"},
	{(u32)MSG_8852B_MAIN_1, "FW from host\n"},
	{(u32)MSG_8852B_MAIN_2, "Skip DL FW handler\n"},
	{(u32)MSG_8852B_MAIN_3, "FW from flash\n"},
	{(u32)MSG_8852B_MAIN_4, "Invalid boot mode\n"},
	{(u32)MSG_8852B_FWDLHDL_1, "Invalid boot reason\n"},
	{(u32)MSG_8852B_FWDLHDL_2, "Enter DL FW handler\n"},
	{(u32)MSG_8852B_FWDLHDL_3, "FWHDR H2C done\n"},
	{(u32)MSG_8852B_FLASHBOOT, "Enter flash FW loader\n"},
	{(u32)MSG_8852B_IRAMENTRN, "Load FW RAM code OK\n"},
	{(u32)MSG_8852B_FIRSTH2C_1, "First H2C Enqueue\n"},
	{(u32)MSG_8852B_FIRSTH2C_2, "H2C node malloc fail\n"},
	{(u32)MSG_8852B_FIRSTH2C_3, "H2C node content malloc fail\n"},
	{(u32)MSG_8852B_H2CDEQ_1, "H2C Dequeue\n"},
	{(u32)MSG_8852B_H2CDEQ_2, "H2CPKT enqueue fail\n"},
	{(u32)MSG_8852B_H2CPKT_1, "content = 0x%x  0x%x  0x%x  0x%x\n"},
	{(u32)MSG_8852B_RESERVED_ROM, "RESERVED"},
	{(u32)MSG_8852B_CMDTABLE_NAME, "%s "},
	{(u32)MSG_8852B_CMDTABLE_1, "        ?\n"},
	{(u32)MSG_8852B_CMDTABLE_2, "       dump bytes, ex: DB 0xb8e00000\n"},
	{(u32)MSG_8852B_CMDTABLE_3, "       write bytes,  ex: EB 0xb8e00000 0x1\n"},
	{(u32)MSG_8852B_CMDTABLE_4, "       dump words, ex: DW 0xb8e00000\n"},
	{(u32)MSG_8852B_CMDTABLE_5, "       write words, ex: EW 0xb8e00000, 0x12345678\n"},
	{(u32)MSG_8852B_CMDTABLE_6, "        jump to address, ex: j 0xb8900000\n"},
	{(u32)MSG_8852B_CMDTABLE_7, "   set debug level\n"},
	{(u32)MSG_8852B_CMDTABLE_8, "  set debug compoment bitmap\n"},
	{(u32)MSG_8852B_CMDTABLE_9, " show task info\n"},
	{(u32)MSG_8852B_CMDTABLE_10, " show heap info\n"},
	{(u32)MSG_8852B_CMDTABLE_11, "  show dynamic allocate memory info, <index>, <mode>\n"},
	{(u32)MSG_8852B_CMDTABLE_12, "  show task time state\n"},
	{(u32)MSG_8852B_CMDTABLE_13, "   AXIDMA test\n"},
	{(u32)MSG_8852B_CMDTABLE_14, "   SPIC test\n"},
	{(u32)MSG_8852B_CMDTABLE_15, "    IDDMA test\n"},
	{(u32)MSG_8852B_CMDTABLE_16, "   RXI300 test\n"},
	{(u32)MSG_8852B_CMDTABLE_17, "      DLE test\n"},
	{(u32)MSG_8852B_CMDTABLE_18, "     HIOE test\n"},
	{(u32)MSG_8852B_CMDTABLE_19, "     RPT test\n"},
	{(u32)MSG_8852B_CMDTABLE_20, "     MISC test\n"},
	{(u32)MSG_8852B_CMDTABLE_21, "  Update STA para for F2PTXCMD\n"},
	{(u32)MSG_8852B_CMDTABLE_22, " Update Common para for F2PTXCMD\n"},
	{(u32)MSG_8852B_CMDTABLE_23, " Wlan Flow Test\n"},
	{(u32)MSG_8852B_CMDTABLE_24, " Wlan Test Mode Setting\n"},
	{(u32)MSG_8852B_CMDTABLE_25, "   Wlan Flow with RUA Test\n"},
	{(u32)MSG_8852B_CMDTABLE_26, "   Wlan UL Flow Test\n"},
	{(u32)MSG_8852B_CMDTABLE_27, "       IPSec test\n"},
	{(u32)MSG_8852B_CMDTABLE_28, "   CryptoSig test\n"},
	{(u32)MSG_8852B_CMDTABLE_29, "  SecureBoot test\n"},
	{(u32)MSG_8852B_CMDTABLE_30, " Secure eFuse R/W test\n"},
	{(u32)MSG_8852B_CMDTABLE_31, "      Plat test\n"},
	{(u32)MSG_8852B_CMDTABLE_32, "    H2C/C2H test\n"},
	{(u32)MSG_8852B_CMDTABLE_33, "    UL F2PCMD test, <number of STAs>, <frame exchange type>, 0\n"},
	{(u32)MSG_8852B_CMDTABLE_34, " Sounding test\n"},
	{(u32)MSG_8852B_CMDTABLE_35, "   security CAM test\n"},
	{(u32)MSG_8852B_CMDTABLE_36, "   Gtimer test, <id>, <mode>, <unit>, <duration>\n"},
	{(u32)MSG_8852B_CMDTABLE_37, "  PStimer test, <band>, <id>, <mode>, <tsf> (valid if mode = 0)\n"},
	{(u32)MSG_8852B_CMDTABLE_38, "     RPWM test\n"},
	{(u32)MSG_8852B_CMDTABLE_39, "    DLTXD test\n"},
	{(u32)MSG_8852B_CMDTABLE_40, "       PS test\n"},
	{(u32)MSG_8852B_CMDTABLE_41, "      32K CAL test\n"},
	{(u32)MSG_8852B_CMDTABLE_42, "   WoW CAM test\n"},
	{(u32)MSG_8852B_CMDTABLE_43, "   PS ONOFF test\n"},
	{(u32)MSG_8852B_CMDTABLE_44, "    BTCoex test\n"},
	{(u32)MSG_8852B_CMDTABLE_45, "    DL Parameters Setting\n"},
	{(u32)MSG_8852B_CMDTABLE_46, "      Dump Wlan common info, f2pcmd result, decision result\n"},
	{(u32)MSG_8852B_CMDTABLE_47, "      Dump Wlan sta or muru grp info\n"},
	{(u32)MSG_8852B_CMDTABLE_48, "      Dump Wlan decision info\n"},
	{(u32)MSG_8852B_CMDTABLE_49, "     Dump FW info\n"},
	{(u32)MSG_8852B_CMDTABLE_50, "    TFDBG\n"},
	{(u32)MSG_8852B_CMDTABLE_51, "    CRT\n"},
	{(u32)MSG_8852B_MALLOC_F, "malloc is failed\n"},
	{(u32)MSG_8852B_STRING_0, "%s\n"},
	{(u32)MSG_8852B_STRING_1, "%s"},
	{(u32)MSG_8852B_PARA_INVALID, "Invalid parameters\n"},
	{(u32)MSG_8852B_CMD_UNKNOWN, "Unknown cmd\n"},
	{(u32)MSG_8852B_CONSOLE_1, "- CMD -\n"},
	{(u32)MSG_8852B_CONSOLE_2, "0x%x: 0x%x\n"},
	{(u32)MSG_8852B_CONSOLE_3, "Jump to 0x%x\n"},
	{(u32)MSG_8852B_CONSOLE_4, "Set dbg level to: 0x%x\n"},
	{(u32)MSG_8852B_CONSOLE_5, "Set dbg component bitmap to: 0x%x\n"},
	{(u32)MSG_8852B_CONSOLE_6, "Task\t\tState\tPrio\tStack start\tMin Stack(DW)\tNum\tCnt\n"},
	{(u32)MSG_8852B_CONSOLE_7, "--------------------------------------------------------------------------------\n"},
	{(u32)MSG_8852B_CONSOLE_8, "Index\t\tStart\t\tTotal(B)\tFree(B)\tMin Free(B)\n"},
	{(u32)MSG_8852B_CONSOLE_9, "------------------------------------------------------------------------\n"},
	{(u32)MSG_8852B_CONSOLE_10, "Address\t\tOwner ID\tFunction\tType\t\tSize(B)\n"},
	{(u32)MSG_8852B_CONSOLE_11, "Owner ID\tFunction\tType\t\tCounter\t\tTotalSize(B)\tHistorical High\n"},
	{(u32)MSG_8852B_CONSOLE_12, "------------------------------------------------------------------------------------------------\n"},
	{(u32)MSG_8852B_CONSOLE_13, "Owner ID\tType\t\tTotalSize(B)\n"},
	{(u32)MSG_8852B_CONSOLE_14, "------------------------------------------------\n"},
	{(u32)MSG_8852B_MCC_SEARCHMACID_1, "[MCC] pmcc_info is NULL!\n"},
	{(u32)MSG_8852B_MCC_SEARCHMACID_2, "[MCC] pgroup_list is empty!\n"},
	{(u32)MSG_8852B_MCC_STATUSRPTHDL_1, "[MCC] MCCStatusRptHDL macid: %d, group: %d, status: %d\n"},
	{(u32)MSG_8852B_MCC_STATUSRPTHDL_2, "[MCC] tsf: 0x%x 0x%x\n"},
	{(u32)MSG_8852B_MCC_TBTTSTATUSRPTHDL, "[MCC] B%dP%d TBTT TSF = 0x%x\n"},
	{(u32)MSG_8852B_MCC_MACIDDROP, "[MCC] MACIDTxIdleCheck fail\n"},
	{(u32)MSG_8852B_MCC_ISSUENULLWOLPS_1, "[MCC][%d][CXEVNT_ENULL]\n"},
	{(u32)MSG_8852B_MCC_ISSUENULLWOLPS_2, "[MCC] Issue null %d fail!!!\n"},
	{(u32)MSG_8852B_MCC_ISSUENULL_1, "[MCC] macid %d role not found\n"},
	{(u32)MSG_8852B_MCC_ISSUENULL_2, "[MCC][%d]Macid %d Null %d, TSF = 0x%x, freerun = 0x%x\n"},
	{(u32)MSG_8852B_MCC_TXNULLCHK_1, "[MCC] mcc group not found\n"},
	{(u32)MSG_8852B_MCC_TXNULLCHK_2, "[MCC] take semaphore fail!\n"},
	{(u32)MSG_8852B_MCC_TXNULLCHK_3, "[MCC][%d]Macid %d TxNull %d SUCCESS, freerun = 0x%x\n"},
	{(u32)MSG_8852B_MCC_TXNULLCHK_4, "[MCC][%d]Macid %d TxNull %d FAIL, freerun = 0x%x\n"},
	{(u32)MSG_8852B_MCC_SENDNULLCB_1, "[MCC][RPT] MACID DROP => macid (%d)\n"},
	{(u32)MSG_8852B_MCC_SENDNULLCB_2, "[MCC][RPT] LIFE DROP => macid (%d)\n"},
	{(u32)MSG_8852B_MCC_SENDNULLCB_3, "[MCC][RPT] invalid RPT (%d)\n"},
	{(u32)MSG_8852B_MCC_SWITCHCH_1, "[MCC] cfg ch FAIL!!!\n"},
	{(u32)MSG_8852B_MCC_SWITCHCH_2, "[MCC] CH SW, CH= %d\n"},
	{(u32)MSG_8852B_MCC_SWITCHCH_3, "[MCC] CH SW WARNING (%d)\n"},
	{(u32)MSG_8852B_MCC_SWITCHCH_4, "[MCC] RFK bypass\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_1, "[MCC] MCCMacidDrop fail\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_2, "[MCC](courtesy)macid %d => macid %d\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_3, "[MCC][%d][CXEVNT_EBT]\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_4, "[MCC][%d][CXEVNT_E5G]\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_5, "[MCC][%d][CXEVNT_E2G]\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_6, "[MCC][%d]Start BT TSF = 0x%x, freerun = 0x%x\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_7, "[MCC][%d]Start macid %d TSF = 0x%x, freerun = 0x%x\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_8, "[MCC] MCCMacidDropRel fail\n"},
	{(u32)MSG_8852B_MCC_FIRSTDURATIONENDHDL_1, "[MCC] First duration running\n"},
	{(u32)MSG_8852B_MCC_FIRSTDURATIONENDHDL_2, "[MCC][REP/STP] act: %d, deal with old schedule now...\n"},
	{(u32)MSG_8852B_MCC_FIRSTDURATIONENDHDL_3, "[MCC] MCCGroupStop fail\n"},
	{(u32)MSG_8852B_MCC_FIRSTDURATIONENDHDL_4, "[MCC] MCCGroupDel fail\n"},
	{(u32)MSG_8852B_MCC_GROUPSTOP_1, "[MCC] FirstDuration timer del!\n"},
	{(u32)MSG_8852B_MCC_GROUPSTOP_2, "[MCC] replace/pause mode, FirstDuration del bypass!\n"},
	{(u32)MSG_8852B_MCC_NEWDURATIONHDL, "[MCC] Set duration\n"},
	{(u32)MSG_8852B_MCC_BITMAPCMP_1, "[MCC] Release macid %d\n"},
	{(u32)MSG_8852B_MCC_BITMAPCMP_2, "[MCC] Pause macid %d\n"},
	{(u32)MSG_8852B_MCC_H2CADDMCCHDL_1, "[MCC] Add MCC macid %d to group %d\n"},
	{(u32)MSG_8852B_MCC_H2CADDMCCHDL_2, "[MCC] macid: %d, duration: %d, bt_in_2g: %d\n"},
	{(u32)MSG_8852B_MCC_H2CADDMCCHDL_3, "[MCC] Add MCC band %d port %d\n"},
	{(u32)MSG_8852B_MCC_H2CSTARTMCCHDL_1, "[MCC] Start MCC group %d from macid %d\n"},
	{(u32)MSG_8852B_MCC_H2CSTARTMCCHDL_2, "[MCC][REP/STP] Group new idx: %d, old idx: %d, act: %d\n"},
	{(u32)MSG_8852B_MCC_H2CSTOPMCCHDL_1, "[MCC][stop]prev_groups: %d\n"},
	{(u32)MSG_8852B_MCC_H2CSTOPMCCHDL_2, "[MCC][stop]stop group %d fail\n"},
	{(u32)MSG_8852B_MCC_H2CSTOPMCCHDL_3, "[MCC][stop]group %d stop!\n"},
	{(u32)MSG_8852B_MCC_H2CDELMCCGROUPHDL_1, "[MCC][Del] prev_groups: %d\n"},
	{(u32)MSG_8852B_MCC_H2CDELMCCGROUPHDL_2, "[MCC][del]del group %d fail\n"},
	{(u32)MSG_8852B_MCC_H2CDELMCCGROUPHDL_3, "[MCC][del]group %d del!\n"},
	{(u32)MSG_8852B_MCC_H2CMCCREQTSFHDL_1, "[MCC] macid %d is not in role table\n"},
	{(u32)MSG_8852B_DEBUGINFO_1, "ISR Name\tCount\t\tExec Time(historical high)\n"},
	{(u32)MSG_8852B_DEBUGINFO_2, "------------------------------------------------\n"},
	{(u32)MSG_8852B_DEBUGINFO_3, "\t%d\t\t%d_%d\n"},
	{(u32)MSG_8852B_DEBUGINFO_4, "\t\t%d\t\t%d_%d\n"},
	{(u32)MSG_8852B_DEBUGINFO_5, "[Error] ISRInfo len = %d!\n"},
	{(u32)MSG_8852B_PROFILING_1, "func_name %s , "},
	{(u32)MSG_8852B_PROFILING_2, "line %d , cycle %d , offset = %d\n"},
	{(u32)MSG_8852B_WLANDUMP_0, "Tx ok packet cnt: %d\n Tx fail packet cnt: %d\n Txcmd success cnt: %d\n Txcmd abort (MU-RTS/RTS fail) cnt: %d\n Txcmd abort (over SP) cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_1, "Txcmd sounding abort cnt: %d\n Txcmd abort (pri user fail) cnt: %d\n Txcmd abort ( cca or medium busy)  cnt: %d\n Txcmd RU/MU2SU cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_2, "chkcmd_sts cnt: %d %d %d %d %d %d\n"},
	{(u32)MSG_8852B_WLANDUMP_3, "TBD"},
	{(u32)MSG_8852B_WLANDUMP_4, "DL Txcmd in last TXOP cnt: %d\n UL Txcmd in last TXOP cnt: %d\n Empty DL SS2F report cnt: %d\n Empty UL SS2F report cnt: %d\n DL TxcmdQ empty cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_5, "Issue DL SU Txcmd cnt: %d\n Issue DL MU Txcmd cnt: %d\n Issue DL RU Txcmd cnt: %d\n Issue UL Txcmd cnt: %d\n f2p_Triggerpkt_cnt=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_6, "Decision MU2SU cnt: %d\n Decision RU2SU cnt: %d\n DLDecision Result record: %x\n Decision SU_FORCESU cnt: %d\n Decision MU_FORCEMU cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_7, "Decision SU_FORCEMU_FAIL cnt: %d\n Decision SU_FORCERU_FAIL cnt: %d\n Decision SU_FORCERU_RUARST_RU2SU cnt: %d\n Decision SU_NOT4_USER cnt: %d\n Decision RU_FORCERU_RUSRST_FIXTBL cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_8, "Decision RU_FORCERU cnt: %d\n Decision SU_WDINFO_USERATE cnt: %d\n Decision SU_PRINULLWD cnt: %d\n ecision MU_BYPASS_MUTPCOMPARE cnt: %d\n Decision SU_MUTXTIME_PASS_MU_NOTSUPPORT cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_9, "Decision SU_MUTXTIME_FAIL_RU_NOTSUPPORT cnt: %d\n Decision SU_RUARST_RU2SU cnt: %d\n Decision RU_RUARST_FIXTBL cnt: %d\n Decision MU_TPCOMPARE_RST cnt: %d\n Decision RU_TPCOMPARE_RST cnt: %d\n Decision SU_TPCOMPARE_RST cnt: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_10, "fw txcmdQ[0] cmd num: %d, fw txcmdQ[1] cmd num: %d,fw txcmdQ[2] cmd num: %d,fw txcmdQ[3] cmd num: %d,fw txcmdQ[4] cmd num: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_11, "fw txcmdQ[5] cmd num: %d, fw txcmdQ[6] cmd num: %d,fw txcmdQ[7] cmd num: %d,fw txcmdQ[8] cmd num: %d,fw txcmdQ[9] cmd num: %d, fw txcmdQ[10] cmd num: %d\n"},
	{(u32)MSG_8852B_WLANDUMP_12, "TBD"},
	{(u32)MSG_8852B_WLANDUMP_13, "mbid0~7: %d %d %d %d %d %d %d %d\n"},
	{(u32)MSG_8852B_WLANDUMP_14, "macid    %d info:\n isHESTA =%d\n AID12 =%d\n DL_BW =%d\n DL_T_PE =%d\n"},
	{(u32)MSG_8852B_WLANDUMP_15, "TF_MAC_Padding =%d\n force tx su =%d\n force tx mu =%d\n fw force mu2su TH = %d\n force tx ru =%d\n"},
	{(u32)MSG_8852B_WLANDUMP_16, "txok_pkt =%d\n txfail pkt cnt: %d\n retry_cnt =%d\n mbssid_idx =%d\n ulgroup_bitmap =%d\n null_wd_cnt =%d\n"},
	{(u32)MSG_8852B_WLANDUMP_17, "ul_sw_grp_bitmap =%d\n AMPDU_max_txtime =%d\n mu_doppler_ctrl =%d\n mu_gi_ltf =%d\n mu decision txtime_bypass =%d\n mu decision mutp_bypass =%d\n"},
	{(u32)MSG_8852B_WLANDUMP_18, "mu_maxinitrate = %x\n mu_maxfinalrate = %x\n mu_mininitrate = %x\n mu_minfinalrate = %x\n mu primary cnt = %d\n"},
	{(u32)MSG_8852B_WLANDUMP_19, " PwrBit =%d\n TP =%d Mbps\n Max Txlen = %x (unit23 byte)\n Min Txlen = %x (unit23 byte)\n Last Txlen = %x (unit23 byte)\n Last BSRlen = %x (unit256 byte) AC=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_20, "mu sta %d info\n mu sta macid= %d\n"},
	{(u32)MSG_8852B_WLANDUMP_21, "mu sta rate array(8bit) 0-4: %x %x %x %x %x"},
	{(u32)MSG_8852B_WLANDUMP_22, "mu sta rate array(8bit) 5-9: %x %x %x %x %x"},
	{(u32)MSG_8852B_WLANDUMP_23, "su ok pkt cnt = %d\n su fail pkt cnt = %d\n su_norsp_pktcnt = %d\n SU TOTALPKTNUM 1~16/17~32/33~64/>65 : %d %d %d %d, OK=0: %d\n SU TXCNT 1/<6/<16/>=16 : %d %d %d %d\n"},
	{(u32)MSG_8852B_WLANDUMP_24, "mu ok pkt cnt = %d\n mu fail pkt cnt = %d\n mu_norsp_pktcnt = %d\n mu2su ok pkt cnt = %d\n mu2su fail pkt cnt = %d\n"},
	{(u32)MSG_8852B_WLANDUMP_25, "ru ok pkt cnt = %d\n ru fail pkt cnt = %d\n"},
	{(u32)MSG_8852B_WLANDUMP_26, "MU TOTALPKTNUM  1~16/17~32/33~64/>65 :  %d %d %d %d, OK=0: %d\n MU DIFF 0/1/2/3/Other : %d %d %d %d %d\n"},
	{(u32)MSG_8852B_WLANDUMP_27, "MU TXCNT 1/<6/<16/>=16: %d %d %d %d\n"},
	{(u32)MSG_8852B_WLANDUMP_28, "pktmaxtxcnt(su base) [0]= %d [1]= %d [2]= %d \n pktmaxtxcnt(mu base) [0]= %d [1]= %d [2]= %d \n pktmaxtxcnt(mu2nd base) [0]= %d [1]= %d [2]= %d \n"},
	{(u32)MSG_8852B_WLANDUMP_30, "F2PTXCMDRPT cnt= %d, SS2FWRPT     cnt =%d, TXRPT cnt =%d, PLDRLSRPT cnt = %d\n"},
	{(u32)MSG_8852B_WLANDUMP_31, "SU DIFF <4/<8/<12/>=12: %d %d %d %d\nmax_queue_time=%x total_queue_time=%x avg_queue_time=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_32, "TWT %d info:\n Txcmd overSP= %d\n Txcmd pri user fail= %d\n DL cmdCnt inSP= %d\n UL cmdCnt inSP= %d\n"},
	{(u32)MSG_8852B_WLANDUMP_33, "DL cmdCnt all= %d\n UL cmdCnt all= %d\n UL fixmode = %x\n cur cmd num = %x\n SP 1st TF fail cnt = %x\n"},
	{(u32)MSG_8852B_WLANDUMP_34, "start_d= %d\n start_t= %d\n endearly_d= %d\n endearly_t= %d\n end_d= %d\n"},
	{(u32)MSG_8852B_WLANDUMP_35, "end_t= %d\n timer_qrydl= %d\n timer_qryul= %d\n start_qrydl= %d\n total_qryul=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_36, "firstTF_fail = %d,%d\n"},
	{(u32)MSG_8852B_WLANDUMP_37, "twt_decision_brk = %d, %d, %d, %d, %d, %d, %d, %d\n"},
	{(u32)MSG_8852B_WLANDUMP_38, "twt_decision_rst= %d, %d, %d\n"},
	{(u32)MSG_8852B_WLANDUMP_39, "twt_ACdecision_rst= %d, %d, %d, %d\n"},
	{(u32)MSG_8852B_WLANDUMP_40, "twt_validdlss2f_cnt= %d, twt_emptydlss2f_cnt= %d, twt_validulss2f_cnt= %d, twt_emptyulss2f_cnt= %d, twt_dlss2f_fromquery= %d, twt_dlss2f_fromtxcmd=%d, twt_ulss2f_fromquery= %d, twt_ulss2f_fromtxcmd=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_41, "TWT member: %d %d %d %d %d\n"},
	{(u32)MSG_8852B_WLANDUMP_42, "twt_dlss2f_qrycnt[0]=%d,twt_dlss2f_qrycnt[1]=%d,twt_dlss2f_qrycnt[2]=%d,twt_dlss2f_qrycnt[3]=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_43, "reform_fail_rst[0]=%d, reform_fail_rst[1]=%d, reform_fail_rst[2]=%d, reform_fail_rst[3]=%d, reform_fail_rst[4]=%d\n"},
	{(u32)MSG_8852B_WLANDUMP_44, "MACID %d WD count BE:%d BK:%d VI:%d VO:%d\n"},
	{(u32)MSG_8852B_WLANDUMP_45, "PPS F2PCMD_PPS:%d/s TXRPT_PPS:%d/s TXPKT_PPS:%d/s SS2F_0_PPS:%d/s SS2F_1_PPS:%d/s SS2F_2_PPS:%d/s"},
	{(u32)MSG_8852B_ROLE_1, "B%dP%d RXBCNOK\n"},
	{(u32)MSG_8852B_ROLE_2, "B%dP%d BCNNOHIT\n"},
	{(u32)MSG_8852B_ROLE_3, "Role idx search fail\n"},
	{(u32)MSG_8852B_ROLE_4, "=>CreateRole\n"},
	{(u32)MSG_8852B_ROLE_5, "[FAIL] Role info alloc fail!\n"},
	{(u32)MSG_8852B_ROLE_6, "[FAIL] Role info - PPSDbgParm alloc fail!\n"},
	{(u32)MSG_8852B_ROLE_7, "[FAIL] Role info - PTWTParam alloc fail!\n"},
	{(u32)MSG_8852B_ROLE_8, "[CreateRole] ActRole=%d, LinkRole=%d.\n"},
	{(u32)MSG_8852B_ROLE_9, "[CreateRole] band=%d, port=%d, macid=%d.\n"},
	{(u32)MSG_8852B_ROLE_10, "=>DelRole\n"},
	{(u32)MSG_8852B_ROLE_11, "[Warn] ROLE_NOT_EXIST for DelRole!\n"},
	{(u32)MSG_8852B_ROLE_12, "[DelRole] ActRole=%d!role_idx=%d\n"},
	{(u32)MSG_8852B_ROLE_13, "Role idx search by macid fail\n"},
	{(u32)MSG_8852B_ROLE_14, "[WARN] Role exist for macid=0x%x! role_idx=0x%x\n"},
	{(u32)MSG_8852B_ROLE_15, "[FAIL] Create Role idx > max_number!\n"},
	{(u32)MSG_8852B_ROLE_16, "[FAIL] search role fail in RoleConnect!\n"},
	{(u32)MSG_8852B_ROLE_17, "[FAIL] search role fail in RoleDisConnect!\n"},
	{(u32)MSG_8852B_ROLE_18, "[FAIL] JoinInfo Role idx > max_number!\n"},
	{(u32)MSG_8852B_ROLE_19, "[WARN] Role exist for macid=0x%x! role_idx=0x%x\n"},
	{(u32)MSG_8852B_ROLE_20, "[Warn] search role fail for DelRole!\n"},
	{(u32)MSG_8852B_ROLE_21, "[FAIL] Create Role Fail!\n"},
	{(u32)MSG_8852B_PMF_00, "start saquery timer fail\n"},
	{(u32)MSG_8852B_PMF_01, "start saquery timer\n"},
	{(u32)MSG_8852B_PMF_02, "creat saquery timer fail\n"},
	{(u32)MSG_8852B_PMF_03, "saquery timer is lanched alread\n"},
	{(u32)MSG_8852B_PMF_04, "SA Query timer deleted!\n"},
	{(u32)MSG_8852B_PMF_05, "Deauth content\n"},
	{(u32)MSG_8852B_PMF_06, "packet_len_no_fcs error\n"},
	{(u32)MSG_8852B_PMF_07, "ICV Error ok\n"},
	{(u32)MSG_8852B_PMF_08, "encrypted deauth frame, SEC_TYPE: 0x%x) \n"},
	{(u32)MSG_8852B_PMF_09, "not Encrypted Deauth/Disassoc\n"},
	{(u32)MSG_8852B_PMF_10, "deauth_reason = %x %x\n"},
	{(u32)MSG_8852B_PMF_11, "tx_sa_query_result = 0x%x\n"},
	{(u32)MSG_8852B_PMF_12, "issue saquery req fail\n"},
	{(u32)MSG_8852B_PMF_13, "ignore the deauth frame\n"},
	{(u32)MSG_8852B_PMF_14, "ICV Error\n"},
	{(u32)MSG_8852B_PMF_15, "bip_result=0x%x\n"},
	{(u32)MSG_8852B_PMF_16, "\npacket_len_no_fcs error\n"},
	{(u32)MSG_8852B_PMF_17, "\nOn SA Query Req! (len=0x%x)\n"},
	{(u32)MSG_8852B_PMF_18, "issue saquery rsp fail\n"},
	{(u32)MSG_8852B_PMF_19, "\nOn SA Query Resp!(len=0x%x)\n"},
	{(u32)MSG_8852B_PMF_20, "issue_sa_query_timeout_hdl!\n"},
	{(u32)MSG_8852B_PMF_21, "Deauth wake up!\n"},
	{(u32)MSG_8852B_PMF_22, "can't get offload PKT for saquery\n"},
	{(u32)MSG_8852B_PMF_23, "can't allocate sendpkt_buff \n"},
	{(u32)MSG_8852B_PMF_24, "FW IPN > pkt IPN\n"},
	{(u32)MSG_8852B_PMF_25, "FW IPN < pkt IPN\n"},
	{(u32)MSG_8852B_PMF_26, "FW IPN == pkt IPN\n"},
	{(u32)MSG_8852B_PMF_27, "IPSecAESECBInit false\n"},
	{(u32)MSG_8852B_PMF_28, "IPSecAESECBEncrypt false\n"},
	{(u32)MSG_8852B_PMF_30, "key_len = %d, false\n"},
	{(u32)MSG_8852B_PMF_31, "iv_len = %d, false\n"},
	{(u32)MSG_8852B_PMF_32, "IPSecInitWithISRDisable false\n"},
	{(u32)MSG_8852B_PMF_40, "MIC check fail\n"},
	{(u32)MSG_8852B_PMF_41, "\n: aes_gmac fail!\n"},
	{(u32)MSG_8852B_PMF_42, "\n: _bip_gcmp_protect(128) fail!\n"},
	{(u32)MSG_8852B_PMF_43, "\n: _bip_gcmp_protect(256) fail!\n"},
	{(u32)MSG_8852B_PMF_44, "\n: unsupport dot11wCipher !\n"},
	{(u32)MSG_8852B_PMF_45, "not a management frame\n"},
	{(u32)MSG_8852B_PMF_46, "is a beacon\n"},
	{(u32)MSG_8852B_PMF_47, "not a broadcast frame\n"},
	{(u32)MSG_8852B_PMF_48, "packet too small\n"},
	{(u32)MSG_8852B_PMF_49, "elemnt_id != 0x4c\n"},
	{(u32)MSG_8852B_PMF_50, "is_bip_enc_frameComm return TRUE\n"},
	{(u32)MSG_8852B_PMF_51, "\nbip_verifyComm: PKT (len=0x%x)\n"},
	{(u32)MSG_8852B_PMF_52, "BSSID not match\n"},
	{(u32)MSG_8852B_PMF_53, "ori_len = 0x%x\n"},
	{(u32)MSG_8852B_PMF_54, "SW BIP DEC FAIL\n"},
	{(u32)MSG_8852B_PMF_55, "NOT encrypted\n"},
	{(u32)MSG_8852B_PMF_56, "IPN verify Fail\n"},
	{(u32)MSG_8852B_PMF_57, "bip_verifyComm return TRUE\n"},
	{(u32)MSG_8852B_PMF_58, "protection bit is not 1\n"},
	{(u32)MSG_8852B_PMF_59, "not a unicast frame\n"},
	{(u32)MSG_8852B_PMF_60, "PairwiseEncAlg not GCMP\n"},
	{(u32)MSG_8852B_PMF_61, "aes_gcm_ad fail\n"},
	{(u32)MSG_8852B_PMF_62, "aes_gcm_ae fail\n"},
	{(u32)MSG_8852B_RXFLOW_1, "can't allocate wlan pktbuf\n"},
	{(u32)MSG_8852B_RXFLOW_2, "DD=%x\n"},
	{(u32)MSG_8852B_RXFLOW_3, "A=%x\n"},
	{(u32)MSG_8852B_RXFLOW_4, "B=%x\n"},
	{(u32)MSG_8852B_RXFWD_1, "Unsupported index!\n"},
	{(u32)MSG_8852B_WLAN_1, "SS Query Report HW stuck!!\n"},
	{(u32)MSG_8852B_SECCAM_1, "Search key, mac_id : %d, key_id : %d, key_type : %d , fail\n"},
	{(u32)MSG_8852B_SECCAM_2, "Search key success\nMac_id : %d, key_id : %d, key_type : %d, key cam index : %d\n"},
	{(u32)MSG_8852B_SECCAM_3, "Wowlan rekey %d, %d, %d\n"},
	{(u32)MSG_8852B_SECCAM_4, "check addr key index full\n"},
	{(u32)MSG_8852B_SECCAM_5, "Free cam index: %d\n"},
	{(u32)MSG_8852B_SECCAM_6, "insertKeyAddrCam ret : %d\n"},
	{(u32)MSG_8852B_RPTHDL_1, "pldrlsrpt len %d not align\n"},
	{(u32)MSG_8852B_RPTHDL_2, "RlsRptHDLRAM8852B,rpt_num=%x,len=%x\n"},
	{(u32)MSG_8852B_RPTHDL_3, "ERR: TxCmdRptHDL get NULL txinfo node,rpt->QSEL=%x,  (rpt->FW_DEFINE & MAX_TXCMD_SEQ_MSK)=%x\n"},
	{(u32)MSG_8852B_RPTHDL_4, "ERR: TxRptHDL get NULL txinfo node,rpt->QSEL=%x,(rpt->FW_DEFINE & MAX_TXCMD_SEQ_MSK)=%x\n"},
	{(u32)MSG_8852B_RPTHDL_5, "ERR: TfRptHDL get NULL txinfo node\n"},
	{(u32)MSG_8852B_RPTHDL_6, "SS2FInfoDeQ8852B\n"},
	{(u32)MSG_8852B_RPTHDL_7, "F2PTXCMDRPT HDL\n"},
	{(u32)MSG_8852B_RPTHDL_8, "SS2FWRPT HDL\n"},
	{(u32)MSG_8852B_RPTHDL_9, "TFRPT HDL\n"},
	{(u32)MSG_8852B_RPTHDL_10, "TXBCNRPT HDL\n"},
	{(u32)MSG_8852B_RPTHDL_11, "CCXRPT HDL\n"},
	{(u32)MSG_8852B_RPTHDL_12, "TXRPT HDL\n"},
	{(u32)MSG_8852B_RPTHDL_13, "PLDRLSRPT HDL\n"},
	{(u32)MSG_8852B_ERRHDL_1, "[ERR]DLE Timeout(idx = %d)\n"},
	{(u32)MSG_8852B_ERRHDL_2, "[ERR]AXIDMA is not idle!\n"},
	{(u32)MSG_8852B_ERRHDL_3, "[ERR]STA scheduler init\n"},
	{(u32)MSG_8852B_ERRHDL_4, "[ERR]WDE cfg ready\n"},
	{(u32)MSG_8852B_ERRHDL_5, "[ERR]PLE cfg ready\n"},
	{(u32)MSG_8852B_ERRHDL_6, "=>DmaTopStuck:FA sts: %d, data: %d!\n"},
	{(u32)MSG_8852B_ERRHDL_7, "=>DmaTopStuck:FA!\n"},
	{(u32)MSG_8852B_ERRHDL_8, "=>DmaTopStuck:know!\n"},
	{(u32)MSG_8852B_ERRHDL_9, "=>RecoveryCMAC!\n"},
	{(u32)MSG_8852B_ERRHDL_10, "[ERR]BBRPT CHIF\n"},
	{(u32)MSG_8852B_ERRHDL_11, "[ERR]Check CMAC_idle\n"},
	{(u32)MSG_8852B_ERRHDL_12, "[ERR]PTCL tx\n"},
	{(u32)MSG_8852B_ERRHDL_13, "[ERR]L0 promote event %x\n"},
	{(u32)MSG_8852B_ERRHDL_14, "[ERR][C2H]Previous: %x; Current: %x\n"},
	{(u32)MSG_8852B_ERRHDL_15, "ErrHDL in!\n"},
	{(u32)MSG_8852B_ERRHDL_16, "ErrHDL out!\n"},
	{(u32)MSG_8852B_ERRHDL_17, "DMAC error: %x\n"},
	{(u32)MSG_8852B_ERRHDL_18, "CMAC0 error: %x\n"},
	{(u32)MSG_8852B_ERRHDL_19, "CMAC1 error: %x\n"},
	{(u32)MSG_8852B_ERRHDL_20, "notify: %x\n"},
	{(u32)MSG_8852B_ERRHDL_21, "--->\n err=%x\n"},
	{(u32)MSG_8852B_ERRHDL_22, "R_AX_SER_DBG_INFO =%x\n"},
	{(u32)MSG_8852B_ERRHDL_23, "R_AX_DMAC_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_24, "R_AX_WDE_ERR_FLAG_CFG_NUM1 =%x\n"},
	{(u32)MSG_8852B_ERRHDL_25, "R_AX_PLE_ERR_FLAG_CFG_NUM1 =%x\n"},
	{(u32)MSG_8852B_ERRHDL_26, "R_AX_WDRLS_ERR_IMR =%x "},
	{(u32)MSG_8852B_ERRHDL_27, "R_AX_WDRLS_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_28, "R_AX_RPQ_RXBD_IDX =%x\n"},
	{(u32)MSG_8852B_ERRHDL_29, "R_AX_SEC_DEBUG =%x\n"},
	{(u32)MSG_8852B_ERRHDL_30, "R_AX_MPDU_TX_ERR_IMR =%x "},
	{(u32)MSG_8852B_ERRHDL_31, "R_AX_MPDU_TX_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_32, "R_AX_MPDU_RX_ERR_IMR =%x "},
	{(u32)MSG_8852B_ERRHDL_33, "R_AX_MPDU_RX_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_34, "R_AX_STA_SCHEDULER_ERR_IMR =%x "},
	{(u32)MSG_8852B_ERRHDL_35, "R_AX_STA_SCHEDULER_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_36, "R_AX_WDE_ERR_IMR=%x "},
	{(u32)MSG_8852B_ERRHDL_37, "R_AX_WDE_ERR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_38, "R_AX_PLE_ERR_IMR=%x "},
	{(u32)MSG_8852B_ERRHDL_39, "R_AX_PLE_ERR_FLAG_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_40, "R_AX_TXPKTCTL_ERR_IMR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_41, "R_AX_TXPKTCTL_ERR_IMR_ISR_B1=%x\n"},
	{(u32)MSG_8852B_ERRHDL_42, "R_AX_PKTIN_ERR_IMR =%x "},
	{(u32)MSG_8852B_ERRHDL_43, "R_AX_PKTIN_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_44, "R_AX_PKTIN_ERR_IMR =%x "},
	{(u32)MSG_8852B_ERRHDL_45, "R_AX_PKTIN_ERR_ISR =%x\n"},
	{(u32)MSG_8852B_ERRHDL_46, "R_AX_HOST_DISPATCHER_ERR_IMR=%x "},
	{(u32)MSG_8852B_ERRHDL_47, "R_AX_HOST_DISPATCHER_ERR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_48, "R_AX_CPU_DISPATCHER_ERR_IMR=%x "},
	{(u32)MSG_8852B_ERRHDL_49, "R_AX_CPU_DISPATCHER_ERR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_50, "R_AX_CPUIO_ERR_IMR=%x "},
	{(u32)MSG_8852B_ERRHDL_51, "R_AX_CPUIO_ERR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_52, "R_AX_BBRPT_COM_ERR_IMR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_53, "0xC164=%x\n"},
	{(u32)MSG_8852B_ERRHDL_54, "R_AX_SCHEDULE_ERR_IMR=%x "},
	{(u32)MSG_8852B_ERRHDL_55, "R_AX_SCHEDULE_ERR_ISR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_56, "R_AX_PTCL_IMR0=%x "},
	{(u32)MSG_8852B_ERRHDL_57, "R_AX_PTCL_ISR0=%x\n"},
	{(u32)MSG_8852B_ERRHDL_58, "R_AX_DLE_CTRL=%x\n"},
	{(u32)MSG_8852B_ERRHDL_59, "R_AX_PHYINFO_ERR_IMR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_60, "R_AX_TXPWR_IMR= N/A "},
	{(u32)MSG_8852B_ERRHDL_61, "R_AX_TXPWR_ISR= N/A\n"},
	{(u32)MSG_8852B_ERRHDL_62, "R_AX_DBGSEL_TRXPTCL=%x "},
	{(u32)MSG_8852B_ERRHDL_63, "R_AX_PHYINFO_ERR_IMR=%x\n"},
	{(u32)MSG_8852B_ERRHDL_64, "R_AX_TMAC_ERR_IMR_ISR=%x "},
	{(u32)MSG_8852B_ERRHDL_65, "R_AX_DBGSEL_TRXPTCL=%x\n"},
	{(u32)MSG_8852B_ERRHDL_66, "<---\n"},
	{(u32)MSG_8852B_MAIN_00, "SW Queue reCreate\n"},
	{(u32)MSG_8852B_MAIN_01, "Enter AXIDMA_init... \n"},
	{(u32)MSG_8852B_MAIN_02, "WDT_timer start... \n"},
	{(u32)MSG_8852B_MAIN_03, "InitHWPostDLRAM done\n"},
	{(u32)MSG_8852B_MAIN_04, "InitFWFuncPostDL RAM done\n"},
	{(u32)MSG_8852B_MAIN_05, "MAC per STAInfo %d bytes\n"},
	{(u32)MSG_8852B_MAIN_06, "BB per STAInfo %d bytes\n"},
	{(u32)MSG_8852B_MAIN_07, "InitWLANFuncRAM done\n"},
	{(u32)MSG_8852B_MAIN_08, "Enter test id (0~7): "},
	{(u32)MSG_8852B_MAIN_09, "%s\n"},
	{(u32)MSG_8852B_MAIN_10, "Thread Metric: %d\n"},
	{(u32)MSG_8852B_MAIN_11, "Test duration: %d seconds\n"},
	{(u32)MSG_8852B_MAIN_14, "WDT_timer start fail \n"},
	{(u32)MSG_8852B_MAIN_15, " SysMib.PInternal->PDebugInfo->DbgLvl =%x\n"},
	{(u32)MSG_8852B_MAIN_16, "Enter flash FW loader\n"},
	{(u32)MSG_8852B_IRAMENTRY_00, "Function ptr length :RAM %x,ROM %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_01, "Function ptr length not equal!!\n"},
	{(u32)MSG_8852B_IRAMENTRY_02, "Start Init PLE memory\n"},
	{(u32)MSG_8852B_IRAMENTRY_03, "PLE data check error!!!"},
	{(u32)MSG_8852B_IRAMENTRY_04, "PLE usage :%x\n"},
	{(u32)MSG_8852B_IRAMENTRY_05, "Initializing RAM bss ...\n"},
	{(u32)MSG_8852B_IRAMENTRY_06, "_BSS_RAM_START_ : %x\t _BSS_RAM_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_07, "B cut\n"},
	{(u32)MSG_8852B_IRAMENTRY_08, "_RAM_FUNCPTR_START_ : %x\t _RAM_FUNCPTR_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_09, "_ROM_FUNCPTR_START_ : %x\t _ROM_FUNCPTR_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_10, "C cut\n"},
	{(u32)MSG_8852B_IRAMENTRY_11, "_RAM_CCUT_FUNCPTR_START_ : %x\t _RAM_CCUT_FUNCPTR_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_12, "_ROM_CCUT_FUNCPTR_START_ : %x\t _ROM_CCUT_FUNCPTR_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_13, "D cut\n"},
	{(u32)MSG_8852B_IRAMENTRY_14, "_RAM_DCUT_FUNCPTR_START_ : %x\t _RAM_DCUT_FUNCPTR_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_15, "_ROM_DCUT_FUNCPTR_START_ : %x\t _ROM_DCUT_FUNCPTR_END_ : %x\n"},
	{(u32)MSG_8852B_IRAMENTRY_16, "Load FW RAM code OK\n"},
	{(u32)MSG_8852B_BACKTRACE_00, "Heap space is not enough for backtrace.......\n"},
	{(u32)MSG_8852B_BACKTRACE_01, "Backtrace......\n"},
	{(u32)MSG_8852B_BACKTRACE_02, "Next SP:%x, Next RA:%x\n"},
	{(u32)MSG_8852B_BACKTRACE_03, "Backtrace is failed\n"},
	{(u32)MSG_8852B_BACKTRACE_04, "Done\n"},
	{(u32)MSG_8852B_BACKTRACE_05, "EPC: %x, Cause: %x, BADVADDR: %x, Status: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_06, "hi: %x, lo: %x, ra: %x, fp: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_07, "sp: %x, gp: %x, t9: %x, t8: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_08, "s7: %x, s6: %x, s5: %x, s4: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_09, "s3: %x, s2: %x, s1: %x, s0: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_10, "t7: %x, t6: %x, t5: %x, t4: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_11, "t3: %x, t2: %x, t1: %x, t0: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_12, "a3: %x, a2: %x, a1: %x, a0: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_13, "v1: %x, v0: %x, at: %x\n"},
	{(u32)MSG_8852B_BACKTRACE_14, "not send c2hHalt\n"},
	{(u32)MSG_8852B_BACKTRACE_15, "no loop\n"},
	{(u32)MSG_8852B_BACKTRACE_16, "Something wrong when allocating backtrace memory\n"},
	{(u32)MSG_8852B_BACKTRACE_17, "Backtrace memory is full!!\n"},
	{(u32)MSG_8852B_BACKTRACE_18, "Init Backtrace Memory failed\n"},
	{(u32)MSG_8852B_PSTIMER_00, "handle task:%x\n"},
	{(u32)MSG_8852B_PSTIMER_01, "handle tsf: %x\n"},
	{(u32)MSG_8852B_PSTIMER_02, "tsf in list: %x\n"},
	{(u32)MSG_8852B_AXIDMA_00, "[ERR] AXIDMA is not idle!\n"},
	{(u32)MSG_8852B_AXIDMA_01, "[ERR] AXIDMA is not enable\n"},
	{(u32)MSG_8852B_AXIDMA_02, "[AXIDMA RX Init]Allocate H2C buffer fail 123\n"},
	{(u32)MSG_8852B_AXIDMA_03, "[AXIDMA RX Init]Allocate PKT buffer fail\n"},
	{(u32)MSG_8852B_AXIDMA_04, "[AXIDMA RX Init]Allocate RPT buffer fail\n"},
	{(u32)MSG_8852B_AXIDMA_05, "No tx_para_p input\n"},
	{(u32)MSG_8852B_AXIDMA_06, "AXIDMA TX setup buff fail %d\n"},
	{(u32)MSG_8852B_AXIDMA_07, "AXIDMA TX CH1 no ppld_info input\n"},
	{(u32)MSG_8852B_PORT_00, "Assert at file: %s\n"},
	{(u32)MSG_8852B_PORT_01, "not send c2hHalt\n"},
	{(u32)MSG_8852B_PORT_02, "Assert at line: %d\n"},
	{(u32)MSG_8852B_PORT_03, "Watch dog timeout in critical section\n"},
	{(u32)MSG_8852B_PORT_04, "Watch dog remain: %d(us)\n"},
	{(u32)MSG_8852B_PORT_05, "Exec Time %x ~ %x: %d(us)\n"},
	{(u32)MSG_8852B_RXI300_00, "EPC Value: %x\n"},
	{(u32)MSG_8852B_RXI300_01, "Error id is inexistent(%x)!\n"},
	{(u32)MSG_8852B_RXI300_02, "Error code is inexistent(%x)!\n"},
	{(u32)MSG_8852B_RXI300_03, "RXI300_ERR_SRC_APB_DEF_SLV"},
	{(u32)MSG_8852B_RXI300_04, "RXI300_ERR_SRC_AXI_APB_SA"},
	{(u32)MSG_8852B_RXI300_05, "Error source is inexistent(%x)!\n"},
	{(u32)MSG_8852B_RXI300_06, "HaltC2H = %x, Error address = %x!\n"},
	{(u32)MSG_8852B_RXI300_07, "Clear interrupt fail!\n"},
	{(u32)MSG_8852B_RXI300_08, "RA/SP Value: %x, %x\n"},
	{(u32)MSG_8852B_PS_CHK_PLATFORM_ERR_1, "DMAC error: %x\n"},
	{(u32)MSG_8852B_PS_CHK_PLATFORM_ERR_2, "CMAC%d error: %x\n"},
	{(u32)MSG_8852B_PS_DDMA_BUFFER_SIZE_OVERFLOW, "MAC%d DDMA buffer size (%x) is overflow!\n"},
	{(u32)MSG_8852B_PS_HIOE_START_ADDR, "LPS HIOE start address = %x, size = %x\n"},
	{(u32)MSG_8852B_PS_HIOE_END_ADDR, "LPS HIOE end address = %x\n"},
	{(u32)MSG_8852B_PS_HIOE_INST_OVERFLOW, "LPS HIOE instruction is overflow! inst_size(%x).\n"},
	{(u32)MSG_8852B_PS_HIOE_READ_PCIEMIO_FAIL, "[Err] ReadPCIEMIO Fail! reg = %x\n"},
	{(u32)MSG_8852B_PS_HIOE_WRITE_PCIEMIO_FAIL, "[Err] WritePCIEMIO Fail! reg = %x\n"},
	{(u32)MSG_8852B_PS_HIOE_BACKUP_FAIL, "BKP fail st.(%x)\n"},
	{(u32)MSG_8852B_PS_HIOE_RESTORE_FAIL, "RES fail st.(%x)\n"},
	{(u32)MSG_8852B_PS_HIOE_INVALID_STATE, "Invalid st.(%x)\n"},
	{(u32)MSG_8852B_PS_HIOE_BACKUP_TIMEOUT, "Bkp (%d) polling timeout!\n"},
	{(u32)MSG_8852B_PS_HIOE_RESTORE_TIMEOUT, "Res polling timeout!\n"},
	{(u32)MSG_8852B_PS_ENTER_32K, ">C\n"},
	{(u32)MSG_8852B_PS_LEAVE_32K, "<C\n"},
	{(u32)MSG_8852B_PS_RESET_BD_POLLING_TIMEOUT, "Reset BD polling timeout! val(%d)\n"},
	{(u32)MSG_8852B_PS_BACKUP_MAC_FAIL, "BkpMAC (%d) start fail!!\n"},
	{(u32)MSG_8852B_PS_BACKUP_MAC_TIMEOUT, "BkpMAC (%d) polling timeout! idx=%x!\n"},
	{(u32)MSG_8852B_PS_RESTORE_MAC_FAIL, "RestoreMAC (%d) start fail!!\n"},
	{(u32)MSG_8852B_PS_RESTORE_MAC_TIMEOUT, "RestoreMAC (%d) polling timeout! idx=%x!\n"},
	{(u32)MSG_8852B_PS_TIMER_STOP_FAIL, "[32K] timer (%d) stop FAIL!\n"},
	{(u32)MSG_8852B_PS_TIMER_START_FAIL, "[32K] timer (%d) start FAIL!\n"},
	{(u32)MSG_8852B_PS_DISABLE_HCIDMA_FAIL, "Disable HCI TX DMA FAIL!\n"},
	{(u32)MSG_8852B_PS_READ_PCIEMIO_FAIL, "[Err] ReadPCIEMIO Fail! reg = %x\n"},
	{(u32)MSG_8852B_PS_WRITE_PCIEMIO_FAIL, "[Err] WritePCIEMIO Fail! reg = %x\n"},
	{(u32)MSG_8852B_PS_32K_STATUS, "LPS Status: %x\n"},
	{(u32)MSG_8852B_PS_32K_ERROR, "LPS Error: %x\n"},
	{(u32)MSG_8852B_PS_32K_INFO, "LPS Info: %x\n"},
	{(u32)MSG_8852B_PS_SLEEP_TIME, "[Sleep Time] Expect=%x, Complete=%x\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_1, "[PST] ResPG Analysis(us): %d, MAC: %d, BB: %d, RF: %d\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_2, "[PST] Res timer(us): %d us, MAC1st backup: %d, MAC everytime backup: %d, Enable WDE/PLE: %d\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_3, "[PST] RFK(us): %d, DACK: %d, Radio: %d, RFC: %d\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_4, "[PST] T2 ClkUp to OpenRF: %d us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_5, "[PST] ResDone = %x us, OpenRF = %x us, TBTT = %x us, RxBcn = %x us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_6, "[PST] OpenRF to TBTT = %d us, TBTT to RxBcn = %d us, RxBcn to ClsRF = %d us, ClsRF to 32k = %d us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_7, "[PST] ResDone = %x us, OpenRF = %x us, TBTT = %x us\n,"},
	{(u32)MSG_8852B_PS_TIMING_LOG_8, "[PST] ResDone to SetBcnTo = %d us, SetBcnTo to BcnTo = %d us, BcnTo to ClsRF = %d us, ClsRF to 32k = %d us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_9, "[PST] OpenRF = %x us, TBTT = %x us, RxBcn = %x us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_10, "[PST] OpenRF to TBTT = %d us, TBTT to RxBcn = %d us, RxBcn to ClsRF = %d us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_11, "[PST] OpenRF = %x us, TBTT = %x us, SetBcnTo to BcnTo = %d us, BcnTo to ClsRF = %d us\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_12, "[PST] OpenRF to ClsRF = %d us, RxBcn to S4 = %d us, S4Cnt = %d\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_13, "[PST] OpenRF to ClsRF = %d us, BcnTo to S4 = %d us, S4Cnt = %d\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_14, "[PST] BcnLossRate = %d/100, BcnTimeoutCnt = %d, BcnErlyCnt = %d\n"},
	{(u32)MSG_8852B_PS_TIMING_LOG_15, "[PST] S4Error[%d] = %d\n"},
	{(u32)MSG_8852B_PS_INIT_FAIL, "[FAIL] lps_info alloc fail!\n"},
	{(u32)MSG_8852B_PS_PLATFORM_ERR, "Platform error (%d)!\n"},
	{(u32)MSG_8852B_PS_RESTORE_FLOW_FAIL, "RestoreFlow FAIL!\n"},
	{(u32)MSG_8852B_PS_AXIDMA_NOT_EMPTY, "[32K] AXIDMA not empty (%d). host = %x, hw = %x\n"},
	{(u32)MSG_8852B_PS_NO_ENTER_LPS, "0x90=%x, No Enter LPS! 0xC0=%x\n"},
	{(u32)MSG_8852B_PS_TX_PACKT_IN, "TxPktIn\n"},
	{(u32)MSG_8852B_PS_TXDMA_BUSY, "[Err] TXDMA is busy! dma_busy1 = %x\n"},
	{(u32)MSG_8852B_PS_TAKE_SEMAPHORE_FAIL, "Step(%d) Take RxModeLock FAIL!!!\n"},
	{(u32)MSG_8852B_PS_NULL_SEMAPHORE, "Step(%d) RxModeLock == NULL!\n"},
	{(u32)MSG_8852B_PS_CLOSE_RF, ">\n"},
	{(u32)MSG_8852B_PS_OPEN_RF, "<\n"},
	{(u32)MSG_8852B_PS_GRANT_WLAN_FAIL, "[PDCK] GNT WL FAIL!!\n"},
	{(u32)MSG_8852B_PS_PDCK_CAL_FAIL, "PDCK CAL FAIL!!\n"},
	{(u32)MSG_8852B_PS_ANACLK_CAL_FAIL, "ANACLK CAL FAIL!!\n"},
	{(u32)MSG_8852B_PS_EN_RX_NORMAL_MODE_FAIL, "RF is OFF. EnRxNormMode FAIL!\n"},
	{(u32)MSG_8852B_PS_EN_RX_NORMAL_MODE, "1->2"},
	{(u32)MSG_8852B_PS_SET_RF_OFF_PERMISSION, "SetRfOffPermission: PhyRfOffPermission[%d]=%d\n"},
	{(u32)MSG_8852B_PS_SET_32K_PERMISSION, "Set32KandPGPermission. 32K(%d), PG(%d)\n"},
	{(u32)MSG_8852B_PS_ENABLE_LPS_FW_TEST, "Enable LPS FW test. Target LPS number (%x)\n"},
	{(u32)MSG_8852B_PS_WAKE_BAR_PULL, "[RF OFF] Wake bar is pulled\n"},
	{(u32)MSG_8852B_PS_RX_FAIL_KEEP_RF_ON, "[RF OFF] Rx FAIL! keep RF on.\n"},
	{(u32)MSG_8852B_PS_CHECK_RF_CONDITION_FAIL, "Check RF OFF condition FAIL (%d)\n"},
	{(u32)MSG_8852B_PS_TX_NULL_FAIL, "[Error] Cannot tx null%d\n"},
	{(u32)MSG_8852B_PS_CREATE_ROLE_FAIL, "[FAIL] Create Role fail!\n"},
	{(u32)MSG_8852B_PS_ALREADY_IN_PS_MODE, "[Error] Already in LPS/WMM PS (%x)!!\n"},
	{(u32)MSG_8852B_PS_SET_POWER_MODE_1, "MAC ID = %d, PS Mode = %d, RLBM = %d\n"},
	{(u32)MSG_8852B_PS_SET_POWER_MODE_2, "Smart PS = %d, Awake Interval = %d, Last RPWM = %d\n"},
	{(u32)MSG_8852B_PS_BEACON_EARLY, "E\n"},
	{(u32)MSG_8852B_PS_RX_BEACON, "R\n"},
	{(u32)MSG_8852B_PS_RX_BEACON_NO_HIT, "N\n"},
	{(u32)MSG_8852B_PS_INVALID_BEACON_REPORT, "[Error] Does not receive BCN Parser Rpt\n"},
	{(u32)MSG_8852B_PS_KEEP_RF_ON, "Keep ON\n"},
	{(u32)MSG_8852B_PS_ENABLE_BEACON_TIMEOUT_TIMER_FAIL, "EnBcnTimeOutCount fail!!\n"},
	{(u32)MSG_8852B_PS_TIMER_VALUE_NOT_INIT, "Timer (%d) val is not init!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_CREATE_TIMER_FAIL, "Create timer (%d) fail!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_SEND_NULL_FAIL_RESULT, "TxNull %d FAIL! ret_type(%d), result(%d)\n"},
	{(u32)MSG_8852B_PS_INVALID_POWER_BIT, "[PsSendNullCb] invalid pwr_bit(%d)\n"},
	{(u32)MSG_8852B_PS_INIT_PS_PARAMETER, "InitPSParm, role_idx=%d\n"},
	{(u32)MSG_8852B_PS_S2_CONDITION_MISMATCH, "[ChkS2 no match] Condition(%d), LpsDbgInfo = 0x%x\n"},
	{(u32)MSG_8852B_PS_S4_CONDITION_MISMATCH, "[ChkS4 no match] Condition(%d), LpsDbgInfo = 0x%x\n"},
	{(u32)MSG_8852B_PS_CHANGE_PS_STATE, "[ChangePSStateByRPWM] REQ State: %d, Cur State: %d\n"},
	{(u32)MSG_8852B_PS_SET_POWER_MODE_ROLE_NOT_EXIST, "Role not exist! Condition (%d)\n"},
	{(u32)MSG_8852B_PS_SET_TBTT_AGG_NUM, "Step(%d), SetTbttAggNum(%d).\n"},
	{(u32)MSG_8852B_PS_RX_BEACON_TIMEOUT, "PsBcnTimeOut\n"},
	{(u32)MSG_8852B_PS_SET_POWER_STATE, "CURRENT_PS_STATE: %d, LASTRPWM: %d\n"},
	{(u32)MSG_8852B_PS_RESET_PS_PARAMETER, "ResetPSParm\n"},
	{(u32)MSG_8852B_PS_ACTIVATE_SETTING, "ActiveSetting\n"},
	{(u32)MSG_8852B_PS_SEND_NULL_RESULT, "[PsSendNullCb] type(%d), result(%d)\n"},
	{(u32)MSG_8852B_PACKET_TX_NOT_ENABLE, "[ERR]MGQ1 Txen = 0, TXEN(0xC348)=%x\n"},
	{(u32)MSG_8852B_PACKET_MACID_SLEEP, "MACID_SLEEP_0(0xC2C0)=%x\n"},
	{(u32)MSG_8852B_PACKET_TX_NULL, "Null %d\n"},
	{(u32)MSG_8852B_PACKET_SEND_NULL_FAIL, "Send NULL FAIL! ret_type(%d), ret_result(%d).\n"},
	{(u32)MSG_8852B_PACKET_INVALID_POWER_BIT, "Send NULL with invalid type(%d)!.\n"},
	{(u32)MSG_8852B_PACKET_NULL_PKTID_NOT_EXIST, "Null PKTID No Exist!!\n"},
	{(u32)MSG_8852B_PACKET_NULL_READ_PKT_OFFLOAD_FAIL, "[IssueNull]ReadFWOfldPKT FAIL!!\n"},
	{(u32)MSG_8852B_PACKET_NULL_PKT_OFFLOAD, "Null ID=%d, pkt_len=%d, ppkt_content=%x\n"},
	{(u32)MSG_8852B_PACKET_PROBE_REQ_PKTID_NOT_EXIST, "Probe req PKTID No Exist!!\n"},
	{(u32)MSG_8852B_PACKET_PROBE_REQ_READ_PKT_OFFLOAD_FAIL, "[IssueProbeReq]ReadFWOfldPKT FAIL!!\n"},
	{(u32)MSG_8852B_WOWLAN_1, "H2C wowlan, fun: %x"},
	{(u32)MSG_8852B_WOWLAN_2, "H2C Keep Alive, Enable: %x\n"},
	{(u32)MSG_8852B_WOWLAN_3, "H2C disconn, Enable: %x\n"},
	{(u32)MSG_8852B_WOWLAN_4, "Wow stop AXIDMA failed\n"},
	{(u32)MSG_8852B_WOWLAN_5, "H2C wow global, Enable: %x\n"},
	{(u32)MSG_8852B_WOWLAN_6, "H2C wakeup ctrl, pattern match Enable: %x\n"},
	{(u32)MSG_8852B_WOWLAN_7, "H2C , nlo Enable: %x\n"},
	{(u32)MSG_8852B_WOWLAN_8, "H2C , wow cam: %x\n"},
	{(u32)MSG_8852B_WOWLAN_9, "\nAppendTkipMICComm\n"},
	{(u32)MSG_8852B_WOWLAN_10, "key[%d]=%x\n"},
	{(u32)MSG_8852B_WOWLAN_11, "DA[%d]=%x\n"},
	{(u32)MSG_8852B_WOWLAN_12, "SA[%d]=%x\n"},
	{(u32)MSG_8852B_WOWLAN_13, "Priority[%d]=%x\n"},
	{(u32)MSG_8852B_WOWLAN_14, "data[%d]=%x\n"},
	{(u32)MSG_8852B_WOWLAN_15, "miccode[%d]=%x\n"},
	{(u32)MSG_8852B_WOWLAN_16, "get 1st rx pktid fail\n"},
	{(u32)MSG_8852B_WOWLAN_17, "(%d, %d) Parsed Failed!\n"},
	{(u32)MSG_8852B_WOWLAN_18, "Magic Packet Parsed Done, reason_bits<%x>\n"},
	{(u32)MSG_8852B_WOWLAN_19, "H2C , arp ofld Enable: %x\n"},
	{(u32)MSG_8852B_WOWLAN_20, "Unexpected HCI type in togglewake\n"},
	{(u32)MSG_8852B_BEACON_1, "req bcn mem err\n"},
	{(u32)MSG_8852B_BEACON_2, "CPUIO rls bcn pld fail\n"},
	{(u32)MSG_8852B_BEACON_3, "req bcn wp err %d\n"},
	{(u32)MSG_8852B_BEACON_4, "bcnq lock fail\n"},
	{(u32)MSG_8852B_BEACON_5, "CPUIO deq bcn fail\n"},
	{(u32)MSG_8852B_BEACON_6, "bcn req wd fail %d\n"},
	{(u32)MSG_8852B_BEACON_7, "enq bcn fail %d\n"},
	{(u32)MSG_8852B_PPS_00, "B%d pps%d already enable\n"},
	{(u32)MSG_8852B_PPS_01, "B%d pps%d already disable\n"},
	{(u32)MSG_8852B_PPS_02, "B%d pps%d reg already enable\n"},
	{(u32)MSG_8852B_PPS_03, "B%d pps%d reg already disable\n"},
	{(u32)MSG_8852B_PPS_04, "invalid pps band %d\n"},
	{(u32)MSG_8852B_PPS_05, "B%d pps%d is not enable yet\n"},
	{(u32)MSG_8852B_PPS_06, "B%d pps%d pof%d already enable\n"},
	{(u32)MSG_8852B_PPS_07, "B%d pps%d pof%d already disable\n"},
	{(u32)MSG_8852B_PPS_08, "B%d pps%d pof%d reg already enable\n"},
	{(u32)MSG_8852B_PPS_09, "B%d pps%d pof%d reg already disable\n"},
	{(u32)MSG_8852B_PPS_10, "B%d pps%d pof%d running\n"},
	{(u32)MSG_8852B_PPS_11, "pps no param ptr %d\n"},
	{(u32)MSG_8852B_PPS_12, "invalid pps port %d\n"},
	{(u32)MSG_8852B_PPS_13, "no valid pps id\n"},
	{(u32)MSG_8852B_PPS_14, "pps is already running\n"},
	{(u32)MSG_8852B_HCI_00, "Wrong MDIO PCIe Input, input speed: %x\n"},
	{(u32)MSG_8852B_HCI_01, "MDIO Read Fail, addr: %x\n"},
	{(u32)MSG_8852B_HCI_02, "MDIO Write Fail, addr: %x\n"},
	{(u32)MSG_8852B_HCI_03, "Init PCIE Card Loss\n"},
	{(u32)MSG_8852B_HCI_04, "MDIO Write Fail\n"},
	{(u32)MSG_8852B_HCI_05, "G1_PHY_3F4: %x\n"},
	{(u32)MSG_8852B_HCI_06, "G1_PHY_3C4: %x\n"},
	{(u32)MSG_8852B_HCI_07, "G1_PHY_3D4: %x\n"},
	{(u32)MSG_8852B_HCI_08, "G1_PHY_204: %x\n"},
	{(u32)MSG_8852B_HCI_09, "Card Loss\n"},
	{(u32)MSG_8852B_HCI_10, "DBG_38: %X, DBG_39: %X, DBG_3C: %X\n"},
	{(u32)MSG_8852B_HCI_11, "DBG_23: %X, MAC_3F0: %X, MAC_F8: %X\n"},
	{(u32)MSG_8852B_HCI_12, "DBG_F0: %X\n"},
	{(u32)MSG_8852B_HCI_13, "[CtrlPCIEACHDMA]ch map empty\n"},
	{(u32)MSG_8852B_HCI_14, "[CtrlPCIEACHDMA]Read PCIE MIO fail\n"},
	{(u32)MSG_8852B_HCI_15, "[CtrlPCIEACHDMA]Write PCIE MIO fail\n"},
	{(u32)MSG_8852B_H2CPKT_0, "content = %x  %x  %x  %x\n"},
	{(u32)MSG_8852B_H2CPKT_2, "size mismatch while deaggregating H2C\n"},
	{(u32)MSG_8852B_H2CPKT_3, "First H2C Enqueue\n"},
	{(u32)MSG_8852B_H2CPKT_4, "Get free H2C node fail\n"},
	{(u32)MSG_8852B_H2CPKT_5, "Get free H2C node fail\n"},
	{(u32)MSG_8852B_H2CPKT_6, "_InitH2CPktPoolRAMComm: H2C ptr is null!!!\n"},
	{(u32)MSG_8852B_H2CPKT_7, "_InitH2CPktPoolRAMComm: H2C queue is full!!!\n"},
	{(u32)MSG_8852B_H2CPKT_8, "H2C is null!!!\n"},
	{(u32)MSG_8852B_H2CPKT_9, "H2C Dequeue\n"},
	{(u32)MSG_8852B_H2CPKT_10, "H2CPKT dequeue fail\n"},
	{(u32)MSG_8852B_H2CPKT_11, "H2CPktEnQueueRAMComm\n"},
	{(u32)MSG_8852B_H2CPKT_12, "H2C header len %d & rx bd info len %d mismatch\n"},
	{(u32)MSG_8852B_H2CPKT_13, "H2CPKT enqueue fail\n"},
	{(u32)MSG_8852B_H2CPKT_14, "H2CPktNodeFreeRAMComm\n"},
	{(u32)MSG_8852B_H2CPKT_15, "Wrong H2C pool class: %d\n"},
	{(u32)MSG_8852B_H2CPKT_16, "H2CPktNodeFreeRAMComm: class %d H2C queue is full!!!\n"},
	{(u32)MSG_8852B_H2CPKT_17, "H2CPktNodeAllocRAMComm\n"},
	{(u32)MSG_8852B_H2CPKT_18, "H2CPkt length is too large\n"},
	{(u32)MSG_8852B_H2CPKT_19, "H2C node pool is empty\n"},
	{(u32)MSG_8852B_H2CPKT_20, "H2C node is valid\n"},
	{(u32)MSG_8852B_H2CPKT_21, "H2C Enqueue\n"},
	{(u32)MSG_8852B_H2CPKT_22, "H2CPKT get lock fail\n"},
	{(u32)MSG_8852B_H2CPKT_23, "H2C size is inconsistent\n"},
	{(u32)MSG_8852B_H2CPKT_24, "H2C node is NULL\n"},
	{(u32)MSG_8852B_H2CPKT_25, "H2CPKT get lock fail\n"},
	{(u32)MSG_8852B_H2CPKT_26, "H2CPKT return lock fail\n"},
	{(u32)MSG_8852B_H2C2HREG_0, "AXIDMA Stop Failed\n"},
	{(u32)MSG_8852B_H2C2HREG_1, "Should never get here\n"},
	{(u32)MSG_8852B_TWT_00, "TWT init fail, ALLOC NULL\n"},
	{(u32)MSG_8852B_TWT_01, "TWT init fail, create timer fail\n"},
	{(u32)MSG_8852B_TWT_02, "TWT init fail, create twtc2hLock fail\n"},
	{(u32)MSG_8852B_TWT_03, "TWT id %d invalid\n"},
	{(u32)MSG_8852B_TWT_04, "[TSF]invalid port %d\n"},
	{(u32)MSG_8852B_TWT_05, "add TWT[%d] h2c already valid\n"},
	{(u32)MSG_8852B_TWT_06, "add TWT h2c Role idx srch fail B%dP%d\n"},
	{(u32)MSG_8852B_TWT_07, "add TWT[%d] h2c Role idx %d exist\n"},
	{(u32)MSG_8852B_TWT_08, "add TWT done, port %x, itvl %d, dur %d\n"},
	{(u32)MSG_8852B_TWT_09, "[TWT]enable PCIE ACH%d DMA fail\n"},
	{(u32)MSG_8852B_TWT_10, "del TWT h2c Role srch fail B%dP%d\n"},
	{(u32)MSG_8852B_TWT_11, "del TWT h2c Role %d not match srch idx %d\n"},
	{(u32)MSG_8852B_TWT_12, "del TWT h2c clr TWT[%d] COM info fail\n"},
	{(u32)MSG_8852B_TWT_13, "del TWT h2c clr TWT[%d] NIC info fail\n"},
	{(u32)MSG_8852B_TWT_14, "TWT timer start fail\n"},
	{(u32)MSG_8852B_TWT_15, "did not assign twt ul fix, force to all TF fix.\n"},
	{(u32)MSG_8852B_TWT_16, "stop TWT timer fail\n"},
	{(u32)MSG_8852B_TWT_17, "del TWT h2c clr TWT[%d] AP info fail\n"},
	{(u32)MSG_8852B_TWT_18, "TWT act %d, macid %d, id %d\n"},
	{(u32)MSG_8852B_TWT_19, "TWT sta num %d\n"},
	{(u32)MSG_8852B_TWT_20, "[TWT]get B%d port %d tsf fail\n"},
	{(u32)MSG_8852B_TWT_21, "[TWT%d]issue wake pkt fail %d-%d\n"},
	{(u32)MSG_8852B_TWT_22, "[TWT]enable PCIE ACH%d DMA fail\n"},
	{(u32)MSG_8852B_TWT_23, "[TWT]disable PCIE ACH%d DMA fail\n"},
	{(u32)MSG_8852B_TWT_24, "[TWT]Next start %X-%X, end %X-%X\n"},
	{(u32)MSG_8852B_TWT_25, "[TWT]TSF diff over u32\n"},
	{(u32)MSG_8852B_TWT_26, "[TWT]SP start early %X-%X, srt diff %d,dur diff %d, end diff %d\n"},
	{(u32)MSG_8852B_CHSW_00, "[ChSw] Channel Switch Fail. (ctrl_bw_ch return false)\n"},
	{(u32)MSG_8852B_PS_TX_REQ, "PsTxReq. role(%d), feature(%d), en(%d)\n"},
	{(u32)MSG_8852B_PS_TX_REQ_DUPLICATED_DISABLE, "[ERROR] role(%d), feature(%d) Tx has been disabled!\n"},
	{(u32)MSG_8852B_MP_0, "error=%d\n"},
	{(u32)MSG_8852B_MP_1, "ips 0x1C err = 0x%x\n"},
	{(u32)MSG_8852B_MP_2, "Wait Timeout ips status =0x%x, ips err = 0x%x\n"},
	{(u32)MSG_8852B_MP_3, "bit=%x"},
	{(u32)MSG_8852B_MP_4, "CMAC"},
	{(u32)MSG_8852B_MP_5, "ALL"},
	{(u32)MSG_8852B_P2P_00, "[P2P]no act info ptr\n"},
	{(u32)MSG_8852B_P2P_01, "[P2P]act h2c init Role idx srch fail macid %d\n"},
	{(u32)MSG_8852B_P2P_02, "[P2P]set pps param fail %d\n"},
	{(u32)MSG_8852B_P2P_03, "[P2P]B%d pps%d en%d fail %d\n"},
	{(u32)MSG_8852B_P2P_04, "[P2P]B%d pps%d pof%d en%d fail %d\n"},
	{(u32)MSG_8852B_P2P_05, "[P2P]set pof param fail %d\n"},
	{(u32)MSG_8852B_P2P_06, "[P2P]B%d P2P%d noa%d already disable\n"},
	{(u32)MSG_8852B_P2P_07, "[P2P]B%d P2P%d has no running NoA sch\n"},
	{(u32)MSG_8852B_P2P_08, "[P2P]no content ptr\n"},
	{(u32)MSG_8852B_P2P_09, "[P2P]act h2c p2p%d over max\n"},
	{(u32)MSG_8852B_P2P_10, "[P2P]act h2c noa%d over max\n"},
	{(u32)MSG_8852B_P2P_11, "[P2P]p2p%d already running\n"},
	{(u32)MSG_8852B_P2P_12, "[P2P]p2p%d not init yet\n"},
	{(u32)MSG_8852B_P2P_13, "[P2P]act h2c init fail %d\n"},
	{(u32)MSG_8852B_P2P_14, "[P2P]act h2c upd sch fail %d\n"},
	{(u32)MSG_8852B_P2P_15, "[P2P]act h2c rm sch fail %d\n"},
	{(u32)MSG_8852B_P2P_16, "[P2P]act h2c term fail %d\n"},
	{(u32)MSG_8852B_P2P_17, "[P2P]illegal act h2c %d\n"},
	{(u32)MSG_8852B_P2P_18, "[P2P] macid ctrl h2c p2p id %d over max\n"},
	{(u32)MSG_8852B_P2P_19, "[P2P]macid ctrl type %d invalid\n"},
	{(u32)MSG_8852B_P2P_20, "[P2P]no p2p info ptr\n"},
	{(u32)MSG_8852B_P2P_21, "[P2P]P2P%d clear MACID ctrl all fail %d\n"},
	{(u32)MSG_8852B_P2P_22, "[P2P]H2C Act fail %d\n"},
	{(u32)MSG_8852B_P2P_23, "[P2P]H2C MACID ctrl fail %d\n"},
	{(u32)MSG_8852B_MPORT_00, "[MPORT]no tsf32 togl h2c content\n"},
	{(u32)MSG_8852B_MPORT_01, "[MPORT]tsf32 togl hdl only support band 0\n"},
	{(u32)MSG_8852B_MPORT_02, "[MPORT]port %d over max\n"},
	{(u32)MSG_8852B_MPORT_03, "[MPORT]B%dP%d tsf32 togl en %d no change\n"},
	{(u32)MSG_8852B_MPORT_04, "[MPORT]tsf32 toggle rpt hdl no input\n"},
	{(u32)MSG_8852B_MPORT_05, "[MPORT]tsf32 togl rpt c2h enq fail %d\n"},
	{(u32)MSG_8852B_MPORT_06, "[MPORT]tsf32 toggle hdl no input\n"},
	{(u32)MSG_8852B_MPORT_07, "[MPORT]B%dP%d tsf low %d not run\n"},
	{(u32)MSG_8852B_MPORT_08, "[MPORT]tsf32 toggle hdl add pstimer task fail\n"},
	{(u32)MSG_8852B_MPORT_09, "[MPORT]invalid port idx %d\n"},
	{(u32)MSG_8852B_MPORT_10, "[MPORT]invalid mbssid %d\n"},
	{(u32)MSG_8852B_MPORT_11, "[MPORT]invalid get cfg type %d\n"},
	{(u32)MSG_8852B_MPORT_12, "[MPORT]B%dP%d get port cfg%d fail %d\n"},
	{(u32)MSG_8852B_MPORT_13, "[MPORT]B%dP%d set port cfg%d val%d fail %d\n"},
	{(u32)MSG_8852B_MPORT_14, "[MPORT]sub space %d overflow\n"},
	{(u32)MSG_8852B_MPORT_15, "[MPORT]port init stat c2h enq fail %d\n"},
	{(u32)MSG_8852B_MPORT_16, "[MPORT]port cfg stat c2h enq fail %d\n"},
	{(u32)MSG_8852B_MPORT_17, "[MPORT]B%dP%d fast drop setup add ps timer fail %d\n"},
	{(u32)MSG_8852B_MPORT_18, "[MPORT]port deinit post fail %d\n"},
	{(u32)MSG_8852B_MPORT_19, "[MPORT]chk bcnq empty fail %d\n"},
	{(u32)MSG_8852B_MPORT_20, "[MPORT]fast bcn drop setup fail %d\n"},
	{(u32)MSG_8852B_MPORT_21, "[MPORT]port deinit patch fail %d\n"},
	{(u32)MSG_8852B_MPORT_22, "[MPORT]B%dP%d deinit patch add pstmr fail %d\n"},
	{(u32)MSG_8852B_MPORT_23, "[MPORT]B%dP%d deinit post fail %d\n"},
	{(u32)MSG_8852B_MPORT_24, "[MPORT]B%dP%d init post fail %d\n"},
	{(u32)MSG_8852B_MPORT_25, "[MPORT]send port init c2h %d\n"},
	{(u32)MSG_8852B_MPORT_26, "[MPORT]send port cfg c2h %d\n"},
	{(u32)MSG_8852B_MPORT_27, "[MPORT]Port deinit setup fail %d\n"},
	{(u32)MSG_8852B_MPORT_28, "[MPORT]illegal port cfg%d val %d\n"},
	{(u32)MSG_8852B_MPORT_29, "[MPORT]port cfg%d check fail %d\n"},
	{(u32)MSG_8852B_MPORT_30, "[MPORT]mbssid en invalid for P%d MB%d\n"},
	{(u32)MSG_8852B_MPORT_31, "[MPORT]mbssid %d over current max %d\n"},
	{(u32)MSG_8852B_MPORT_32, "[MPORT]port%d is not 0 or state%d is not AP\n"},
	{(u32)MSG_8852B_MPORT_33, "[MPORT]set max mbid num fail %d\n"},
	{(u32)MSG_8852B_MPORT_34, "[MPORT]invalid port cfg type %d\n"},
	{(u32)MSG_8852B_MPORT_35, "[MPORT]port init no input\n"},
	{(u32)MSG_8852B_MPORT_36, "[MPORT]B%dP%d mbid set fail %d\n"},
	{(u32)MSG_8852B_MPORT_37, "[MPORT]B%dP%d subspc set fail %d\n"},
	{(u32)MSG_8852B_MPORT_38, "[MPORT]no port init h2c content\n"},
	{(u32)MSG_8852B_MPORT_39, "[MPORT]port init setup fail %d\n"},
	{(u32)MSG_8852B_MPORT_40, "[MPORT]no port cfg h2c content\n"},
	{(u32)MSG_8852B_NULL_RESULT, "TxNull %d result(%d)!!!\n"},
	{(u32)MSG_8852B_MALLOC_1, "%x\t"},
	{(u32)MSG_8852B_MALLOC_2, "\t\t%u\t\t"},
	{(u32)MSG_8852B_MALLOC_3, "\t\t%u\n"},
	{(u32)MSG_8852B_MALLOC_4, "Fast heap\t%x\t%u\t\t%u\t%u\n"},
	{(u32)MSG_8852B_MALLOC_5, "Slow heap\t%x\t%u\t\t%u\t%u\n"},
	{(u32)MSG_8852B_MALLOC_6, "\t\t%u\t\t%u\t\t%u\n"},
	{(u32)MSG_8852B_MALLOC_7, "Don't support this mode!\n"},
	{(u32)MSG_8852B_MALLOC_8, "%s\t\t"},
	{(u32)MSG_8852B_MALLOC_9, "[Err][Phase%d]FastHeap(%u) is under threshold(%u)!\n"},
	{(u32)MSG_8852B_MALLOC_10, "[Phase%d]FastHeap(%u) is above threshold(%u)!\n"},
	{(u32)MSG_8852B_MALLOC_11, "[Err][Phase%d]SlowHeap(%u) is under threshold(%u)!\n"},
	{(u32)MSG_8852B_MALLOC_12, "[Phase%d]SlowHeap(%u) is above threshold(%u)!\n"},
	{(u32)MSG_8852B_MALLOC_13, "call %s return NULL\n"},
	{(u32)MSG_8852B_MALLOC_14, "exceed memory limit\n"},
	{(u32)MSG_8852B_MALLOC_15, " total: %d bytes\n cur used: %d bytes\n"},
	{(u32)MSG_8852B_MALLOC_16, "cur free: %d bytes\n release size exceed allocate size\n"},
	{(u32)MSG_8852B_PS_CREATE_TIMER_DUPLICATED, "[ERR][LPS] Create timer (%d) is existed!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_DELETE_TIMER_FAIL, "[ERR][LPS] Delete timer (%d) FAIL!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_DELETE_TIMER_NOT_EXIST, "[ERR][LPS] Delete timer (%d) is not existed!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_DTIM_TIMER_NOT_EXIST, "[ERR][LPS] Operation(%d) DTIM timer is not existed!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_BCN_TIMER_NOT_EXIST, "[ERR][LPS] Operation(%d) BCN timer is not existed!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_TRX_TIMER_NOT_EXIST, "[ERR][LPS] Operation(%d) TRX timer is not existed!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_ENABLE_DTIM_TIMEOUT_TIMER_FAIL, "[ERR][LPS] EnDTIMTimeOutCountComm FAIL!!\n"},
	{(u32)MSG_8852B_PS_ENABLE_TRX_TIMEOUT_TIMER_FAIL, "[ERR][LPS] EnTRXTimeOutCount FAIL!!\n"},
	{(u32)MSG_8852B_PS_DRFC_RESTORE_FAIL, "[ERR][LPS] Restore DRFC FAIL!! RF mode (%d)\n"},
	{(u32)MSG_8852B_PS_S2TOS4_TX_BUSY, "[WARN][LPS][S2ToS4State] Macid TX busy, role_idx(%d)\n"},
	{(u32)MSG_8852B_RPWM_SEQ_MISMATCH, "[ERR] RPWM Seq Num mismatch!\n"},
	{(u32)MSG_8852B_RPWM_REQ_STATE_INVALID, "[ERR] Req Pwr state (%d) is invalid!\n"},
	{(u32)MSG_8852B_READ_RPWM, "Read RPWM = %x\n"},
	{(u32)MSG_8852B_WRITE_CPWM, "LDM = %x, cpwm_val = %x, CPWM = %x\n"},
	{(u32)MSG_8852B_MCC_H2CADDMCCHDL_4, "[MCC] channel band type is None!\n"},
	{(u32)MSG_8852B_TASK_ERROR, "Task Error: %x\n"},
	{(u32)MSG_8852B_GETMEDIASTS_1, "GetMediaStatusbyMacid fail, macid = %x!\n"},
	{(u32)MSG_8852B_SETMEDIASTS_1, "SetMediaStatusbyMacid: macid number >= 32, macid = %x!\n"},
	{(u32)MSG_8852B_SETMEDIASTS_2, "SetMediaStatusbyMacid: Role_idx error, macid = %x, role_idx = %x!\n"},
	{(u32)MSG_8852B_IPS_SET_CFG_ROLE_NOT_EXIST, "[SetIpsCfg] role is not existed\n"},
	{(u32)MSG_8852B_IPS_SET_CFG_DUPLICATE_ENABLE, "[SetIpsCfg] IPS is already enabled! role_idx(%d)\n"},
	{(u32)MSG_8852B_IPS_SET_CFG, "[SetIpsCfg] macid(%d), Enable(%d)\n"},
	{(u32)MSG_8852B_IPS_CHK_I1_COND_MATCH_1, "=>ChkI1ConditionMatch\n"},
	{(u32)MSG_8852B_IPS_CHK_I1_COND_MATCH_2, "[ChkI1 no match] IpsDbgInfo = 0x%x\n"},
	{(u32)MSG_8852B_IPS_CHANGE_IPS_STATE_INVALID_REQ_STATE, "[ChangeIpsState] Invalid req_state = %d\n"},
	{(u32)MSG_8852B_IPS_CHANGE_STATE_BY_CONDITION, "[ChangeIPSStateByCondition] REQ State: %d, Cur State: %d\n"},
	{(u32)MSG_8852B_PS_TRX_REQ_ROLE_NOT_EXIST, "[ERR] [PsTRxReq] role(%d) is not existed!\n"},
	{(u32)MSG_8852B_PS_TRX_REQ, "[PsTRxReq] %d. role(%d), feature(%d), en(%d)\n"},
	{(u32)MSG_8852B_PS_TRX_REQ_DISABLE_ERR, "[ERR] [PsTRxReq] %d. role(%d), feature(%d) Tx has been disabled!\n"},
	{(u32)MSG_8852B_ROLE_22, "[FAIL] Role info - IpsParm alloc fail!\n"},
	{(u32)MSG_8852B_MCC_H2CRESETMCCGROUPHDR_1, "[MCC][Reset] Reset groups: %d\n"},
	{(u32)MSG_8852B_HEAP_01, "%s\t\t"},
	{(u32)MSG_8852B_HEAP_02, "(%d)\t%d"},
	{(u32)MSG_8852B_HEAP_03, "%d\t\t%d\t\t%d\n"},
	{(u32)MSG_8852B_HEAP_04, "(%d)\t%d(%d)\t\t\t"},
	{(u32)MSG_8852B_HEAP_05, "(%d)\t"},
	{(u32)MSG_8852B_INTEGER_01, "%d\n"},
	{(u32)MSG_8852B_STRING_2, "%s\t"},
	{(u32)MSG_8852B_PKTOFLD_RSP_RTY, "pktofld rsp retry\n"},
	{(u32)MSG_8852B_PKTOFLD_RSP_FAIL, "pktofld rsp first fail (%d)\n"},
	{(u32)MSG_8852B_PKTOFLD_NULL, "pktofld mal null and return\n"},
	{(u32)MSG_8852B_PKTOFLD_NULL_RSP, "pktofld rsp mal null and return\n"},
	{(u32)MSG_8852B_PKTOFLD_SEMO_FAIL, "pktofld semaphore fail\n"},
	{(u32)MSG_8852B_PKTOFLD_RET, "pktofld hdl return %d\n"},
	{(u32)MSG_8852B_PS_DTIM_TIMER_OP_FAIL, "[ERR][LPS] Operation(%d) DTIM timer fail!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_BCN_TIMER_OP_FAIL, "[ERR][LPS] Operation(%d) BCN timer fail!! role_idx(%d)\n"},
	{(u32)MSG_8852B_PS_TRX_TIMER_OP_FAIL, "[ERR][LPS] Operation(%d) TRX timer fail!! role_idx(%d)\n"},
	{(u32)MSG_8852B_MCC_CHECKREPLACEGROUP_1, "[MCC][REP] old_group:%d didn't start yet!\n"},
	{(u32)MSG_8852B_MCC_CHECKREPLACEGROUP_2, "[MCC][REP] group %d didn't running, and deleting...\n"},
	{(u32)MSG_8852B_MCC_CHECKREPLACEGROUP_3, "[MCC][REP] update to previous group: %d"},
	{(u32)MSG_8852B_MCC_CHECKREPLACEGROUP_4, "[MCC][REP] previous group:%d is running\n"},
	{(u32)MSG_8852B_MCC_CHECKREPLACEGROUP_5, "[MCC][REP] replace group: %d, stop macid: %d\n"},
	{(u32)MSG_8852B_PS_STATE_SHORTCUT, "=>PsStateShortCut\n"},
	{(u32)MSG_8852B_PS_DEBUG_DUMP_1, "[PS] Dump debug info after 32K\n"},
	{(u32)MSG_8852B_PS_DEBUG_DUMP_2, "[PS] Dump debug info after open RF\n"},
	{(u32)MSG_8852B_PS_DEBUG_DUMP_3, "[PS] Dump debug info after Rx normal mode\n"},
	{(u32)MSG_8852B_PS_DEBUG_DUMP_4, "[PS] Dump debug info before close RF\n"},
	{(u32)MSG_8852B_PROXY_MALLOC_FAIL, "[Proxy] Malloc fail, (ln %d)\n"},
	{(u32)MSG_8852B_PROXY_TX_ENQFAIL, "[Proxy] Enq fail, (ln %d)\n"},
	{(u32)MSG_8852B_PROXY_PKT_NOT_FOUND, "[Proxy] pkt not found, (ln %d)\n"},
	{(u32)MSG_8852B_PROXY_PTCL_DROP_BSSID, "[Proxy][Ptcl] Drop since bssid not match (incoming %x:%x:%x:%x:%x%x)\n"},
	{(u32)MSG_8852B_PROXY_PTCL_MATCH, "[Proxy][Ptcl] Match ipv%d service: %d (ln %d)\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_IPV4, "[Proxy][MDNS] Ipv4Pkt\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_IPV6, "[Proxy][MDNS] Ipv6Pkt\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_A, "[Proxy][MDNS] A rsp\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_AAAA, "[Proxy][MDNS] AAAA rsp\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_PTR, "[Proxy][MDNS] PTR rsp\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_NUMMACHINE, "[Proxy][MDNS] Machine * %d\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_NUMSERV, "[Proxy][MDNS] Serv * %d\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_NO, "[Proxy][MDNS]  #%d\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_SERVNAME, "[Proxy][MDNS]     Name\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_SERVRSP, "[Proxy][MDNS]     SRV rsp\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_SERYTRGT, "[Proxy][MDNS]     Target\n"},
	{(u32)MSG_8852B_PROXY_MDNS_DUMP_SERVTXT, "[Proxy][MDNS]     TXT rsp\n"},
	{(u32)MSG_8852B_PROXY_DUMPBUF, "[Proxy][Buf]       len (%d), addr: %x\n"},
	{(u32)MSG_8852B_PROXY_MDNS_RX_0, "[Proxy][MDNS] Machine (%x), Serv (%x), Target (%x), Type (%x) ==> isMDNS (%d), isMulticast (%d)\n"},
	{(u32)MSG_8852B_PROXY_MDNS_RX_1, "[Proxy][MDNS] Wake\n"},
	{(u32)MSG_8852B_PROXY_MDNS_TX_0, "[Proxy][MDNS] Issuing %d ans\n"},
	{(u32)MSG_8852B_PROXY_MDNS_TX_1, "[Proxy][MDNS] Write compress offset %x at loc %x (ln %d)\n"},
	{(u32)MSG_8852B_PROXY_CFG_VAL_ERR, "[Proxy] Cfg fail (value err), (ln %d)\n"},
	{(u32)MSG_8852B_PROXY_PATTERN_SW_WAKE, "[Proxy][Pattern] SW pattern match wake. Rsn (%x) Isv6 (%d)\n"},
	{(u32)MSG_8852B_MCC_CHANGEROLE_9, "[MCC][Warning] TSF abnormal, cur_tsf = 0x%x, tsf = 0x%x\n"},
	{(u32)MSG_8852B_PS_TRX_TIMEOUT, "=>TRXTimeOut\n"},
	{(u32)MSG_8852B_CSI_H2C_DBG_1, "[CSI] H2C. macid(%d), en(%d), period(%d)\n"},
	{(u32)MSG_8852B_CSI_H2C_DBG_2, "[CSI] H2C. retry_cnt(%d), Tx rate(%d), pkt_num(%d)\n"},
	{(u32)MSG_8852B_CSI_ROLE_NOT_EXIST, "[CSI][ERR] Role does not exist!\n"},
	{(u32)MSG_8852B_CSI_DUPLICATED_CMD, "[CSI][WARN] en(%d) command is duplicated!\n"},
	{(u32)MSG_8852B_CSI_INVALID_PARAM, "[CSI][ERR] Invalid param! en(%d),  period(%d), pkt_num(%d)\n"},
	{(u32)MSG_8852B_CSI_H2C_PKT_DUMP, "[CSI] H2C. Packet index(%d), packet id(%d)\n"},
	{(u32)MSG_8852B_CSI_H2C_PEER_MACID_DUMP, "[CSI] H2C. peer macid index(%d), packet id(%d)\n"},
	{(u32)MSG_8852B_CSI_PERIOD_TX_FAIL, "[CSI][ERR] Start period first Tx fail!\n"},
	{(u32)MSG_8852B_CSI_ADD_PSTIMER_FAIL, "[CSI][ERR] Add ps timer fail! role_idx(%d)\n"},
	{(u32)MSG_8852B_CSI_PREVIOUS_TX_RUNNING, "[CSI][WARN] Previous Tx interval is running\n"},
	{(u32)MSG_8852B_CSI_TX_DATA_FAIL, "[CSI][ERR] Tx DATA fail! ret_type(%d), result(%d)\n"},
	{(u32)MSG_8852B_CSI_READ_PKT_OFFLOAD_FAIL, "[CSI][ERR] Read pkt_idx(%d) fail!\n"},
	{(u32)MSG_8852B_CSI_TX_DATA, "[CSI] Tx DATA. role_idx(%d), pkt_idx(%d)\n"},
	{(u32)MSG_8852B_CSI_TX_DATA_CB, "[CSI] Tx DATA CB. role_idx(%d), pkt_idx(%d), ret_type(%d), result(%d)\n"},
	{(u32)MSG_8852B_CSI_FUNC_DISABLE, "[CSI] CSI is disabled! function(%d) no work\n"},
	{(u32)MSG_8852B_CSI_TX_INVALID_IDX, "[CSI][ERR] Tx with invalid pkt_idx(%d). Offloaded pkt_num(%d)\n"},
	{(u32)MSG_8852B_CSI_PROCESS_TIME, "[CSI][DBG] CSI process time (%d)\n"},
	{(u32)MSG_8852B_CSI_TX_DATA_CB_INVALID_IDX, "[CSI][ERR] Tx CB with invalid pkt_idx(%d). Offloaded pkt_num(%d)\n"},
	{(u32)MSG_8852B_NAN_DW_START_2G_TSF, "[NAN] DW Start 2G Port = 0x%x, free run = 0x%x , tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DW_START_5G_TSF, "[NAN] DW Start 5G Port = 0x%x, free run = 0x%x , tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DW_END_TSF, "[NAN] DW Start END Port = 0x%x, free run = 0x%x , tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DISC_BEACON_START_2G_TSF, "[NAN] Disc Bcn Start 2G Port = 0x%x, free run = 0x%x , tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DISC_BEACON_START_5G_TSF, "[NAN] Disc Bcn Start 5G Port = 0x%x, free run = 0x%x , tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_SDF_START, "[NAN] SDF Start tsf=%x\n"},
	{(u32)MSG_8852B_NAN_BCN_TX_SUCCESS, "[NAN] BCN TX SUCCESS \n"},
	{(u32)MSG_8852B_NAN_BCN_TX_FAIL, "[NAN] BCN TX fail reason:%d \n"},
	{(u32)MSG_8852B_NAN_BCN_TX_TIME, "[NAN] BCN TX time: hi = 0x%x low = 0x%x \n"},
	{(u32)MSG_8852B_NAN_BCN_TX_END, "[NAN] BCN TX success at tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_BCN_TX_EN, "[NAN] BCN TX port = 0x%x\n"},
	{(u32)MSG_8852B_NAN_FUNC_FAIL, "[NAN] FAIL in func: %d, line: %d, ret = %d\n"},
	{(u32)MSG_8852B_NAN_SYNC_BCN_RX, "[NAN] RX NAN SYNC BCN , SN = %d\n"},
	{(u32)MSG_8852B_NAN_SYNC_BCN_RX_TOTAL, "[NAN] RX NAN SYNC BCN Total in a DW , cnt = %d\n"},
	{(u32)MSG_8852B_NAN_DISC_BCN_RX, "[NAN] RX NAN DISC BCN , SN = %d\n"},
	{(u32)MSG_8852B_NAN_BCN_RX_BYPASS, "[NAN] RX NON-NAN BCN \n"},
	{(u32)MSG_8852B_NAN_DISC_BCN_RX_BYPASS, "[NAN] RX DISC BCN BYPASS \n"},
	{(u32)MSG_8852B_NAN_MPORT_SETTING_IN_FW, "[NAN] Setting Mport in FW\n"},
	{(u32)MSG_8852B_NAN_FAW_START, "[NAN] FAW module %d start, freerun = 0x%x ,tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_FAW_END, "[NAN] FAW module %d end, tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_FAW_DELETE, "[NAN] FAW module %d delete\n"},
	{(u32)MSG_8852B_NAN_WARMUP_END, "[NAN] warmup end\n"},
	{(u32)MSG_8852B_NAN_CLIENT_START, "[NAN] Client start, free run = 0x%x, tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_CLIENT_END, "[NAN] Client end, free run = 0x%x, tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_TX_NULL_EARLY, "[NAN] TX Null early, mac_id = %d, free run = 0x%x, tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DW_START_OVER_TIME, "[NAN] DW Start task run over time, duration = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DW_END_OVER_TIME, "[NAN] DW End task run over time, duration = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DISC_START_OVER_TIME, "[NAN] DISC Start task run over time, duration = 0x%x\n"},
	{(u32)MSG_8852B_NAN_CLIENT_START_OVER_TIME, "[NAN] Client Start task run over time, duration = 0x%x\n"},
	{(u32)MSG_8852B_NAN_P2P_START, "[NAN] P2P start, free run = 0x%x, tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_P2P_END, "[NAN] P2P end, free run = 0x%x, tsf = 0x%x\n"},
	{(u32)MSG_8852B_NAN_P2P_START_OVER_TIME, "[NAN] P2P Start task run over time, duration = 0x%x\n"},
	{(u32)MSG_8852B_NAN_FAW_START_OVER_TIME, "[NAN] FAW Start task run over time, duration = 0x%x\n"},
	{(u32)MSG_8852B_NAN_DISC_BEACON_END, "[NAN] Disc Bcn END Port = 0x%x, free run = 0x%x , tsf = 0x%x\n"},
	{(u32)MSG_8852B_MALLOC_17, "%d\t%d\t\t%d\n"},
	{(u32)MSG_8852B_CONSOLE_15, "Index\tAddress\t\tMSID\t\tFunc\tType\tSize(B)\n"},
	{(u32)MSG_8852B_CONSOLE_16, "----------------------------------------------------------------\n"},
	{(u32)MSG_8852B_CONSOLE_17, "MSID\t\tGroup(Func)\t\tCounter\tTotalSize(B)\tHistorical High\n"},
	{(u32)MSG_8852B_CONSOLE_18, "--------------------------------------------------------------------------------\n"},
	{(u32)MSG_8852B_CONSOLE_19, "MSID\t\tCounter\tTotalSize(B)\n"},
	{(u32)MSG_8852B_CONSOLE_20, "----------------------------------------\n"},
	{(u32)MSG_8852B_SCAN_NOT_SUPPORT, "[Scan] Fw not support scanofld\n"},
	{(u32)MSG_8852B_SCAN_HSTCTRL_FAIL_BAND_ERR, "[Scan][Hst] Fail since band %d >= %d\n"},
	{(u32)MSG_8852B_SCAN_HSTCTRL_FAIL_NOT_SCANNING, "[Scan][Hst] Fail since band %d not scanning\n"},
	{(u32)MSG_8852B_SCAN_HSTCTRL_FAIL_CH_NOT_ALIGN, "[Scan][Hst] Fail since band is on ch %d but drv gives %d\n"},
	{(u32)MSG_8852B_SCAN_HSTCTRL_FAIL_CMD_UKN, "[Scan][Hst] Fail since cmd %d unknown\n"},
	{(u32)MSG_8852B_SCAN_ADD_FAIL_BAND_ERR, "[Scan][Add] Fail since band %d >= %d\n"},
	{(u32)MSG_8852B_SCAN_ADD_FAIL_SCANNING, "[Scan][Add] Fail since band %d is scanning\n"},
	{(u32)MSG_8852B_SCAN_ADD_FAIL_SIZE_ERR, "[Scan][Add] Fail since size from drv (%d) is smaller than fw define (%d)\n"},
	{(u32)MSG_8852B_SCAN_ADD_FAIL_NUM_ERR, "[Scan][Add] Fail since numofch is 0\n"},
	{(u32)MSG_8852B_SCAN_ADD_FAIL_MALLOC_FAIL, "[Scan][Add] Fail since malloc fail\n"},
	{(u32)MSG_8852B_SCAN_FAIL_BAND_ERR, "[Scan][Cfg] Fail since band 1 not enabled\n"},
	{(u32)MSG_8852B_SCAN_FAIL_SCANNING, "[Scan][Cfg] Start when scanning, abort\n"},
	{(u32)MSG_8852B_SCAN_FAIL_CHLIST_ERR, "[Scan][Cfg] Ch list empty, abort\n"},
	{(u32)MSG_8852B_SCAN_FAIL_NUMSSID_ERR, "[Scan][Cfg] Too much ssid (%d), abort\n"},
	{(u32)MSG_8852B_SCAN_FAIL_ROLE_ERR, "[Scan][Cfg] Role of (%d, %d) not found, abort\n"},
	{(u32)MSG_8852B_SCAN_ENTER_RX, "[Scan][En][Rx](%d) MAC ofdm(%d,%d,%d) cck(%d,%d,%d) / BB CCA ofdm(0x%x) cck(0x%x), CRC lega(0x%x) cck(0x%x), RXBLK(0x%x)\n"},
	{(u32)MSG_8852B_SCAN_LEAVE_RX, "[Scan][Lv][Rx](%d) MAC ofdm(%d,%d,%d) cck(%d,%d,%d) / BB CCA ofdm(0x%x) cck(0x%x), CRC lega(0x%x) cck(0x%x), RXBLK(0x%x)\n"},
	{(u32)MSG_8852B_SCAN_ENTER_TX, "[Scan][En][Tx](%d) MAC PPDU ofdm(%d) lcck(%d) scck(%d) / BB ofdm(0x%x) cck(0x%x) cck_frm_mac(0x%x) / RF addr0(0x%x)\n"},
	{(u32)MSG_8852B_SCAN_LEAVE_TX, "[Scan][Lv][Tx](%d) MAC PPDU ofdm(%d) lcck(%d) scck(%d) / BB ofdm(0x%x) cck(0x%x) cck_frm_mac(0x%x) / RF addr0(0x%x)\n"},
	{(u32)MSG_8852B_DEF_01, "[DEF] ebw = 0x%x\n"},
	{(u32)MSG_8852B_DEF_02, "[DEF] dbw = 0x%x, mbw = 0x%x, eflag = 0x%x\n"},
	{(u32)MSG_8852B_DEF_03, "[DEF] eptcl = 0x%x, cptcl = 0x%x\n"},
	{(u32)MSG_8852B_DEF_04, "[DEF] band no chk, rfband = 0x%x\n"},
	{(u32)MSG_8852B_STACSA_CH_NOT_FOUND, "[CSA] ch %d not found\n"},
	{(u32)MSG_8852B_STACSA_CH_SUPP_BW, "[CSA] ch %d supported bw %x\n"},
	{(u32)MSG_8852B_STACSA_CSATIMEOUT, "[CSA] pri(%x), cent(%d), bw(%d), ch_band(%d)\n"},
	{(u32)MSG_8852B_STACSA_CHNLSA, "[CSA] CHNLSA ch %d cnt %d\n"},
	{(u32)MSG_8852B_STACSA_2NDCHOFST, "[CSA] SecondChnlOffset offset %d\n"},
	{(u32)MSG_8852B_STACSA_WIDEBWCHSW, "[CSA] WideBwChnlSw width %d seg0 %d seg1 %d\n"},
	{(u32)MSG_8852B_STACSA_WIDEBWCHSW_WRP, "[CSA] WideBwChnlSw(Wrp) width %d seg0 %d seg1 %d\n"},
	{(u32)MSG_8852B_STACSA_HTCAP_20_40, "[CSA] HT cap 20/40\n"},
	{(u32)MSG_8852B_STACSA_HTCAP_SET_40, "[CSA] HT cap set bcn_ch_width to 40\n"},
	{(u32)MSG_8852B_STACSA_HTINFO_ANYBW, "[CSA] HT info allow any chwidth\n"},
	{(u32)MSG_8852B_STACSA_HTINFO_SET_40, "[CSA] HT info set bcn_ch_width to 40\n"},
	{(u32)MSG_8852B_STACSA_HTINFO_SET_UP, "[CSA] HT info set bcn_ch_offset to upper\n"},
	{(u32)MSG_8852B_STACSA_HTINFO_SET_LW, "[CSA] HT info set bcn_ch_offset to lower\n"},
	{(u32)MSG_8852B_STACSA_HTINFO_SET_20, "[CSA] HT info set bcn_ch_offset and width to dont care 20\n"},
	{(u32)MSG_8852B_STACSA_VHTOP_BW, "[CSA] VHTOP set bcn_ch_width to %d\n"},
	{(u32)MSG_8852B_STACSA_CSAIE, "[CSA] CSA IE: ch(%d) csa_ch_width(%d) ofst(%d)\n"},
	{(u32)MSG_8852B_STACSA_CSA_80, "[CSA] CSA IE: bw 80\n"},
	{(u32)MSG_8852B_STACSA_CSA_20, "[CSA] CSA IE: bw 20\n"},
	{(u32)MSG_8852B_STACSA_CSA_40_UP, "[CSA] CSA IE: bw 40 upper\n"},
	{(u32)MSG_8852B_STACSA_CSA_40_LW, "[CSA] CSA IE: bw 40 lower\n"},
	{(u32)MSG_8852B_STACSA_CSA_CH_BAND, "[CSA] CSA IE: ch_band %d\n"},
	{(u32)MSG_8852B_STACSA_CSA_CENT_CH, "[CSA] CSA IE: central_ch %d\n"},
	{(u32)MSG_8852B_STACSA_CSA_FINAL, "[CSA] CSA IE: going to switch to p(%d) c(%d) bw(%d) band(%d)\n"},
	{(u32)MSG_8852B_STACSA_BCN, "[CSA] BCN IE: ori bw (%d) ofst (%d), new bw (%d) ofst (%d)\n"},
	{(u32)MSG_8852B_STACSA_BCN_SWITCH, "[CSA] BCN IE: switch to p(%d) c(%d) bw(%d) band(%d)\n"},
	{(u32)MSG_8852B_STACSA_BROKEN_BCN, "[CSA] Broken bcn\n"},
	{(u32)MSG_8852B_STACSA_CFG_CHLIST_ERR, "[CSA] size(hst, fw) = (%d, %d), chNum(%d)\n"},
	{(u32)MSG_8852B_WOWLAN_MAGIC_WAKER_0, "[MagicWaker] waker num = 0\n"},
	{(u32)MSG_8852B_WOWLAN_MAGIC_WAKER_1, "[MagicWaker] waker num = %d\n"},
	{(u32)MSG_8852B_WOWLAN_MAGIC_WAKER_ADDR_NULL, "[MagicWaker] pMagicWakerParm->MACAddr == NULL\n"},
	{(u32)MSG_8852B_WOWLAN_MAGIC_WAKER_INIT_ERR, "[MagicWaker] pMagicWakerParm == NULL\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_ERR, "[TCPKeepalive] pTCPKeepaliveParm == NULL\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_READ_ERR, "[TCPKeepalive] ReadFWOfldPKT fail\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_IMMED_ERR, "[TCPKeepalive] immediately tx fail\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_NO_ROLE, "[TCPKeepalive] role is not action\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_ENQ_ERR, "[TCPKeepalive] WowCpuMgPktEnQueue fail\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_DISABLE, "[TCPKeepalive] TCP Keepalive is disabled\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_TIMER_0, "[TCPKeepalive] create timer fail\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_TIMER_1, "[TCPKeepalive] start timer fail\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_TIMER_2, "[TCPKeepalive] timer = NULL\n"},
	{(u32)MSG_8852B_WOWLAN_TCP_KEEPALIVE_IMM_FAIL, "[TCPKeepalive] TCP Keepalive immediately tx fail\n"},
	{(u32)MSG_8852B_SPIC_1, "dum_first(%d), dum_last(%d)\n"},
	{(u32)MSG_8852B_SPIC_2, "Update RDTIME[%d]BAUD[%d]IO[%d]CMD[%x]DUM[%d]\n"},
	{(u32)MSG_8852B_SPIC_3, "\nFIANL BAUD[%x]IO[%x]CMD[%x]DUM[%x]\n"},
	{(u32)MSG_8852B_SPIC_4, "FINAL[%x][%x]\n"},
	{(u32)MSG_8852B_SPIC_5, "T1[%x]T2[%x]RDTIME[%x]\n"},
	{(u32)MSG_8852B_SPIC_6, "BAUD[%x]CH[%x]CMD[%x]CYC[%x]\n"},
	{(u32)MSG_8852B_SPIC_7, "SPIC Calibration Fail\n"},
	{(u32)MSG_8852B_SCAN_FAIL_NUMSHORTSSID_ERR, "[Scan][Cfg] Too much shortSsid (%d), abort\n"},
	{(u32)MSG_8852B_SCAN_FAIL_NUMBSSID_ERR, "[Scan][Cfg] Too much bssid (%d), abort\n"},
	{(u32)MSG_8852B_GTK_1, "GTK Rekey Sha256 Fail(%d)\n"},
	{(u32)MSG_8852B_PS_RPWM_IMR_DUMP, "RPWM IMR is not enabled. IMR(0x%x) = 0x%x\n"},
	{(u32)MSG_8852B_WOWLAN_21, "H2C AOAC Report Req fail\n"},
	{(u32)MSG_8852B_WOWLAN_22, "WowCPUIoRxCtrl,en(%d)pull(%d)sus(%d)res(%d)idle(%d)\n"},
	{(u32)MSG_8852B_WOWLAN_23, "WowCPUIoRxCtrl resume polling fw rx idle timeout\n"},
	{(u32)MSG_8852B_H2C2HREG_2, "WowCPUIoRxCtrl fail\n"},
	{(u32)MSG_8852B_H2C2HREG_3, "WowCPUIoRxCtrl success\n"},
	{(u32)MSG_8852B_MCC_SENDNULLCB_4, "[MCC][RPT] Retry DROP => macid (%d)\n"},
	{(u32)MSG_8852B_PS_POWER_LEVEL_1, "[Req_Pwr_Lvl] bcn_to_val = %d, ps_lvl = %d, trx_lvl = %d\n"},
	{(u32)MSG_8852B_PS_POWER_LEVEL_2, "[Req_Pwr_Lvl] BcnTimeOutTime = %d, BcnTimeOutLimit = %d, BcnTOTxNullLimit = %d, TRXTimeOutTime = %d\n"},
	{(u32)MSG_8852B_PS_POWER_LEVEL_ROLE_NOT_FOUND, "[Req_Pwr_Lvl] Role not exist!. macid(%d)\n"},
	{(u32)MSG_8852B_OUTSRC_START, " out source delimiter start"},
	{(u32)MSG_8852B_BTC_0, "_setup_slot  new_ver:%d, ver:%d\n"},
	{(u32)MSG_8852B_BTC_1, "_check_bt_rfk_req(): mbx=%d, result=%d\n"},
	{(u32)MSG_8852B_BTC_2, "_send_offload_runinfo(): type:%d, run_cnt:%d\n"},
	{(u32)MSG_8852B_BTC_3, "_send_bt_info: len = %d\n"},
	{(u32)MSG_8852B_BTC_4, "_get_mbx30_rsp: Length=%x, data0=%x, data1=%x, data2=%x, data3=%x, data4=%x\n"},
	{(u32)MSG_8852B_BTC_5, "seq = %x, reg_val=%x\n"},
	{(u32)MSG_8852B_BTC_6, "_read_mreg\n"},
	{(u32)MSG_8852B_BTC_7, "_send_rpt(): cnt=%d, len=%d, type=%d, map=%x\n"},
	{(u32)MSG_8852B_BTC_8, "_tmr_btrfk(): BT RFK timeout!!\n"},
	{(u32)MSG_8852B_BTC_9, "_tmr_mon\n"},
	{(u32)MSG_8852B_BTC_10, "Aboart BT mailbox\n"},
	{(u32)MSG_8852B_BTC_11, "Mailbox dequeue fail\n"},
	{(u32)MSG_8852B_BTC_12, "_setup_rpt, enable=%x, para=%x, rpt_enable=%x\n"},
	{(u32)MSG_8852B_BTC_13, "_setup_slot->[Slot-%d Policy] dur:%d(modify:%x), tbl:%x, cxtype:%d\n"},
	{(u32)MSG_8852B_BTC_14, "_setup_mreg -> rid: %d, type: %d, byte: %d, offset: %x\n"},
	{(u32)MSG_8852B_BTC_15, "_setup_cxpolicy->[TDMA Policy] type:%d, rxflctrl:%d, txpause:%d, wtgle_n:%d, leak_n:%d, ext_ctrl=%d\n"},
	{(u32)MSG_8852B_BTC_16, "_setup_cxpolicy->[Slot-%d Policy] dur:%d(modify:%x), tbl:%x, cxtype:%d\n"},
	{(u32)MSG_8852B_BTC_17, "_setup_drvinfo(): type:%d, len=%d\n"},
	{(u32)MSG_8852B_BTC_18, "_setup_gpio_dbg(): phdl->gpio_dbg.en_map = %x\n"},
	{(u32)MSG_8852B_BTC_19, "_setup_gpio_dbg(): dbg_signal-%d ==> gpio-%d\n"},
	{(u32)MSG_8852B_BTC_20, "_setup_gpio_dbg(): enable dbg_signal-%d ==> gpio-%d\n"},
	{(u32)MSG_8852B_BTC_21, "_setup_bt: data0=%x, data1=%x, data2=%x, data3=%x\n"},
	{(u32)MSG_8852B_BTC_22, "mailbox enqueue fail\n"},
	{(u32)MSG_8852B_BTC_23, "mailbox: curr abalible bytes: %d\n"},
	{(u32)MSG_8852B_BTC_24, "[BTC], _update_bt_scbd return by invalid scbd value\n"},
	{(u32)MSG_8852B_BTC_25, "[BTC], _update_bt_info \n"},
	{(u32)MSG_8852B_BTC_26, "[BTC], _update_bt_info return by bt-info duplicate!!\n"},
	{(u32)MSG_8852B_BTC_27, "BTCoexMailboxSendComm return because mailbox not-avl (%x)\n"},
	{(u32)MSG_8852B_BTC_28, "BTCoexMailboxDataHDLComm: id = %d\n"},
	{(u32)MSG_8852B_BTC_29, "Recv H2C class: %d\n"},
	{(u32)MSG_8852B_BTC_30, "H2C Process status: %d\n"},
	{(u32)MSG_8852B_BTC_31, "cat: %d, class: %d, func: %d\n"},
	{(u32)MSG_8852B_BTC_32, "Wrong BTC AOAC state"},
	{(u32)MSG_8852B_BTC_33, "_evnt_wltmr: cycle.c_slot = %d!!\n"},
	{(u32)MSG_8852B_BTC_34, "_cx_policy_update\n"},
	{(u32)MSG_8852B_BTC_35, "_btc_gpio\n"},
	{(u32)MSG_8852B_BTC_36, "Coex exception: %x\n"},
	{(u32)MSG_8852B_BTC_37, "_enter: n_slot=%d, bt_relink=%d\n"},
	{(u32)MSG_8852B_BTC_38, "_enter-collision!!: n_slot=%d, last_slot=%d\n"},
	{(u32)MSG_8852B_BTC_39, "skip_cnt=%d\n"},
	{(u32)MSG_8852B_BTC_40, "tdma.type=%d, tdma_new.type=%d, c_slot=%d!!\n"},
	{(u32)MSG_8852B_BTC_41, "wait cycle_w2b to update cxpolicy!!\n"},
	{(u32)MSG_8852B_BTC_42, "BTCoexFCInitComm\n"},
	{(u32)MSG_8852B_BTC_43, "[FAIL] Create Role fail!\n"},
	{(u32)MSG_8852B_BTC_44, "[BTC], _set_bt_wl_ch_info():\n"},
	{(u32)MSG_8852B_BTC_45, "_set_policy(): policy_type:%x\n"},
	{(u32)MSG_8852B_BTC_46, "[BTC], _set_ant(): return by no change!!\n"},
	{(u32)MSG_8852B_BTC_47, "[BTC], _set_ant(): return by bt rfk!!\n"},
	{(u32)MSG_8852B_BTC_48, "[BTC], _set_ant(): return by wl rfk!!\n"},
	{(u32)MSG_8852B_BTC_49, "[BTC], _set_ant(): phy_map=%d, type=%d\n"},
	{(u32)MSG_8852B_BTC_50, "[BTC], _action_wl_only !!\n"},
	{(u32)MSG_8852B_BTC_51, "[BTC], _action_wl_init !!\n"},
	{(u32)MSG_8852B_BTC_52, "[BTC], _action_wl_off !!\n"},
	{(u32)MSG_8852B_BTC_53, "[BTC], _action_freerun !!\n"},
	{(u32)MSG_8852B_BTC_54, "[BTC], _action_bt_whql_test !!\n"},
	{(u32)MSG_8852B_BTC_55, "[BTC], _action_bt_rfk !!\n"},
	{(u32)MSG_8852B_BTC_56, "[BTC], _action_bt_off !!\n"},
	{(u32)MSG_8852B_BTC_57, "[BTC], _action_wl_5g !!\n"},
	{(u32)MSG_8852B_BTC_58, "[BTC], _action_wl_other !!\n"},
	{(u32)MSG_8852B_BTC_59, "[BTC], _action_wl_idle !!\n"},
	{(u32)MSG_8852B_BTC_60, "[BTC], _action_wl_nc !!\n"},
	{(u32)MSG_8852B_BTC_61, "[BTC], _action_wl_rfk !!\n"},
	{(u32)MSG_8852B_BTC_62, "[BTC], _set_action_by_bt !!\n"},
	{(u32)MSG_8852B_BTC_63, "[BTC], _run_coex(): run_reason = %s\n"},
	{(u32)MSG_8852B_BTC_64, "[BTC], _run_coex(): return for Manual CTRL!!\n"},
	{(u32)MSG_8852B_BTC_65, "[BTC], _run_coex(): return for Stop Coex DM!!\n"},
	{(u32)MSG_8852B_BTC_66, "[BTC], _run_coex(): return for WL init fail!!\n"},
	{(u32)MSG_8852B_BTC_67, "[BTC], _set_bt_tx_power(): level = %d\n"},
	{(u32)MSG_8852B_BTC_68, "[BTC], _set_bt_rx_gain(): level = %d\n"},
	{(u32)MSG_8852B_BTC_69, "[BTC], _set_bt_golden_rx_range(): p_id=%d, level=%d\n"},
	{(u32)MSG_8852B_TxEn, "[TxEn] rcode: %d, band: %d, tx_en: %x, tx_en_mask: %x, state: %x -> %x\n"},
	{(u32)MSG_8852B_MACIDPAUSE_AP_0, "[MACIDPAUSE] rcode: %d, pause_en: %x%x%x%x, pause_en_mask: %x%x%x%x\n"},
	{(u32)MSG_8852B_MACIDPAUSE_AP_1, "[MACIDPAUSE] original MACIDPauseFWInfo: %x%x%x%x\n"},
	{(u32)MSG_8852B_MACIDPAUSE_AP_2, "[MACIDPAUSE] MACIDPauseFWInfo: %x%x%x%x, MACIDPauseDRVInfo: %x%x%x%x, MACIDSleepFWInfo: %x%x%x%x\n"},
	{(u32)MSG_8852B_MACIDPAUSE_NIC, "[MACIDPAUSE] rcode: %d, pause_en: %x, pause_en_mask: %x, MACIDPauseFWInfo: %x -> %x, MACIDPauseDRVInfo: %x, MACIDSleepFWInfo: %x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_0, "[RA]RateChange=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_1, "[RA]RDth=0x%x,RUth=0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_2, "[RA]r4=100\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_3, "[RA]ForceRD\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_4, "[RA]RDCnt=0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_5, "[RA]RUCnt=0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_6, "[RA]RS\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_7, "[RA]SGIRD\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_8, "[RA]BWRD\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_9, "[RA]RDToLowest1\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_10, "[RA]RDToLowest2\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_11, "[RA]RD:crate=0x%x,mrate0=0x%x,mrate1=0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_12, "[RA]rate=0x%x,bw:0x%x,rate2=0x%x,bw2:0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_13, "[RA]Hit:bw=0x%x->0x%x,rate=0x%x->0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_14, "[RA]SR:rate0=0x%x,rate1=0x%x,rate2=0x%x,cnt=0x%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_15, "[RA]init_rate_up:id:%d,try_num=%d,agg=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_16, "[RA]SGIRU\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_17, "[RA]BWRU\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_18, "[RA]RUbw++\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_19, "[RA]RUToHighest\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_20, "[RA]NoUpRate\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_21, "[RA]RU:crate=%x,mrate0=%x,mrate1=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_22, "[RA,W]macid:%x,mode:%x,bw_idx:%x,mcs:%x,ss:%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_23, "[RA][TRY]PER=%x,RDR=%x,R4=%x, pre_tp=%d, next_tp=%d\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_24, "RSVD\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_25, "[RA][TRY]rate=%x,sta->up_fail_limit_rate[0]=%x,sta->up_fail_limit_rate[1]=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_26, "[RA]TryFail\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_27, "[RA]TrySuccess\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_28, "[RA]MtTryIdx=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_29, "[RA]TryFailCnt=%x,rate=%x,bw=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_30, "[RA]DrvFixRate\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_31, "[RA]POLLUTED\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_32, "[RA]Tot=0\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_33, "[RA]Tx=0,Tot:%x,Ok:%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_34, "[RA]StaNull\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_35, "[RA]NoHESU\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_36, "[RA]WDNoRelease\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_37, "[RA]TxRptTot=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_38, "[RA]Ovfl\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_39, "[RSSI]bcn{a,b}={%d,%d},data_rssi{a,b}={%d,%d}\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_40, "RSVD\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_41, "[RA]GetTxSta:id:%d,try_num=%d,agg=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_42, "[RA]1 chk_rate_up_lmt return: r_idx = %x, c_mcs = %x >= l_mcs = %x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_43, "[RA]PER=%x,RDR=%x,r4=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_44, "[RA]2 chk_rate_up_lmt return: r_idx = %x, c_mcs = %x >= l_mcs = %x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_45, "[RA]3 chk_rate_up_lmt OK: r_idx = %x, c_mcs = %x >= l_mcs = %x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_46, "[RA]rate_changed=%x @ rate_check_for_update\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_47, "[RA]chk rate exist: rate_idx=%x->%x (%x,%x,%x)\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_48, "[RA]chk_rate_up_lmt=%x,sta->up_fail_limit_rate[0]=%x,sta->up_fail_limit_rate[1]=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_49, "[RA]r_idx = %x => per_ma = %x, per_var == %x, decision_offset_n=%x, decision_offset_p=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_50, "[RA]UpFailLimitCnt:%x,m_rtae_up_fail_cnt_lmt:%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_51, "[RA][txrpt]Txcnt=%x, Try=%x, total=%x, OK=%x, Initrate,Giltf=%x,%x, Finalrate,Giltf=%x,%x, BW=%x,wd_not_released=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_52, "[RA][TBTT]ID=%x,Media:%x,Tot=%x,Ok=%x,OK=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_53, "[RA][TBTT][FWfixrate]ID=%x,Media:%x,Tot=%x,Ok=%x,a-OK%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_54, "[RA]Sgi_pending_cnt = %x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_55, "[RA][SGI]New rate = %x, Old gi = %x, New gi = %x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_56, "[RA][H2C]Mode_sel=%x, gi_ltf=%x, dcm_cap=%x, er_cap=%x, init_rate_lv=%x, ldpc_cap=%x, stbc_cap=%x, arfr_ctrl=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_57, "[RA][H2C]Initial_BW=%x, max_ss_support=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_58, "[RA][H2C]Ra_mask0=%x, ra_mask1=%x, highest_rate=%x, max_start_rate=%x, lowest_rate=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_59, "[RA][H2C]Initrate: rateidx=%x, mode=%x, gi_ltf=%x, bw_idx=%x\n"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_60, "[LPS][After32K]OFDM_CCA=%d, CCK_CCA=%d, OFDM_OK=%d, CCK_OK=%d, OFDM_ERR=%d, CCK_ERR=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_61, "[LPS][OpenRF]OFDM_CCA=%d, CCK_CCA=%d, OFDM_OK=%d, CCK_OK=%d, OFDM_ERR=%d, CCK_ERR=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_62, "[LPS][NORMAL]OFDM_CCA=%d, CCK_CCA=%d, OFDM_OK=%d, CCK_OK=%d, OFDM_ERR=%d, CCK_ERR=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_63, "[LPS][After32K]Rx_path=%d, rssi_a=%d, rssi_b=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_64, "[LPS][OpenRF]Rx_path=%d, rssi_a=%d, rssi_b=%d, tx_path_dec=%d,tx_path_udp=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_65, "[LPS][NORMAL]Rx_path=%d, rssi_a=%d, rssi_b=%d,0x4860=%x, tx_path_dec=%d, tx_path_udp=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_66, "[LPS][CloseRF]OFDM_CCA=%d, CCK_CCA=%d, OFDM_OK=%d, CCK_OK=%d, OFDM_ERR=%d, CCK_ERR=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_67, "[LPS][CloseRF]Rx_path=%d, rssi_a=%d, rssi_b=%d,0x4860=%x"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_68, "[LPS][After32K]OFDM_TxEN=%d, OFDM_TxON=%d, CCK_TxEn=%d, CCK_TxON=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_69, "[LPS][OpenRF]OFDM_TxEN=%d, OFDM_TxON=%d, CCK_TxEn=%d, CCK_TxON=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_70, "[LPS][NORMAL]OFDM_TxEN=%d, OFDM_TxON=%d, CCK_TxEn=%d, CCK_TxON=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_71, "[LPS][CloseRF]OFDM_TxEN=%d, OFDM_TxON=%d, CCK_TxEn=%d, CCK_TxON=%d, tx_path_dec=%d, tx_path_udp=%d"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_72, "[LPS][After32K]0x12ac=%x, 0x12b0=%x, 0x12b8=%x, 0x32ac=%x, 0x32b0=%x, 0x32b8=%x, 0x35c=%x, 0x700=%x, tx_path_udp=%x"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_73, "[LPS][OpenRF]0x12ac=%x, 0x12b0=%x, 0x12b8=%x, 0x32ac=%x, 0x32b0=%x, 0x32b8=%x, 0x35c=%x, 0x700=%x"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_74, "[LPS][NORMAL]0x12ac=%x, 0x12b0=%x, 0x12b8=%x, 0x32ac=%x, 0x32b0=%x, 0x32b8=%x, 0x35c=%x, 0x700=%x"},
	{(u32)MSG_8852B_OUTSRC_BB_SURA_75, "[LPS][CloseRF]0x12ac=%x, 0x12b0=%x, 0x12b8=%x, 0x32ac=%x, 0x32b0=%x, 0x32b8=%x, 0x35c=%x, 0x700=%x"},
	{(u32)MSG_8852B_OUTSRC_END, " out source delimiter end"},
	{(u32)MSG_8852B_WDT_DETECT_START_OK, "start_ok\n"},
	{(u32)MSG_8852B_BACKTRACE_19, "possible RA = 0x%x\n"},
	{(u32)MSG_8852B_LAST, "Please add your log above."},
};
