/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef _MAC_BE_SER_AUTO_GEN_8852B_H_
#define _MAC_BE_SER_AUTO_GEN_8852B_H_

#include "../../../../mac_ax/trxcfg.h"
#include "../../../../mac_ax/fwofld.h"
#if MAC_AX_8852B_SUPPORT

// svn reversion
#define SER_IMR_REV_8852B 29242

#define IMR_IO_OFLD_NON_FLUSH	0

#define SER_ENABLE 0XFFFFFFFF
#define SER_DISABLE 0X00000000

/* cmac_dma_top 0x1860c800 R_AX_DLE_CTRL  */
/* cmac_dma_top 0x1860e800 R_AX_DLE_CTRL_C1  */
#define CMAC_DMA_TOP_IMR0_MSK_8852B 0x80c000
#define CMAC_DMA_TOP_IMR0_SET_8852B 0xc000
// Enable Bit, B_AX_rxsts_fsm_hang_error_imr, B_AX_RXSTS_FSM_HANG_ERROR_IMR
#define CMAC_DMA_TOP_IMR0_BIT14_8852B_EN SER_ENABLE
// Enable Bit, B_AX_rxdata_fsm_hang_error_imr, B_AX_RXDATA_FSM_HANG_ERROR_IMR
#define CMAC_DMA_TOP_IMR0_BIT15_8852B_EN SER_ENABLE
// Enable Bit, B_AX_no_Reserve_page_err_imr, B_AX_NO_RESERVE_PAGE_ERR_IMR
#define CMAC_DMA_TOP_IMR0_BIT23_8852B_EN SER_DISABLE
/* ptcltop 0x1860c6c0 R_AX_PTCL_IMR0  */
/* ptcltop 0x1860e6c0 R_AX_PTCL_IMR0_C1  */
#define PTCLTOP_IMR0_MSK_8852B 0xff80df01
#define PTCLTOP_IMR0_SET_8852B 0x10800001
// Enable Bit, fsm_timeout_err_imr, B_AX_FSM_TIMEOUT_ERR
#define PTCLTOP_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, F2PCMDRPT_FULL_DROP_ERR_IMR, B_AX_F2PCMDRPT_FULL_DROP_ERR
#define PTCLTOP_IMR0_BIT8_8852B_EN SER_DISABLE
// Enable Bit, TXPRT_FULL_DROP_ERR_IMR, B_AX_TXPRT_FULL_DROP_ERR
#define PTCLTOP_IMR0_BIT9_8852B_EN SER_DISABLE
// Enable Bit, D_PKTID_ERR_IMR, B_AX_D_PKTID_ERR
#define PTCLTOP_IMR0_BIT10_8852B_EN SER_DISABLE
// Enable Bit, Q_PKTID_ERR_IMR, B_AX_Q_PKTID_ERR
#define PTCLTOP_IMR0_BIT11_8852B_EN SER_DISABLE
// Enable Bit, BCNQ_ORDER_ERR_IMR, B_AX_BCNQ_ORDER_ERR
#define PTCLTOP_IMR0_BIT12_8852B_EN SER_DISABLE
// Enable Bit, TWTSP_QSEL_ERR_IMR, B_AX_TWTSP_QSEL_ERR
#define PTCLTOP_IMR0_BIT14_8852B_EN SER_DISABLE
// Enable Bit, F2PCMD_EMPTY_ERR_IMR, B_AX_F2PCMD_EMPTY_ERR
#define PTCLTOP_IMR0_BIT15_8852B_EN SER_DISABLE
// Enable Bit, TX_RECORD_PKTID_ERR_IMR, B_AX_TX_RECORD_PKTID_ERR
#define PTCLTOP_IMR0_BIT23_8852B_EN SER_ENABLE
// Enable Bit, TX_SPF_U3_PKTID_ERR_IMR, B_AX_TX_SPF_U3_PKTID_ERR
#define PTCLTOP_IMR0_BIT24_8852B_EN SER_DISABLE
// Enable Bit, TX_SPF_U2_PKTID_ERR_IMR, B_AX_TX_SPF_U2_PKTID_ERR
#define PTCLTOP_IMR0_BIT25_8852B_EN SER_DISABLE
// Enable Bit, TX_SPF_U1_PKTID_ERR_IMR, B_AX_TX_SPF_U1_PKTID_ERR
#define PTCLTOP_IMR0_BIT26_8852B_EN SER_DISABLE
// Enable Bit, RX_SPF_U0_PKTID_ERR_IMR, B_AX_RX_SPF_U0_PKTID_ERR
#define PTCLTOP_IMR0_BIT27_8852B_EN SER_DISABLE
// Enable Bit, F2PCMD_USER_ALLC_ERR_IMR, B_AX_F2PCMD_USER_ALLC_ERR
#define PTCLTOP_IMR0_BIT28_8852B_EN SER_ENABLE
// Enable Bit, F2PCMD_ASSIGN_PKTID_ERR_IMR, B_AX_F2PCMD_ASSIGN_PKTID_ERR
#define PTCLTOP_IMR0_BIT29_8852B_EN SER_DISABLE
// Enable Bit, F2PCMD_RD_PKTID_ERR_IMR, B_AX_F2PCMD_RD_PKTID_ERR
#define PTCLTOP_IMR0_BIT30_8852B_EN SER_DISABLE
// Enable Bit, F2PCMD_PKTID_ERR_IMR, B_AX_F2PCMD_PKTID_ERR
#define PTCLTOP_IMR0_BIT31_8852B_EN SER_DISABLE
/* schedulertop 0x1860c3e8 R_AX_SCHEDULE_ERR_IMR  */
/* schedulertop 0x1860e3e8 R_AX_SCHEDULE_ERR_IMR_C1  */
#define SCHEDULERTOP_IMR0_MSK_8852B 0x3
#define SCHEDULERTOP_IMR0_SET_8852B 0x1
// Enable Bit, fsm_timeout_err_imr, B_AX_FSM_TIMEOUT_ERR_INT
#define SCHEDULERTOP_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, sort_non_idle_err_imr, B_AX_SORT_NON_IDLE_ERR_INT
#define SCHEDULERTOP_IMR0_BIT1_8852B_EN SER_DISABLE
/* phyintf 0x1860ccfc R_AX_PHYINFO_ERR_IMR  */
/* phyintf 0x1860ecfc R_AX_PHYINFO_ERR_IMR_C1  */
#define PHYINTF_IMR0_MSK_8852B 0x3f0000
#define PHYINTF_IMR0_SET_8852B 0x10000
// Enable Bit, B_AX_PHY_TXON_TIMEOUT_INT_EN, B_AX_PHY_TXON_TIMEOUT_INT_EN
#define PHYINTF_IMR0_BIT16_8852B_EN SER_ENABLE
// Enable Bit, B_AX_CCK_CCA_TIMEOUT_INT_EN, B_AX_CCK_CCA_TIMEOUT_INT_EN
#define PHYINTF_IMR0_BIT17_8852B_EN SER_DISABLE
// Enable Bit, B_AX_OFDM_CCA_TIMEOUT_INT_EN, B_AX_OFDM_CCA_TIMEOUT_INT_EN
#define PHYINTF_IMR0_BIT18_8852B_EN SER_DISABLE
// Enable Bit, B_AX_DATA_ON_TIMEOUT_INT_EN, B_AX_DATA_ON_TIMEOUT_INT_EN
#define PHYINTF_IMR0_BIT19_8852B_EN SER_DISABLE
// Enable Bit, B_AX_STS_ON_TIMEOUT_INT_EN, B_AX_STS_ON_TIMEOUT_INT_EN
#define PHYINTF_IMR0_BIT20_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CSI_ON_TIMEOUT_INT_EN, B_AX_CSI_ON_TIMEOUT_INT_EN
#define PHYINTF_IMR0_BIT21_8852B_EN SER_DISABLE
/* rmac 0x1860cef4 R_AX_RMAC_ERR_ISR  */
/* rmac 0x1860eef4 R_AX_RMAC_ERR_ISR_C1  */
#define RMAC_IMR0_MSK_8852B 0xff000
#define RMAC_IMR0_SET_8852B 0xe4000
// Enable Bit, B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_INT_EN, B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT12_8852B_EN SER_DISABLE
// Enable Bit, B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_INT_EN, B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT13_8852B_EN SER_DISABLE
// Enable Bit, B_AX_RMAC_DMA_TIMEOUT_INT_EN, B_AX_RMAC_DMA_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT14_8852B_EN SER_ENABLE
// Enable Bit, B_AX_RMAC_CCA_TIMEOUT_INT_EN, B_AX_RMAC_CCA_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT15_8852B_EN SER_DISABLE
// Enable Bit, B_AX_RMAC_DATA_ON_TIMEOUT_INT_EN, B_AX_RMAC_DATA_ON_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT16_8852B_EN SER_DISABLE
// Enable Bit, B_AX_RMAC_CSI_TIMEOUT_INT_EN, B_AX_RMAC_CSI_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT17_8852B_EN SER_ENABLE
// Enable Bit, B_AX_RMAC_RX_TIMEOUT_INT_EN, B_AX_RMAC_RX_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT18_8852B_EN SER_ENABLE
// Enable Bit, B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN, B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN
#define RMAC_IMR0_BIT19_8852B_EN SER_ENABLE
/* tmac 0x1860ccec R_AX_TMAC_ERR_IMR_ISR  */
/* tmac 0x1860ecec R_AX_TMAC_ERR_IMR_ISR_C1  */
#define TMAC_IMR0_MSK_8852B 0x780
#define TMAC_IMR0_SET_8852B 0x780
// Enable Bit, B_AX_TMAC_MACTX_INT_EN, B_AX_TMAC_MACTX_INT_EN
#define TMAC_IMR0_BIT7_8852B_EN SER_ENABLE
// Enable Bit, B_AX_TMAC_TXCTL_INT_EN, B_AX_TMAC_TXCTL_INT_EN
#define TMAC_IMR0_BIT8_8852B_EN SER_ENABLE
// Enable Bit, B_AX_TMAC_RESP_INT_EN, B_AX_TMAC_RESP_INT_EN
#define TMAC_IMR0_BIT9_8852B_EN SER_ENABLE
// Enable Bit, B_AX_TMAC_TXPLCP_INT_EN, B_AX_TMAC_TXPLCP_INT_EN
#define TMAC_IMR0_BIT10_8852B_EN SER_ENABLE
/* wdrls 0x18609430 R_AX_WDRLS_ERR_IMR  */
#define WDRLS_IMR0_MSK_8852B 0x3337
#define WDRLS_IMR0_SET_8852B 0x3327
// Enable Bit, r_IMR_ERR_CTL_WDPKTID_ISNULL, B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR
#define WDRLS_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_CTL_PLPKTID_ISNULL, B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR
#define WDRLS_IMR0_BIT1_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_CTL_FRZTO, B_AX_WDRLS_CTL_FRZTO_ERR
#define WDRLS_IMR0_BIT2_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_PLEBREQ_TO, B_AX_WDRLS_PLEBREQ_TO_ERR
#define WDRLS_IMR0_BIT4_8852B_EN SER_DISABLE
// Enable Bit, r_IMR_ERR_PLEBREQ_PKTID_ISNULL, B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR
#define WDRLS_IMR0_BIT5_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_RPT0_AGGNUM0, B_AX_WDRLS_RPT0_AGGNUM0_ERR
#define WDRLS_IMR0_BIT8_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_RPT0_FRZTO, B_AX_WDRLS_RPT0_FRZTO_ERR
#define WDRLS_IMR0_BIT9_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_RPT1_AGGNUM0, B_AX_WDRLS_RPT1_AGGNUM_ERR
#define WDRLS_IMR0_BIT12_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_RPT1_FRZTO, B_AX_WDRLS_RPT1_FRZTO_ERR
#define WDRLS_IMR0_BIT13_8852B_EN SER_ENABLE
/* WSEC 0x18609d1c R_AX_SEC_DEBUG  */
#define WSEC_IMR0_MSK_8852B 0x8
#define WSEC_IMR0_SET_8852B 0x8
// Enable Bit, B_AX_IMR_ERROR, B_AX_IMR_ERROR
#define WSEC_IMR0_BIT3_8852B_EN SER_ENABLE
/* MPDU TX Processor 0x18609bf4 R_AX_MPDU_TX_ERR_IMR  */
#define MPDU_TX_PROCESSOR_IMR0_MSK_8852B 0x3e
#define MPDU_TX_PROCESSOR_IMR0_SET_8852B 0x0
// Enable Bit, B_AX_TX_GET_ERRPKTID_INT_EN, B_AX_TX_GET_ERRPKTID_ERR
#define MPDU_TX_PROCESSOR_IMR0_BIT1_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TX_NXT_ERRPKTID_INT_EN, B_AX_TX_NXT_ERRPKTID_ERR
#define MPDU_TX_PROCESSOR_IMR0_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TX_MPDU_SIZE_ZERO_INT_EN, B_AX_TX_MPDU_SIZE_ZERO_ERR
#define MPDU_TX_PROCESSOR_IMR0_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TX_OFFSET_ERR_INT_EN, B_AX_TX_OFFSET_ERR
#define MPDU_TX_PROCESSOR_IMR0_BIT4_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TX_HDR3_SIZE_ERR_INT_EN, B_AX_TX_HDR3_SIZE_ERR
#define MPDU_TX_PROCESSOR_IMR0_BIT5_8852B_EN SER_DISABLE
/* MPDU RX Processor 0x18609cf4 R_AX_MPDU_RX_ERR_IMR  */
#define MPDU_RX_PROCESSOR_IMR0_MSK_8852B 0xb
#define MPDU_RX_PROCESSOR_IMR0_SET_8852B 0x0
// Enable Bit, get null packet ID IMR, B_AX_GETPKTID_ERR_ISR
#define MPDU_RX_PROCESSOR_IMR0_BIT0_8852B_EN SER_DISABLE
// Enable Bit, RX_MHDRLEN_ERR_IMR, B_AX_MHDRLEN_ERR_ISR
#define MPDU_RX_PROCESSOR_IMR0_BIT1_8852B_EN SER_DISABLE
// Enable Bit, AX_RPT_ERR_IMR, B_AX_RPT_ERR_ISR
#define MPDU_RX_PROCESSOR_IMR0_BIT3_8852B_EN SER_DISABLE
/* STA scheduler 0x18609ef0 R_AX_STA_SCHEDULER_ERR_IMR  */
#define STA_SCHEDULER_IMR0_MSK_8852B 0x7
#define STA_SCHEDULER_IMR0_SET_8852B 0x7
// Enable Bit, search hang timeout IMR, B_AX_SEARCH_HANG_TIMEOUT_ISR
#define STA_SCHEDULER_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, report hang timeout IMR, B_AX_RPT_HANG_TIMEOUT_ISR
#define STA_SCHEDULER_IMR0_BIT1_8852B_EN SER_ENABLE
// Enable Bit, ple_b_pktid_err_IMR, B_AX_PLE_B_PKTID_ERR_ISR
#define STA_SCHEDULER_IMR0_BIT2_8852B_EN SER_ENABLE
/* txpktctl 0x18609f1c R_AX_TXPKTCTL_ERR_IMR_ISR  */
#define TXPKTCTL_IMR0_MSK_8852B 0x30f
#define TXPKTCTL_IMR0_SET_8852B 0x101
// Enable Bit, B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN, None
#define TXPKTCTL_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN, None
#define TXPKTCTL_IMR0_BIT1_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN, None
#define TXPKTCTL_IMR0_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN, None
#define TXPKTCTL_IMR0_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN, None
#define TXPKTCTL_IMR0_BIT8_8852B_EN SER_ENABLE
// Enable Bit, B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN, None
#define TXPKTCTL_IMR0_BIT9_8852B_EN SER_DISABLE
/* txpktctl 0x18609f2c R_AX_TXPKTCTL_ERR_IMR_ISR_B1  */
#define TXPKTCTL_IMR1_MSK_8852B 0x30f
#define TXPKTCTL_IMR1_SET_8852B 0x303
// Enable Bit, B1_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN, None
#define TXPKTCTL_IMR1_BIT0_8852B_EN SER_ENABLE
// Enable Bit, B1_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN, None
#define TXPKTCTL_IMR1_BIT1_8852B_EN SER_ENABLE
// Enable Bit, B1_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN, None
#define TXPKTCTL_IMR1_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B1_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN, None
#define TXPKTCTL_IMR1_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B1_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN, None
#define TXPKTCTL_IMR1_BIT8_8852B_EN SER_ENABLE
// Enable Bit, B1_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN, None
#define TXPKTCTL_IMR1_BIT9_8852B_EN SER_ENABLE
/* wde_dle 0x18608c38 R_AX_WDE_ERR_IMR  */
#define WDE_DLE_IMR0_MSK_8852B 0x7f0ff0ff
#define WDE_DLE_IMR0_SET_8852B 0x3f0ff0ff
// Enable Bit, r_IMR_ERR_BUFMGN_REQ_QTAID, B_AX_WDE_BUFREQ_QTAID_ERR
#define WDE_DLE_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_REQ_UNAVAL, B_AX_WDE_BUFREQ_UNAVAL_ERR
#define WDE_DLE_IMR0_BIT1_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_RTN_INVLD, B_AX_WDE_BUFRTN_INVLD_PKTID_ERR
#define WDE_DLE_IMR0_BIT2_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_RTN_SIZE_ERR, B_AX_WDE_BUFRTN_SIZE_ERR
#define WDE_DLE_IMR0_BIT3_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_REQ_SRCHTAILPG_ERR, B_AX_WDE_BUFREQ_SRCHTAILPG_ERR
#define WDE_DLE_IMR0_BIT4_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_GETNPG_STRPG_ERR, B_AX_WDE_GETNPG_STRPG_ERR
#define WDE_DLE_IMR0_BIT5_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_GETNPG_PGOFST_ERR, B_AX_WDE_GETNPG_PGOFST_ERR
#define WDE_DLE_IMR0_BIT6_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_FRZTO_ERR, B_AX_WDE_BUFMGN_FRZTO_ERR
#define WDE_DLE_IMR0_BIT7_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_CMDTYPE, B_AX_WDE_QUE_CMDTYPE_ERR
#define WDE_DLE_IMR0_BIT12_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_DSTQINFO, B_AX_WDE_QUE_DSTQUEID_ERR
#define WDE_DLE_IMR0_BIT13_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_SRCQINFO, B_AX_WDE_QUE_SRCQUEID_ERR
#define WDE_DLE_IMR0_BIT14_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_PKTCNT_OVRFLW, B_AX_WDE_ENQ_PKTCNT_OVRF_ERR
#define WDE_DLE_IMR0_BIT15_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_PKTCNT_NEGVAL, B_AX_WDE_ENQ_PKTCNT_NVAL_ERR
#define WDE_DLE_IMR0_BIT16_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_PREPKTLLT_AD, B_AX_WDE_PREPKTLLT_AD_ERR
#define WDE_DLE_IMR0_BIT17_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_NXTPKTLL_AD, B_AX_WDE_NXTPKTLL_AD_ERR
#define WDE_DLE_IMR0_BIT18_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_FRZTO, B_AX_WDE_QUEMGN_FRZTO_ERR
#define WDE_DLE_IMR0_BIT19_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_ARBT, B_AX_WDE_DATCHN_ARBT_ERR
#define WDE_DLE_IMR0_BIT24_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_NULLPG, B_AX_WDE_DATCHN_NULLPG_ERR
#define WDE_DLE_IMR0_BIT25_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_FRZTO, B_AX_WDE_DATCHN_FRZTO_ERR
#define WDE_DLE_IMR0_BIT26_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_RRDY, B_AX_WDE_DATCHN_RRDY_ERR
#define WDE_DLE_IMR0_BIT27_8852B_EN SER_ENABLE
// Enable Bit, B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN, None
#define WDE_DLE_IMR0_BIT28_8852B_EN SER_ENABLE
// Enable Bit, B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN, None
#define WDE_DLE_IMR0_BIT29_8852B_EN SER_ENABLE
// Enable Bit, B_AX_WDE_DATCHN_UAPG_ERR_INT_EN, None
#define WDE_DLE_IMR0_BIT30_8852B_EN SER_DISABLE
/* ple_dle 0x18609038 R_AX_PLE_ERR_IMR  */
#define PLE_DLE_IMR0_MSK_8852B 0xf0ff0ff
#define PLE_DLE_IMR0_SET_8852B 0xf0ff0df
// Enable Bit, r_IMR_ERR_BUFMGN_REQ_QTAID, B_AX_PLE_BUFREQ_QTAID_ERR
#define PLE_DLE_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_REQ_UNAVAL, B_AX_PLE_BUFREQ_UNAVAL_ERR
#define PLE_DLE_IMR0_BIT1_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_RTN_INVLD, B_AX_PLE_BUFRTN_INVLD_PKTID_ERR
#define PLE_DLE_IMR0_BIT2_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_RTN_SIZE_ERR, B_AX_PLE_BUFRTN_SIZE_ERR
#define PLE_DLE_IMR0_BIT3_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_REQ_SRCHTAILPG_ERR, B_AX_PLE_BUFREQ_SRCHTAILPG_ERR
#define PLE_DLE_IMR0_BIT4_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_GETNPG_STRPG_ERR, B_AX_PLE_GETNPG_STRPG_ERR
#define PLE_DLE_IMR0_BIT5_8852B_EN SER_DISABLE
// Enable Bit, r_IMR_ERR_BUFMGN_GETNPG_PGOFST_ERR, B_AX_PLE_GETNPG_PGOFST_ERR
#define PLE_DLE_IMR0_BIT6_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_BUFMGN_FRZTO_ERR, B_AX_PLE_BUFMGN_FRZTO_ERR
#define PLE_DLE_IMR0_BIT7_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_CMDTYPE, B_AX_PLE_QUE_CMDTYPE_ERR
#define PLE_DLE_IMR0_BIT12_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_DSTQINFO, B_AX_PLE_QUE_DSTQUEID_ERR
#define PLE_DLE_IMR0_BIT13_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_SRCQINFO, B_AX_PLE_QUE_SRCQUEID_ERR
#define PLE_DLE_IMR0_BIT14_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_PKTCNT_OVRFLW, B_AX_PLE_ENQ_PKTCNT_OVRF_ERR
#define PLE_DLE_IMR0_BIT15_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_PKTCNT_NEGVAL, B_AX_PLE_ENQ_PKTCNT_NVAL_ERR
#define PLE_DLE_IMR0_BIT16_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_PREPKTLLT_AD, B_AX_PLE_PREPKTLLT_AD_ERR
#define PLE_DLE_IMR0_BIT17_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_NXTPKTLL_AD, B_AX_PLE_NXTPKTLL_AD_ERR
#define PLE_DLE_IMR0_BIT18_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_QUEMGN_FRZTO, B_AX_PLE_QUEMGN_FRZTO_ERR
#define PLE_DLE_IMR0_BIT19_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_ARBT, B_AX_PLE_DATCHN_ARBT_ERR
#define PLE_DLE_IMR0_BIT24_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_NULLPG, B_AX_PLE_DATCHN_NULLPG_ERR
#define PLE_DLE_IMR0_BIT25_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_FRZTO, B_AX_PLE_DATCHN_FRZTO_ERR
#define PLE_DLE_IMR0_BIT26_8852B_EN SER_ENABLE
// Enable Bit, r_IMR_ERR_DATCHN_RRDY, B_AX_PLE_DATCHN_RRDY_ERR
#define PLE_DLE_IMR0_BIT27_8852B_EN SER_ENABLE
/* PKTIN 0x18609a20 R_AX_PKTIN_ERR_IMR  */
#define PKTIN_IMR0_MSK_8852B 0x1
#define PKTIN_IMR0_SET_8852B 0x1
// Enable Bit,  get null pktid IMR, B_AX_PKTIN_GETPKTID_ERR_INT
#define PKTIN_IMR0_BIT0_8852B_EN SER_ENABLE
/* Host Dispatcher 0x18608850 R_AX_HOST_DISPATCHER_ERR_IMR  */
#define HOST_DISPATCHER_IMR0_MSK_8852B 0xff0fffff
#define HOST_DISPATCHER_IMR0_SET_8852B 0xcc000161
// Enable Bit, B_AX_HDT_CHANNEL_DIFF_ERR_IMR, B_AX_HDT_CHANNEL_DIFF_ERR
#define HOST_DISPATCHER_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_CHANNEL_ID_ERR_IMR, B_AX_HDT_CHANNEL_ID_ERR
#define HOST_DISPATCHER_IMR0_BIT1_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PKT_FAIL_DBG_IMR, B_AX_HDT_PKT_FAIL_DBG
#define HOST_DISPATCHER_IMR0_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PERMU_OVERFLOW_IMR, B_AX_HDT_PERMU_OVERFLOW
#define HOST_DISPATCHER_IMR0_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PERMU_UNDERFLOW_IMR, B_AX_HDT_PERMU_UNDERFLOW
#define HOST_DISPATCHER_IMR0_BIT4_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PAYLOAD_OVERFLOW_IMR, B_AX_HDT_PAYLOAD_OVERFLOW
#define HOST_DISPATCHER_IMR0_BIT5_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_PAYLOAD_UNDERFLOW_IMR, B_AX_HDT_PAYLOAD_UNDERFLOW
#define HOST_DISPATCHER_IMR0_BIT6_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_OFFSET_UNMATCH_IMR, B_AX_HDT_OFFSET_UNMATCH
#define HOST_DISPATCHER_IMR0_BIT7_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_CHANNEL_DMA_ERR_IMR, B_AX_HDT_CHANNEL_DMA_ERR
#define HOST_DISPATCHER_IMR0_BIT8_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_WD_CHK_ERR_IMR, B_AX_HDT_WD_CHK_ERR
#define HOST_DISPATCHER_IMR0_BIT9_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PRE_COST_ERR_IMR, B_AX_HDT_PRE_COST_ERR
#define HOST_DISPATCHER_IMR0_BIT10_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_TXPKTSIZE_ERR_IMR, B_AX_HDT_TXPKTSIZE_ERR
#define HOST_DISPATCHER_IMR0_BIT11_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_TCP_CHK_ERR_IMR, B_AX_HDT_TCP_CHK_ERR
#define HOST_DISPATCHER_IMR0_BIT12_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_TX_WRITE_OVERFLOW_IMR, B_AX_HDT_TX_WRITE_OVERFLOW
#define HOST_DISPATCHER_IMR0_BIT13_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_TX_WRITE_UNDERFLOW_IMR, B_AX_HDT_TX_WRITE_UNDERFLOW
#define HOST_DISPATCHER_IMR0_BIT14_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PLD_CMD_OVERLOW_IMR, B_AX_HDT_PLD_CMD_OVERLOW
#define HOST_DISPATCHER_IMR0_BIT15_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_PLD_CMD_UNDERFLOW_IMR, B_AX_HDT_PLD_CMD_UNDERFLOW
#define HOST_DISPATCHER_IMR0_BIT16_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_FLOW_CTRL_ERR_IMR, B_AX_HDT_FLOW_CTRL_ERR
#define HOST_DISPATCHER_IMR0_BIT17_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_NULLPKT_ERR_IMR, B_AX_HDT_NULLPKT_ERR
#define HOST_DISPATCHER_IMR0_BIT18_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_BURST_NUM_ERR_IMR, B_AX_HDT_BURST_NUM_ERR
#define HOST_DISPATCHER_IMR0_BIT19_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_AGG_CFG_ERR_IMR, B_AX_HDT_RXAGG_CFG_ERR
#define HOST_DISPATCHER_IMR0_BIT24_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_SHIFT_EN_ERR_IMR, B_AX_HDT_SHIFT_EN_ERR
#define HOST_DISPATCHER_IMR0_BIT25_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_TOTAL_LEN_UNDER_ERR_IMR, B_AX_HDT_TOTAL_LEN_ERR
#define HOST_DISPATCHER_IMR0_BIT26_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_DMA_PROCESS_ERR_IMR, B_AX_HDT_DMA_PROCESS_ERR
#define HOST_DISPATCHER_IMR0_BIT27_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_SHIFT_DMA_CFG_ERR_IMR, B_AX_HDT_SHIFT_DMA_CFG_ERR
#define HOST_DISPATCHER_IMR0_BIT28_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_CHKSUM_FSM_ERR_IMR, B_AX_HDT_CHKSUM_FSM_ERR
#define HOST_DISPATCHER_IMR0_BIT29_8852B_EN SER_DISABLE
// Enable Bit, B_AX_HDT_WRFF_OVERFLOW_ERR_IMR, B_AX_HDT_RX_WRITE_OVERFLOW
#define HOST_DISPATCHER_IMR0_BIT30_8852B_EN SER_ENABLE
// Enable Bit, B_AX_HDT_WRFF_UNDERFLOW_ERR_IMR, B_AX_HDT_RX_WRITE_UNDERFLOW
#define HOST_DISPATCHER_IMR0_BIT31_8852B_EN SER_ENABLE
/* CPU Dispatcher 0x18608854 R_AX_CPU_DISPATCHER_ERR_IMR  */
#define CPU_DISPATCHER_IMR0_MSK_8852B 0x3f07ffff
#define CPU_DISPATCHER_IMR0_SET_8852B 0x4000062
// Enable Bit, B_AX_CPU_EP_CH_DIFF_ERR_IMR, B_AX_CPU_CHANNEL_DIFF_ERR
#define CPU_DISPATCHER_IMR0_BIT0_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PKT_FAIL_DBG_IMR, B_AX_CPU_PKT_FAIL_DBG
#define CPU_DISPATCHER_IMR0_BIT1_8852B_EN SER_ENABLE
// Enable Bit, B_AX_CPU_CH_ID_ERR_IMR, B_AX_CPU_CHANNEL_ID_ERR
#define CPU_DISPATCHER_IMR0_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PERMU_FF_OVERFLOW_ERR_IMR, B_AX_CPU_PERMU_OVERFLOW
#define CPU_DISPATCHER_IMR0_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PERMU_FF_UNDERFLOW_ERR_IMR, B_AX_CPU_PERMU_UNDERFLOW
#define CPU_DISPATCHER_IMR0_BIT4_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PAYLOAD_OVER_ERR_IMR, B_AX_CPU_PAYLOAD_OVERFLOW
#define CPU_DISPATCHER_IMR0_BIT5_8852B_EN SER_ENABLE
// Enable Bit, B_AX_CPU_PAYLOAD_UNDER_ERR_IMR, B_AX_CPU_PAYLOAD_UNDERFLOW
#define CPU_DISPATCHER_IMR0_BIT6_8852B_EN SER_ENABLE
// Enable Bit, B_AX_CPU_PAYLOAD_CHKSUM_ERR_IMR, B_AX_CPU_PAYLOAD_CHKSUM_ERR
#define CPU_DISPATCHER_IMR0_BIT7_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_OFFSET_UNMATCH_ERR_IMR, B_AX_CPU_OFFSET_UNMATCH
#define CPU_DISPATCHER_IMR0_BIT8_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_CHANNEL_DMA_ERR_IMR, B_AX_CPU_CHANNEL_DMA_ERR
#define CPU_DISPATCHER_IMR0_BIT9_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_WD_CHKSUM_ERR_IMR, B_AX_CPU_WD_CHK_ERR
#define CPU_DISPATCHER_IMR0_BIT10_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PRE_SUB_ERR_IMR, B_AX_CPU_PRE_COST_ERR
#define CPU_DISPATCHER_IMR0_BIT11_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PLD_CMD_OVERFLOW_ERR_IMR, B_AX_CPU_PLD_CMD_OVERLOW
#define CPU_DISPATCHER_IMR0_BIT12_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_PLD_CMD_UNDERFLOW_ERR_IMR, B_AX_CPU_PLD_CMD_UNDERFLOW
#define CPU_DISPATCHER_IMR0_BIT13_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_F2P_QSEL_ERR_IMR, B_AX_CPU_F2P_QSEL_ERR
#define CPU_DISPATCHER_IMR0_BIT14_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_F2P_SEQ_ERR_IMR, B_AX_CPU_F2P_SEQ_ERR
#define CPU_DISPATCHER_IMR0_BIT15_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_FLOW_CTRL_ERR_IMR, B_AX_CPU_FLOW_CTRL_ERR
#define CPU_DISPATCHER_IMR0_BIT16_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_NULLPKT_ERR_IMR, B_AX_CPU_NULLPKT_ERR
#define CPU_DISPATCHER_IMR0_BIT17_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_BURST_NUM_ERR_IMR, B_AX_CPU_BURST_NUM_ERR
#define CPU_DISPATCHER_IMR0_BIT18_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_RXAGG_CFG_ERR_IMR, B_AX_CPU_RXAGG_CFG_ERR
#define CPU_DISPATCHER_IMR0_BIT24_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_SHIFT_EN_ERR_IMR, B_AX_CPU_SHIFT_EN_ERR
#define CPU_DISPATCHER_IMR0_BIT25_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_TOTAL_LEN_ERR_IMR, B_AX_CPU_TOTAL_LEN_ERR
#define CPU_DISPATCHER_IMR0_BIT26_8852B_EN SER_ENABLE
// Enable Bit, B_AX_CPU_DMA_PROCESS_ERR_IMR, B_AX_CPU_DMA_PROCESS_ERR
#define CPU_DISPATCHER_IMR0_BIT27_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_SHIFT_DMA_CFG_ERR_IMR, B_AX_CPU_SHIFT_DMA_CFG_ERR
#define CPU_DISPATCHER_IMR0_BIT28_8852B_EN SER_DISABLE
// Enable Bit, B_AX_CPU_CHKSUM_FSM_ERR_IMR, B_AX_CPU_CHKSUM_FSM_ERR
#define CPU_DISPATCHER_IMR0_BIT29_8852B_EN SER_DISABLE
/* Dispatcher DLE interface 0x18608858 R_AX_OTHER_DISPATCHER_ERR_IMR  */
#define DISPATCHER_DLE_INTERFACE_IMR0_MSK_8852B 0x3f031f1f
#define DISPATCHER_DLE_INTERFACE_IMR0_SET_8852B 0x0
// Enable Bit, B_WDE_FLOW_CTRL_ERR_IMR, B_AX_WDE_FLOW_CTRL_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT0_8852B_EN SER_DISABLE
// Enable Bit, B_WDE_NULL_PKT_ERR_IMR, B_AX_WDE_NULL_PKT_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT1_8852B_EN SER_DISABLE
// Enable Bit, B_WDE_BURST_NUM_ERR_IMR, B_AX_WDE_BURST_NUM_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B_WDE_RESPONSE_ERR_IMR, B_AX_WDE_RESP_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B_WDE_OUTPUT_ERR_IMR, B_AX_WDE_OUTPUT_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT4_8852B_EN SER_DISABLE
// Enable Bit, B_PLE_FLOW_CTRL_ERR_IMR, B_AX_PLE_FLOW_CTRL_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT8_8852B_EN SER_DISABLE
// Enable Bit, B_PLE_NULL_PKT_ERR_IMR, B_AX_PLE_NULL_PKT_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT9_8852B_EN SER_DISABLE
// Enable Bit, B_PLE_BURST_NUM_ERR_IMR, B_AX_PLE_BURST_NUM_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT10_8852B_EN SER_DISABLE
// Enable Bit, B_PLE_RESPOSE_ERR_IMR, B_AX_PLE_RESP_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT11_8852B_EN SER_DISABLE
// Enable Bit, B_PLE_OUTPUT_ERR_IMR, B_AX_PLE_OUTPUT_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT12_8852B_EN SER_DISABLE
// Enable Bit, B_HOST_ADDR_INFO_LEN_ERR_IMR, B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT16_8852B_EN SER_DISABLE
// Enable Bit, B_CPU_ADDR_INFO_LEN_ERR_IMR, B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT17_8852B_EN SER_DISABLE
// Enable Bit, B_STF_CMD_OVERFLOW_ERR_IMR, B_AX_OTHER_STF_CMD_OVERFLOW
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT24_8852B_EN SER_DISABLE
// Enable Bit, B_STF_CMD_UNDERFLOW_ERR_IMR, B_AX_OTHER_STF_CMD_UNDERFLOW
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT25_8852B_EN SER_DISABLE
// Enable Bit, B_STF_WRFF_OVERFLOW_ERR_IMR, B_AX_OTHER_STF_WRFF_OVERFLOW
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT26_8852B_EN SER_DISABLE
// Enable Bit, B_STF_WRFF_UNDERFLOW_ERR_IMR, B_AX_OTHER_STF_WRFF_UNDERFLOW
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT27_8852B_EN SER_DISABLE
// Enable Bit, B_STF_OQT_OVERFLOW_ERR_IMR, B_AX_OTHER_STF_WROQT_OVERFLOW
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT28_8852B_EN SER_DISABLE
// Enable Bit, B_STF_OQT_UNDERFLOW_ERR_IMR, B_AX_OTHER_STF_WROQT_UNDERFLOW
#define DISPATCHER_DLE_INTERFACE_IMR0_BIT29_8852B_EN SER_DISABLE
/* dle_cpuio 0x18609840 R_AX_CPUIO_ERR_IMR  */
#define DLE_CPUIO_IMR0_MSK_8852B 0x1111
#define DLE_CPUIO_IMR0_SET_8852B 0x1111
// Enable Bit, wde_bufchn_cmd_togl IMR, B_AX_ERR_WDEBUF_OP_ERR
#define DLE_CPUIO_IMR0_BIT0_8852B_EN SER_ENABLE
// Enable Bit, wde_quechn_cmd_togl IMR, B_AX_ERR_WDEQUE_OP_ERR
#define DLE_CPUIO_IMR0_BIT4_8852B_EN SER_ENABLE
// Enable Bit, ple_bufchn_cmd_togl IMR, B_AX_PLEBUF_OP_ERR
#define DLE_CPUIO_IMR0_BIT8_8852B_EN SER_ENABLE
// Enable Bit, pldle_quechn_cmd_togl IMR, B_AX_PLEQUE_OP_ERR
#define DLE_CPUIO_IMR0_BIT12_8852B_EN SER_ENABLE
/* bbrpt 0x1860960c R_AX_BBRPT_COM_ERR_IMR_ISR  */
#define BBRPT_IMR0_MSK_8852B 0x1
#define BBRPT_IMR0_SET_8852B 0x1
// Enable Bit, B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN, None
#define BBRPT_IMR0_BIT0_8852B_EN SER_ENABLE
/* bbrpt 0x1860962c R_AX_BBRPT_CHINFO_ERR_IMR_ISR  */
#define BBRPT_IMR1_MSK_8852B 0xff
#define BBRPT_IMR1_SET_8852B 0x0
// Enable Bit, B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN, None
#define BBRPT_IMR1_BIT0_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_OVF_ERR_INT_EN, None
#define BBRPT_IMR1_BIT1_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN, None
#define BBRPT_IMR1_BIT2_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN, None
#define BBRPT_IMR1_BIT3_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN, None
#define BBRPT_IMR1_BIT4_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN, None
#define BBRPT_IMR1_BIT5_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_NULL_ERR_INT_EN, None
#define BBRPT_IMR1_BIT6_8852B_EN SER_DISABLE
// Enable Bit, B_AX_BBPRT_CHIF_TO_ERR_INT_EN, None
#define BBRPT_IMR1_BIT7_8852B_EN SER_DISABLE
/* bbrpt 0x1860963c R_AX_BBRPT_DFS_ERR_IMR_ISR  */
#define BBRPT_IMR2_MSK_8852B 0x1
#define BBRPT_IMR2_SET_8852B 0x1
// Enable Bit, B_AX_BBRPT_DFS_TO_ERR_INT_EN, None
#define BBRPT_IMR2_BIT0_8852B_EN SER_ENABLE
/* bbrpt 0x1860966c R_AX_LA_ERRFLAG  */
#define BBRPT_IMR3_MSK_8852B 0x1
#define BBRPT_IMR3_SET_8852B 0x1
// Enable Bit, B_AX_LA_IMR_DATA_LOSS, None
#define BBRPT_IMR3_BIT0_8852B_EN SER_ENABLE

u32 ser_imr_config_8852b(struct mac_ax_adapter *adapter, u8 band,
			 enum mac_ax_hwmod_sel sel);

#endif /* #if MAC_AX_8852B_SUPPORT */
#endif
