/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.12*/
#ifndef _HALRF_HWIMG_RAW_DATA_8852B_H
#define _HALRF_HWIMG_RAW_DATA_8852B_H

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE


#if 0
/* Please put following enum definitions in appropriate header file. */
enum odm_pw_byrate_para_type {
	PW_BYRATE_PARA_NSS1,
	PW_BYRATE_PARA_NSS2,
	PW_BYRATE_PARA_OFFS = 0xF
};

enum odm_pw_byrate_rate_type {
	PW_BYRATE_RATE_11M_1M,
	PW_BYRATE_RATE_18M_6M,
	PW_BYRATE_RATE_54M_24M,
	PW_BYRATE_RATE_MCS3_0,
	PW_BYRATE_RATE_MCS7_4,
	PW_BYRATE_RATE_MCS11_8,
	PW_BYRATE_RATE_DCM4_0,
	PW_BYRATE_RATE_AllRate2_1,  /* CCK, OFDM, HT, VHT */
	PW_BYRATE_RATE_AllRate2_2,  /* HE_HEDCM */
	PW_BYRATE_RATE_AllRate5_1,  /* OFDM, HT, VHT, HE_HEDCM */
	PW_BYRATE_RATE_AllRate6_1,  /* OFDM, HT, VHT, HE_HEDCM (6G) */
	PW_BYRATE_RATE_NULL = 0xF
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC,
	PW_LMT_REGU_ETSI,
	PW_LMT_REGU_MKK,
	PW_LMT_REGU_IC,
	PW_LMT_REGU_KCC,
	PW_LMT_REGU_ACMA,
	PW_LMT_REGU_CHILE,
	PW_LMT_REGU_UKRAINE,
	PW_LMT_REGU_MEXICO,
	PW_LMT_REGU_CN,
	PW_LMT_REGU_WW13,
	PW_LMT_REGU_NULL
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_2_4G,
	PW_LMT_BAND_5G,
	PW_LMT_BAND_6G,
	PW_LMT_BAND_NULL
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_20M,
	PW_LMT_BW_40M,
	PW_LMT_BW_80M,
	PW_LMT_BW_160M,
	PW_LMT_BW_NULL
};

enum odm_pw_lmt_ru_bandwidth_type {
	PW_LMT_RU_BW_RU26,
	PW_LMT_RU_BW_RU52,
	PW_LMT_RU_BW_RU106,
	PW_LMT_RU_BW_NULL
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_CCK,
	PW_LMT_RS_OFDM,
	PW_LMT_RS_HT,
	PW_LMT_RS_VHT,
	PW_LMT_RS_HE,
	PW_LMT_RS_NULL
};

enum odm_pw_lmt_beamform_type {
	PW_LMT_BF,
	PW_LMT_NONBF,
	PW_LMT_NULL
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_1T,
	PW_LMT_PH_2T,
	PW_LMT_PH_3T,
	PW_LMT_PH_4T,
	PW_LMT_PH_NULL
};

struct halrf_tx_pw_lmt {
	u8			band:1;
	u8			bw:3;
	u8			rs:2;
	u8			ntx:2;
	u8			bf:3;
	u8			reg:5;
	u8			ch;
	s8			val;
};

struct halrf_tx_pw_lmt_ru {
	u8			band:1;
	u8			bw:2;
	u8			ntx:2;
	u8			rs:3;
	u8			reg;
	u8			ch;
	s8			val;
};
#endif


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8852b_radioa[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0010001, 0x00000002,
		0xF0020001, 0x00000003,
		0xF0030001, 0x00000004,
		0xF0040001, 0x00000005,
		0xF0050001, 0x00000006,
		0xF0060001, 0x00000007,
		0xF0070001, 0x00000008,
		0xF0080001, 0x00000009,
		0xF00B0001, 0x0000000A,
		0xF00C0001, 0x0000000B,
		0xF0290001, 0x0000000C,
		0xF02B0001, 0x0000000D,
		0x005, 0x00000000,
		0x000, 0x00030000,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x000, 0x00033C00,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x011, 0x00014073,
		0x067, 0x00000070,
		0x059, 0x000A0000,
		0x066, 0x00000100,
		0x057, 0x0000D589,
		0x05A, 0x0007FFFF,
		0x0A4, 0x0006FF12,
		0x043, 0x00005000,
		0x0E1, 0x00000001,
		0x0DD, 0x000001A0,
		0x0CA, 0x00002000,
		0x0D3, 0x00000003,
		0x0B3, 0x0004EFE0,
		0x0B4, 0x0007C07E,
		0x0B5, 0x0003A701,
		0x0B6, 0x000581E0,
		0x0B7, 0x00001A0A,
		0x0BB, 0x000C7000,
		0x0ED, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x00000543,
		0x033, 0x00000001,
		0x03F, 0x00000542,
		0x033, 0x00000002,
		0x03F, 0x00000541,
		0x033, 0x00000003,
		0x03F, 0x00000521,
		0x033, 0x00000004,
		0x03F, 0x00000343,
		0x033, 0x00000005,
		0x03F, 0x00000342,
		0x033, 0x00000006,
		0x03F, 0x00000341,
		0x033, 0x00000007,
		0x03F, 0x00000321,
		0x033, 0x00000008,
		0x03F, 0x000005C3,
		0x033, 0x00000009,
		0x03F, 0x000005C2,
		0x033, 0x0000000A,
		0x03F, 0x000005C1,
		0x033, 0x0000000B,
		0x03F, 0x000005A1,
		0x033, 0x0000000C,
		0x03F, 0x000002C3,
		0x033, 0x0000000D,
		0x03F, 0x000002C2,
		0x033, 0x0000000E,
		0x03F, 0x000002C1,
		0x033, 0x0000000F,
		0x03F, 0x000002A1,
		0x0ED, 0x00000000,
		0x0ED, 0x00002000,
		0x033, 0x00000002,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000006,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x0ED, 0x00000000,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000004,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
		0x08F, 0x000D0F7A,
		0x0EF, 0x00080000,
		0x033, 0x00000008,
		0x03E, 0x000000C4,
		0x03F, 0x000034C0,
		0x033, 0x0000000A,
		0x03E, 0x000000C4,
		0x03F, 0x000035D0,
		0x033, 0x0000000B,
		0x03E, 0x000000C4,
		0x03F, 0x000035C8,
		0x033, 0x0000008A,
		0x03E, 0x000000C4,
		0x03F, 0x000035F7,
		0x0EF, 0x00000000,
		0x08D, 0x000CC800,
		0x0EF, 0x00004000,
		0x033, 0x00000006,
		0x03F, 0x00000700,
		0x033, 0x00000005,
		0x03F, 0x00090600,
		0x033, 0x00000004,
		0x03F, 0x000A3500,
		0x033, 0x00000003,
		0x03F, 0x000A3400,
		0x033, 0x00000002,
		0x03F, 0x00008B00,
		0x033, 0x00000001,
		0x03F, 0x00001B00,
		0x033, 0x00000000,
		0x03F, 0x00003A00,
		0x033, 0x0000000F,
		0x03F, 0x00000700,
		0x033, 0x0000000E,
		0x03F, 0x00000700,
		0x033, 0x0000000D,
		0x03F, 0x00090600,
		0x033, 0x0000000C,
		0x03F, 0x000A3500,
		0x033, 0x0000000B,
		0x03F, 0x000A3400,
		0x033, 0x0000000A,
		0x03F, 0x00008B00,
		0x033, 0x00000009,
		0x03F, 0x00001B00,
		0x033, 0x00000008,
		0x03F, 0x00003A00,
		0x0EF, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
		0x03F, 0x00000017,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000000,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000001,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000002,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000003,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000004,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000005,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000006,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000008,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000009,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000000A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000000B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000000C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000000D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000000E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000010,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000011,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000012,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000013,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000014,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000015,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000016,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000020,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000021,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000022,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000023,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000024,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000025,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000026,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000028,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000029,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000002A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000002B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000002C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000002D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000002E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000030,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000031,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000032,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000033,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000034,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000035,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000036,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000431A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000431A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x067, 0x00008072,
		0x0EF, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x00000ED5,
		0x033, 0x00000002,
		0x03F, 0x00000FC7,
		0x033, 0x00000003,
		0x03F, 0x00000783,
		0x033, 0x00000004,
		0x03F, 0x00000973,
		0x033, 0x00000005,
		0x03F, 0x00000762,
		0x033, 0x00000006,
		0x03F, 0x00000762,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000002B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000003B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x033, 0x00000004,
		0x03F, 0x00000001,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00003000,
		0x033, 0x00000001,
		0x03F, 0x00003001,
		0x033, 0x00000002,
		0x03F, 0x00003003,
		0x033, 0x00000003,
		0x03F, 0x00003007,
		0x033, 0x00000004,
		0x03F, 0x0000300F,
		0x033, 0x00000005,
		0x03F, 0x0000310F,
		0x033, 0x00000006,
		0x03F, 0x0000330F,
		0x033, 0x00000007,
		0x03F, 0x0000330F,
		0x033, 0x00000008,
		0x03F, 0x00003000,
		0x033, 0x00000009,
		0x03F, 0x00003001,
		0x033, 0x0000000A,
		0x03F, 0x00003003,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0xA0000000,	0x00000000,
		0x03F, 0x00003103,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0xA0000000,	0x00000000,
		0x03F, 0x00003307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0xA0000000,	0x00000000,
		0x03F, 0x00002307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EC, 0x00000100,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03D, 0x00000078,
		0x03E, 0x00080000,
		0x03F, 0x00000000,
		0x033, 0x00000005,
		0x03D, 0x0000007B,
		0x03E, 0x00020000,
		0x03F, 0x00000000,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x033, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000017F,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000017F,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000017F,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06F, 0x00077A18,
		0x06D, 0x00000C31,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03F, 0x000005FF,
		0x0EF, 0x00000000,
		0x005, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0xA0000000,	0x00000000,
		0x094, 0x000001FC,
	0xB0000000,	0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000080,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000081,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000082,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x00000083,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000080,
		0x1003F, 0x000001A9,
		0x10033, 0x00000081,
		0x1003F, 0x000001A3,
		0x10033, 0x00000082,
		0x1003F, 0x0000019D,
		0x10033, 0x00000083,
		0x1003F, 0x00000197,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x00000091,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000A1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000A2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000A3,
		0x1003F, 0x00000197,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000C1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000C2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000C3,
		0x1003F, 0x00000197,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000000,
		0x1003F, 0x000000F6,
		0x10033, 0x00000001,
		0x1003F, 0x000000F3,
		0x10033, 0x00000002,
		0x1003F, 0x000000F0,
		0x10033, 0x00000003,
		0x1003F, 0x000000ED,
		0x10033, 0x00000004,
		0x1003F, 0x000000EA,
		0x10033, 0x00000005,
		0x1003F, 0x000000E7,
		0x10033, 0x00000006,
		0x1003F, 0x000000A6,
		0x10033, 0x00000007,
		0x1003F, 0x000000A3,
		0x10033, 0x00000008,
		0x1003F, 0x00000063,
		0x10033, 0x00000009,
		0x1003F, 0x00000060,
		0x10033, 0x0000000A,
		0x1003F, 0x00000023,
		0x10033, 0x0000000B,
		0x1003F, 0x00000020,
		0x10033, 0x0000000C,
		0x1003F, 0x0000001D,
		0x10033, 0x0000000D,
		0x1003F, 0x0000001A,
		0x10033, 0x0000000E,
		0x1003F, 0x00000017,
		0x10033, 0x0000000F,
		0x1003F, 0x00000014,
		0x10033, 0x00000010,
		0x1003F, 0x00000011,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000000,
		0x1003F, 0x000001AF,
		0x10033, 0x00000001,
		0x1003F, 0x000001A9,
		0x10033, 0x00000002,
		0x1003F, 0x000001A3,
		0x10033, 0x00000003,
		0x1003F, 0x0000019D,
		0x10033, 0x00000004,
		0x1003F, 0x00000197,
		0x10033, 0x00000005,
		0x1003F, 0x0000015F,
		0x10033, 0x00000006,
		0x1003F, 0x00000159,
		0x10033, 0x00000007,
		0x1003F, 0x0000011F,
		0x10033, 0x00000008,
		0x1003F, 0x00000119,
		0x10033, 0x00000009,
		0x1003F, 0x000000DF,
		0x10033, 0x0000000A,
		0x1003F, 0x000000D9,
		0x10033, 0x0000000B,
		0x1003F, 0x0000009F,
		0x10033, 0x0000000C,
		0x1003F, 0x00000099,
		0x10033, 0x0000000D,
		0x1003F, 0x0000005F,
		0x10033, 0x0000000E,
		0x1003F, 0x00000059,
		0x10033, 0x0000000F,
		0x1003F, 0x0000001F,
		0x10033, 0x00000010,
		0x1003F, 0x00000019,
		0x10033, 0x00000011,
		0x1003F, 0x00000013,
		0x100EE, 0x00000000,
		0x10005, 0x00000001,
		0x09F, 0x00000042,

};


/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8852b_radiob[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0010001, 0x00000002,
		0xF0020001, 0x00000003,
		0xF0030001, 0x00000004,
		0xF0040001, 0x00000005,
		0xF0050001, 0x00000006,
		0xF0060001, 0x00000007,
		0xF0070001, 0x00000008,
		0xF0080001, 0x00000009,
		0xF00B0001, 0x0000000A,
		0xF00C0001, 0x0000000B,
		0xF0290001, 0x0000000C,
		0xF02B0001, 0x0000000D,
		0x005, 0x00000000,
		0x000, 0x00030000,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x000, 0x00033C00,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x011, 0x00014073,
		0x067, 0x00000070,
		0x059, 0x000A0000,
		0x066, 0x00000100,
		0x05A, 0x0007F000,
		0x0A4, 0x0006FF12,
		0x043, 0x00005000,
		0x0E1, 0x00000001,
		0x0DD, 0x000001A0,
		0x0CA, 0x00002000,
		0x0D3, 0x00000003,
		0x0B3, 0x0004EFE0,
		0x0B4, 0x0007C03E,
		0x0B5, 0x0003A201,
		0x0BB, 0x000C7000,
		0x0ED, 0x00002000,
		0x033, 0x00000002,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000006,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x0ED, 0x00000000,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000004,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
		0x08F, 0x000D0F7A,
		0x0EF, 0x00080000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0xA0000000,	0x00000000,
		0x03E, 0x000000C4,
		0x03F, 0x000034C0,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0xA0000000,	0x00000000,
		0x03E, 0x000000C4,
		0x03F, 0x000035D0,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0xA0000000,	0x00000000,
		0x03E, 0x000000C4,
		0x03F, 0x000035C8,
	0xB0000000,	0x00000000,
		0x033, 0x0000008A,
		0x03E, 0x00000031,
		0x03F, 0x00000D7D,
		0x0EF, 0x00000000,
		0x08D, 0x000CC800,
		0x0EF, 0x00004000,
		0x033, 0x00000007,
		0x03F, 0x00000700,
		0x033, 0x00000006,
		0x03F, 0x00000700,
		0x033, 0x00000005,
		0x03F, 0x00090600,
		0x033, 0x00000004,
		0x03F, 0x000A3500,
		0x033, 0x00000003,
		0x03F, 0x000A3400,
		0x033, 0x00000002,
		0x03F, 0x00008B00,
		0x033, 0x00000001,
		0x03F, 0x00001B00,
		0x033, 0x00000000,
		0x03F, 0x00003A00,
		0x033, 0x0000000F,
		0x03F, 0x00000700,
		0x033, 0x0000000E,
		0x03F, 0x00000700,
		0x033, 0x0000000D,
		0x03F, 0x00090600,
		0x033, 0x0000000C,
		0x03F, 0x000A3500,
		0x033, 0x0000000B,
		0x03F, 0x000A3400,
		0x033, 0x0000000A,
		0x03F, 0x00008B00,
		0x033, 0x00000009,
		0x03F, 0x00001B00,
		0x033, 0x00000008,
		0x03F, 0x00003A00,
		0x033, 0x00000017,
		0x03F, 0x00000705,
		0x033, 0x00000016,
		0x03F, 0x00000705,
		0x033, 0x00000015,
		0x03F, 0x00090605,
		0x033, 0x00000014,
		0x03F, 0x000A3505,
		0x033, 0x00000013,
		0x03F, 0x000A3405,
		0x033, 0x00000012,
		0x03F, 0x00008B05,
		0x033, 0x00000011,
		0x03F, 0x00001B05,
		0x033, 0x00000010,
		0x03F, 0x00003A05,
		0x0EF, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0xA0000000,	0x00000000,
		0x03F, 0x00000005,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0xA0000000,	0x00000000,
		0x03F, 0x00000017,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0xA0000000,	0x00000000,
		0x03F, 0x00000007,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000000,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000001,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000002,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000003,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000004,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000005,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000006,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000008,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000009,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000000A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000000B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000000C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000000D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000000E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000010,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000011,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000012,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000013,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000014,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000015,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000016,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000020,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000021,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000022,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000023,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000024,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000025,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000026,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000028,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000029,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000002A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000002B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000002C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000002D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000002E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000030,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000031,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000032,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000033,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000034,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000035,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000036,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000431A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000431A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004379,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000434A,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004349,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004386,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004386,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004386,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004386,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004389,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004386,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x067, 0x00008072,
		0x0EF, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x00000ED5,
		0x033, 0x00000002,
		0x03F, 0x00000FC5,
		0x033, 0x00000003,
		0x03F, 0x00000A93,
		0x033, 0x00000004,
		0x03F, 0x00000973,
		0x033, 0x00000005,
		0x03F, 0x00000761,
		0x033, 0x00000006,
		0x03F, 0x00000761,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000002B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000003B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x033, 0x00000004,
		0x03F, 0x00000001,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00003000,
		0x033, 0x00000001,
		0x03F, 0x00003001,
		0x033, 0x00000002,
		0x03F, 0x00003003,
		0x033, 0x00000003,
		0x03F, 0x00003007,
		0x033, 0x00000004,
		0x03F, 0x0000300F,
		0x033, 0x00000005,
		0x03F, 0x0000310F,
		0x033, 0x00000006,
		0x03F, 0x0000330F,
		0x033, 0x00000007,
		0x03F, 0x0000330F,
		0x033, 0x00000008,
		0x03F, 0x00003000,
		0x033, 0x00000009,
		0x03F, 0x00003001,
		0x033, 0x0000000A,
		0x03F, 0x00003003,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0xA0000000,	0x00000000,
		0x03F, 0x00003103,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0xA0000000,	0x00000000,
		0x03F, 0x00003307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0xA0000000,	0x00000000,
		0x03F, 0x00002307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EC, 0x00000100,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03D, 0x00000078,
		0x03E, 0x00080000,
		0x03F, 0x00000000,
		0x033, 0x00000005,
		0x03D, 0x0000007B,
		0x03E, 0x00020000,
		0x03F, 0x00000000,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x033, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000017F,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000017F,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000017F,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000017F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000173,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000007F,
	0xA0000000,	0x00000000,
		0x03F, 0x0000007F,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06F, 0x00077A18,
		0x06D, 0x00000C31,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03F, 0x000005FF,
		0x0EF, 0x00000000,
		0x005, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0xA0000000,	0x00000000,
		0x094, 0x000001FC,
	0xB0000000,	0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000080,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000081,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000082,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x00000083,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000080,
		0x1003F, 0x000001A9,
		0x10033, 0x00000081,
		0x1003F, 0x000001A3,
		0x10033, 0x00000082,
		0x1003F, 0x0000019D,
		0x10033, 0x00000083,
		0x1003F, 0x00000197,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x00000091,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000A1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000A2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000A3,
		0x1003F, 0x00000197,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000C1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000C2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000C3,
		0x1003F, 0x00000197,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90060001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90080001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x900c0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90290001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x902b0001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000000,
		0x1003F, 0x000000F6,
		0x10033, 0x00000001,
		0x1003F, 0x000000F3,
		0x10033, 0x00000002,
		0x1003F, 0x000000F0,
		0x10033, 0x00000003,
		0x1003F, 0x000000ED,
		0x10033, 0x00000004,
		0x1003F, 0x000000EA,
		0x10033, 0x00000005,
		0x1003F, 0x000000E7,
		0x10033, 0x00000006,
		0x1003F, 0x000000A6,
		0x10033, 0x00000007,
		0x1003F, 0x000000A3,
		0x10033, 0x00000008,
		0x1003F, 0x00000063,
		0x10033, 0x00000009,
		0x1003F, 0x00000060,
		0x10033, 0x0000000A,
		0x1003F, 0x00000023,
		0x10033, 0x0000000B,
		0x1003F, 0x00000020,
		0x10033, 0x0000000C,
		0x1003F, 0x0000001D,
		0x10033, 0x0000000D,
		0x1003F, 0x0000001A,
		0x10033, 0x0000000E,
		0x1003F, 0x00000017,
		0x10033, 0x0000000F,
		0x1003F, 0x00000014,
		0x10033, 0x00000010,
		0x1003F, 0x00000011,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000000,
		0x1003F, 0x000001AF,
		0x10033, 0x00000001,
		0x1003F, 0x000001A9,
		0x10033, 0x00000002,
		0x1003F, 0x000001A3,
		0x10033, 0x00000003,
		0x1003F, 0x0000019D,
		0x10033, 0x00000004,
		0x1003F, 0x00000197,
		0x10033, 0x00000005,
		0x1003F, 0x0000015F,
		0x10033, 0x00000006,
		0x1003F, 0x00000159,
		0x10033, 0x00000007,
		0x1003F, 0x0000011F,
		0x10033, 0x00000008,
		0x1003F, 0x00000119,
		0x10033, 0x00000009,
		0x1003F, 0x000000DF,
		0x10033, 0x0000000A,
		0x1003F, 0x000000D9,
		0x10033, 0x0000000B,
		0x1003F, 0x0000009F,
		0x10033, 0x0000000C,
		0x1003F, 0x00000099,
		0x10033, 0x0000000D,
		0x1003F, 0x0000005F,
		0x10033, 0x0000000E,
		0x1003F, 0x00000059,
		0x10033, 0x0000000F,
		0x1003F, 0x0000001F,
		0x10033, 0x00000010,
		0x1003F, 0x00000019,
		0x10033, 0x00000011,
		0x1003F, 0x00000013,
		0x100EE, 0x00000000,
		0x10005, 0x00000001,
		0x09F, 0x00000042,

};


/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8852b_txpwr_lmt[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 78, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 56, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 56, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 56, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 74, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 54, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 54, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 54, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 42, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 42, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 42, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 66, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 66, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 66, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 50, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 42, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 42, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 42, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 34, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 30, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 2, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 3, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 4, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 5, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 7, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 8, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 9, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 10, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 11, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 12, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 13, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 3, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 4, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 5, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 6, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 11, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 11, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 36, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 36, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 36, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 36, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 40, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 40, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 40, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 40, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 44, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 44, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 44, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 44, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 48, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 48, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 48, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 48, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 52, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 52, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 52, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 56, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 56, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 56, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 60, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 60, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 60, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 64, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 100, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 104, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 108, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 112, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 116, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 120, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 120, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 120, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 120, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 120, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 120, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 120, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 124, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 124, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 124, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 124, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 124, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 124, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 124, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 128, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 128, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 128, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 128, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 128, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 128, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 128, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 132, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 132, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 132, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 132, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 136, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 136, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 136, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 136, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 140, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 140, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 144, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 144, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 144, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 144, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 149, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 149, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 149, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 149, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 149, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 149, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 153, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 153, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 153, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 153, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 153, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 153, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 157, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 157, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 157, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 157, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 157, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 161, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 161, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 161, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 161, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 161, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 165, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 165, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 165, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 165, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 165, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 169, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 173, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 177, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 38, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 38, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 46, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 46, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 54, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 54, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 62, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 62, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 102, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 102, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 102, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 110, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 110, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 110, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 110, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 118, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 118, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 118, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 118, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 126, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 126, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 126, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 126, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 134, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 134, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 134, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 134, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 142, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 142, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 151, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 151, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 151, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 151, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 159, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 159, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 159, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 38, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 38, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 38, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 46, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 46, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 46, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 54, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 54, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 54, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 62, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 62, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 62, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 102, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 102, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 110, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 110, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 110, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 118, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 118, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 118, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 126, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 126, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 126, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 134, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 134, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 134, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 142, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 142, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 151, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 151, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 151, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 151, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 159, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 159, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 159, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 38, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 38, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 38, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 38, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 38, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 38, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 38, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 38, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 38, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 46, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 46, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 46, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 46, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 46, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 46, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 46, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 46, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 54, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 54, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 54, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 54, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 54, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 54, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 54, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 62, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 62, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 62, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 62, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 62, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 62, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 62, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 62, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 62, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 102, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 102, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 102, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 102, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 110, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 110, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 110, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 110, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 118, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 118, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 118, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 118, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 126, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 126, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 126, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 126, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 134, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 134, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 134, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 134, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 134, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 134, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 134, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 142, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 142, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 142, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 142, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 142, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 151, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 151, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 151, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 151, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 151, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 151, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 151, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 151, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 151, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 159, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 159, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 159, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 159, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 159, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 159, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 159, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 159, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 159, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 167, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 175, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 42, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 42, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 42, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 58, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 58, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 58, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 106, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 106, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 122, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 122, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 122, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 122, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 138, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 138, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 155, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 155, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 155, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 155, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 42, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 42, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 42, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 58, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 58, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 106, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 106, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 106, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 122, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 122, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 122, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 122, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 138, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 138, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 155, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 155, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 155, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 155, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 42, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 42, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 42, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 42, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 42, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 42, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 42, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 58, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 58, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 58, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 58, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 58, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 58, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 58, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 58, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 106, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 106, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 106, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 106, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 106, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 106, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 106, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 122, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 122, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 122, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 122, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 122, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 122, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 122, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 122, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 122, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 138, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 138, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 138, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 138, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 138, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 138, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 138, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 155, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 155, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 155, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 155, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 155, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 155, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 155, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 155, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 155, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 171, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 171, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8852b_txpwr_lmt_ru[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UKRAINE, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MEXICO, 1, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CNOLD, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_QATAR, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CHILE, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UKRAINE, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MEXICO, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CNOLD, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_QATAR, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CHILE, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UKRAINE, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MEXICO, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CNOLD, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_QATAR, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CHILE, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UKRAINE, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MEXICO, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CNOLD, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_QATAR, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CHILE, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UKRAINE, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MEXICO, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CNOLD, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_QATAR, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CHILE, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UKRAINE, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MEXICO, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_