/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#define _RTL8852B_REGULATION_C_
#include "rtl8852b_hal.h"

/* regu tbl definition starts here */
#define REGULATION_CHPLAN_VERSION_8852B 68
#define REGULATION_COUNTRY_VERSION_8852B 50

static const struct chdef_2ghz chdef2g_8852b[] = {
    {0, {0x00, 0x00}, {0x00, 0x00}},
    {1, {0xff, 0x1f}, {0x00, 0x18}},
    {2, {0xff, 0x1f}, {0x00, 0x00}},
    {3, {0xff, 0x07}, {0x00, 0x00}},
    {4, {0xff, 0x3f}, {0x00, 0x00}},
    {5, {0x00, 0x1e}, {0x00, 0x00}},
    {6, {0xff, 0x3f}, {0x00, 0x38}},
};

static const struct chdef_5ghz chdef5g_8852b[] = {
    {0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {1, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {2, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x00, 0x00, 0x00},
    {3, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x1f, 0x00, 0x00},
    {4, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x01}, {0x00, 0x00}, {0xff, 0x01}, 0x1f, 0x00, 0x00},
    {5, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x7f, 0x00}, {0x00, 0x00}, {0x7f, 0x00}, 0x0f, 0x00, 0x00},
    {6, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {7, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {8, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {10, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x00, 0x00, 0x00},
    {12, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {13, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {14, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0xff, 0x07}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {17, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x07}, {0x00, 0x00}, {0x00, 0x07}, 0x1f, 0x00, 0x00},
    {18, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {19, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x00, 0x00, 0x00},
    {20, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x0f, 0x00, 0x00},
    {21, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x07}, {0x00, 0x00}, {0x00, 0x07}, 0x00, 0x00, 0x00},
    {22, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0x1f, 0x00, 0x00},
    {23, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x00}, {0x00, 0x00}, {0xff, 0x00}, 0x1f, 0x00, 0x00},
    {24, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {25, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {26, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {27, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0x1f, 0x07}, {0x1f, 0x07}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {28, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {29, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {30, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {31, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {32, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {33, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x0f}, {0x00, 0x00}, {0x1f, 0x0f}, 0x1f, 0x00, 0x00},
    {34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x00, 0x00, 0x00},
    {36, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x0f, {0xff, 0x0f}, {0xff, 0x0f}, {0xff, 0x0f}, 0x1f, 0x1f, 0x00},
    {37, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {38, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0x00, 0x00, 0x00},
    {39, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x00}, {0x00, 0x00}, {0xff, 0x00}, 0x1f, 0x00, 0x1f},
    {40, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {41, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x1f, 0x1f, 0x00},
    {42, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x1f, 0x1f, 0x00},
    {43, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x06}, {0xff, 0x06}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {44, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x1f, 0x07}, {0x1f, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {45, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {46, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {47, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {48, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0x00, 0x00, 0x00},
    {49, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x01}, {0x00, 0x00}, {0xff, 0x01}, 0x00, 0x00, 0x00},
    {50, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x0f}, {0x00, 0x00}, {0x00, 0x0f}, 0x1f, 0x00, 0x00},
    {51, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x00}, {0x00, 0x00}, {0x1f, 0x00}, 0x00, 0x00, 0x00},
    {52, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0xff, 0x00, 0x00},
    {53, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x0f, 0x00}, {0x00, 0x00}, {0x0f, 0x00}, 0x1f, 0x00, 0x00},
    {54, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {55, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x0f, {0xff, 0x0f}, {0xff, 0x0f}, {0xff, 0x0f}, 0xff, 0xff, 0x00},
    {56, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x0f}, {0x00, 0x00}, {0x1f, 0x0f}, 0xff, 0x00, 0x00},
    {57, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x0f}, {0xff, 0x0f}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {58, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x07}, {0x00, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {59, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {60, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x7f, 0x00, 0x00},
    {61, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x00}, {0x00, 0x00}, {0xff, 0x00}, 0x7f, 0x00, 0x00},
};

static const struct regulatory_domain_mapping rdmap_8852b[] = {
    {0x20, {REGULATION_WW, 1}, {REGULATION_NA, 0}},
    {0x21, {REGULATION_ETSI, 2}, {REGULATION_NA, 0}},
    {0x22, {REGULATION_FCC, 3}, {REGULATION_NA, 0}},
    {0x23, {REGULATION_MKK, 4}, {REGULATION_NA, 0}},
    {0x24, {REGULATION_ETSI, 5}, {REGULATION_NA, 0}},
    {0x25, {REGULATION_FCC, 3}, {REGULATION_FCC, 3}},
    {0x26, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 2}},
    {0x27, {REGULATION_MKK, 4}, {REGULATION_MKK, 2}},
    {0x28, {REGULATION_KCC, 1}, {REGULATION_KCC, 5}},
    {0x29, {REGULATION_FCC, 1}, {REGULATION_FCC, 6}},
    {0x30, {REGULATION_FCC, 1}, {REGULATION_FCC, 7}},
    {0x31, {REGULATION_FCC, 1}, {REGULATION_FCC, 8}},
    {0x32, {REGULATION_FCC, 1}, {REGULATION_FCC, 9}},
    {0x33, {REGULATION_FCC, 1}, {REGULATION_FCC, 10}},
    {0x34, {REGULATION_FCC, 3}, {REGULATION_FCC, 1}},
    {0x35, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 3}},
    {0x36, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 4}},
    {0x37, {REGULATION_MKK, 4}, {REGULATION_MKK, 10}},
    {0x38, {REGULATION_MKK, 4}, {REGULATION_MKK, 11}},
    {0x39, {REGULATION_NCC, 3}, {REGULATION_NCC, 12}},
    {0x40, {REGULATION_NCC, 3}, {REGULATION_NCC, 13}},
    {0x41, {REGULATION_WW, 6}, {REGULATION_NA, 0}},
    {0x42, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 14}},
    {0x43, {REGULATION_FCC, 3}, {REGULATION_FCC, 6}},
    {0x44, {REGULATION_NCC, 3}, {REGULATION_NCC, 9}},
    {0x45, {REGULATION_ACMA, 1}, {REGULATION_ACMA, 1}},
    {0x46, {REGULATION_FCC, 3}, {REGULATION_FCC, 15}},
    {0x47, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 10}},
    {0x48, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 7}},
    {0x49, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 6}},
    {0x50, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 16}},
    {0x51, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 9}},
    {0x52, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 17}},
    {0x53, {REGULATION_NCC, 3}, {REGULATION_NCC, 18}},
    {0x54, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 15}},
    {0x55, {REGULATION_FCC, 3}, {REGULATION_FCC, 1}},
    {0x56, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 19}},
    {0x57, {REGULATION_FCC, 3}, {REGULATION_FCC, 20}},
    {0x58, {REGULATION_MKK, 2}, {REGULATION_MKK, 14}},
    {0x59, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 21}},
    {0x2a, {REGULATION_FCC, 2}, {REGULATION_NA, 0}},
    {0x60, {REGULATION_FCC, 3}, {REGULATION_FCC, 9}},
    {0x61, {REGULATION_FCC, 2}, {REGULATION_FCC, 1}},
    {0x62, {REGULATION_FCC, 2}, {REGULATION_FCC, 3}},
    {0x63, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 23}},
    {0x64, {REGULATION_MKK, 2}, {REGULATION_MKK, 24}},
    {0x65, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 24}},
    {0x66, {REGULATION_FCC, 3}, {REGULATION_FCC, 27}},
    {0x67, {REGULATION_FCC, 3}, {REGULATION_FCC, 25}},
    {0x68, {REGULATION_FCC, 2}, {REGULATION_FCC, 27}},
    {0x69, {REGULATION_FCC, 2}, {REGULATION_FCC, 25}},
    {0x6a, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 25}},
    {0x6b, {REGULATION_FCC, 1}, {REGULATION_FCC, 29}},
    {0x6c, {REGULATION_FCC, 1}, {REGULATION_FCC, 26}},
    {0x6d, {REGULATION_FCC, 2}, {REGULATION_FCC, 28}},
    {0x6e, {REGULATION_FCC, 1}, {REGULATION_FCC, 25}},
    {0x6f, {REGULATION_NA, 0}, {REGULATION_ETSI, 6}},
    {0x70, {REGULATION_NA, 0}, {REGULATION_ETSI, 30}},
    {0x71, {REGULATION_NA, 0}, {REGULATION_ETSI, 25}},
    {0x72, {REGULATION_NA, 0}, {REGULATION_ETSI, 31}},
    {0x73, {REGULATION_FCC, 1}, {REGULATION_FCC, 1}},
    {0x74, {REGULATION_FCC, 2}, {REGULATION_FCC, 19}},
    {0x75, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 32}},
    {0x2b, {REGULATION_IC, 2}, {REGULATION_IC, 33}},
    {0x76, {REGULATION_FCC, 2}, {REGULATION_FCC, 22}},
    {0x77, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 34}},
    {0x78, {REGULATION_FCC, 3}, {REGULATION_FCC, 35}},
    {0x79, {REGULATION_MKK, 2}, {REGULATION_MKK, 2}},
    {0x2c, {REGULATION_MKK, 2}, {REGULATION_NA, 0}},
    {0x2d, {REGULATION_CHILE, 1}, {REGULATION_CHILE, 22}},
    {0x2e, {REGULATION_WW, 3}, {REGULATION_WW, 37}},
    {0x2f, {REGULATION_CHILE, 1}, {REGULATION_CHILE, 38}},
    {0x3a, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 2}},
    {0x3b, {REGULATION_ACMA, 2}, {REGULATION_ACMA, 1}},
    {0x3c, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 10}},
    {0x3d, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 15}},
    {0x3e, {REGULATION_KCC, 2}, {REGULATION_KCC, 3}},
    {0x3f, {REGULATION_FCC, 3}, {REGULATION_FCC, 22}},
    {0x4a, {REGULATION_IC, 3}, {REGULATION_IC, 33}},
    {0x4b, {REGULATION_KCC, 2}, {REGULATION_KCC, 22}},
    {0x4c, {REGULATION_FCC, 3}, {REGULATION_FCC, 28}},
    {0x4d, {REGULATION_MEX, 2}, {REGULATION_MEX, 1}},
    {0x4e, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 42}},
    {0x4f, {REGULATION_NA, 0}, {REGULATION_MKK, 43}},
    {0x5a, {REGULATION_NA, 0}, {REGULATION_FCC, 44}},
    {0x5b, {REGULATION_NA, 0}, {REGULATION_FCC, 45}},
    {0x5c, {REGULATION_NA, 0}, {REGULATION_FCC, 43}},
    {0x5d, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 8}},
    {0x5e, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 3}},
    {0x5f, {REGULATION_MKK, 2}, {REGULATION_MKK, 47}},
    {0x7a, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 28}},
    {0x7b, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 46}},
    {0x7c, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 47}},
    {0x7d, {REGULATION_MKK, 4}, {REGULATION_MKK, 48}},
    {0x7e, {REGULATION_MKK, 2}, {REGULATION_MKK, 48}},
    {0x00, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 49}},
    {0x01, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 50}},
    {0x02, {REGULATION_ETSI, 3}, {REGULATION_ETSI, 7}},
    {0x03, {REGULATION_ACMA, 2}, {REGULATION_ACMA, 33}},
    {0x04, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 51}},
    {0x05, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 6}},
    {0x06, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 7}},
    {0x07, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 23}},
    {0x08, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 21}},
    {0x09, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 17}},
    {0x1b, {REGULATION_FCC, 2}, {REGULATION_FCC, 52}},
    {0x1c, {REGULATION_KCC, 2}, {REGULATION_KCC, 53}},
    {0x0a, {REGULATION_NA, 0}, {REGULATION_NA, 0}},
    {0x0b, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 22}},
    {0x0c, {REGULATION_FCC, 3}, {REGULATION_FCC, 54}},
    {0x0d, {REGULATION_MKK, 4}, {REGULATION_MKK, 14}},
    {0x0e, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 57}},
    {0x0f, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 58}},
    {0x10, {REGULATION_IC, 2}, {REGULATION_IC, 56}},
    {0x11, {REGULATION_FCC, 2}, {REGULATION_FCC, 59}},
    {0x12, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 60}},
    {0x13, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 61}},
    {0x14, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 32}},
    {0x15, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 9}},
    {0x7f, {REGULATION_WW, 1}, {REGULATION_WW, 55}},
};

const struct chdef_6ghz chdef6g_8852b[] = {
    {0, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, 0x00, 0x00, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}},
    {1, {0xff, 0xff, 0xff}, {0x00, 0x00, 0x00}, 0x00, 0x00, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}},
    {2, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, 0x3f, 0x00, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}},
    {3, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, 0x00, 0x00, {0xff, 0xff, 0x03}, {0x00, 0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}},
    {4, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, 0x00, 0x00, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0xff, 0x07}, {0x00, 0x00}},
    {5, {0xff, 0xff, 0xff}, {0xff, 0xff, 0xff}, 0x3f, 0x3f, {0xff, 0xff, 0x03}, {0xff, 0xff, 0x03}, {0xff, 0x07}, {0xff, 0x07}},
    {6, {0xff, 0xff, 0xff}, {0x00, 0x00, 0x00}, 0x3f, 0x00, {0xff, 0xff, 0x03}, {0x00, 0x00, 0x00}, {0xff, 0x07}, {0x00, 0x00}},
};

const struct regulatory_domain_mapping_6g rdmap6_8852b[] = {
    {0x00, REGULATION_NA, 0},
    {0x01, REGULATION_FCC, 1},
    {0x02, REGULATION_FCC, 2},
    {0x03, REGULATION_FCC, 3},
    {0x04, REGULATION_FCC, 4},
    {0x05, REGULATION_FCC, 6},
    {0x06, REGULATION_ETSI, 1},
    {0x07, REGULATION_IC, 6},
    {0x08, REGULATION_KCC, 6},
    {0x09, REGULATION_KCC, 1},
    {0x1b, REGULATION_ACMA, 1},
    {0x1c, REGULATION_MKK, 1},
    {0x7f, REGULATION_WW, 5},
};

const struct country_domain_mapping cdmap_8852b[] = {
    {0x4d, 0x00, {'A', 'R'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0000 */
    {0x11, 0x00, {'B', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0001 */
    {0x62, 0x00, {'B', 'R'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0002 */
    {0x76, 0x00, {'C', 'L'}, TPO_CHILE, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0003 */
    {0x76, 0x00, {'C', 'O'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0004 */
    {0x76, 0x00, {'C', 'R'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0005 */
    {0x76, 0x00, {'E', 'C'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0006 */
    {0x76, 0x00, {'S', 'V'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0007 */
    {0x76, 0x00, {'G', 'T'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0008 */
    {0x76, 0x00, {'H', 'N'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0009 */
    {0x4d, 0x00, {'M', 'X'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0010 */
    {0x76, 0x00, {'N', 'I'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0011 */
    {0x76, 0x00, {'P', 'A'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0012 */
    {0x76, 0x00, {'P', 'Y'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0013 */
    {0x76, 0x00, {'P', 'E'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0014 */
    {0x1b, 0x00, {'U', 'S'}, TPO_NA, 0x1f, 0, 0x00000001, 0x00000003, 0x00, 0}, /* 0015 */
    {0x30, 0x00, {'U', 'Y'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0016 */
    {0x30, 0x00, {'V', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0017 */
    {0x76, 0x00, {'P', 'R'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0018 */
    {0x76, 0x00, {'D', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0019 */
    {0x5e, 0x00, {'A', 'T'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0020 */
    {0x5e, 0x00, {'B', 'E'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0021 */
    {0x5e, 0x00, {'C', 'Y'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0022 */
    {0x5e, 0x00, {'C', 'Z'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0023 */
    {0x5e, 0x00, {'D', 'K'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0024 */
    {0x5e, 0x00, {'E', 'E'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0025 */
    {0x5e, 0x00, {'F', 'I'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0026 */
    {0x5e, 0x00, {'F', 'R'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0027 */
    {0x5e, 0x00, {'D', 'E'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0028 */
    {0x5e, 0x00, {'G', 'R'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0029 */
    {0x5e, 0x00, {'H', 'U'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0030 */
    {0x5e, 0x00, {'I', 'S'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0031 */
    {0x5e, 0x00, {'I', 'E'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0032 */
    {0x5e, 0x00, {'I', 'T'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0033 */
    {0x5e, 0x00, {'L', 'V'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0034 */
    {0x5e, 0x00, {'L', 'I'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0035 */
    {0x5e, 0x00, {'L', 'T'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0036 */
    {0x5e, 0x00, {'L', 'U'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0037 */
    {0x5e, 0x00, {'M', 'T'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0038 */
    {0x5e, 0x00, {'M', 'C'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0039 */
    {0x5e, 0x00, {'N', 'L'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0040 */
    {0x5e, 0x00, {'N', 'O'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0041 */
    {0x5e, 0x00, {'P', 'L'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0042 */
    {0x5e, 0x00, {'P', 'T'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0043 */
    {0x5e, 0x00, {'S', 'K'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0044 */
    {0x5e, 0x00, {'S', 'I'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0045 */
    {0x5e, 0x00, {'E', 'S'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0046 */
    {0x5e, 0x00, {'S', 'E'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0047 */
    {0x5e, 0x00, {'C', 'H'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0048 */
    {0x0b, 0x00, {'G', 'B'}, TPO_UK, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0049 */
    {0x5e, 0x00, {'A', 'L'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0050 */
    {0x5e, 0x00, {'A', 'Z'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0051 */
    {0x06, 0x00, {'B', 'H'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0052 */
    {0x5e, 0x00, {'B', 'A'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0053 */
    {0x5e, 0x00, {'B', 'G'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0054 */
    {0x5e, 0x00, {'H', 'R'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0055 */
    {0x3c, 0x00, {'E', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0056 */
    {0x5e, 0x00, {'G', 'H'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0057 */
    {0x05, 0x00, {'I', 'Q'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0058 */
    {0x5e, 0x00, {'I', 'L'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0059 */
    {0x5e, 0x00, {'J', 'O'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0060 */
    {0x5e, 0x00, {'K', 'Z'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0061 */
    {0x5e, 0x00, {'K', 'E'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0062 */
    {0x5e, 0x00, {'K', 'W'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0063 */
    {0x5e, 0x00, {'K', 'G'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0064 */
    {0x5e, 0x00, {'L', 'B'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0065 */
    {0x5e, 0x00, {'L', 'S'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0066 */
    {0x5e, 0x00, {'M', 'K'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0067 */
    {0x3c, 0x00, {'M', 'A'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0068 */
    {0x5e, 0x00, {'M', 'Z'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0069 */
    {0x5e, 0x00, {'N', 'A'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0070 */
    {0x75, 0x00, {'N', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0071 */
    {0x5e, 0x00, {'O', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0072 */
    {0x5e, 0x00, {'Q', 'A'}, TPO_QATAR, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0073 */
    {0x5e, 0x00, {'R', 'O'}, TPO_NA, 0x1f, CNTRY_EU, 0x00000002, 0x00000003, 0x00, 0}, /* 0074 */
    {0x09, 0x00, {'R', 'U'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0075 */
    {0x5e, 0x00, {'S', 'A'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0076 */
    {0x3a, 0x00, {'S', 'N'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0077 */
    {0x5e, 0x00, {'R', 'S'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0078 */
    {0x3a, 0x00, {'M', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0079 */
    {0x5e, 0x00, {'Z', 'A'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0080 */
    {0x5e, 0x00, {'T', 'R'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0081 */
    {0x5e, 0x00, {'U', 'A'}, TPO_UKRAINE, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0082 */
    {0x5e, 0x00, {'A', 'E'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0083 */
    {0x3a, 0x00, {'Y', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0084 */
    {0x5e, 0x00, {'Z', 'W'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0085 */
    {0x5e, 0x00, {'B', 'D'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0086 */
    {0x5e, 0x00, {'K', 'H'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0087 */
    {0x06, 0x00, {'C', 'N'}, TPO_CN, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0088 */
    {0x5e, 0x00, {'H', 'K'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0089 */
    {0x5e, 0x00, {'I', 'N'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0090 */
    {0x5d, 0x00, {'I', 'D'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0091 */
    {0x4b, 0x00, {'K', 'R'}, TPO_NA, 0x0f, 0, 0x00000001, 0x00000003, 0x00, 0}, /* 0092 */
    {0x07, 0x00, {'M', 'Y'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0093 */
    {0x5e, 0x00, {'P', 'K'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0094 */
    {0x5e, 0x00, {'P', 'H'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0095 */
    {0x5e, 0x00, {'S', 'G'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0096 */
    {0x5e, 0x00, {'L', 'K'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0097 */
    {0x76, 0x00, {'T', 'W'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0098 */
    {0x5e, 0x00, {'T', 'H'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0099 */
    {0x5e, 0x00, {'V', 'N'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0100 */
    {0x03, 0x00, {'A', 'U'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0101 */
    {0x03, 0x00, {'N', 'Z'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0102 */
    {0x5e, 0x00, {'P', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0103 */
    {0x10, 0x00, {'C', 'A'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0104 */
    {0x7d, 0x00, {'J', 'P'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0105 */
    {0x76, 0x00, {'J', 'M'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0106 */
    {0x76, 0x00, {'A', 'N'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0107 */
    {0x76, 0x00, {'T', 'T'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0108 */
    {0x04, 0x00, {'T', 'N'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0109 */
    {0x42, 0x00, {'A', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0110 */
    {0x00, 0x00, {'D', 'Z'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0111 */
    {0x76, 0x00, {'A', 'S'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0112 */
    {0x3a, 0x00, {'A', 'D'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0113 */
    {0x5e, 0x00, {'A', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0114 */
    {0x5e, 0x00, {'A', 'I'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0115 */
    {0x26, 0x00, {'A', 'Q'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0116 */
    {0x76, 0x00, {'A', 'G'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0117 */
    {0x5e, 0x00, {'A', 'M'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0118 */
    {0x76, 0x00, {'A', 'W'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0119 */
    {0x76, 0x00, {'B', 'S'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0120 */
    {0x76, 0x00, {'B', 'B'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0121 */
    {0x08, 0x00, {'B', 'Y'}, TPO_NA, 0x07, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0122 */
    {0x76, 0x00, {'B', 'Z'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0123 */
    {0x3a, 0x00, {'B', 'J'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0124 */
    {0x76, 0x00, {'B', 'M'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0125 */
    {0x5e, 0x00, {'B', 'T'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0126 */
    {0x5e, 0x00, {'B', 'W'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0127 */
    {0x5e, 0x00, {'B', 'V'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0128 */
    {0x3a, 0x00, {'I', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0129 */
    {0x76, 0x00, {'V', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0130 */
    {0x06, 0x00, {'B', 'N'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0131 */
    {0x5e, 0x00, {'B', 'F'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0132 */
    {0x3a, 0x00, {'M', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0133 */
    {0x3a, 0x00, {'B', 'I'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0134 */
    {0x5e, 0x00, {'C', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0135 */
    {0x5e, 0x00, {'C', 'V'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0136 */
    {0x76, 0x00, {'K', 'Y'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0137 */
    {0x3a, 0x00, {'C', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0138 */
    {0x3a, 0x00, {'T', 'D'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0139 */
    {0x03, 0x00, {'C', 'X'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0140 */
    {0x03, 0x00, {'C', 'C'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0141 */
    {0x5e, 0x00, {'K', 'M'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0142 */
    {0x5e, 0x00, {'C', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0143 */
    {0x5e, 0x00, {'C', 'D'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0144 */
    {0x5e, 0x00, {'C', 'K'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0145 */
    {0x42, 0x00, {'C', 'I'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0146 */
    {0x5e, 0x00, {'D', 'J'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0147 */
    {0x76, 0x00, {'D', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0148 */
    {0x5e, 0x00, {'G', 'Q'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0149 */
    {0x3a, 0x00, {'E', 'R'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0150 */
    {0x3a, 0x00, {'E', 'T'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0151 */
    {0x5e, 0x00, {'F', 'K'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0152 */
    {0x5e, 0x00, {'F', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0153 */
    {0x76, 0x00, {'F', 'J'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0154 */
    {0x3a, 0x00, {'G', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0155 */
    {0x3a, 0x00, {'P', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0156 */
    {0x3a, 0x00, {'T', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0157 */
    {0x5e, 0x00, {'G', 'A'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0158 */
    {0x5e, 0x00, {'G', 'M'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0159 */
    {0x5e, 0x00, {'G', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0160 */
    {0x5e, 0x00, {'G', 'I'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0161 */
    {0x5e, 0x00, {'G', 'L'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0162 */
    {0x76, 0x00, {'G', 'D'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0163 */
    {0x5e, 0x00, {'G', 'P'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0164 */
    {0x76, 0x00, {'G', 'U'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0165 */
    {0x5e, 0x00, {'G', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0166 */
    {0x5e, 0x00, {'G', 'N'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0167 */
    {0x5e, 0x00, {'G', 'W'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0168 */
    {0x76, 0x00, {'G', 'Y'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0169 */
    {0x76, 0x00, {'H', 'T'}, TPO_NA, 0x17, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0170 */
    {0x03, 0x00, {'H', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0171 */
    {0x5e, 0x00, {'V', 'A'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0172 */
    {0x5e, 0x00, {'I', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0173 */
    {0x5e, 0x00, {'J', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0174 */
    {0x26, 0x00, {'K', 'I'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0175 */
    {0x5e, 0x00, {'X', 'K'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0176 */
    {0x5e, 0x00, {'L', 'A'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0177 */
    {0x5e, 0x00, {'L', 'R'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0178 */
    {0x5e, 0x00, {'L', 'Y'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0179 */
    {0x5e, 0x00, {'M', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0180 */
    {0x5e, 0x00, {'M', 'G'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0181 */
    {0x5e, 0x00, {'M', 'W'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0182 */
    {0x3c, 0x00, {'M', 'V'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0183 */
    {0x5e, 0x00, {'M', 'L'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0184 */
    {0x76, 0x00, {'M', 'H'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0185 */
    {0x3a, 0x00, {'M', 'Q'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0186 */
    {0x5e, 0x00, {'M', 'R'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0187 */
    {0x5e, 0x00, {'M', 'U'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0188 */
    {0x5e, 0x00, {'Y', 'T'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0189 */
    {0x76, 0x00, {'F', 'M'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0190 */
    {0x5e, 0x00, {'M', 'D'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0191 */
    {0x5e, 0x00, {'M', 'N'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0192 */
    {0x3a, 0x00, {'M', 'S'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0193 */
    {0x5e, 0x00, {'N', 'R'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0194 */
    {0x06, 0x00, {'N', 'P'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0195 */
    {0x3a, 0x00, {'N', 'C'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0196 */
    {0x5e, 0x00, {'N', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0197 */
    {0x03, 0x00, {'N', 'U'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0198 */
    {0x03, 0x00, {'N', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0199 */
    {0x76, 0x00, {'M', 'P'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0200 */
    {0x76, 0x00, {'P', 'W'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0201 */
    {0x5e, 0x00, {'R', 'E'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0202 */
    {0x5e, 0x00, {'R', 'W'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0203 */
    {0x5e, 0x00, {'S', 'H'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0204 */
    {0x76, 0x00, {'K', 'N'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0205 */
    {0x76, 0x00, {'L', 'C'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0206 */
    {0x76, 0x00, {'M', 'F'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0207 */
    {0x76, 0x00, {'S', 'X'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0208 */
    {0x5e, 0x00, {'P', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0209 */
    {0x76, 0x00, {'V', 'C'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0210 */
    {0x76, 0x00, {'W', 'S'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0211 */
    {0x3a, 0x00, {'S', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0212 */
    {0x5e, 0x00, {'S', 'T'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0213 */
    {0x76, 0x00, {'S', 'C'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0214 */
    {0x5e, 0x00, {'S', 'L'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0215 */
    {0x3a, 0x00, {'S', 'B'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0216 */
    {0x3a, 0x00, {'S', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0217 */
    {0x3a, 0x00, {'G', 'S'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0218 */
    {0x74, 0x00, {'S', 'R'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0219 */
    {0x5e, 0x00, {'S', 'J'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0220 */
    {0x5e, 0x00, {'S', 'Z'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0221 */
    {0x5e, 0x00, {'T', 'J'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0222 */
    {0x5e, 0x00, {'T', 'Z'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0223 */
    {0x5e, 0x00, {'T', 'G'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0224 */
    {0x03, 0x00, {'T', 'K'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0225 */
    {0x3a, 0x00, {'T', 'O'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0226 */
    {0x3a, 0x00, {'T', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0227 */
    {0x3a, 0x00, {'T', 'C'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0228 */
    {0x21, 0x00, {'T', 'V'}, TPO_NA, 0x01, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0229 */
    {0x3a, 0x00, {'U', 'G'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0230 */
    {0x76, 0x00, {'V', 'I'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 1}, /* 0231 */
    {0x3a, 0x00, {'U', 'Z'}, TPO_NA, 0x1f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0232 */
    {0x26, 0x00, {'V', 'U'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0233 */
    {0x3a, 0x00, {'W', 'F'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0234 */
    {0x3c, 0x00, {'E', 'H'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0235 */
    {0x5e, 0x00, {'Z', 'M'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0236 */
    {0x5e, 0x00, {'C', 'U'}, TPO_NA, 0x07, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0237 */
    {0x3a, 0x00, {'I', 'R'}, TPO_NA, 0x01, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0238 */
    {0x21, 0x00, {'S', 'Y'}, TPO_NA, 0x01, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0239 */
    {0x5e, 0x00, {'S', 'D'}, TPO_NA, 0x07, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0240 */
    {0x5e, 0x00, {'P', 'S'}, TPO_NA, 0x0f, 0, 0x00000000, 0x00000003, 0x00, 0}, /* 0241 */
};
/* regu tbl definition ends here */

u8 hal_query_group_cntry_num_8852b(
	struct rtw_regu_policy *policy, u8 group_id)
{
	u8 num = 0;

	if (!policy)
		return 0;

	PHL_QRY_GRP_CNTRY_NUM(num, policy, group_id,
		rdmap_8852b, cdmap_8852b);

	return num;
}

u8 hal_get_cntry_idx_8852b(char *cntry)
{
	u8 idx = INVALID_CNTRY_IDX;

	PHL_GET_CNTRY_INDEX(cntry, idx, cdmap_8852b);

	return idx;
}

u8 hal_get_cntry_tbl_size_8852b(void)
{
	u8 size = 0;

	PHL_GET_CNTRY_TBL_SIZE(size, cdmap_8852b);

	return size;
}

u8 hal_get_chnlplan_ver_8852b(void)
{
	return REGULATION_CHPLAN_VERSION_8852B;
}

u8 hal_get_country_ver_8852b(void)
{
	return REGULATION_COUNTRY_VERSION_8852B;
}

u8 hal_get_domain_regulation_8852b(
	u8 domain, u8 band)
{
	u8 regu = REGULATION_MAX;

	PHL_GET_DOMAIN_REGU(regu, domain, rdmap_8852b, band);

	return regu;
}

u8 hal_get_domain_idx_8852b(u8 domain, bool is_6g)
{
	u8 did = INVALID_DOMAIN_INDEX;

	if (is_6g)
		PHL_GET_DOMAIN_INDEX_6G(did, domain, rdmap6_8852b);
	else
		PHL_GET_DOMAIN_INDEX(did, domain, rdmap_8852b);

	return did;
}

u8 hal_get_cat6g_by_country_8852b(char *country)
{
	u8 cat6g = 0 ;

	PHL_GET_CAT6G_BY_COUNTRY(cat6g, country, cdmap_8852b);

	return cat6g;
}

void hal_get_6g_regulatory_info_8852b(u8 domain,
	u8 *dm_code, u8 *regulation, u8 *ch_idx)
{
	PHL_GET_6G_REGULATORY_INFO(*dm_code, *regulation, *ch_idx,
		domain, rdmap6_8852b);
}

void hal_qry_cntry_chnlplan_8852b(
	struct rtw_regulation_country_chplan *chplan, char *country)
{
	PHL_QRY_CNTRY_CHNLPLAN(country, chplan, cdmap_8852b);
}

void hal_get_chplan_update_info_8852b(
	u8 group, u8 did, void *info, enum band_type band)
{
	if (band == BAND_ON_24G)
		PHL_GET_CHPLAN_UPDATE_INFO_2G(did, info,
			rdmap_8852b, chdef2g_8852b);
	else if (band == BAND_ON_5G)
		PHL_GET_CHPLAN_UPDATE_INFO_5G(group, did, info,
			rdmap_8852b, chdef5g_8852b);
}

void hal_fill_group_cntry_list_8852b(
	struct rtw_regu_policy *policy,
	char* list, u32 group_size, u8 group_id)
{
	if (!policy || !list)
		return;

	PHL_FILL_GRP_CNTRY_LIST(policy, list, group_size,
		group_id, rdmap_8852b, cdmap_8852b);
}

void hal_get_chdef_6g_8852b(
	u8 ch_idx, struct chdef_6ghz *chdef)
{
	PHL_GET_CHDEF_6G(ch_idx, chdef, chdef6g_8852b);
}

void hal_get_regu_func_cert_info_8852b(char *country,
	struct rtw_regu_func_cert_info *rg_cert)
{
	PHL_GET_RG_FUNC_CERT_BY_COUNTRY(country, cdmap_8852b, rg_cert);
}