/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#ifndef _PHL_WATCHDOG_H_
#define _PHL_WATCHDOG_H_

#define WDOG_PERIOD 2000

enum watchdog_state {
	WD_STATE_INIT,
	WD_STATE_STARTED,
#ifdef CONFIG_POST_CORE_KEEP_ALIVE
	WD_STATE_KEEPALIVE,
#endif
	WD_STATE_STOP,
};

struct phl_watchdog {
	_os_timer wdog_timer;
	enum watchdog_state state;

#ifdef CONFIG_POST_CORE_KEEP_ALIVE
	struct rtw_keep_alive_param klive_param;
	void (*core_keep_alive)(void *drv_priv, struct rtw_keep_alive_param *klive);
#endif

	/* Only sw statistics or sw behavior or trigger FG cmd */
	void (*core_sw_wdog)(void *drv_priv);
	/* I/O, tx behavior, request power, ... */
	void (*core_hw_wdog)(void *drv_priv);
	/* No I/O, collect diag statistics after hw watchdog (before trigger next watchdog) */
	void (*core_post_wdog)(void *drv_priv, bool is_hw_wdog_exec);
	u16 period;
};
void
phl_watchdog_cmd_complete_hdl(struct phl_info_t *phl_info);
enum rtw_phl_status
phl_watchdog_hw_cmd_hdl(struct phl_info_t *phl_info, enum rtw_phl_status psts);
enum rtw_phl_status
phl_watchdog_sw_cmd_hdl(struct phl_info_t *phl_info, enum rtw_phl_status psts);
void rtw_phl_watchdog_start(void *phl);
void rtw_phl_watchdog_stop(void *phl);
#ifdef CONFIG_POST_CORE_KEEP_ALIVE
enum rtw_phl_status phl_keep_alive_hdl(struct phl_info_t *phl_info);
bool phl_wdog_state_is_keep_alive(struct phl_info_t *phl_info);
enum rtw_phl_status rtw_phl_set_wdog_state_keep_alive(void *phl,
						      bool enable, struct rtw_keep_alive_param *klive_param);
#endif

#ifdef CONFIG_FSM
void rtw_phl_watchdog_callback(void *phl);
#endif

#endif /*_PHL_WATCHDOG_H_*/

